/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.jdo.util.JDOUtils;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.persist.spi.Complex;

public class SQLRelationLoader {
    private String tableName;
    private int[] leftType;
    private TypeConvertor[] leftFrom;
    private String[] leftParam;
    private TypeConvertor[] rightFrom;
    private String[] rightParam;
    private int[] rightType;
    private String[] left;
    private String[] right;
    private String select;
    private String insert;
    private String delete;
    private String deleteAll;

    public SQLRelationLoader(String table, String[] key, int[] keyType, TypeConvertor[] idTo, TypeConvertor[] idFrom, String[] idParam, String[] otherKey, int[] otherKeyType, TypeConvertor[] ridTo, TypeConvertor[] ridFrom, String[] ridParam) {
        int i;
        this.leftFrom = idFrom;
        this.leftParam = idParam;
        this.rightFrom = ridFrom;
        this.rightParam = ridParam;
        this.tableName = table;
        this.left = key;
        this.right = otherKey;
        this.leftType = keyType;
        this.rightType = otherKeyType;
        StringBuffer sb = new StringBuffer();
        int count = 0;
        sb.append("SELECT ");
        for (i = 0; i < this.left.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.left[i]);
            ++count;
        }
        for (i = 0; i < this.right.length; ++i) {
            sb.append(",");
            sb.append(this.right[i]);
            ++count;
        }
        sb.append(" FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE ");
        for (i = 0; i < this.left.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this.left[i]);
            sb.append("=?");
        }
        for (i = 0; i < this.right.length; ++i) {
            sb.append(" AND ");
            sb.append(this.right[i]);
            sb.append("=?");
        }
        this.select = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" (");
        for (i = 0; i < this.left.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.left[i]);
            ++count;
        }
        for (i = 0; i < this.right.length; ++i) {
            sb.append(",");
            sb.append(this.right[i]);
            ++count;
        }
        sb.append(") VALUES (");
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        this.insert = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("DELETE FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE ");
        for (i = 0; i < this.left.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this.left[i]);
            sb.append("=?");
        }
        for (i = 0; i < this.right.length; ++i) {
            sb.append(" AND ");
            sb.append(this.right[i]);
            sb.append("=?");
        }
        this.delete = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("DELETE FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE ");
        for (i = 0; i < this.left.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this.left[i]);
            sb.append("=?");
        }
        this.deleteAll = sb.toString();
    }

    private Object idToSQL(int index, Object object) throws PersistenceException {
        if (object == null || this.leftFrom[index] == null) {
            return object;
        }
        return this.leftFrom[index].convert(object, this.leftParam[index]);
    }

    private Object ridToSQL(int index, Object object) throws PersistenceException {
        if (object == null || this.rightFrom[index] == null) {
            return object;
        }
        return this.rightFrom[index].convert(object, this.rightParam[index]);
    }

    public void createRelation(Connection conn, Object leftValue, Object rightValue) throws PersistenceException {
        ResultSet rset = null;
        PreparedStatement selectStatement = null;
        PreparedStatement insertStatement = null;
        try {
            Complex right;
            int i;
            Complex left;
            int count = 1;
            selectStatement = conn.prepareStatement(this.select);
            if (this.leftType.length > 1) {
                left = (Complex)leftValue;
                for (i = 0; i < left.size(); ++i) {
                    selectStatement.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                    ++count;
                }
            } else {
                selectStatement.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                ++count;
            }
            if (this.rightType.length > 1) {
                right = (Complex)rightValue;
                for (i = 0; i < right.size(); ++i) {
                    selectStatement.setObject(count, this.ridToSQL(i, right.get(i)), this.rightType[i]);
                    ++count;
                }
            } else {
                selectStatement.setObject(count, this.ridToSQL(0, rightValue), this.rightType[0]);
            }
            count = 1;
            rset = selectStatement.executeQuery();
            insertStatement = conn.prepareStatement(this.insert);
            if (!rset.next()) {
                if (this.leftType.length > 1) {
                    left = (Complex)leftValue;
                    for (i = 0; i < left.size(); ++i) {
                        insertStatement.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                        ++count;
                    }
                } else {
                    insertStatement.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                    ++count;
                }
                if (this.rightType.length > 1) {
                    right = (Complex)rightValue;
                    for (i = 0; i < right.size(); ++i) {
                        insertStatement.setObject(count, this.ridToSQL(i, right.get(i)), this.rightType[i]);
                        ++count;
                    }
                } else {
                    insertStatement.setObject(count, this.ridToSQL(0, rightValue), this.rightType[0]);
                }
                int r = insertStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            catch (Throwable throwable) {
                JDOUtils.closeResultSet(rset);
                JDOUtils.closeStatement(selectStatement);
                JDOUtils.closeStatement(insertStatement);
                throw throwable;
            }
        }
        JDOUtils.closeResultSet(rset);
        JDOUtils.closeStatement(selectStatement);
        JDOUtils.closeStatement(insertStatement);
    }

    public void deleteRelation(Connection conn, Object leftValue) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            int count = 1;
            stmt = conn.prepareStatement(this.deleteAll);
            if (this.leftType.length > 1) {
                Complex left = (Complex)leftValue;
                for (int i = 0; i < left.size(); ++i) {
                    stmt.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                    ++count;
                }
            } else {
                stmt.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
            }
            int i = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            catch (Throwable throwable) {
                JDOUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JDOUtils.closeStatement(stmt);
    }

    public void deleteRelation(Connection conn, Object leftValue, Object rightValue) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            int i;
            int count = 1;
            stmt = conn.prepareStatement(this.delete);
            if (this.leftType.length > 1) {
                Complex left = (Complex)leftValue;
                for (i = 0; i < left.size(); ++i) {
                    stmt.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                    ++count;
                }
            } else {
                stmt.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                ++count;
            }
            if (this.rightType.length > 1) {
                Complex right = (Complex)rightValue;
                for (i = 0; i < right.size(); ++i) {
                    stmt.setObject(count, this.ridToSQL(i, right.get(i)), this.rightType[i]);
                    ++count;
                }
            } else {
                stmt.setObject(count, this.ridToSQL(0, rightValue), this.rightType[0]);
            }
            int i2 = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            catch (Throwable throwable) {
                JDOUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JDOUtils.closeStatement(stmt);
    }
}

