/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;

class MetricsElement {
    private static final NumberFormat METAMATA_NF = NumberFormat.getInstance();
    private static final NumberFormat NEUTRAL_NF;
    private int indent;
    private String construct;
    private Vector metrics;

    MetricsElement(int indent, String construct, Vector metrics) {
        this.indent = indent;
        this.construct = construct;
        this.metrics = metrics;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getName() {
        return this.construct;
    }

    public Enumeration getMetrics() {
        return this.metrics.elements();
    }

    public boolean isCompilationUnit() {
        return this.construct.endsWith(".java") || this.construct.endsWith(".class");
    }

    public boolean isMethod() {
        return this.construct.endsWith("(...)") || this.construct.endsWith("()");
    }

    /*
     * WARNING - void declaration
     */
    public static MetricsElement parse(String line) throws ParseException {
        int pos;
        Vector<String> metrics = new Vector<String>();
        while ((pos = line.indexOf(9)) != -1) {
            void var2_2;
            String token = line.substring(0, (int)var2_2);
            metrics.addElement(token);
            line = line.substring((int)(var2_2 + true));
        }
        metrics.addElement(line);
        if (metrics.size() != 14) {
            throw new ParseException("Could not parse the following line as a metrics: -->" + line + "<--", -1);
        }
        String name = (String)metrics.elementAt(0);
        metrics.removeElementAt(0);
        int indent = 0;
        pos = name.lastIndexOf(47);
        if (pos != -1) {
            name = name.substring(pos + 1);
            indent = pos + 1;
        }
        return new MetricsElement(indent, name, metrics);
    }

    static {
        METAMATA_NF.setMaximumFractionDigits(1);
        NEUTRAL_NF = NumberFormat.getInstance();
        if (NEUTRAL_NF instanceof DecimalFormat) {
            ((DecimalFormat)NEUTRAL_NF).applyPattern("###0.###;-###0.###");
        }
        NEUTRAL_NF.setMaximumFractionDigits(1);
    }
}

