/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.AggregateTransformer;

abstract class XalanExecutor {
    protected AggregateTransformer caller;

    XalanExecutor() {
    }

    private final void setCaller(AggregateTransformer caller) {
        this.caller = caller;
    }

    protected OutputStream getOutputStream() throws IOException {
        if ("frames".equals(this.caller.format)) {
            return new ByteArrayOutputStream();
        }
        return new FileOutputStream(new File(this.caller.toDir, "junit-noframes.html"));
    }

    abstract void execute() throws Exception;

    static XalanExecutor newInstance(AggregateTransformer caller) throws BuildException {
        Class<?> procVersion = null;
        XalanExecutor executor = null;
        try {
            procVersion = Class.forName("org.apache.xalan.processor.XSLProcessorVersion");
            executor = (XalanExecutor)Class.forName("org.apache.tools.ant.taskdefs.optional.junit.Xalan2Executor").newInstance();
        }
        catch (Exception xalan2missing) {
            try {
                procVersion = Class.forName("org.apache.xalan.xslt.XSLProcessorVersion");
                executor = (XalanExecutor)Class.forName("org.apache.tools.ant.taskdefs.optional.junit.Xalan1Executor").newInstance();
            }
            catch (Exception xalan1missing) {
                throw new BuildException("Could not find xalan2 nor xalan1 in the classpath. Check http://xml.apache.org/xalan-j");
            }
        }
        String version = XalanExecutor.getXalanVersion(procVersion);
        caller.task.log("Using Xalan version: " + version);
        executor.setCaller(caller);
        return executor;
    }

    private static String getXalanVersion(Class procVersion) {
        try {
            Field f = procVersion.getField("S_VERSION");
            return f.get(null).toString();
        }
        catch (Exception e) {
            return "?";
        }
    }
}

