/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker.structure;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.XMLType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import psidev.psi.mi.filemakers.xmlMaker.mapping.TreeMapping;
import psidev.psi.mi.filemakers.xmlMaker.structure.DictionaryContainer;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFile;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFileContainer;
import psidev.psi.mi.filemakers.xmlMaker.structure.MarshallingObservable;
import psidev.psi.mi.filemakers.xsd.AbstractXsdTreeStruct;
import psidev.psi.mi.filemakers.xsd.FileMakersException;
import psidev.psi.mi.filemakers.xsd.Utils;
import psidev.psi.mi.filemakers.xsd.XsdNode;

public class XsdTreeStructImpl
extends AbstractXsdTreeStruct {
    private int lineNumber = 0;
    private static final int marshalling = 0;
    private static final int checking = 1;
    private static int checkMode = 1;
    public boolean checkXml = false;
    private String indentation = "";
    public MarshallingObservable observable = new MarshallingObservable();
    public DictionaryContainer dictionaries = new DictionaryContainer();
    public ArrayList unduplicableNodes = new ArrayList();
    public HashMap validationRegexps = new HashMap();
    private String pathFilter;
    public FlatFileContainer flatFiles = new FlatFileContainer();
    public String name = "";
    public String id = "";
    public int lastId = 0;
    public HashMap associatedFields = new HashMap();
    public HashMap associatedDuplicableFields = new HashMap();
    public HashMap associatedValues = new HashMap();
    public HashMap associatedOpenDictionary = new HashMap();
    public HashMap associatedClosedDictionary = new HashMap();
    public HashMap associatedDictionaryColumn = new HashMap();
    public ArrayList associatedAutogeneration = new ArrayList();
    public ArrayList associatedFlatFiles = new ArrayList();
    public ArrayList flatFilesStack = new ArrayList();

    public String getRegexp(XsdNode node) {
        if (this.validationRegexps.containsKey(node)) {
            return (String)this.validationRegexps.get(node);
        }
        return "";
    }

    public FlatFile getCurrentFlatFile() {
        if (this.flatFilesStack.size() > 0) {
            return (FlatFile)this.flatFilesStack.get(this.flatFilesStack.size() - 1);
        }
        return null;
    }

    public XsdTreeStructImpl() {
        super(false, true);
        this.associatedFlatFiles.add(null);
    }

    public void emptySelectionLists() {
        this.associatedFields = new HashMap();
        this.associatedValues = new HashMap();
        this.associatedClosedDictionary = new HashMap();
        this.associatedOpenDictionary = new HashMap();
        this.associatedDictionaryColumn = new HashMap();
        this.associatedAutogeneration = new ArrayList();
        this.associatedFlatFiles = new ArrayList();
        this.expendChoices = new ArrayList();
    }

    public void pushFlatFile(FlatFile f) {
        this.flatFilesStack.add(f);
    }

    public void popFlatFile() {
        this.flatFilesStack.remove(this.flatFilesStack.size() - 1);
    }

    public boolean areSubPaths(TreeNode[] path1, TreeNode[] path2) {
        int minLength = path1.length < path2.length ? path1.length : path2.length;
        int i = 0;
        while (i < minLength) {
            if (path1[i] != path2[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isChildOfRootPaths(XsdNode node) {
        TreeNode[] path = node.getPath();
        int i = 0;
        while (i < this.associatedFlatFiles.size()) {
            if (this.associatedFlatFiles.get(i) != null && !this.areSubPaths(path, ((XsdNode)this.associatedFlatFiles.get(i)).getPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void associateFlatFile(XsdNode node, int flatFile) {
        XsdNode previousAssociation = null;
        while (this.associatedFlatFiles.size() <= flatFile) {
            this.associatedFlatFiles.add(null);
        }
        previousAssociation = (XsdNode)this.associatedFlatFiles.get(flatFile);
        int previousFlatfileAssociated = this.associatedFlatFiles.indexOf(node);
        if (previousFlatfileAssociated > -1) {
            this.associatedFlatFiles.set(previousFlatfileAssociated, null);
        }
        this.check((XsdNode)this.treeModel.getRoot());
        if (previousAssociation != null) {
            this.treeModel.reload(previousAssociation);
        }
        this.associatedFlatFiles.set(flatFile, node);
        this.rootNode.use();
    }

    public void associateDefaultValue(XsdNode node, String value) {
        this.cancelAllAssociations(node);
        this.associatedValues.put(node, value);
        node.useOnlyThis();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void associateDictionnary(XsdNode node, int dictionary, int column, boolean closedAssociation) {
        this.associatedClosedDictionary.remove(node);
        this.associatedOpenDictionary.remove(node);
        if (closedAssociation) {
            this.associatedClosedDictionary.put(node, new Integer(dictionary));
        } else {
            this.associatedOpenDictionary.put(node, new Integer(dictionary));
        }
        this.associatedDictionaryColumn.put(node, new Integer(column));
    }

    public void associateField(XsdNode node, String path, boolean isUnduplicableAssociation) {
        this.cancelAllAssociations(node);
        boolean error = false;
        this.associatedFields.put(node, path);
        if (isUnduplicableAssociation) {
            this.unduplicableNodes.add(node);
        }
        node.use();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void associateField(XsdNode node, String path) {
        this.associateField(node, path, false);
    }

    public void associateValidationRegexp(XsdNode node, String regexp) {
        this.validationRegexps.put(node, regexp);
    }

    public void associateDuplicableField(XsdNode node, String path) {
        boolean error = false;
        this.associatedDuplicableFields.put(node, path);
        node.use();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void cancelAssociateDictionnary(XsdNode node) {
        this.associatedClosedDictionary.remove(node);
        this.associatedOpenDictionary.remove(node);
        this.associatedDictionaryColumn.remove(node);
    }

    public void cancelAssociateField(XsdNode node) {
        if (!this.associatedFields.containsKey(node)) {
            return;
        }
        this.associatedFields.remove(node);
        node.unuse();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void cancelAssociateFlatFile(XsdNode node) {
        if (!this.associatedFlatFiles.contains(node)) {
            return;
        }
        this.associatedFlatFiles.set(this.associatedFlatFiles.indexOf(node), null);
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void cancelDuplicableField(XsdNode node) {
        if (!this.associatedDuplicableFields.containsKey(node)) {
            return;
        }
        this.associatedDuplicableFields.remove(node);
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void cancelDefaultValue(XsdNode node) {
        if (!this.associatedValues.containsKey(node)) {
            return;
        }
        this.associatedValues.remove(node);
        node.unuseOnlyThis();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public boolean hasDefaultValue(XsdNode node) {
        return this.associatedValues.containsKey(node);
    }

    public boolean isAffected(XsdNode node) {
        return this.associatedFields.containsKey(node);
    }

    public boolean isMapped(XsdNode node) {
        if (this.isAffected(node)) {
            return true;
        }
        if (this.hasDefaultValue(node)) {
            return true;
        }
        return this.associatedAutogeneration.contains(node);
    }

    public String getValue(XsdNode node) {
        if (this.isAffected(node)) {
            String replacementValue;
            String value;
            String path;
            String modelPath = path = (String)this.associatedFields.get(node);
            String g = this.pathFilter;
            if (this.pathFilter != null && !this.unduplicableNodes.contains(node)) {
                String[] filters = this.pathFilter.split("\\.");
                String[] paths = path.split("\\.");
                String filteredPath = "";
                int i = 0;
                while (i < filters.length) {
                    try {
                        paths[i] = String.valueOf(Integer.parseInt(filters[i]) + Integer.parseInt(paths[i]));
                    }
                    catch (IndexOutOfBoundsException e) {
                        return "";
                    }
                    ++i;
                }
                i = 0;
                while (i < paths.length - 1) {
                    filteredPath = String.valueOf(filteredPath) + paths[i] + ".";
                    ++i;
                }
                path = filteredPath = String.valueOf(filteredPath) + paths[paths.length - 1];
            }
            if ((value = this.flatFiles.getValue(path, modelPath)) == null) {
                return null;
            }
            if (this.validationRegexps.containsKey(node) && !value.matches((String)this.validationRegexps.get(node))) {
                return null;
            }
            if (this.associatedClosedDictionary.containsKey(node)) {
                replacementValue = this.dictionaries.getReplacementValue((Integer)this.associatedClosedDictionary.get(node), value, (Integer)this.associatedDictionaryColumn.get(node));
                if (replacementValue == null) {
                    this.getMessageManager().sendMessage(String.valueOf(this.printPath(node.getPath())) + ": no value found for " + value + " in dictionary! (line : " + this.lineNumber + ")", 2);
                    return null;
                }
                return this.getXmlValue(replacementValue.trim());
            }
            if (this.associatedOpenDictionary.containsKey(node) && (replacementValue = this.dictionaries.getReplacementValue((Integer)this.associatedOpenDictionary.get(node), value, (Integer)this.associatedDictionaryColumn.get(node))) != null) {
                value = replacementValue;
            }
            if (value.trim().length() == 0) {
                return null;
            }
            return this.getXmlValue(value.trim());
        }
        if (this.associatedAutogeneration.contains(node)) {
            String value = String.valueOf(this.id) + this.lastId;
            ++this.lastId;
            return this.getXmlValue(value);
        }
        if (this.hasDefaultValue(node)) {
            return this.getXmlValue((String)this.associatedValues.get(node));
        }
        return "";
    }

    public String getXmlValue(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public String getInfos(XsdNode node) {
        if (node == null) {
            return "No node selected!";
        }
        String infos = super.getInfos(node);
        infos = String.valueOf(infos) + this.getAssociationInfo(node);
        return infos;
    }

    public String getAssociationInfo(XsdNode node) {
        String field;
        String infos = "";
        String duplicableField = (String)this.associatedDuplicableFields.get(node);
        if (duplicableField != null) {
            infos = String.valueOf(infos) + "this node will be automaticaly duplicated: \nfile: " + Utils.relativizeURL(this.flatFiles.getFlatFile((int)Integer.parseInt((String)duplicableField.substring((int)0, (int)duplicableField.indexOf((String)".")))).fileURL).getPath() + "\nfield: " + duplicableField.substring(duplicableField.indexOf(".") + 1) + ".[1..*]\n";
        }
        if ((field = (String)this.associatedFields.get(node)) != null) {
            infos = String.valueOf(infos) + "associated field: \nfile: " + Utils.relativizeURL(this.flatFiles.getFlatFile((int)Integer.parseInt((String)field.substring((int)0, (int)field.indexOf((String)".")))).fileURL).getPath() + "\nfield: " + field.substring(field.indexOf(".") + 1) + "\n";
        }
        if (this.hasDefaultValue(node)) {
            infos = String.valueOf(infos) + "associated value: " + this.associatedValues.get(node) + "\n";
        }
        if (this.associatedOpenDictionary.containsKey(node)) {
            infos = String.valueOf(infos) + "find replacement value in dictionnary: " + this.dictionaries.getName((Integer)this.associatedOpenDictionary.get(node)) + " or keep orginal value.\n";
        }
        if (this.associatedClosedDictionary.containsKey(node)) {
            infos = String.valueOf(infos) + "find replacement value in dictionnary: " + this.dictionaries.getName((Integer)this.associatedClosedDictionary.get(node)) + "\n";
        }
        if (this.associatedAutogeneration.contains(node)) {
            infos = String.valueOf(infos) + "A value will be automaticaly generated for this node.";
        }
        if (this.associatedFlatFiles.contains(node)) {
            infos = String.valueOf(infos) + Utils.relativizeURL(this.flatFiles.getFlatFile((int)this.associatedFlatFiles.indexOf((Object)node)).fileURL).getPath() + "\n";
        }
        if (this.unduplicableNodes.contains(node)) {
            infos = String.valueOf(infos) + "unduplicable";
        }
        if (this.validationRegexps.containsKey(node)) {
            infos = String.valueOf(infos) + "validated by regular expression:" + this.validationRegexps.get(node);
        }
        return infos;
    }

    public boolean checkAttribute(XsdNode node) {
        if (node.isRequired && !this.isAffected(node) && !this.hasDefaultValue(node) && !this.associatedAutogeneration.contains(node)) {
            node.isCheckedOk = false;
            return false;
        }
        node.isCheckedOk = true;
        return true;
    }

    public boolean checkElement(XsdNode node) {
        if (!(node.transparent || node.isUsed || node.isRequired)) {
            node.isCheckedOk = true;
            return true;
        }
        if (node.transparent) {
            boolean checkedOk = true;
            Iterator it = this.getChildren(node);
            while (it.hasNext()) {
                XsdNode child = (XsdNode)it.next();
                if (this.check(child)) continue;
                checkedOk = false;
            }
            node.isCheckedOk = checkedOk;
            return checkedOk;
        }
        XMLType type = ((ElementDecl)node.getUserObject()).getType();
        if (type == null) {
            return true;
        }
        if (type.isSimpleType()) {
            if (node.isRequired && !this.isAffected(node) && !this.hasDefaultValue(node) && !this.associatedAutogeneration.contains(node)) {
                node.isCheckedOk = false;
                return false;
            }
            node.isCheckedOk = true;
            return true;
        }
        return this.checkGroup(node);
    }

    public boolean checkGroup(XsdNode node) {
        boolean hasUsedChild = false;
        if (node.transparent) {
            boolean checkedOk = true;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                XsdNode child = (XsdNode)children.nextElement();
                if (this.check(child)) continue;
                checkedOk = false;
            }
            node.isCheckedOk = checkedOk;
            return checkedOk;
        }
        boolean errors = false;
        HashMap<String, Object> maxOccurs = new HashMap<String, Object>();
        HashMap<String, Integer> minOccurs = new HashMap<String, Integer>();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            int i;
            XsdNode child = (XsdNode)children.nextElement();
            int nbDuplications = 1;
            String previousFilter = this.pathFilter;
            String filter = "";
            if (this.associatedDuplicableFields.containsKey(child)) {
                nbDuplications = this.flatFiles.nbElements((String)this.associatedDuplicableFields.get(child));
                i = 0;
                while (i < ((String)this.associatedDuplicableFields.get(child)).split("\\.").length) {
                    filter = String.valueOf(filter) + "0.";
                    ++i;
                }
                this.pathFilter = filter = String.valueOf(filter) + "0";
            }
            i = 0;
            while (i < nbDuplications) {
                if (i > 0) {
                    int lastFilterIdx = Integer.parseInt(filter.substring(filter.lastIndexOf(".") + 1)) + i;
                    this.pathFilter = String.valueOf(filter.substring(0, filter.lastIndexOf(".") + 1)) + lastFilterIdx;
                }
                boolean isChildOk = this.check(child);
                switch (((Annotated)child.getUserObject()).getStructureType()) {
                    case 3: {
                        if (isChildOk) break;
                        errors = true;
                        break;
                    }
                    case 10: {
                        if (((Group)child.getUserObject()).getOrder().getType() == 2 && !child.isExtended) {
                            errors = true;
                            break;
                        }
                        if (isChildOk) break;
                        errors = true;
                        break;
                    }
                    case 8: {
                        if (!maxOccurs.containsKey(child.toString())) {
                            int max = child.max;
                            if (max != -1) {
                                maxOccurs.put(child.toString(), new Integer(max));
                            } else {
                                maxOccurs.put(child.toString(), "UNBOUNDED");
                            }
                            minOccurs.put(child.toString(), new Integer(child.min));
                        }
                        if (!child.isCheckedOk) break;
                        try {
                            maxOccurs.put(child.toString(), new Integer((Integer)maxOccurs.get(child.toString()) - 1));
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        minOccurs.put(child.toString(), new Integer((Integer)minOccurs.get(child.toString()) - 1));
                    }
                }
                this.pathFilter = previousFilter;
                if (child.isUsed) {
                    hasUsedChild = true;
                }
                ++i;
            }
        }
        Iterator names = minOccurs.keySet().iterator();
        Iterator mins = minOccurs.values().iterator();
        Iterator maxs = maxOccurs.values().iterator();
        while (names.hasNext()) {
            names.next();
            if ((Integer)mins.next() > 0) {
                errors = true;
            }
            try {
                if ((Integer)maxs.next() >= 0) continue;
                errors = true;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        boolean bl = node.isCheckedOk = !errors;
        if (node.isRequired && !hasUsedChild) {
            node.isCheckedOk = false;
        }
        return node.isCheckedOk;
    }

    public String closeElement(XsdNode node, boolean isEmptyElement) {
        if (isEmptyElement) {
            return "";
        }
        return "</" + node.toString() + ">";
    }

    public void closeElement(XsdNode node, boolean isEmptyElement, Writer out) throws IOException {
        if (isEmptyElement) {
            return;
        }
        out.write("</" + node.toString() + ">");
    }

    public boolean check(XsdNode node) {
        switch (((Annotated)node.getUserObject()).getStructureType()) {
            case 3: {
                return this.checkAttribute(node);
            }
            case 8: {
                return this.checkElement(node);
            }
            case 10: {
                return this.checkGroup(node);
            }
        }
        return false;
    }

    public void validateXml(File xmlFile, Writer log) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
        factory.setAttribute(SCHEMA_SOURCE, this.schemaFile);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this.xmlErrorHandler);
            Document document = builder.parse(xmlFile);
        }
        catch (ParserConfigurationException builder) {
        }
        catch (SAXException builder) {
        }
        catch (OutOfMemoryError ooo) {
            try {
                log.write("ERROR: not enougth memory to perform XML validation");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getMessageManager().sendMessage("ERROR: not enougth memory to perform XML validation", 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String openElement(XsdNode node, String attributes, boolean isEmptyElement) {
        if (isEmptyElement) {
            return "\n<" + node.toString() + attributes + "/>";
        }
        return "\n<" + node.toString() + " " + attributes + ">";
    }

    public String openElement(XsdNode node, ArrayList attributes, boolean isEmptyElement) {
        String attributesString = "";
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            String attributeName = (String)it.next();
            String attributeValue = (String)it.next();
            if (attributeValue.equals("")) continue;
            attributesString = String.valueOf(attributesString) + " " + attributeName + "=\"" + attributeValue + "\"";
        }
        if ((attributesString = attributesString.trim()).length() > 0) {
            attributesString = " " + attributesString;
        } else if (isEmptyElement) {
            return null;
        }
        if (isEmptyElement) {
            return "\n" + this.indentation + "<" + node.toString() + attributesString + "/>";
        }
        return "\n" + this.indentation + "<" + node.toString() + attributesString + ">";
    }

    public String preview() {
        return this.previewNode((XsdNode)this.treeModel.getRoot());
    }

    public String preview(XsdNode node) {
        return this.previewNode(node);
    }

    public String previewAttribute(XsdNode node) {
        String value = this.getValue(node);
        if (value != null && !value.equals("")) {
            return " " + ((AttributeDecl)node.getUserObject()).getName() + "=\"" + value + "\"";
        }
        return null;
    }

    public String previewElement(XsdNode node) {
        boolean isEmptyElement;
        if (!node.isUsed) {
            return null;
        }
        String attributes = "";
        String elements = "";
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            XsdNode child = (XsdNode)children.nextElement();
            switch (((Annotated)child.getUserObject()).getStructureType()) {
                case 3: {
                    String attribute = this.previewAttribute(child);
                    if (attribute == null) break;
                    attributes = String.valueOf(attributes) + attribute;
                    break;
                }
                case 8: {
                    String element = this.previewElement(child);
                    if (element == null) break;
                    elements = String.valueOf(elements) + element;
                    break;
                }
                case 10: {
                    String group = this.previewGroup(child);
                    if (group == null) break;
                    elements = String.valueOf(elements) + group;
                }
            }
        }
        String value = this.getValue(node);
        boolean bl = isEmptyElement = (value == null || value.equals("")) && elements.length() == 0;
        if (elements.length() != 0) {
            elements = String.valueOf(elements) + "\n";
        }
        if (attributes.length() == 0 && isEmptyElement) {
            return null;
        }
        if (value == null) {
            value = "";
        }
        return String.valueOf(this.openElement(node, attributes, isEmptyElement)) + value + elements + this.closeElement(node, isEmptyElement);
    }

    public String previewGroup(XsdNode node) {
        String group = "";
        Enumeration<TreeNode> elements = node.children();
        while (elements.hasMoreElements()) {
            String element = this.previewNode((XsdNode)elements.nextElement());
            if (element == null) continue;
            group = String.valueOf(group) + element;
        }
        return group;
    }

    public String previewNode(XsdNode node) {
        switch (((Annotated)node.getUserObject()).getStructureType()) {
            case 3: {
                return this.previewAttribute(node);
            }
            case 10: {
                return this.previewGroup(node);
            }
            case 8: {
                return this.previewElement(node);
            }
        }
        return "<error: unmanaged elementt/>";
    }

    public void cancelAllAssociations(XsdNode node) {
        this.unduplicableNodes.remove(node);
        this.validationRegexps.remove(node);
        this.associatedAutogeneration.remove(node);
        this.associatedFields.remove(node);
        this.associatedValues.remove(node);
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void associateAutoGenerateValue(XsdNode node) {
        this.cancelAllAssociations(node);
        this.associatedAutogeneration.add(node);
        this.name = node.toString();
        node.useOnlyThis();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public void cancelAutogenerate(XsdNode node) {
        if (!this.associatedAutogeneration.contains(node)) {
            return;
        }
        this.associatedAutogeneration.remove(node);
        node.unuseOnlyThis();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
    }

    public String getNodeProblem(XsdNode node) {
        if (this.isAffected(node)) {
            String replacementValue;
            String value = this.getValue(node);
            if (value == null || value.length() == 0) {
                return "the field " + ((String)this.associatedFields.get(node)).substring(((String)this.associatedFields.get(node)).indexOf(".") + 1) + " is empty";
            }
            if (this.associatedClosedDictionary.containsKey(node) && ((replacementValue = this.dictionaries.getReplacementValue((Integer)this.associatedClosedDictionary.get(node), value, (Integer)this.associatedDictionaryColumn.get(node))) == null || replacementValue.length() == 0)) {
                return "no replacement value found for value " + value + " (in dictionnary: " + this.dictionaries.getName((Integer)this.associatedClosedDictionary.get(node)) + ", field " + ((String)this.associatedFields.get(node)).substring(((String)this.associatedFields.get(node)).indexOf(".") + 1);
            }
        }
        return "no association to this node";
    }

    public TreeMapping getMapping() {
        TreeMapping mapping = new TreeMapping();
        mapping.setId(this.id);
        mapping.setAutoDuplicate(this.autoDuplicate);
        mapping.setManageChoices(this.manageChoices);
        mapping.setSchemaURL(Utils.relativizeURL(this.getSchemaURL()).getPath());
        ArrayList<String> associatedAutogeneration = new ArrayList<String>();
        int i = 0;
        while (i < this.associatedAutogeneration.size()) {
            associatedAutogeneration.add(this.getPathForNode((XsdNode)this.associatedAutogeneration.get(i)));
            ++i;
        }
        mapping.setAssociatedAutogeneration(associatedAutogeneration);
        ArrayList<String> unduplicableNodes = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.unduplicableNodes.size()) {
            unduplicableNodes.add(this.getPathForNode((XsdNode)this.unduplicableNodes.get(i2)));
            ++i2;
        }
        mapping.setUnduplicableNodes(unduplicableNodes);
        mapping.setExpendChoices(this.expendChoices);
        HashMap associatedFields = new HashMap();
        for (XsdNode node : this.associatedFields.keySet()) {
            associatedFields.put(this.getPathForNode(node), this.associatedFields.get(node));
        }
        mapping.setAssociatedFields(associatedFields);
        HashMap associatedDuplicableFields = new HashMap();
        for (XsdNode node : this.associatedDuplicableFields.keySet()) {
            associatedDuplicableFields.put(this.getPathForNode(node), this.associatedDuplicableFields.get(node));
        }
        mapping.setAssociatedDuplicableFields(associatedDuplicableFields);
        HashMap associatedValues = new HashMap();
        for (XsdNode node : this.associatedValues.keySet()) {
            String field = (String)this.associatedValues.get(node);
            associatedValues.put(this.getPathForNode(node), this.associatedValues.get(node));
        }
        mapping.setAssociatedValues(associatedValues);
        HashMap validationRegexps = new HashMap();
        for (XsdNode node : this.validationRegexps.keySet()) {
            String field = (String)this.validationRegexps.get(node);
            validationRegexps.put(this.getPathForNode(node), this.validationRegexps.get(node));
        }
        mapping.setValidationRegexps(validationRegexps);
        HashMap associatedOpenDictionary = new HashMap();
        for (XsdNode node : this.associatedOpenDictionary.keySet()) {
            associatedOpenDictionary.put(this.getPathForNode(node), this.associatedOpenDictionary.get(node));
        }
        mapping.setAssociatedOpenDictionary(associatedOpenDictionary);
        HashMap associatedClosedDictionary = new HashMap();
        for (XsdNode node : this.associatedClosedDictionary.keySet()) {
            associatedClosedDictionary.put(this.getPathForNode(node), this.associatedClosedDictionary.get(node));
        }
        mapping.setAssociatedClosedDictionary(associatedClosedDictionary);
        HashMap associatedDictionaryColumn = new HashMap();
        for (XsdNode node : this.associatedDictionaryColumn.keySet()) {
            associatedDictionaryColumn.put(this.getPathForNode(node), this.associatedDictionaryColumn.get(node));
        }
        mapping.setAssociatedDictionaryColumn(associatedDictionaryColumn);
        ArrayList<String> associatedFlatFiles = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.associatedFlatFiles.size()) {
            associatedFlatFiles.add(this.getPathForNode((XsdNode)this.associatedFlatFiles.get(i3)));
            ++i3;
        }
        mapping.setAssociatedFlatFiles(associatedFlatFiles);
        return mapping;
    }

    public void loadMapping(TreeMapping mapping) throws MalformedURLException {
        XsdNode node;
        String field;
        XsdNode node2;
        this.setId(mapping.id);
        this.setSchemaURL(new File(mapping.getSchemaURL()).toURL());
        this.setAutoDuplicate(mapping.autoDuplicate);
        this.setManageChoices(mapping.manageChoices);
        int i = 0;
        while (i < mapping.expendChoices.size()) {
            String path = (String)mapping.expendChoices.get(i);
            String choice = (String)mapping.expendChoices.get(++i);
            ++i;
            int index = path.indexOf(".");
            String subpath = path;
            if (choice != null) {
                this.redoChoice(path, choice);
                continue;
            }
            this.duplicateNode(this.getNodeByPath(path));
        }
        i = 0;
        while (i < mapping.associatedAutogeneration.size()) {
            node2 = this.getNodeByPath((String)mapping.associatedAutogeneration.get(i));
            node2.useOnlyThis();
            this.associateAutoGenerateValue(node2);
            ++i;
        }
        for (String path : mapping.associatedValues.keySet()) {
            field = (String)mapping.associatedValues.get(path);
            XsdNode node3 = this.getNodeByPath(path);
            node3.useOnlyThis();
            this.associatedValues.put(node3, mapping.associatedValues.get(path));
        }
        for (String path : mapping.validationRegexps.keySet()) {
            field = (String)mapping.validationRegexps.get(path);
            XsdNode node4 = this.getNodeByPath(path);
            this.validationRegexps.put(node4, mapping.validationRegexps.get(path));
        }
        for (String path : mapping.associatedOpenDictionary.keySet()) {
            this.associatedOpenDictionary.put(this.getNodeByPath(path), mapping.associatedOpenDictionary.get(path));
        }
        for (String path : mapping.associatedClosedDictionary.keySet()) {
            this.associatedClosedDictionary.put(this.getNodeByPath(path), mapping.associatedClosedDictionary.get(path));
        }
        for (String path : mapping.associatedDictionaryColumn.keySet()) {
            this.associatedDictionaryColumn.put(this.getNodeByPath(path), mapping.associatedDictionaryColumn.get(path));
        }
        i = 0;
        while (i < mapping.associatedFlatFiles.size()) {
            this.rootNode.use();
            this.associatedFlatFiles.add(this.getNodeByPath((String)mapping.associatedFlatFiles.get(i)));
            ++i;
        }
        for (String path : mapping.associatedDuplicableFields.keySet()) {
            node = this.getNodeByPath(path);
            node.useOnlyThis();
            this.associatedDuplicableFields.put(this.getNodeByPath(path), mapping.associatedDuplicableFields.get(path));
        }
        for (String path : mapping.associatedFields.keySet()) {
            node = this.getNodeByPath(path);
            node.useOnlyThis();
            this.associatedFields.put(this.getNodeByPath(path), mapping.associatedFields.get(path));
        }
        i = 0;
        while (i < mapping.unduplicableNodes.size()) {
            node2 = this.getNodeByPath((String)mapping.unduplicableNodes.get(i));
            this.unduplicableNodes.add(node2);
            ++i;
        }
    }

    public ArrayList getAssociatedAutogeneration() {
        return this.associatedAutogeneration;
    }

    public void setAssociatedAutogeneration(ArrayList associatedAutogeneration) {
        this.associatedAutogeneration = associatedAutogeneration;
    }

    public HashMap getAssociatedDictionaryColumn() {
        return this.associatedDictionaryColumn;
    }

    public void setAssociatedDictionaryColumn(HashMap associatedDictionaryColumn) {
        this.associatedDictionaryColumn = associatedDictionaryColumn;
    }

    public HashMap getAssociatedFields() {
        return this.associatedFields;
    }

    public void setAssociatedFields(HashMap associatedFields) {
        this.associatedFields = associatedFields;
    }

    public ArrayList getAssociatedFlatFiles() {
        return this.associatedFlatFiles;
    }

    public void setAssociatedFlatFiles(ArrayList associatedFlatFiles) {
        this.associatedFlatFiles = associatedFlatFiles;
    }

    public HashMap getAssociatedValues() {
        return this.associatedValues;
    }

    public void setAssociatedValues(HashMap associatedValues) {
        this.associatedValues = associatedValues;
    }

    public DictionaryContainer getDictionaries() {
        return this.dictionaries;
    }

    public void setDictionaries(DictionaryContainer dictionaries) {
        this.dictionaries = dictionaries;
    }

    public FlatFileContainer getFlatFiles() {
        return this.flatFiles;
    }

    public void setFlatFiles(FlatFileContainer flatFiles) {
        this.flatFiles = flatFiles;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getLastId() {
        return this.lastId;
    }

    public void setLastId(int lastId) {
        this.lastId = lastId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpendChoices(ArrayList expendChoices) {
        this.expendChoices = expendChoices;
    }

    public ArrayList getExpandChoices() {
        return this.expendChoices;
    }

    public HashMap getAssociatedDuplicableFields() {
        return this.associatedDuplicableFields;
    }

    public void setAssociatedDuplicableFields(HashMap associatedDuplicableFields) {
        this.associatedDuplicableFields = associatedDuplicableFields;
    }

    public void print2(File outFile) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        this.observable.setMessage("output file: " + outFile.getName());
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<!-- created using XmlMakerFlattener v1.0 (http://cvs.sourceforge.net/viewcvs.py/psidev/psi/mi/tools/) -->");
        this.getMessageManager().sendMessage("start marshalling to file :" + outFile.getName() + " at " + new Date(), 1);
        try {
            out.write(this.xmlMake());
        }
        catch (FileMakersException fme) {
            this.getMessageManager().sendMessage("Exception in main loop: " + fme, 0);
        }
        catch (NullPointerException npe) {
            this.getMessageManager().sendMessage("marshalling failed", 0);
        }
        this.getMessageManager().sendMessage("marshalling done, finished at " + new Date(), 1);
        ((Writer)out).flush();
        ((Writer)out).close();
        this.observable.setMessage("marshalling done");
        this.observable.notifyObservers(this.observable.getMessage());
        this.observable.deleteObservers();
    }

    public String xmlMake() throws IOException, FileMakersException {
        return this.xmlMake((XsdNode)this.treeModel.getRoot());
    }

    public String xmlMake(XsdNode node) throws IOException, FileMakersException {
        this.lastId = 0;
        return this.xmlMakeElement(node);
    }

    public String xmlMakeElement(XsdNode node) throws IOException, FileMakersException {
        boolean isEmptyElement;
        String value;
        if (!node.isUsed) {
            return "";
        }
        String xmlCode = "";
        Iterator children = this.getChildren(node);
        ArrayList<XsdNode> attributeList = new ArrayList<XsdNode>();
        ArrayList<XsdNode> elementList = new ArrayList<XsdNode>();
        ArrayList<XsdNode> groupList = new ArrayList<XsdNode>();
        while (children.hasNext()) {
            XsdNode child = (XsdNode)children.next();
            switch (((Annotated)child.getUserObject()).getStructureType()) {
                case 3: {
                    attributeList.add(child);
                    break;
                }
                case 8: {
                    if (!child.isUsed) break;
                    elementList.add(child);
                    break;
                }
                case 10: {
                    this.getMessageManager().sendMessage("should not be any group...." + child, 2);
                    if (!child.isUsed) break;
                    groupList.add(child);
                }
            }
        }
        this.indentation = String.valueOf(this.indentation) + "\t";
        HashMap<String, Object> maxOccurs = new HashMap<String, Object>();
        HashMap<String, Integer> minOccurs = new HashMap<String, Integer>();
        int i = 0;
        while (i < elementList.size()) {
            XsdNode child = (XsdNode)elementList.get(i);
            if (!maxOccurs.containsKey(child.toString())) {
                if (child.max != -1) {
                    maxOccurs.put(child.toString(), new Integer(child.max));
                } else {
                    maxOccurs.put(child.toString(), "UNBOUNDED");
                }
                minOccurs.put(child.toString(), new Integer(child.min));
            }
            if (this.associatedDuplicableFields.get(child) != null) {
                int j;
                String tmpPath = (String)this.associatedDuplicableFields.get(child);
                if (this.pathFilter != null && !this.unduplicableNodes.contains(node)) {
                    String[] filters = this.pathFilter.split("\\.");
                    String[] paths = tmpPath.split("\\.");
                    String filteredPath = "";
                    j = 0;
                    while (j < filters.length) {
                        paths[j] = String.valueOf(Integer.parseInt(filters[j]) + Integer.parseInt(paths[j]));
                        ++j;
                    }
                    j = 0;
                    while (j < paths.length - 1) {
                        filteredPath = String.valueOf(filteredPath) + paths[j] + ".";
                        ++j;
                    }
                    tmpPath = filteredPath = String.valueOf(filteredPath) + paths[paths.length - 1];
                }
                int nbDuplications = this.flatFiles.nbElements(tmpPath);
                String previousFilter = this.pathFilter;
                String filter = "";
                j = 0;
                while (j < ((String)this.associatedDuplicableFields.get(child)).split("\\.").length) {
                    filter = previousFilter != null && previousFilter.split("\\.").length > j ? String.valueOf(filter) + previousFilter.split("\\.")[j] + "." : String.valueOf(filter) + "0.";
                    ++j;
                }
                this.pathFilter = filter = String.valueOf(filter) + "0";
                j = 0;
                while (j < nbDuplications) {
                    int lastFilterIdx = Integer.parseInt(filter.substring(filter.lastIndexOf(".") + 1)) + j;
                    this.pathFilter = String.valueOf(filter.substring(0, filter.lastIndexOf(".") + 1)) + lastFilterIdx;
                    String xmlChildCode = this.xmlMakeElement(child);
                    if (xmlChildCode != null) {
                        try {
                            maxOccurs.put(child.toString(), new Integer((Integer)maxOccurs.get(child.toString()) - 1));
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        minOccurs.put(child.toString(), new Integer((Integer)minOccurs.get(child.toString()) - 1));
                    }
                    xmlCode = String.valueOf(xmlCode) + xmlChildCode;
                    ++j;
                }
                this.pathFilter = previousFilter;
            } else if (this.associatedFlatFiles.contains(child)) {
                this.pushFlatFile(this.flatFiles.getFlatFile(this.associatedFlatFiles.indexOf((XsdNode)elementList.get(i))));
                this.getMessageManager().sendMessage("[CREATE XML] from file: " + this.getCurrentFlatFile().fileURL.getFile(), 1);
                this.observable.setCurrentFlatFile(this.getCurrentFlatFile().fileURL.getFile());
                this.observable.setElement(node.toString());
                ++this.observable.indentation;
                boolean endOfFile = false;
                this.getCurrentFlatFile().restartFile();
                if (this.getCurrentFlatFile().firstLineForTitles()) {
                    this.getCurrentFlatFile().nextLine();
                }
                int previousLineNumber = this.lineNumber;
                this.lineNumber = 0;
                while (!endOfFile) {
                    this.observable.setCurrentLine(this.lineNumber++);
                    try {
                        if (!this.getCurrentFlatFile().hasLine()) {
                            throw new IOException("!getCurrentFlatFile().hasLine()");
                        }
                        String xmlChildCode = this.xmlMakeElement(child);
                        if (xmlChildCode != null) {
                            try {
                                maxOccurs.put(child.toString(), new Integer((Integer)maxOccurs.get(child.toString()) - 1));
                            }
                            catch (ClassCastException filter) {
                                // empty catch block
                            }
                            minOccurs.put(child.toString(), new Integer((Integer)minOccurs.get(child.toString()) - 1));
                        }
                        xmlCode = String.valueOf(xmlCode) + xmlChildCode;
                        this.getCurrentFlatFile().nextLine();
                    }
                    catch (IOException e) {
                        endOfFile = true;
                        this.getCurrentFlatFile().restartFile();
                    }
                }
                this.lineNumber = previousLineNumber;
                this.popFlatFile();
            } else {
                String xmlChildCode = this.xmlMakeElement(child);
                if (xmlChildCode != null && !xmlChildCode.equals("")) {
                    try {
                        maxOccurs.put(child.toString(), new Integer((Integer)maxOccurs.get(child.toString()) - 1));
                    }
                    catch (ClassCastException previousLineNumber) {
                        // empty catch block
                    }
                    minOccurs.put(child.toString(), new Integer((Integer)minOccurs.get(child.toString()) - 1));
                    xmlCode = String.valueOf(xmlCode) + xmlChildCode;
                }
            }
            ++i;
        }
        this.indentation = this.indentation.substring(1);
        boolean errors = false;
        Iterator names = minOccurs.keySet().iterator();
        Iterator mins = minOccurs.values().iterator();
        Iterator maxs = maxOccurs.values().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if ((Integer)mins.next() > 0) {
                this.getMessageManager().sendMessage(String.valueOf(this.printPath(node.getPath())) + ": a " + name + " is missing! (line : " + this.lineNumber + ")", 0);
                errors = true;
            }
            try {
                if ((Integer)maxs.next() >= 0) continue;
                this.getMessageManager().sendMessage(String.valueOf(this.printPath(node.getPath())) + ": a " + name + " should be removed! (line : " + this.lineNumber + ")", 0);
                errors = true;
            }
            catch (ClassCastException filter) {
                // empty catch block
            }
        }
        ArrayList<String> checkedAttributes = new ArrayList<String>();
        int i2 = 0;
        while (i2 < attributeList.size()) {
            XsdNode attribute = (XsdNode)attributeList.get(i2);
            checkedAttributes.add(attribute.getName());
            if (this.getValue(attribute) == null || this.getValue(attribute).length() == 0) {
                if (attribute.isRequired) {
                    this.getMessageManager().sendMessage(String.valueOf(this.printPath(node.getPath())) + " attibute  " + attribute + " is required for " + node + " (line : " + this.lineNumber + ")", 0);
                    errors = true;
                } else {
                    checkedAttributes.add("");
                }
            } else {
                checkedAttributes.add(this.getValue(attribute));
            }
            ++i2;
        }
        if (errors) {
            return "";
        }
        if (xmlCode.trim().length() > 0) {
            xmlCode = String.valueOf(xmlCode) + "\n" + this.indentation;
        }
        if ((value = this.getValue(node)) != null && value.trim().length() > 0) {
            xmlCode = String.valueOf(xmlCode) + value;
        }
        boolean bl = isEmptyElement = xmlCode == null || xmlCode.length() <= 0;
        if (!isEmptyElement) {
            return String.valueOf(this.openElement(node, checkedAttributes, isEmptyElement)) + xmlCode + this.closeElement(node, isEmptyElement);
        }
        return this.openElement(node, checkedAttributes, isEmptyElement);
    }
}

