/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFile;
import psidev.psi.mi.filemakers.xsd.Utils;

public class FlatFilePanel
extends JPanel {
    public String lastVisitedDirectory = ".";
    public FlatFile flatFile = new FlatFile();
    public String currentPath = "";
    public DefaultListModel listModel = new DefaultListModel();
    public JPanel listPanel = new JPanel(new BorderLayout());
    public JList list = new JList(this.listModel);
    public JTextField separatorLbl = new JTextField(3);
    JCheckBox skipFirstLineb = new JCheckBox("skip first line");

    public FlatFilePanel() {
        super(new BorderLayout());
        this.separatorLbl.setEditable(false);
        Box buttonsPanel = new Box(1);
        Box nextLineBox = new Box(0);
        nextLineBox.setBorder(new TitledBorder(""));
        JPanel cellBox = new JPanel(new GridLayout(3, 2));
        JButton firstLineb = new JButton("<<");
        Utils.setDefaultSize(firstLineb);
        firstLineb.addActionListener(new firstLineListener());
        nextLineBox.add(firstLineb);
        JButton nextLineb = new JButton(">");
        Utils.setDefaultSize(nextLineb);
        nextLineb.addActionListener(new nextLineListener());
        nextLineBox.add(nextLineb);
        JButton nextLineWithFieldb = new JButton(">>");
        Utils.setDefaultSize(nextLineWithFieldb);
        nextLineWithFieldb.addActionListener(new nextLineWithFieldListener());
        nextLineBox.add(nextLineWithFieldb);
        this.list.setFixedCellHeight(12);
        this.list.setFixedCellWidth(60);
        this.list.setLayoutOrientation(0);
        this.list.setAutoscrolls(true);
        this.list.setCellRenderer(new MyCellRenderer());
        this.list.setVisible(true);
        Box listButtonsPanel = new Box(0);
        this.list.setVisible(true);
        JButton fileb = new JButton("Open");
        Utils.setDefaultSize(fileb);
        fileb.addActionListener(new loadFileListener());
        cellBox.add(fileb);
        this.skipFirstLineb.addItemListener(new skipFirstLineListener());
        cellBox.add(this.skipFirstLineb);
        JButton setSeparatorb = new JButton("Separator");
        Utils.setDefaultSize(setSeparatorb);
        setSeparatorb.addActionListener(new setSeparatorListener());
        cellBox.add(setSeparatorb);
        cellBox.add(this.separatorLbl);
        JButton enterb = new JButton("Split");
        Utils.setDefaultSize(enterb);
        enterb.addActionListener(new enterListener());
        cellBox.add(enterb);
        JButton backb = new JButton("Back");
        Utils.setDefaultSize(backb);
        backb.addActionListener(new backListener());
        cellBox.add(backb);
        buttonsPanel.add(cellBox);
        buttonsPanel.add(nextLineBox);
        JScrollPane scrollList = new JScrollPane(this.list);
        this.listPanel.add((Component)scrollList, "Center");
        this.listPanel.add((Component)listButtonsPanel, "South");
        this.add((Component)this.listPanel, "Center");
        this.add((Component)buttonsPanel, "South");
    }

    public void loadFile() throws IOException {
        JTextField separator = new JTextField();
        JTextField fileName = new JTextField();
        JCheckBox forgetFirstLine = new JCheckBox();
        try {
            Box panel = new Box(1);
            String defaultDirectory = Utils.lastVisitedDirectory;
            if (Utils.lastVisitedFlatFileDirectory != null) {
                defaultDirectory = Utils.lastVisitedFlatFileDirectory;
            }
            JFileChooser fc = new JFileChooser(defaultDirectory);
            panel.add(new JLabel("Line separator"));
            panel.add(separator);
            panel.add(new JLabel("first line for titles (do not parse it)"));
            panel.add(forgetFirstLine);
            fc.setAccessory(panel);
            int returnVal = fc.showOpenDialog(new JFrame());
            if (returnVal != 0) {
                return;
            }
            this.flatFile.lineSeparator = separator != null && separator.getText().length() != 0 ? separator.getText() : null;
            this.flatFile.firstLineForTitles = forgetFirstLine.isSelected();
            URL fileURL = fc.getSelectedFile().toURL();
            this.flatFile.load(fileURL);
            Utils.lastVisitedDirectory = fileURL.getPath();
            Utils.lastVisitedFlatFileDirectory = fileURL.getPath();
            this.updateList();
            this.skipFirstLineb.setSelected(this.flatFile.firstLineForTitles());
        }
        catch (FileNotFoundException fe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load the file", "[PSI makers: PSI maker] Flat File", 0);
        }
        catch (NullPointerException ioe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load the file", "[PSI makers: PSI maker] Flat File", 0);
        }
    }

    public void updateList() {
        String separator = this.flatFile.getSeparator(this.currentPath);
        if (separator == null) {
            this.listModel.removeAllElements();
            this.listModel.addElement(this.flatFile.getElementAt(this.currentPath, null));
        } else {
            String[] l = this.flatFile.getElementAt(this.currentPath, null).split(separator);
            int i = 0;
            while (i < l.length) {
                if (i < this.listModel.getSize()) {
                    this.listModel.set(i, l[i].trim());
                    ++i;
                    continue;
                }
                this.listModel.addElement(l[i].trim());
                ++i;
            }
            while (i < this.listModel.getSize()) {
                this.listModel.set(i, "");
                ++i;
            }
        }
        this.separatorLbl.setText(this.flatFile.getSeparator(this.currentPath));
    }

    public String getSelectedPath() {
        if (this.currentPath == "" && this.list.getSelectedIndex() == -1) {
            return "";
        }
        if (this.currentPath == "") {
            return "" + this.list.getSelectedIndex();
        }
        if (this.list.getSelectedIndex() == -1) {
            return this.currentPath;
        }
        return String.valueOf(this.currentPath) + "." + this.list.getSelectedIndex();
    }

    public void setSkipFirstLine() {
        this.flatFile.setFirstLineForTitles(this.skipFirstLineb.isSelected());
    }

    public class skipFirstLineListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            FlatFilePanel.this.setSkipFirstLine();
        }
    }

    public class setSeparatorListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String s = JOptionPane.showInputDialog(new JFrame("[PSI makers: PSI maker] Flat File"), "Separator (use regular expression, e.g.: ; ;|:|, \\| ", FlatFilePanel.this.flatFile.getSeparator(FlatFilePanel.this.currentPath));
            if (s != null) {
                try {
                    FlatFilePanel.this.flatFile.setSeparator(FlatFilePanel.this.currentPath, s);
                    FlatFilePanel.this.updateList();
                    FlatFilePanel.this.separatorLbl.setText(s);
                }
                catch (PatternSyntaxException ex) {
                    JOptionPane.showMessageDialog(new JFrame(), "the separator specified is not a valid regular expression.", "Separator", 0);
                }
            }
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            try {
                this.setToolTipText(value.toString());
                String s = value.toString();
                this.setText(s);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    public class loadFileListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                FlatFilePanel.this.loadFile();
            }
            catch (IOException urie) {
                JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load flat file", 0);
            }
        }
    }

    public class nextLineListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FlatFilePanel.this.flatFile.nextLine();
            FlatFilePanel.this.updateList();
            if (!FlatFilePanel.this.flatFile.hasLine()) {
                JOptionPane.showMessageDialog(new JFrame(), "No more line to read", "[PSI makers: PSI maker] Flat File", 0);
            }
        }
    }

    public class nextLineWithFieldListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (FlatFilePanel.this.list.getSelectedIndex() == -1) {
                return;
            }
            if (FlatFilePanel.this.currentPath == "") {
                FlatFilePanel.this.flatFile.nextLineWithField("" + FlatFilePanel.this.list.getSelectedIndex());
            } else {
                FlatFilePanel.this.flatFile.nextLineWithField(String.valueOf(FlatFilePanel.this.currentPath) + "." + FlatFilePanel.this.list.getSelectedIndex());
            }
            FlatFilePanel.this.updateList();
            if (!FlatFilePanel.this.flatFile.hasLine()) {
                JOptionPane.showMessageDialog(new JFrame(), "No more line to read", "[PSI makers: PSI maker] Flat File", 0);
            }
        }
    }

    public class firstLineListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                FlatFilePanel.this.flatFile.reload();
                FlatFilePanel.this.flatFile.nextLine();
                FlatFilePanel.this.updateList();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class setLineSeparatorListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String s = JOptionPane.showInputDialog(new JFrame("[PSI makers: PSI maker] Flat File"), "Line Separator (use regular expression, e.g.: // \n", "//");
            if (s != null) {
                FlatFilePanel.this.flatFile.lineSeparator = s;
            }
            FlatFilePanel.this.updateList();
        }
    }

    public class enterListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FlatFilePanel.this.currentPath = FlatFilePanel.this.currentPath == "" ? String.valueOf(FlatFilePanel.this.currentPath) + FlatFilePanel.this.list.getSelectedIndex() : String.valueOf(FlatFilePanel.this.currentPath) + "." + FlatFilePanel.this.list.getSelectedIndex();
            FlatFilePanel.this.updateList();
        }
    }

    public class backListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (FlatFilePanel.this.currentPath.indexOf(".") == -1) {
                FlatFilePanel.this.currentPath = "";
                FlatFilePanel.this.updateList();
                return;
            }
            FlatFilePanel.this.currentPath = FlatFilePanel.this.currentPath.substring(0, FlatFilePanel.this.currentPath.lastIndexOf("."));
            FlatFilePanel.this.updateList();
        }
    }
}

