/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlFlattener.structure;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exolab.castor.xml.schema.Annotated;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import psidev.psi.mi.filemakers.xmlFlattener.mapping.TreeMapping;
import psidev.psi.mi.filemakers.xsd.AbstractXsdTreeStruct;
import psidev.psi.mi.filemakers.xsd.Utils;
import psidev.psi.mi.filemakers.xsd.XsdNode;

public class XsdTreeStructImpl
extends AbstractXsdTreeStruct {
    public static final int NUMERIC_NUMEROTATION = 0;
    public static final int HIGH_ALPHABETIC_NUMEROTATION = 1;
    public static final int LOW_ALPHABETIC_NUMEROTATION = 2;
    public static final int NO_NUMEROTATION = 3;
    public int numerotation_type = 0;
    int curElementsCount = 0;
    public Document document = null;
    public URL documentURL = null;
    public String separator = "|";
    public XsdNode lineNode = null;
    public boolean lineNodeIsSelected = false;
    public ArrayList lineElements = null;
    public static final int TITLE = 0;
    public static final int FULL = 1;
    public HashMap elementFilters = new HashMap();
    HashMap referencedElements = new HashMap();
    private HashMap xsKeyNodes = new HashMap();
    public HashMap maxCounts = new HashMap();
    public boolean firstElement = true;
    public ArrayList selections = new ArrayList();
    public HashMap associatedNames = new HashMap();

    public XsdTreeStructImpl() {
        super(false, false);
    }

    public void setSeparator(String s) {
        this.separator = s;
    }

    public boolean check(XsdNode node) {
        return true;
    }

    public void emptySelectionLists() {
        ArrayList selectionsCopy = new ArrayList();
        selectionsCopy.addAll(this.selections);
        for (XsdNode node : selectionsCopy) {
            this.unselectNode(node);
        }
        this.lineNode = null;
        this.elementFilters = new HashMap();
    }

    public void loadDocument(URL url) throws FileNotFoundException, NullPointerException, MalformedURLException, IOException, SAXException {
        this.maxCounts = new HashMap();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
        factory.setAttribute(SCHEMA_SOURCE, this.schemaFile);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            System.out.println(url.toString());
            builder.setErrorHandler(this.xmlErrorHandler);
            this.document = builder.parse(url.toString());
            this.documentURL = url;
            System.out.println("get keys/keyRefs");
            this.buidKeyMaps();
            for (String refer : this.refType2referedType.keySet()) {
                String refered = (String)this.refType2referedType.get(refer);
                System.out.println("found reftype: " + refer + " refers " + refered);
            }
            System.out.println("done");
            System.out.println("document parsed ... get elements");
            this.setLineNode(this.lineNode);
            Utils.lastVisitedDirectory = url.getPath();
            Utils.lastVisitedDocumentDirectory = url.getPath();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private void getKeyNodes(String keyName, String keySelector, String keyField) {
        if (this.document == null) {
            return;
        }
        String[] path = keySelector.split("/");
        Node nodeContainer = this.getContainer(this.document, path, 0);
        if (nodeContainer == null) {
            return;
        }
        System.out.println("found list of refered node: " + nodeContainer.getNodeName());
        int i = 0;
        while (i < nodeContainer.getChildNodes().getLength()) {
            Node child = nodeContainer.getChildNodes().item(i);
            String name = child.getNodeName();
            String idFieldName = this.getReferedIdFieldName(name);
            if (child.hasAttributes()) {
                int j = 0;
                while (j < child.getAttributes().getLength()) {
                    if (child.getAttributes().item(j).getNodeName().equals(idFieldName)) {
                        String ref = child.getAttributes().item(j).getTextContent();
                        this.xsKeyNodes.put(String.valueOf(keyName) + "#" + ref, child);
                        System.out.println("add: " + keyName + "#" + ref);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private Node getContainer(Node node, String[] path, int startIdx) {
        if (startIdx == path.length - 1) {
            return node;
        }
        if (!node.hasChildNodes()) {
            System.out.println("no more nodes");
            return null;
        }
        int j = 0;
        while (j < node.getChildNodes().getLength()) {
            if (node.getChildNodes().item(j).getNodeName().equals(path[startIdx])) {
                return this.getContainer(node.getChildNodes().item(j), path, ++startIdx);
            }
            ++j;
        }
        return null;
    }

    private String getReferedIdFieldName(String key) {
        return "id";
    }

    private void buidKeyMaps() {
        System.out.println("get keys");
        for (Node node : this.keyz) {
            int i;
            String keyName = null;
            String keySelector = null;
            String keyField = null;
            if (node.hasAttributes()) {
                i = 0;
                while (i < node.getAttributes().getLength()) {
                    if (node.getAttributes().item(i).getNodeName().equals("name")) {
                        keyName = node.getAttributes().item(i).getTextContent();
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < node.getChildNodes().getLength()) {
                int j;
                Node child = node.getChildNodes().item(i);
                if (child.getNodeName().equals("xs:selector")) {
                    j = 0;
                    while (j < child.getAttributes().getLength()) {
                        if (child.getAttributes().item(j).getNodeName().equals("xpath")) {
                            keySelector = String.valueOf(this.getXpath(child.getParentNode().getParentNode())) + "/" + child.getAttributes().item(j).getTextContent();
                        }
                        ++j;
                    }
                } else if (child.getNodeName().equals("xs:field")) {
                    j = 0;
                    while (j < child.getAttributes().getLength()) {
                        if (child.getAttributes().item(j).getNodeName().equals("xpath")) {
                            keyField = child.getAttributes().item(j).getTextContent().replace("@", "");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.getKeyNodes(keyName, keySelector, keyField);
        }
        System.out.println("get keyRefs");
        for (Node node : this.keyRefs) {
            String keyRefName = null;
            String keyRefRefer = null;
            String keyRefSelector = null;
            String keyRefField = null;
            if (node.hasAttributes()) {
                int i = 0;
                while (i < node.getAttributes().getLength()) {
                    if (node.getAttributes().item(i).getNodeName().equals("name")) {
                        keyRefName = node.getAttributes().item(i).getTextContent();
                    } else if (node.getAttributes().item(i).getNodeName().equals("refer")) {
                        keyRefRefer = node.getAttributes().item(i).getTextContent();
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                int j;
                Node child = node.getChildNodes().item(i);
                if (child.getNodeName().equals("xs:selector")) {
                    j = 0;
                    while (j < child.getAttributes().getLength()) {
                        if (child.getAttributes().item(j).getNodeName().equals("xpath")) {
                            keyRefSelector = child.getAttributes().item(j).getTextContent();
                        }
                        ++j;
                    }
                } else if (child.getNodeName().equals("xs:field")) {
                    j = 0;
                    while (j < child.getAttributes().getLength()) {
                        if (child.getAttributes().item(j).getNodeName().equals("xpath")) {
                            keyRefField = child.getAttributes().item(j).getTextContent();
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.refType2referedType.put(String.valueOf(this.getSchemaXpath(node.getParentNode())) + "/" + keyRefSelector, keyRefRefer);
        }
    }

    public void setLineNode(XsdNode lineNode) {
        this.lineNode = lineNode;
        this.maxCounts = new HashMap();
        this.lineElements = this.getNodes(lineNode.getPath());
        this.treeModel.reload(lineNode);
        this.lineNodeIsSelected = true;
    }

    public String getInfos(XsdNode node) {
        String infos = super.getInfos(node);
        infos = String.valueOf(infos) + "selected: " + this.selections.contains(node) + "\n";
        return infos;
    }

    public ArrayList getNodes(TreeNode[] path) {
        if (this.document == null) {
            return null;
        }
        Element value = this.document.getDocumentElement();
        ArrayList list = this.getXmlElements(path, value, 0);
        this.curElementsCount = list.size();
        System.out.println(String.valueOf(this.curElementsCount) + " elements found for selection.");
        return list;
    }

    public ArrayList getXmlElements(TreeNode[] path, Node xmlNode, int pathIndex) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (pathIndex < path.length - 1) {
            NodeList children = xmlNode.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                if (((XsdNode)path[pathIndex + 1]).toString().compareTo(children.item(j).getNodeName()) == 0) {
                    list.addAll(this.getXmlElements(path, children.item(j), pathIndex + 1));
                }
                ++j;
            }
            return list;
        }
        list.add(xmlNode);
        return list;
    }

    public String getElementValue(Element element) {
        try {
            NodeList children = element.getChildNodes();
            String value = "";
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeName() == "#text") {
                    value = children.item(i).getNodeValue();
                }
                ++i;
            }
            return value;
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setXmlRoot() {
        if (this.lineNodeIsSelected) {
            return;
        }
        if (this.selections.size() == 0) {
            this.lineNode = (XsdNode)this.treeModel.getRoot();
            this.lineElements = this.getNodes(this.lineNode.getPath());
            return;
        }
        XsdNode value = this.rootNode;
        XsdNode tmp = null;
        XsdNode select = null;
        XsdNode lastDuplicable = null;
        Enumeration<TreeNode> children = value.children();
        int nb = 0;
        while (nb <= 1 && !this.selections.contains(tmp)) {
            if (children.hasMoreElements()) {
                XsdNode child = (XsdNode)children.nextElement();
                if (child.isUsed) {
                    tmp = child;
                    ++nb;
                }
                if (!this.selections.contains(child)) continue;
                select = child;
                continue;
            }
            nb = 0;
            if (tmp.isDuplicable()) {
                lastDuplicable = tmp;
            }
            value = tmp;
            children = value.children();
        }
        if (nb <= 1) {
            value = select;
        }
        System.out.println("[PSI makers: flattener] root selected: " + value.toString());
        this.lineNode = lastDuplicable;
        this.lineElements = this.getNodes(this.lineNode.getPath());
    }

    public void write(Writer out) throws IOException {
        this.setXmlRoot();
        this.firstElement = true;
        out.write(String.valueOf(this.getTitle(this.lineNode)) + "\n");
        out.flush();
        this.firstElement = true;
        int i = 0;
        while (i < this.lineElements.size()) {
            this.firstElement = true;
            this.writeNode(this.lineNode, (Element)this.lineElements.get(i), out, false);
            out.write("\n");
            out.flush();
            ++i;
        }
    }

    public int getMaxCount(XsdNode node) {
        XsdNode originalNode = node;
        if (this.lineElements == null) {
            return 0;
        }
        if (this.maxCounts.containsKey(node)) {
            return (Integer)this.maxCounts.get(node);
        }
        int count = 0;
        int max = 0;
        if (((Annotated)node.getUserObject()).getStructureType() == 3) {
            node = (XsdNode)node.getParent();
        }
        int i = 0;
        while (i < this.lineElements.size()) {
            count = this.getMaxCount((Node)this.lineElements.get(i), this.lineNode, node, node.pathFromAncestorEnumeration(this.lineNode));
            if (count > max) {
                max = count;
            }
            ++i;
        }
        if (max < node.min) {
            max = node.min;
        }
        if (max == 0) {
            max = 1;
        }
        this.maxCounts.put(originalNode, new Integer(max));
        return max;
    }

    public int getMaxCount(Node element, XsdNode parent, XsdNode target, Enumeration path) {
        if (target == parent) {
            if (this.elementFilters.containsKey(target)) {
                try {
                    String value = ((Element)element).getAttributeNode(target.toString()).getNodeValue();
                    if (!value.matches((String)this.elementFilters.get(target))) {
                        return 0;
                    }
                }
                catch (NullPointerException e) {
                    return 0;
                }
            }
            return 1;
        }
        int currentMax = 0;
        int totalCount = 0;
        int max = 0;
        path.nextElement();
        XsdNode nextNode = (XsdNode)path.nextElement();
        NodeList childrens = element.getChildNodes();
        int indexChildrens = 0;
        while (indexChildrens < childrens.getLength()) {
            Element ref;
            Node child = childrens.item(indexChildrens);
            if (child.getNodeType() == 3) {
                Enumeration<TreeNode> xsdChildrens = target.children();
                while (xsdChildrens.hasMoreElements()) {
                    XsdNode xsdChild = (XsdNode)xsdChildrens.nextElement();
                    if (!this.elementFilters.containsKey(xsdChild)) continue;
                    try {
                        String value = ((Element)element).getAttributeNode(child.toString()).getNodeValue();
                        if (value.matches((String)this.elementFilters.get(child))) continue;
                        return 0;
                    }
                    catch (NullPointerException e) {
                        return 0;
                    }
                }
            }
            if (child.getNodeName().compareTo(nextNode.toString()) == 0) {
                currentMax = this.getMaxCount(child, nextNode, target, target.pathFromAncestorEnumeration(nextNode));
                totalCount += currentMax;
                if (((XsdNode)target.getParent()).toString().compareTo(parent.toString()) == 0) {
                    max += currentMax;
                } else if (currentMax > max) {
                    max = currentMax;
                }
            } else if (this.isXsRefPath(child)) {
                ref = this.getElementByKeyRef(child);
                if (ref != null && ref.getNodeName().compareTo(nextNode.toString()) == 0) {
                    currentMax = this.getMaxCount(ref, nextNode, target, target.pathFromAncestorEnumeration(nextNode));
                    totalCount += currentMax;
                    if (((XsdNode)target.getParent()).toString().compareTo(parent.toString()) == 0) {
                        max += currentMax;
                    } else if (currentMax > max) {
                        max = currentMax;
                    }
                }
            } else if (this.isRefType(child.getNodeName()) && (ref = this.getElementById(((Element)child).getAttribute("ref"))) != null && ref.getNodeName().compareTo(nextNode.toString()) == 0) {
                currentMax = this.getMaxCount(ref, nextNode, target, target.pathFromAncestorEnumeration(nextNode));
                totalCount += currentMax;
                if (((XsdNode)target.getParent()).toString().compareTo(parent.toString()) == 0) {
                    max += currentMax;
                } else if (currentMax > max) {
                    max = currentMax;
                }
            }
            ++indexChildrens;
        }
        return max;
    }

    public boolean writeNode(XsdNode xsdNode, Node xmlElement, Writer out, boolean empty) throws IOException {
        XsdNode child;
        Enumeration<TreeNode> children;
        if (!empty) {
            children = xsdNode.children();
            while (children.hasMoreElements()) {
                child = (XsdNode)children.nextElement();
                if (((Annotated)child.getUserObject()).getStructureType() != 3 || !this.elementFilters.containsKey(child)) continue;
                try {
                    String value = ((Element)xmlElement).getAttributeNode(child.toString()).getNodeValue();
                    Pattern p = Pattern.compile((String)this.elementFilters.get(child));
                    Matcher m = p.matcher(value);
                    boolean b = m.matches();
                    if (b) continue;
                    return false;
                }
                catch (NullPointerException e) {
                    return false;
                }
            }
        }
        if (!xsdNode.isUsed) {
            return false;
        }
        if (this.selections.contains(xsdNode) && (xmlElement != null || empty)) {
            String value = this.getElementValue((Element)xmlElement);
            if (this.elementFilters.containsKey(xsdNode) && !empty && this.elementFilters.get(xsdNode) != null && ((String)this.elementFilters.get(xsdNode)).length() > 0) {
                if (value.matches((String)this.elementFilters.get(xsdNode))) {
                    if (this.firstElement) {
                        this.firstElement = false;
                    } else {
                        out.write(this.separator);
                    }
                    out.write(this.getElementValue((Element)xmlElement));
                }
            } else {
                if (this.firstElement) {
                    this.firstElement = false;
                } else {
                    out.write(this.separator);
                }
                out.write(this.getElementValue((Element)xmlElement));
            }
        }
        children = xsdNode.children();
        block10: while (children.hasMoreElements()) {
            child = (XsdNode)children.nextElement();
            if (!child.isUsed) continue;
            switch (((Annotated)child.getUserObject()).getStructureType()) {
                case 8: {
                    int cpt = 0;
                    int nbElementFound = 0;
                    if (xmlElement != null) {
                        NodeList allElements = xmlElement.getChildNodes();
                        ArrayList<Node> elements = new ArrayList<Node>();
                        int i = 0;
                        while (i < allElements.getLength()) {
                            Element ref;
                            if (allElements.item(i).getNodeName().compareTo(child.toString()) == 0) {
                                elements.add(allElements.item(i));
                            } else if (this.isXsRefPath(allElements.item(i))) {
                                ref = this.getElementByKeyRef(allElements.item(i));
                                if (ref != null && ref.getNodeName().compareTo(child.toString()) == 0) {
                                    elements.add(ref);
                                }
                            } else if (this.isRefType(allElements.item(i).getNodeName()) && (ref = this.getElementById(((Element)allElements.item(i)).getAttribute("ref"))) != null && ref.getNodeName().compareTo(child.toString()) == 0) {
                                elements.add(ref);
                            }
                            ++i;
                        }
                        while (cpt < elements.size()) {
                            boolean notEmptyElement = this.writeNode(child, (Node)elements.get(cpt), out, false);
                            ++cpt;
                            if (!notEmptyElement) continue;
                            ++nbElementFound;
                        }
                    }
                    int maxCount = this.getMaxCount(child);
                    while (nbElementFound < maxCount) {
                        this.writeNode(child, null, out, true);
                        ++nbElementFound;
                    }
                    continue block10;
                }
                case 3: {
                    if (this.firstElement) {
                        this.firstElement = false;
                    } else {
                        out.write(this.separator);
                    }
                    if (xmlElement == null) continue block10;
                    try {
                        out.write(((Element)xmlElement).getAttributeNode(child.toString()).getNodeValue());
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue block10;
                }
                default: {
                    System.out.println("[PSI makers: flattener] ERROR: the node is neither an attribute nor an element");
                }
            }
        }
        return true;
    }

    public String getTitle(XsdNode node) {
        String out = "";
        this.getMaxCount(node);
        if (!node.isUsed) {
            return out;
        }
        if (this.selections.contains(node)) {
            if (this.firstElement) {
                this.firstElement = false;
            } else {
                out = String.valueOf(out) + this.separator;
            }
            out = String.valueOf(out) + node.getName() + this.nextNumber(node);
        }
        Enumeration<TreeNode> children = node.children();
        block4: while (children.hasMoreElements()) {
            XsdNode child = (XsdNode)children.nextElement();
            if (!child.isUsed) continue;
            switch (((Annotated)child.getUserObject()).getStructureType()) {
                case 8: {
                    int cpt = 0;
                    int maxCount = this.getMaxCount(child);
                    while (cpt < maxCount) {
                        out = String.valueOf(out) + this.getTitle(child);
                        ++cpt;
                    }
                    continue block4;
                }
                case 3: {
                    if (this.firstElement) {
                        this.firstElement = false;
                    } else {
                        out = String.valueOf(out) + this.separator;
                    }
                    out = String.valueOf(out) + child.getName() + this.nextNumber(child);
                    break;
                }
                default: {
                    System.out.println("[PSI makers: flattener] ERROR: the node is neither an attribute nor an element");
                }
            }
        }
        return out;
    }

    public void addName(XsdNode node, String name) {
        this.associatedNames.put(node, name);
        node.setName(name);
        this.treeModel.reload(node);
    }

    public void addFilter(XsdNode node, String regexp) {
        this.elementFilters.remove(node);
        if (regexp != null && !regexp.trim().equals("")) {
            this.elementFilters.put(node, regexp.trim());
        }
    }

    public void selectNode(XsdNode node) {
        this.selections.add(node);
        node.use();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
        this.setXmlRoot();
    }

    public void unselectNode(XsdNode node) {
        this.selections.remove(node);
        node.unuse();
        this.check((XsdNode)this.treeModel.getRoot());
        this.treeModel.reload(node);
        this.setXmlRoot();
    }

    public TreeMapping getMapping() {
        TreeMapping mapping = new TreeMapping();
        mapping.numerotation_type = this.numerotation_type;
        System.out.println("saving mapping");
        if (this.documentURL != null) {
            mapping.setDocumentURL(Utils.relativizeURL(this.documentURL).getPath());
        }
        if (this.getSchemaURL() != null) {
            mapping.setSchemaURL(Utils.relativizeURL(this.getSchemaURL()).getPath());
        }
        if (this.lineNode != null) {
            mapping.setLineNode(this.getPathForNode(this.lineNode));
        }
        mapping.setSeparator(this.separator);
        mapping.setExpendChoices(this.expendChoices);
        ArrayList<String> selections = new ArrayList<String>();
        int i = 0;
        while (i < this.selections.size()) {
            selections.add(this.getPathForNode((XsdNode)this.selections.get(i)));
            ++i;
        }
        mapping.setSelections(selections);
        HashMap associatedNames = new HashMap();
        for (XsdNode node : this.associatedNames.keySet()) {
            associatedNames.put(this.getPathForNode(node), this.associatedNames.get(node));
        }
        mapping.setAssociatedNames(associatedNames);
        HashMap elementFilters = new HashMap();
        for (XsdNode node : this.elementFilters.keySet()) {
            elementFilters.put(this.getPathForNode(node), this.elementFilters.get(node));
        }
        mapping.setElementFilters(elementFilters);
        return mapping;
    }

    public String marshallNode(XsdNode node, Node element) throws IOException {
        Enumeration<TreeNode> children;
        String marshalling = "";
        if (!node.isUsed) {
            return marshalling;
        }
        if (this.selections.contains(node)) {
            if (this.firstElement) {
                this.firstElement = false;
            } else {
                marshalling = String.valueOf(marshalling) + this.separator;
            }
            children = node.children();
            boolean filtered = false;
            while (children.hasMoreElements()) {
                XsdNode child = (XsdNode)children.nextElement();
                if (((Annotated)child.getUserObject()).getStructureType() != 3 || !this.elementFilters.containsKey(child)) continue;
                try {
                    String value = ((Element)element).getAttributeNode(child.toString()).getNodeValue();
                    if (value.matches((String)this.elementFilters.get(child))) continue;
                    filtered = true;
                }
                catch (NullPointerException value) {
                    // empty catch block
                }
            }
            if (element != null && !filtered) {
                marshalling = String.valueOf(marshalling) + this.getElementValue((Element)element);
            }
        }
        children = node.children();
        block9: while (children.hasMoreElements()) {
            XsdNode child = (XsdNode)children.nextElement();
            if (!child.isUsed) continue;
            switch (((Annotated)child.getUserObject()).getStructureType()) {
                case 8: {
                    int cpt = 0;
                    if (element != null) {
                        NodeList allElements = element.getChildNodes();
                        ArrayList<Node> elements = new ArrayList<Node>();
                        int i = 0;
                        while (i < allElements.getLength()) {
                            Element ref;
                            if (allElements.item(i).getNodeName().compareTo(child.toString()) == 0) {
                                elements.add(allElements.item(i));
                            } else if (this.isXsRefPath(allElements.item(i))) {
                                ref = this.getElementByKeyRef((Element)allElements.item(i));
                                if (ref != null && ref.getNodeName().compareTo(child.toString()) == 0) {
                                    elements.add(ref);
                                }
                            } else if (this.isRefType(allElements.item(i).getNodeName()) && (ref = this.getElementById(((Element)allElements.item(i)).getAttribute("ref"))) != null && ref.getNodeName().compareTo(child.toString()) == 0) {
                                elements.add(ref);
                            }
                            ++i;
                        }
                        while (cpt < elements.size()) {
                            marshalling = String.valueOf(marshalling) + this.marshallNode(child, (Node)elements.get(cpt));
                            ++cpt;
                        }
                    }
                    int maxCount = this.getMaxCount(child);
                    while (cpt < maxCount) {
                        marshalling = String.valueOf(marshalling) + this.marshallNode(child, null);
                        ++cpt;
                    }
                    continue block9;
                }
                case 3: {
                    if (this.firstElement) {
                        this.firstElement = false;
                    } else {
                        marshalling = String.valueOf(marshalling) + this.separator;
                    }
                    if (element == null) continue block9;
                    try {
                        marshalling = String.valueOf(marshalling) + ((Element)element).getAttributeNode(child.toString()).getNodeValue();
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue block9;
                }
                default: {
                    System.out.println("[PSI makers: flattener] ERROR: the node is neither an attribute nor an element");
                }
            }
        }
        return marshalling;
    }

    public void loadMapping(TreeMapping mapping) throws IOException, SAXException {
        XsdNode node;
        String field;
        if (mapping.documentURL != null) {
            this.setDocumentURL(new File(mapping.documentURL).toURL());
        }
        if (mapping.getSchemaURL() != null) {
            this.setSchemaURL(new File(mapping.getSchemaURL()).toURL());
        }
        File schema = new File(Utils.absolutizeURL(this.schemaURL).getPath());
        this.loadSchema(schema);
        this.setExpendChoices(mapping.expendChoices);
        int i = 0;
        while (i < this.expendChoices.size()) {
            String path = (String)this.expendChoices.get(i);
            ++i;
            super.extendPath(super.getNodeByPath(path));
        }
        if (mapping.getLineNode() != null) {
            this.setLineNode(this.getNodeByPath(mapping.getLineNode()));
        }
        if (this.documentURL != null) {
            this.loadDocument(this.documentURL);
        }
        this.setSeparator(mapping.separator);
        i = 0;
        while (i < mapping.selections.size()) {
            XsdNode node2 = this.getNodeByPath((String)mapping.selections.get(i));
            this.selectNode(node2);
            ++i;
        }
        for (String path : mapping.associatedNames.keySet()) {
            field = (String)mapping.associatedNames.get(path);
            node = this.getNodeByPath(path);
            this.addName(node, (String)mapping.associatedNames.get(path));
        }
        for (String path : mapping.elementFilters.keySet()) {
            field = (String)mapping.elementFilters.get(path);
            node = this.getNodeByPath(path);
            this.elementFilters.put(node, mapping.elementFilters.get(path));
        }
        this.numerotation_type = mapping.numerotation_type;
    }

    public URL getDocumentURL() {
        return this.documentURL;
    }

    public void setDocumentURL(URL documentURL) {
        this.documentURL = documentURL;
    }

    public void setSchemaURI(URL schemaURL) {
        this.schemaURL = schemaURL;
    }

    public XsdNode getLineNode() {
        return this.lineNode;
    }

    public int getCurElementCount() {
        return this.curElementsCount;
    }

    private String nextNumber(XsdNode node) {
        String alphabetHigh = "_ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String alphabetLow = "_abcdefghijklmnopqrstuvwxyz";
        int count = this.getMaxCount(node, this.lineNode) + 1;
        if (count > 1) {
            int num = node.nextNumber();
            if (this.numerotation_type == 1 && (num %= count) < alphabetHigh.length()) {
                return "" + alphabetHigh.charAt(num);
            }
            if (this.numerotation_type == 2 && num < alphabetHigh.length()) {
                return "" + alphabetLow.charAt(num);
            }
            if (this.numerotation_type == 0) {
                return "" + num;
            }
            return "" + num;
        }
        return "";
    }

    public void resetCount() {
        this.resetCount(this.lineNode);
    }

    private void resetCount(XsdNode node) {
        node.cpt = 0;
        int nbChildren = node.getChildCount();
        int i = 0;
        while (i < nbChildren) {
            this.resetCount((XsdNode)node.getChildAt(i));
            ++i;
        }
    }

    public int getMaxCount(XsdNode node, XsdNode parent) {
        if (node == parent) {
            return this.getMaxCount(node);
        }
        Enumeration<TreeNode> e = node.pathFromAncestorEnumeration(parent);
        e.nextElement();
        XsdNode nextNode = (XsdNode)e.nextElement();
        return this.getMaxCount(parent) * this.getMaxCount(node, nextNode);
    }

    private Element getElementById(String id) {
        System.out.println("get id : " + id);
        Element ref = this.document.getElementById(id);
        return ref;
    }

    private Element getElementByKeyRef(Node node) {
        String refType = this.getDocumentXpath(node);
        System.out.println("search ref for : " + refType);
        String refId = node.getTextContent();
        if (refId == null || refId.equals("")) {
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                if (node.getAttributes().item(i).getNodeName().equals("ref")) {
                    refId = node.getAttributes().item(i).getNodeValue();
                }
                ++i;
            }
        }
        String referedType = (String)this.refType2referedType.get(refType);
        Element ref = (Element)this.xsKeyNodes.get(String.valueOf(referedType) + "#" + refId);
        return ref;
    }

    private String getXpath(Node node) {
        String name;
        String xpath = "";
        if (node.getParentNode() != null) {
            xpath = this.getXpath(node.getParentNode());
        }
        if ((name = this.getName(node)) != null && xpath != null && !xpath.equals("")) {
            xpath = String.valueOf(xpath) + "/";
        }
        if (name != null) {
            xpath = String.valueOf(xpath) + name;
        }
        return xpath;
    }

    private String getName(Node node) {
        if (!node.hasAttributes()) {
            return null;
        }
        int i = 0;
        while (i < node.getAttributes().getLength()) {
            if (node.getAttributes().item(i).getNodeName().equals("name")) {
                return node.getAttributes().item(i).getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private void getKeys(Node node) {
        try {
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                if (node.getChildNodes().item(i).getNodeName().indexOf("keyref") > 0) {
                    this.keyRefs.add(node.getChildNodes().item(i));
                } else if (node.getChildNodes().item(i).getNodeName().indexOf("key") > 0) {
                    this.keyz.add(node.getChildNodes().item(i));
                }
                this.getKeys(node.getChildNodes().item(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

