/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlFlattener.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import psidev.psi.mi.filemakers.xmlFlattener.structure.XsdTreeStructImpl;
import psidev.psi.mi.filemakers.xsd.AbstractXsdTreePanel;
import psidev.psi.mi.filemakers.xsd.Utils;
import psidev.psi.mi.filemakers.xsd.XsdNode;

public class XsdTreePanelImpl
extends AbstractXsdTreePanel {
    public String exampleLine;
    public ButtonGroup numerotationButtons;
    public JRadioButton numericb;
    public JRadioButton highAlphabeticb;
    public JRadioButton lowAlphabeticb;
    public JRadioButton noneb;
    public JCheckBox displayExample;
    public JLabel filter;

    public XsdTreePanelImpl(XsdTreeStructImpl xsdTree, JTextPane messagePane) {
        super(xsdTree, "East");
        TreeMouseAdapter mouseListener = new TreeMouseAdapter();
        xsdTree.tree.addMouseListener(mouseListener);
        JScrollPane scrollpane = new JScrollPane(messagePane);
        scrollpane.setMaximumSize(new Dimension(Short.MAX_VALUE, 150));
        scrollpane.setMinimumSize(new Dimension(200, 150));
        scrollpane.setPreferredSize(new Dimension(200, 150));
        scrollpane.setVerticalScrollBarPolicy(22);
        scrollpane.setHorizontalScrollBarPolicy(32);
        scrollpane.setBorder(new TitledBorder("Preview"));
        this.add((Component)scrollpane, "South");
    }

    public Box getButtonPanel() {
        Box buttonsPanel = new Box(1);
        buttonsPanel.setAlignmentX(0.5f);
        Box treeBox = new Box(1);
        treeBox.setBorder(new TitledBorder("Schema"));
        Box associationBox = new Box(1);
        associationBox.setBorder(new TitledBorder("Association"));
        Box outputBox = new Box(1);
        outputBox.setBorder(new TitledBorder("Output"));
        Box numerotationBox = new Box(0);
        numerotationBox.setBorder(new TitledBorder("Numerotation"));
        JButton loadFileb = new JButton("Open schema");
        Utils.setDefaultSize(loadFileb);
        loadFileb.addActionListener(new LoadSchemaListener());
        JButton selectLineNodeb = new JButton("Main node");
        Utils.setDefaultSize(selectLineNodeb);
        selectLineNodeb.addActionListener(new SelectLineNodeListener());
        JButton selectNodeb = new JButton("Select");
        Utils.setDefaultSize(selectNodeb);
        selectNodeb.addActionListener(new SelectNodeListener());
        JButton unselectNodeb = new JButton("Unselect");
        Utils.setDefaultSize(unselectNodeb);
        unselectNodeb.addActionListener(new UnselectNodeListener());
        JButton nameb = new JButton("Name");
        Utils.setDefaultSize(nameb);
        nameb.addActionListener(new associateNameListener());
        JButton filterb = new JButton("Filter");
        Utils.setDefaultSize(filterb);
        filterb.addActionListener(new AssociateFilterListener());
        JButton infosb = new JButton("About");
        Utils.setDefaultSize(infosb);
        infosb.addActionListener(new InfosListener());
        associationBox.add(selectNodeb);
        associationBox.add(unselectNodeb);
        associationBox.add(nameb);
        associationBox.add(filterb);
        this.filter = new JLabel("no filter");
        associationBox.add(this.filter);
        treeBox.add(loadFileb);
        associationBox.add(infosb);
        JButton loadXmlFileb = new JButton("Open document (XML)");
        Utils.setDefaultSize(loadXmlFileb);
        loadXmlFileb.addActionListener(new LoadDocumentListener());
        JButton setSeparatorb = new JButton("Separator");
        Utils.setDefaultSize(setSeparatorb);
        setSeparatorb.addActionListener(new SetSeparatorListener());
        JButton printTabFileb = new JButton("Print");
        Utils.setDefaultSize(printTabFileb);
        printTabFileb.addActionListener(new PrintFlatFileListener());
        treeBox.add(loadXmlFileb);
        treeBox.add(selectLineNodeb);
        outputBox.add(setSeparatorb);
        outputBox.add(printTabFileb);
        this.numerotationButtons = new ButtonGroup();
        this.numericb = new JRadioButton("1");
        this.highAlphabeticb = new JRadioButton("A");
        this.lowAlphabeticb = new JRadioButton("a");
        this.noneb = new JRadioButton("none");
        this.numericb.addActionListener(new NumerotationListener());
        this.highAlphabeticb.addActionListener(new NumerotationListener());
        this.lowAlphabeticb.addActionListener(new NumerotationListener());
        numerotationBox.setAlignmentX(0.0f);
        this.numerotationButtons.add(this.numericb);
        this.numerotationButtons.add(this.highAlphabeticb);
        this.numerotationButtons.add(this.lowAlphabeticb);
        this.numerotationButtons.add(this.noneb);
        switch (((XsdTreeStructImpl)this.xsdTree).numerotation_type) {
            case 1: {
                this.highAlphabeticb.setSelected(true);
                break;
            }
            case 2: {
                this.lowAlphabeticb.setSelected(true);
                break;
            }
            case 0: {
                this.numericb.setSelected(true);
                break;
            }
            default: {
                this.noneb.setSelected(true);
            }
        }
        numerotationBox.add(this.numericb);
        numerotationBox.add(this.highAlphabeticb);
        numerotationBox.add(this.lowAlphabeticb);
        numerotationBox.add(this.noneb);
        buttonsPanel.add(treeBox);
        buttonsPanel.add(associationBox);
        buttonsPanel.add(outputBox);
        buttonsPanel.add(numerotationBox);
        this.displayExample = new JCheckBox("preview");
        buttonsPanel.add(this.displayExample);
        this.displayExample.addActionListener(new PreviewListener());
        return buttonsPanel;
    }

    public void setCellRenderer() {
        this.xsdTree.tree.setCellRenderer(new XslTreeRenderer());
    }

    public void setTreeSelectionListener() {
        this.xsdTree.tree.addTreeSelectionListener(new AbstractXsdTreePanel.XsdTreeSelectionListener(this));
    }

    public void loadDocument() {
        try {
            JFileChooser fileChooser;
            int returnVal;
            String defaultDirectory = Utils.lastVisitedDirectory;
            if (Utils.lastVisitedDocumentDirectory != null) {
                defaultDirectory = Utils.lastVisitedDocumentDirectory;
            }
            if ((returnVal = (fileChooser = new JFileChooser(defaultDirectory)).showOpenDialog(new JFrame())) != 0) {
                return;
            }
            URL fileURL = fileChooser.getSelectedFile().toURL();
            ((XsdTreeStructImpl)this.xsdTree).loadDocument(fileURL);
            this.xsdTree.getMessageManager().sendMessage("XML document " + fileURL + " loaded.", 1);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.exampleLine = null;
    }

    public void selectNode() {
        XsdNode node = (XsdNode)((XsdTreeStructImpl)this.xsdTree).tree.getLastSelectedPathComponent();
        if (node == null) {
            this.xsdTree.getMessageManager().sendMessage("no node selected", 0);
            return;
        }
        if (!((XsdTreeStructImpl)this.xsdTree).canHaveValue((XsdNode)((XsdTreeStructImpl)this.xsdTree).tree.getLastSelectedPathComponent())) {
            this.xsdTree.getMessageManager().sendMessage("no value should  have been associated to this node", 0);
            return;
        }
        ((XsdTreeStructImpl)this.xsdTree).selectNode(node);
        this.exampleLine = null;
        this.updatePreview();
    }

    public void updatePreview() {
        ((XsdTreeStructImpl)this.xsdTree).firstElement = true;
        if (((XsdTreeStructImpl)this.xsdTree).document != null && ((XsdTreeStructImpl)this.xsdTree).lineNode != null) {
            String preview = "";
            if (((XsdTreeStructImpl)this.xsdTree).getCurElementCount() > 0) {
                preview = String.valueOf(preview) + ((XsdTreeStructImpl)this.xsdTree).getCurElementCount() + " elements found.\n";
            }
            try {
                ((XsdTreeStructImpl)this.xsdTree).resetCount();
                preview = String.valueOf(preview) + ((XsdTreeStructImpl)this.xsdTree).getTitle(((XsdTreeStructImpl)this.xsdTree).lineNode) + "\n";
            }
            catch (OutOfMemoryError oome) {
                preview = "not enougth memory to perform preview\n";
            }
            if (this.displayExample.isSelected()) {
                try {
                    ((XsdTreeStructImpl)this.xsdTree).firstElement = true;
                    if (((XsdTreeStructImpl)this.xsdTree).document != null && ((XsdTreeStructImpl)this.xsdTree).lineElements.size() > 0) {
                        if (this.exampleLine == null) {
                            this.exampleLine = ((XsdTreeStructImpl)this.xsdTree).marshallNode(((XsdTreeStructImpl)this.xsdTree).lineNode, (Element)((XsdTreeStructImpl)this.xsdTree).lineElements.get(0));
                        }
                        preview = String.valueOf(preview) + this.exampleLine;
                    }
                }
                catch (IOException ioe) {
                    preview = String.valueOf(preview) + "no document loaded\n";
                }
                catch (OutOfMemoryError oome) {
                    preview = String.valueOf(preview) + "not enougth memory to perform preview\n";
                }
            }
            this.xsdTree.getMessageManager().sendMessage(preview, 1);
        } else if (this.displayExample.isSelected()) {
            this.xsdTree.getMessageManager().sendMessage("no document loaded", 0);
        }
    }

    public void unselectNode() {
        XsdNode node = (XsdNode)((XsdTreeStructImpl)this.xsdTree).tree.getLastSelectedPathComponent();
        if (node == null) {
            this.xsdTree.getMessageManager().sendMessage("no node selected", 0);
            return;
        }
        ((XsdTreeStructImpl)this.xsdTree).unselectNode(node);
        this.exampleLine = null;
        this.updatePreview();
    }

    public void associateName(XsdNode node) {
        String value = JOptionPane.showInputDialog(new JFrame(), "Enter the name, \n", node.getName());
        ((XsdTreeStructImpl)this.xsdTree).addName(node, value);
        this.updatePreview();
        ((XsdTreeStructImpl)this.xsdTree).treeModel.reload(node);
    }

    public void associateFilter(XsdNode node) {
        String oldValue = (String)((XsdTreeStructImpl)this.xsdTree).elementFilters.get(node);
        if (oldValue == null) {
            oldValue = "";
        }
        String value = JOptionPane.showInputDialog(new JFrame(), "Enter the name, \n", oldValue);
        ((XsdTreeStructImpl)this.xsdTree).addFilter(node, value);
        this.exampleLine = null;
        this.updatePreview();
        ((XsdTreeStructImpl)this.xsdTree).treeModel.reload(node);
    }

    public class associateNameListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdNode selectedNode = (XsdNode)((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).tree.getLastSelectedPathComponent();
            if (selectedNode == null) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("no node selected", 0);
                return;
            }
            XsdTreePanelImpl.this.associateName(selectedNode);
        }
    }

    public class NumerotationListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (XsdTreePanelImpl.this.highAlphabeticb.isSelected()) {
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).numerotation_type = 1;
            }
            if (XsdTreePanelImpl.this.lowAlphabeticb.isSelected()) {
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).numerotation_type = 2;
            }
            if (XsdTreePanelImpl.this.numericb.isSelected()) {
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).numerotation_type = 0;
            }
            if (XsdTreePanelImpl.this.noneb.isSelected()) {
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).numerotation_type = 3;
            }
            XsdTreePanelImpl.this.updatePreview();
        }
    }

    public class LoadDocumentListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (XsdTreePanelImpl.this.xsdTree.schema == null) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("please load a XML schema first", 0);
                return;
            }
            XsdTreePanelImpl.this.loadDocument();
            Iterator it = XsdTreePanelImpl.this.xsdTree.xmlErrorHandler.errors.iterator();
            while (it.hasNext()) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage((String)it.next(), 0);
            }
            XsdTreePanelImpl.this.updatePreview();
        }
    }

    public class PrintFlatFileListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (XsdTreePanelImpl.this.xsdTree.rootNode == null) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("no schema loaded", 0);
                return;
            }
            if (((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).document == null) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("no document loaded", 0);
                return;
            }
            TreeNode[] path = XsdTreePanelImpl.this.xsdTree.rootNode.getPath();
            try {
                JFileChooser fileChooser;
                int returnVal;
                String defaultDirectory = Utils.lastVisitedDirectory;
                if (Utils.lastVisitedOutputDirectory != null) {
                    defaultDirectory = Utils.lastVisitedOutputDirectory;
                }
                if ((returnVal = (fileChooser = new JFileChooser(defaultDirectory)).showSaveDialog(new JFrame())) != 0) {
                    return;
                }
                Utils.lastVisitedDirectory = fileChooser.getSelectedFile().getPath();
                Utils.lastVisitedOutputDirectory = fileChooser.getSelectedFile().getPath();
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileChooser.getSelectedFile())));
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).resetCount();
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).write(out);
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("unable to write file", 0);
            }
        }
    }

    public class CheckListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class SetSeparatorListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String s = JOptionPane.showInputDialog(new JFrame(), (Object)"Field separator, \n");
            if (s != null) {
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).setSeparator(s);
            }
        }
    }

    public class InfosListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdNode node = (XsdNode)XsdTreePanelImpl.this.xsdTree.tree.getLastSelectedPathComponent();
            if (node == null) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("no node selected", 0);
                return;
            }
            XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage(XsdTreePanelImpl.this.xsdTree.getInfos(node), 1);
        }
    }

    public class PreviewListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdTreePanelImpl.this.updatePreview();
        }
    }

    public class LoadSchemaListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdTreePanelImpl.this.loadSchema();
            if (XsdTreePanelImpl.this.xsdTree.schema != null) {
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).setXmlRoot();
            }
        }
    }

    public class SelectLineNodeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                XsdTreePanelImpl.this.xsdTree.emptySelectionLists();
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).lineNode = (XsdNode)XsdTreePanelImpl.this.xsdTree.tree.getLastSelectedPathComponent();
                ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).setLineNode(((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).lineNode);
            }
            catch (NullPointerException npe) {
                XsdTreePanelImpl.this.xsdTree.getMessageManager().sendMessage("no node selected", 0);
            }
            XsdTreePanelImpl.this.exampleLine = null;
            XsdTreePanelImpl.this.updatePreview();
        }
    }

    public class TreeMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            XsdNode selectedNode = (XsdNode)((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).tree.getLastSelectedPathComponent();
            if (((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).elementFilters.containsKey(selectedNode)) {
                XsdTreePanelImpl.this.filter.setText((String)((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).elementFilters.get(selectedNode));
            } else {
                XsdTreePanelImpl.this.filter.setText("no filter");
            }
            if (e.getClickCount() == 2) {
                XsdNode node = (XsdNode)((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).tree.getLastSelectedPathComponent();
                if (((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).selections.contains(node)) {
                    XsdTreePanelImpl.this.unselectNode();
                } else {
                    XsdTreePanelImpl.this.selectNode();
                }
                XsdTreePanelImpl.this.updatePreview();
            }
        }
    }

    public class XslTreeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon iconAttribute = new ImageIcon("images/ic-att.gif");
        ImageIcon iconElement = new ImageIcon("images/ic-elt.gif");
        Font affected;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            XsdNode node = (XsdNode)value;
            switch (((Annotated)node.getUserObject()).getStructureType()) {
                case 10: {
                    this.setIcon(null);
                    break;
                }
                case 3: {
                    this.setIcon(this.iconAttribute);
                    this.setToolTipText("default value: " + ((AttributeDecl)node.getUserObject()).getDefaultValue());
                    break;
                }
                case 8: {
                    this.setIcon(this.iconElement);
                    try {
                        this.setToolTipText(((Documentation)((Annotation)((ElementDecl)node.getUserObject()).getAnnotations().nextElement()).getDocumentation().nextElement()).getContent());
                        break;
                    }
                    catch (Exception e) {
                        this.setToolTipText("no documentation");
                    }
                }
            }
            if (((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).elementFilters.containsKey(node)) {
                this.setText(String.valueOf(node.getName()) + " *");
            } else {
                this.setText(node.getName());
            }
            this.setForeground(Color.GRAY);
            if (node.isUsed) {
                this.setForeground(Color.BLACK);
            }
            if (((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).selections.contains(node)) {
                this.setForeground(Color.RED);
            }
            if (node == ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).lineNode) {
                this.setForeground(Color.BLUE);
            }
            if (node == ((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).lineNode) {
                this.setForeground(Color.GREEN);
            }
            return this;
        }
    }

    public class SelectNodeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdTreePanelImpl.this.selectNode();
        }
    }

    public class UnselectNodeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdTreePanelImpl.this.unselectNode();
        }
    }

    public class AssociateFilterListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XsdNode node = (XsdNode)((XsdTreeStructImpl)XsdTreePanelImpl.this.xsdTree).tree.getLastSelectedPathComponent();
            XsdTreePanelImpl.this.associateFilter(node);
            XsdTreePanelImpl.this.updatePreview();
        }
    }
}

