/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.geneontology.util.FilteredIterator;
import org.geneontology.util.VectorFilter;

public class Subset
extends AbstractSet
implements Serializable {
    private static final long serialVersionUID = 8179875474046027783L;
    protected VectorFilter filter;
    protected int size = -1;
    protected boolean containedMarked = false;
    protected Collection set;
    protected boolean cacheSize;

    public Subset() {
        this(null, null, false);
    }

    public Subset(VectorFilter filter, Collection set) {
        this(filter, set, false);
    }

    public Subset(VectorFilter filter, Collection set, boolean cacheSize) {
        this.filter = filter;
        this.set = set;
        this.cacheSize = cacheSize;
        if (cacheSize) {
            this.cacheSize();
        }
    }

    public Iterator iterator() {
        if (this.cacheSize) {
            return new CachedSubsetIterator();
        }
        return new FilteredIterator(this.filter, this.set.iterator());
    }

    public boolean remove(Object o) {
        if (this.filter.satisfies(o)) {
            return this.set.remove(o);
        }
        return false;
    }

    protected void markForRecategorize(Object o) {
        this.containedMarked = this.contains(o);
    }

    protected void recategorize(Object o) {
        if (this.contains(o)) {
            if (!this.containedMarked) {
                ++this.size;
            }
        } else if (this.containedMarked) {
            --this.size;
        }
    }

    public boolean isEmpty() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            if (!this.filter.satisfies(it.next())) continue;
            return false;
        }
        return true;
    }

    public void setFilter(VectorFilter filter) {
        this.filter = filter;
    }

    public void setData(Collection set) {
        this.set = set;
    }

    public boolean add(Object o) {
        if (this.filter.satisfies(o)) {
            return this.set.add(o);
        }
        return false;
    }

    protected void updateRemove(Object o) {
        if (this.filter.satisfies(o)) {
            --this.size;
        }
    }

    protected void updateAdd(Object o) {
        if (this.filter.satisfies(o)) {
            ++this.size;
        }
    }

    protected void cacheSize() {
        this.cacheSize(0);
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            if (!this.filter.satisfies(it.next())) continue;
            ++this.size;
        }
    }

    protected void cacheSize(int size) {
        this.size = size;
    }

    public int size() {
        if (!this.cacheSize) {
            this.cacheSize();
        }
        return this.size;
    }

    public boolean contains(Object o) {
        return this.filter.satisfies(o) && this.set.contains(o);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    protected class CachedSubsetIterator
    implements Iterator {
        int index = 0;
        Iterator internal;
        Object lastObject;

        protected CachedSubsetIterator() {
            this.internal = Subset.this.set.iterator();
        }

        public boolean hasNext() {
            return this.index < Subset.this.size;
        }

        public Object next() {
            do {
                this.lastObject = this.internal.next();
            } while (!Subset.this.filter.satisfies(this.lastObject));
            ++this.index;
            return this.lastObject;
        }

        public void remove() {
            if (Subset.this.filter.satisfies(this.lastObject)) {
                this.internal.remove();
            }
        }
    }
}

