/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.regex.Pattern;

public class StringUtil {
    public static final String LINE_BREAK = System.getProperty("line.separator");
    protected static Pattern p = Pattern.compile("[A-Za-z0-9_\\-!.~\\\\'\\(\\)\\*,;#:\\$&\\+=\\?/\\[\\]@]*");

    public static int compareToIgnoreCase(String a, String b) {
        int length = a.length();
        if (b.length() < length) {
            length = b.length();
        }
        int i = 0;
        while (i < length) {
            char bchar;
            char achar = Character.toUpperCase(a.charAt(i));
            if (achar < (bchar = Character.toUpperCase(b.charAt(i)))) {
                return -1;
            }
            if (achar > bchar) {
                return 1;
            }
            ++i;
        }
        if (a.length() < b.length()) {
            return -1;
        }
        if (a.length() > b.length()) {
            return 1;
        }
        return 0;
    }

    public static String wrap(String text, int screenWidth) {
        return StringUtil.wrap(text, screenWidth, 0, 0, LINE_BREAK, false);
    }

    public static String wrap(String text, int screenWidth, String lineBreak) {
        return StringUtil.wrap(text, screenWidth, 0, 0, lineBreak, false);
    }

    public static String wrap(String text, int screenWidth, int firstIndent, int indent, String lineBreak, boolean traceMode) {
        return StringUtil.wrap(new StringBuffer(text), screenWidth, firstIndent, indent, lineBreak, traceMode).toString();
    }

    public static StringBuffer wrap(StringBuffer text, int screenWidth, int firstIndent, int indent, String lineBreak, boolean traceMode) {
        if (firstIndent < 0 || indent < 0 || screenWidth < 0) {
            throw new IllegalArgumentException("Negative dimension");
        }
        int allowedCols = screenWidth - 1;
        if (allowedCols - indent < 2 || allowedCols - firstIndent < 2) {
            throw new IllegalArgumentException("Usable columns < 2");
        }
        int ln = text.length();
        int defaultNextLeft = allowedCols - indent;
        int b = 0;
        int e = 0;
        StringBuffer res = new StringBuffer((int)((double)ln * 1.2));
        int left = allowedCols - firstIndent;
        int i = 0;
        while (i < firstIndent) {
            res.append(' ');
            ++i;
        }
        StringBuffer tempb = new StringBuffer(indent + 2);
        tempb.append(lineBreak);
        int i2 = 0;
        while (i2 < indent) {
            tempb.append(' ');
            ++i2;
        }
        String defaultBreakAndIndent = tempb.toString();
        boolean firstSectOfSrcLine = true;
        boolean firstWordOfSrcLine = true;
        int traceLineState = 0;
        int nextLeft = defaultNextLeft;
        String breakAndIndent = defaultBreakAndIndent;
        int wln = 0;
        while (true) {
            char c2;
            char c;
            if (e <= ln) {
                c = e != ln ? (char)text.charAt(e) : (char)' ';
                if (traceLineState > 0 && e > b) {
                    if (c == '.' && traceLineState == 1) {
                        c = ' ';
                    } else {
                        c2 = text.charAt(e - 1);
                        if (c2 == ':') {
                            c = ' ';
                        } else if (c2 == '(') {
                            traceLineState = 2;
                            c = ' ';
                        }
                    }
                }
                if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                    ++e;
                    continue;
                }
                wln = e - b;
                if (left >= wln) {
                    res.append(text.substring(b, e));
                    left -= wln;
                    b = e;
                } else {
                    int x;
                    wln = e - b;
                    if (wln > nextLeft || firstWordOfSrcLine) {
                        int ob = b;
                        while (wln > left) {
                            if (left > 2 || left == 2 && (firstWordOfSrcLine || b != ob || nextLeft <= 2)) {
                                res.append(text.substring(b, b + left - 1));
                                res.append("-");
                                res.append(breakAndIndent);
                                wln -= left - 1;
                                b += left - 1;
                                left = nextLeft;
                                continue;
                            }
                            x = res.length() - 1;
                            if (x >= 0 && res.charAt(x) == ' ') {
                                res.delete(x, x + 1);
                            }
                            res.append(breakAndIndent);
                            left = nextLeft;
                        }
                        res.append(text.substring(b, b + wln));
                        b += wln;
                        left -= wln;
                    } else {
                        x = res.length() - 1;
                        if (x >= 0 && res.charAt(x) == ' ') {
                            res.delete(x, x + 1);
                        }
                        res.append(breakAndIndent);
                        res.append(text.substring(b, e));
                        left = nextLeft - wln;
                        b = e;
                    }
                }
                firstSectOfSrcLine = false;
                firstWordOfSrcLine = false;
            }
            int extra = 0;
            while (e < ln) {
                c = text.charAt(e);
                if (c == ' ') {
                    ++e;
                    continue;
                }
                if (c == '\t') {
                    ++e;
                    extra += 7;
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    nextLeft = defaultNextLeft;
                    breakAndIndent = defaultBreakAndIndent;
                    res.append(breakAndIndent);
                    if (++e >= ln || (c2 = text.charAt(e)) != '\n' && c2 != '\r' || c != c2) {
                        // empty if block
                    }
                    left = nextLeft;
                    b = ++e;
                    firstSectOfSrcLine = true;
                    firstWordOfSrcLine = true;
                    traceLineState = 0;
                    continue;
                }
                wln = e - b + extra;
                if (firstSectOfSrcLine) {
                    int y = allowedCols - indent - wln;
                    if (traceMode && ln > e + 2 && text.charAt(e) == 'a' && text.charAt(e + 1) == 't' && text.charAt(e + 2) == ' ') {
                        if (y > 8) {
                            y -= 3;
                        }
                        traceLineState = 1;
                    }
                    if (y > 5) {
                        y = allowedCols - y;
                        nextLeft = allowedCols - y;
                        tempb = new StringBuffer(indent + 2);
                        tempb.append(lineBreak);
                        int i3 = 0;
                        while (i3 < y) {
                            tempb.append(' ');
                            ++i3;
                        }
                        breakAndIndent = tempb.toString();
                    }
                }
                if (wln <= left) {
                    res.append(text.substring(b, e));
                    left -= wln;
                    b = e;
                } else {
                    res.append(breakAndIndent);
                    left = nextLeft;
                    b = e;
                }
                firstSectOfSrcLine = false;
                break;
            }
            if (e >= ln) break;
        }
        return res;
    }

    public static String repeat(String s, int n) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static String repeat(char c, int n) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isValidURICharacter(char c) {
        return p.matcher(String.valueOf(c)).matches();
    }

    public static boolean containsOnlyValidURICharacters(String s) {
        return p.matcher(s).matches();
    }

    public static String replace(String string, String original, String replacement) {
        int index = 0;
        while ((index = string.indexOf(original, index)) != -1) {
            string = String.valueOf(string.substring(0, index)) + replacement + string.substring(index + original.length());
            index += replacement.length();
        }
        return string;
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

