/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Vector;

public class DiskCachedList
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = -1879960027305363426L;
    protected transient int size = 0;
    protected transient List fileIndexCache;
    protected boolean cacheFileIndex = false;
    protected transient File indexFile;
    private Vector serializationHolder;

    public DiskCachedList() throws IOException {
        this(false);
    }

    public DiskCachedList(boolean cacheFileIndex) throws IOException {
        this.cacheFileIndex = cacheFileIndex;
        this.createFileIndex();
    }

    protected void createFileIndex() throws IOException {
        if (this.cacheFileIndex) {
            this.fileIndexCache = new Vector();
        } else {
            this.indexFile = File.createTempFile("diskcache", ".index");
            this.indexFile.deleteOnExit();
            this.flushFileIndex(new Vector());
        }
    }

    public Object get(int index) {
        List indexList = this.getFileIndex();
        File objFile = (File)indexList.get(index);
        return this.getObjectForFile(objFile);
    }

    protected Object getObjectForFile(File objFile) {
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(objFile));
            Object out = is.readObject();
            is.close();
            return out;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not access object cache file " + objFile);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not load cached object file " + objFile + " because of a class " + "not found exception " + ex);
        }
    }

    public int size() {
        return this.size;
    }

    public Object set(int index, Object element) {
        List indexList = this.getFileIndex();
        File objFile = this.writeFileRef(element);
        File oldFile = indexList.set(index, objFile);
        Object out = this.getObjectForFile(objFile);
        oldFile.delete();
        this.flushFileIndex(indexList);
        return out;
    }

    public void add(int index, Object element) {
        List indexList = this.getFileIndex();
        File objFile = this.writeFileRef(element);
        indexList.add(index, objFile);
        this.flushFileIndex(indexList);
        ++this.size;
    }

    public Object remove(int index) {
        List indexList = this.getFileIndex();
        File objFile = (File)indexList.remove(index);
        Object out = this.getObjectForFile(objFile);
        objFile.delete();
        this.flushFileIndex(indexList);
        --this.size;
        return out;
    }

    protected File writeFileRef(Object o) {
        File objFile;
        try {
            objFile = File.createTempFile("objcache", ".obj");
            objFile.deleteOnExit();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create object cache file for " + o);
        }
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(objFile));
            os.writeObject(o);
            os.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not write object cache file " + objFile);
        }
        return objFile;
    }

    public void finalize() {
        if (!this.cacheFileIndex) {
            this.indexFile.delete();
        }
    }

    protected List getFileIndex() {
        if (this.cacheFileIndex) {
            return this.fileIndexCache;
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.indexFile));
            List list = (List)is.readObject();
            is.close();
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not access list index file " + this.indexFile);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not load list index file " + this.indexFile + " because of a " + "class not found exception " + ex);
        }
    }

    protected void flushFileIndex(List list) {
        if (!this.cacheFileIndex) {
            try {
                ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.indexFile));
                os.writeObject(list);
                os.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not flush list index file " + this.indexFile);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serializationHolder = new Vector();
        int i = 0;
        while (i < this.size) {
            this.serializationHolder.add(this.get(i));
            ++i;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = this.serializationHolder.size();
        this.createFileIndex();
        int i = 0;
        while (i < this.serializationHolder.size()) {
            this.add(this.serializationHolder.get(i));
            ++i;
        }
        this.serializationHolder = null;
    }
}

