/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.geneontology.util.ComparableComparator;
import org.geneontology.util.EmptyIterator;
import org.geneontology.util.EqualityComparator;
import org.geneontology.util.EqualsEqualityComparator;
import org.geneontology.util.ObjectUtil;

public class CollectionUtil {
    public static final EmptyIterator EMPTY_ITERATOR = EmptyIterator.EMPTY_ITERATOR;
    protected static final ComparableComparator comparableComparator = new ComparableComparator();
    private static final EqualsEqualityComparator equalityComparator = new EqualsEqualityComparator();

    private CollectionUtil() {
    }

    public static boolean hasSameContents(Collection a, Collection b) {
        return CollectionUtil.hasSameContents(a, b, equalityComparator);
    }

    public static boolean hasSameContents(Collection a, Collection b, EqualityComparator cmp) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (CollectionUtil.contains(b, it.next(), cmp)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection vector, Object o, EqualityComparator cmp) {
        Iterator it = vector.iterator();
        while (it.hasNext()) {
            if (!cmp.equals(it.next(), o)) continue;
            return true;
        }
        return false;
    }

    public static List createSortedList(Collection v, Comparator c, boolean duplicates) {
        ArrayList out = new ArrayList();
        Iterator it = v.iterator();
        while (it.hasNext()) {
            CollectionUtil.insertSorted(out, c, it.next(), duplicates);
        }
        return out;
    }

    public static boolean insertSorted(List v, Comparator c, Object o, boolean duplicates) {
        int pos = Collections.binarySearch(v, o, c);
        if (duplicates && pos >= 0) {
            if (pos >= v.size()) {
                pos = v.size() - 1;
            }
            if (pos < 0) {
                pos = 0;
            }
            v.add(pos, o);
            return true;
        }
        if (pos < 0) {
            v.add(-pos - 1, o);
            return true;
        }
        return false;
    }

    public static boolean insertSorted(List v, Comparator c, Object o) {
        return CollectionUtil.insertSorted(v, c, o, true);
    }

    public static void insertSorted(List v, Object o) {
        CollectionUtil.insertSorted(v, comparableComparator, o);
    }

    public static void copyIntoSorted(Iterator it, List dest, Comparator comparator) {
        while (it.hasNext()) {
            CollectionUtil.insertSorted(dest, comparator, it.next());
        }
    }

    public static void copyIntoSorted(Collection source, List dest, Comparator comparator) {
        CollectionUtil.copyIntoSorted(source.iterator(), dest, comparator);
    }

    public static void addAll(Collection c, Iterator it) {
        while (it.hasNext()) {
            c.add(it.next());
        }
    }

    public static boolean contains(Iterator it, Object o) {
        while (it.hasNext()) {
            if (!ObjectUtil.equals(o, it.next())) continue;
            return true;
        }
        return false;
    }

    public static Collection initialize(Collection c, Iterator it) {
        c.clear();
        CollectionUtil.addAll(c, it);
        return c;
    }
}

