/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import org.geneontology.util.TagSpec;

public class ArgumentSpec {
    protected int cardinality;
    protected TagSpec tagSpec;
    protected String documentation;

    public ArgumentSpec(TagSpec tagSpec, int cardinality) {
        this(tagSpec, cardinality, null);
    }

    public ArgumentSpec(TagSpec tagSpec, int cardinality, String documentation) {
        this.tagSpec = tagSpec;
        this.cardinality = cardinality;
        if (documentation == null) {
            if (tagSpec != null) {
                this.documentation = tagSpec.getDocumentation();
            } else if (cardinality == -1) {
                this.documentation = "arg1 arg2 ...";
            } else {
                int i = 0;
                while (i < cardinality) {
                    this.documentation = String.valueOf(this.documentation) + (i > 0 ? " " : "") + "arg" + (i + 1);
                    ++i;
                }
            }
        }
    }

    public String getDocumenation() {
        if (this.tagSpec == null) {
            return "none";
        }
        return this.tagSpec.getDocumentation();
    }

    public String getSummaryDocumentation() {
        return this.documentation;
    }

    public TagSpec getTagSpec() {
        return this.tagSpec;
    }

    public int getCardinality() {
        return this.cardinality;
    }
}

