/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.geneontology.io.AllFileFilter;
import org.geneontology.swing.FileSystemTreeModel;
import org.geneontology.swing.SwingUtil;

public class MultiFileChooser
extends JPanel {
    private static final long serialVersionUID = 3285835745137459354L;
    protected static int MARGIN = 5;
    public static final int APPROVE = 1;
    public static final int CANCEL = 2;
    private UIExtension ext = new UIExtension();
    protected FileSystemTreeModel model;
    protected JTree tree;
    protected JScrollPane pane;
    protected Icon fileIcon = UIManager.getIcon("FileView.fileIcon");
    protected Icon directoryIcon = UIManager.getIcon("FileView.directoryIcon");
    protected Icon hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
    protected Icon floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
    protected Icon computerIcon = UIManager.getIcon("FileView.computerIcon");
    protected Icon homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
    protected Icon upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
    protected JButton openButton = new JButton();
    protected JButton cancelButton = new JButton("Cancel");
    protected JButton upFolderButton = new JButton(this.upFolderIcon);
    protected JButton rootFolderButton = new JButton(this.computerIcon);
    protected JButton homeFolderButton = new JButton(this.homeFolderIcon);
    protected JLabel fileNameLabel = new JLabel();
    protected JComboBox filterBox = new JComboBox();
    protected int choice = 2;
    protected FilenameFilter[] filters;

    protected void attachListeners() {
        this.upFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiFileChooser.this.showParent();
            }
        });
        this.rootFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiFileChooser.this.showRoot();
            }
        });
        this.homeFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiFileChooser.this.showHome();
            }
        });
        this.filterBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiFileChooser.this.selectFilter();
            }
        });
    }

    protected void selectFilter() {
        this.model.setFilter((FilenameFilter)this.filterBox.getSelectedItem());
    }

    protected void showParent() {
        File file = (File)this.model.getRoot();
        this.model.setRoot(file.getParentFile());
        this.initButtons();
    }

    protected void showRoot() {
        this.model.setRoot(this.model.getDefaultRoot());
        this.initButtons();
    }

    protected void showHome() {
        this.model.setRoot(new File(System.getProperty("user.home")));
        this.initButtons();
    }

    public File getRoot() {
        Object o = this.model.getRoot();
        if (!(o instanceof File)) {
            return null;
        }
        return (File)o;
    }

    public void setFilters(FilenameFilter[] filters) {
        this.filters = filters;
        this.filterBox.removeAllItems();
        this.filterBox.setSelectedIndex(-1);
        int i = 0;
        while (i < filters.length) {
            this.filterBox.addItem(filters[i]);
            ++i;
        }
        this.filterBox.setSelectedIndex(0);
    }

    protected void initButtons() {
        this.fileNameLabel.setText(this.model.getRoot().toString());
        this.rootFolderButton.setEnabled(!this.model.getRoot().equals(this.model.getDefaultRoot()));
        this.homeFolderButton.setEnabled(!this.model.getRoot().equals(new File(System.getProperty("user.home"))));
        this.upFolderButton.setEnabled(this.model.getRoot() instanceof File && ((File)this.model.getRoot()).getParentFile() != null);
    }

    public MultiFileChooser() {
        this(new File(System.getProperty("user.home")));
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.tree.setCellRenderer(renderer);
    }

    public MultiFileChooser(File root) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 350));
        FilenameFilter[] defaultFilters = new FilenameFilter[]{new AllFileFilter()};
        this.setFilters(defaultFilters);
        this.model = new FileSystemTreeModel(root);
        this.tree = new JTree(this.model);
        this.setCellRenderer(new FileCellRenderer());
        this.pane = new JScrollPane(this.tree, 20, 30);
        this.fileNameLabel.setText(root.toString());
        JPanel horzBox = new JPanel();
        horzBox.setLayout(new BoxLayout(horzBox, 0));
        horzBox.add(Box.createHorizontalStrut(MARGIN));
        horzBox.add(Box.createHorizontalGlue());
        horzBox.add(this.openButton);
        horzBox.add(Box.createVerticalStrut(15));
        horzBox.add(this.cancelButton);
        horzBox.add(Box.createHorizontalGlue());
        horzBox.add(Box.createHorizontalStrut(MARGIN));
        JPanel filterSpacingBox = new JPanel();
        filterSpacingBox.setLayout(new BoxLayout(filterSpacingBox, 0));
        filterSpacingBox.add(Box.createHorizontalStrut(MARGIN));
        filterSpacingBox.add(this.filterBox);
        filterSpacingBox.add(Box.createHorizontalStrut(MARGIN));
        JPanel buttonBox = new JPanel();
        buttonBox.setLayout(new BoxLayout(buttonBox, 1));
        buttonBox.add(Box.createVerticalStrut(10));
        buttonBox.add(filterSpacingBox);
        buttonBox.add(Box.createVerticalStrut(5));
        buttonBox.add(horzBox);
        buttonBox.add(Box.createVerticalStrut(MARGIN));
        JPanel pathButtonBox = new JPanel();
        pathButtonBox.setLayout(new BoxLayout(pathButtonBox, 0));
        pathButtonBox.add(Box.createHorizontalStrut(MARGIN));
        pathButtonBox.add(this.fileNameLabel);
        pathButtonBox.add(Box.createHorizontalStrut(10));
        pathButtonBox.add(Box.createHorizontalGlue());
        pathButtonBox.add(this.rootFolderButton);
        pathButtonBox.add(Box.createHorizontalStrut(10));
        pathButtonBox.add(this.upFolderButton);
        pathButtonBox.add(Box.createHorizontalStrut(10));
        pathButtonBox.add(this.homeFolderButton);
        pathButtonBox.add(Box.createHorizontalStrut(MARGIN));
        JPanel northBox = new JPanel();
        northBox.setLayout(new BoxLayout(northBox, 1));
        northBox.add(Box.createVerticalStrut(MARGIN));
        northBox.add(pathButtonBox);
        northBox.add(Box.createVerticalStrut(10));
        JPanel paneBox = new JPanel();
        paneBox.setLayout(new BorderLayout());
        paneBox.add(Box.createHorizontalStrut(MARGIN), "East");
        paneBox.add((Component)this.pane, "Center");
        paneBox.add(Box.createHorizontalStrut(MARGIN), "West");
        filterSpacingBox.setAlignmentX(0.0f);
        paneBox.setAlignmentX(0.0f);
        this.pane.setAlignmentX(0.0f);
        this.tree.setAlignmentX(0.0f);
        this.openButton.setAlignmentX(0.0f);
        this.cancelButton.setAlignmentX(0.0f);
        this.fileNameLabel.setAlignmentX(0.0f);
        this.rootFolderButton.setAlignmentX(0.0f);
        this.upFolderButton.setAlignmentX(0.0f);
        this.homeFolderButton.setAlignmentX(0.0f);
        this.filterBox.setAlignmentX(0.0f);
        horzBox.setAlignmentX(0.0f);
        buttonBox.setAlignmentX(0.0f);
        pathButtonBox.setAlignmentX(0.0f);
        northBox.setAlignmentX(0.0f);
        this.add((Component)northBox, "North");
        this.add((Component)paneBox, "Center");
        this.add((Component)buttonBox, "South");
        this.attachListeners();
        this.initButtons();
    }

    public void setSelectedFiles(File[] files) {
        if (files == null) {
            return;
        }
        TreePath[] paths = this.getTreePaths(files);
        this.tree.setSelectionPaths(paths);
        int i = 0;
        while (i < paths.length) {
            this.tree.makeVisible(paths[i]);
            ++i;
        }
    }

    protected TreePath[] getTreePaths(File[] files) {
        TreePath[] paths = new TreePath[files.length];
        int i = 0;
        while (i < files.length) {
            paths[i] = this.model.getTreePath(files[i]);
            ++i;
        }
        return paths;
    }

    protected void attachListeners(JDialog dialog) {
        this.cancelButton.addActionListener(new ButtonListener(2, dialog));
        this.openButton.addActionListener(new ButtonListener(1, dialog));
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.tree != null) {
            this.tree.setFont(font);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setFont(font);
        }
        if (this.openButton != null) {
            this.openButton.setFont(font);
        }
        if (this.filterBox != null) {
            this.filterBox.setFont(font);
        }
        if (this.fileNameLabel != null) {
            this.fileNameLabel.setFont(font);
        }
    }

    public int showDialog(Component parent, String approveButtonText) {
        this.openButton.setText(approveButtonText);
        Window w = SwingUtilities.getWindowAncestor(parent);
        JDialog dialog = w == null ? new JDialog() : (w instanceof Dialog ? new JDialog((Dialog)w) : (w instanceof Frame ? new JDialog((Frame)w) : new JDialog()));
        dialog.setModal(true);
        dialog.setFont(this.getFont());
        dialog.setContentPane(this);
        this.attachListeners(dialog);
        dialog.pack();
        SwingUtil.center(dialog);
        dialog.show();
        return this.choice;
    }

    public int showOpenDialog(Component parent) {
        return this.showDialog(parent, "Open");
    }

    public int showSaveDialog(Component parent) {
        return this.showDialog(parent, "Save");
    }

    public File[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        File[] files = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            files[i] = (File)paths[i].getLastPathComponent();
            ++i;
        }
        return files;
    }

    protected static class UIExtension
    extends BasicFileChooserUI {
        public UIExtension() {
            super(new JFileChooser());
        }

        public Icon getFileIcon() {
            return this.fileIcon;
        }

        public Icon getComputerIcon() {
            return this.computerIcon;
        }

        public Icon getDirectoryIcon() {
            return this.directoryIcon;
        }

        public Icon getHardDriveIcon() {
            return this.hardDriveIcon;
        }

        public Icon getFloppyDriveIcon() {
            return this.floppyDriveIcon;
        }

        public Icon getHomeFolderIcon() {
            return this.homeFolderIcon;
        }

        public Icon getUpFolderIcon() {
            return this.upFolderIcon;
        }
    }

    protected class FileCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 4350638134436017539L;

        protected FileCellRenderer() {
        }

        protected void setIcons(Icon icon) {
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof FileSystemTreeModel.DummyRoot) {
                this.setIcons(MultiFileChooser.this.computerIcon);
            }
            String fileName = value.toString();
            if (value instanceof File) {
                File file = (File)value;
                if (file.isDirectory()) {
                    this.setIcons(MultiFileChooser.this.directoryIcon);
                } else {
                    this.setIcons(MultiFileChooser.this.fileIcon);
                }
                if (!MultiFileChooser.this.model.getRoot().equals(file)) {
                    fileName = file.getName();
                }
            }
            return super.getTreeCellRendererComponent(tree, fileName, sel, expanded, leaf, row, hasFocus);
        }
    }

    protected class ButtonListener
    implements ActionListener {
        protected int option;
        protected JDialog dialog;

        public ButtonListener(int option, JDialog dialog) {
            this.option = option;
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            MultiFileChooser.this.choice = this.option;
            this.dialog.hide();
        }
    }
}

