/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing.dragtree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.geneontology.swing.DragTree;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DragListener;

public class DefaultDragTreeListener
implements DragListener {
    protected JTree tree;
    protected Image dragEnabledImage;
    protected Image dragDisabledImage;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected static final Point offset = new Point(0, 0);

    public DefaultDragTreeListener(JTree tree) {
        this.tree = tree;
        tree.add(this.rendererPane);
    }

    public Point getDragOffset(DragEvent e, boolean allow) {
        return offset;
    }

    public boolean allowDrag(MouseEvent e) {
        int[] rows = this.tree.getSelectionRows();
        return rows != null && rows.length > 0;
    }

    protected void buildImageCache() {
        this.dragEnabledImage = this.getDragImage(this.tree.getSelectionRows());
        this.dragDisabledImage = new BufferedImage(this.dragEnabledImage.getWidth(null), this.dragEnabledImage.getHeight(null), 2);
        Graphics imageGraphics = this.dragDisabledImage.getGraphics();
        imageGraphics.drawImage(this.dragEnabledImage, 0, 0, null);
        imageGraphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        imageGraphics.fillRect(0, 0, this.dragDisabledImage.getWidth(null), this.dragDisabledImage.getHeight(null));
    }

    protected void clearImageCache() {
        this.dragEnabledImage = null;
        this.dragDisabledImage = null;
    }

    protected BufferedImage getDragImage(int[] row) {
        int highlightRow = -1;
        int clickTargetRow = -1;
        if (this.tree instanceof DragTree) {
            clickTargetRow = ((DragTree)this.tree).getClickTarget();
            highlightRow = ((DragTree)this.tree).getHighlightRow();
            ((DragTree)this.tree).highlightDropTarget(-1);
            ((DragTree)this.tree).indicateClickTarget(-1);
        }
        TreeCellRenderer rend = this.tree.getCellRenderer();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < row.length) {
            Component rendComponent = rend.getTreeCellRendererComponent(this.tree, this.tree.getPathForRow(row[i]).getLastPathComponent(), false, false, false, row[i], false);
            this.rendererPane.add(rendComponent);
            rendComponent.validate();
            Dimension dim = rendComponent.getPreferredSize();
            rendComponent.setVisible(true);
            width = (int)Math.max((double)width, dim.getWidth());
            height = (int)((double)height + dim.getHeight());
            ++i;
        }
        BufferedImage out = new BufferedImage(width, height, 2);
        Graphics2D graphics = out.createGraphics();
        graphics.setColor(new Color(0, 0, 255, 80));
        graphics.fillRect(0, 0, width, height);
        graphics.setClip(0, 0, width, height);
        int i2 = 0;
        while (i2 < row.length) {
            Component rendComponent = rend.getTreeCellRendererComponent(this.tree, this.tree.getPathForRow(row[i2]).getLastPathComponent(), false, false, false, row[i2], false);
            Dimension dim = rendComponent.getPreferredSize();
            this.rendererPane.paintComponent(graphics, rendComponent, this.tree, 0, i2 * dim.height, width, dim.height, true);
            if (i2 != row.length - 1) {
                graphics.setColor(new Color(0, 0, 255, 180));
                graphics.drawLine(0, (int)(dim.getHeight() * (double)(i2 + 1)), width, (int)(dim.getHeight() * (double)(i2 + 1)));
            }
            ++i2;
        }
        this.rendererPane.removeAll();
        if (this.tree instanceof DragTree) {
            ((DragTree)this.tree).highlightDropTarget(highlightRow);
            ((DragTree)this.tree).indicateClickTarget(clickTargetRow);
        }
        return out;
    }

    public Image getDragImage(DragEvent e, boolean dropAllowed) {
        if (this.dragEnabledImage == null || this.dragDisabledImage == null) {
            this.buildImageCache();
        }
        if (dropAllowed) {
            return this.dragEnabledImage;
        }
        return this.dragDisabledImage;
    }

    public Cursor getDragCursor(DragEvent e, boolean dropAllowed) {
        if (this.tree instanceof DragTree) {
            return ((DragTree)this.tree).getCursor(e.getModifiers(), dropAllowed);
        }
        return null;
    }

    public Object getDragData(MouseEvent e) {
        return this.tree.getSelectionPaths();
    }

    public void dragging(DragEvent e) {
    }

    public void dragEnd(DragEvent e) {
        this.clearImageCache();
    }

    public void dropped(DragEvent e) {
        this.clearImageCache();
    }
}

