/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.Icon;

public class MultiIcon
implements Icon {
    protected Vector icons = new Vector();
    protected int iconSpacing = 5;

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int i = 0;
        while (i < this.icons.size()) {
            Icon icon = (Icon)this.icons.get(i);
            icon.paintIcon(c, g, x, y);
            x += icon.getIconWidth() + this.iconSpacing;
            ++i;
        }
    }

    public int getIconWidth() {
        int totalWidth = 0;
        int i = 0;
        while (i < this.icons.size()) {
            Icon icon = (Icon)this.icons.get(i);
            if (i > 0) {
                totalWidth += this.iconSpacing;
            }
            totalWidth += icon.getIconWidth();
            ++i;
        }
        return totalWidth;
    }

    public int getIconHeight() {
        int maxHeight = 0;
        int i = 0;
        while (i < this.icons.size()) {
            Icon icon = (Icon)this.icons.get(i);
            if (icon.getIconHeight() > maxHeight) {
                maxHeight = icon.getIconHeight();
            }
            ++i;
        }
        return maxHeight;
    }

    public void addIcon(Icon icon) {
        this.icons.add(icon);
    }

    public void removeIcon(Icon icon) {
        this.icons.remove(icon);
    }

    public void clearIcons() {
        this.icons.clear();
    }
}

