/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.plaf.kde;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.geneontology.plaf.AbstractMenu;
import org.geneontology.plaf.AbstractMenuItem;

public class KDEUtil {
    private static final String[] PATHS = new String[]{"apps", "actions", "devices", "filesystems", "mimetypes"};

    protected static String run(String cmd) throws Exception {
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = reader.readLine();
        reader.close();
        return line;
    }

    protected KDEMenuItem getMenuItem(KDEMenuItem menu, File pathroot, File mainpath, File file) throws IOException {
        if (!file.exists()) {
            return menu;
        }
        Properties p = new Properties();
        p.load(new FileInputStream(file));
        String name = p.getProperty("Name");
        if (name != null) {
            menu.setLabel(name);
        }
        menu.setNoDisplay(Boolean.valueOf(p.getProperty("Hidden")));
        String iconPath = p.getProperty("Icon");
        menu.setIconPath(this.getIconPath(iconPath, pathroot, mainpath));
        return menu;
    }

    protected String getIconPath(String iconPath, File pathroot, File mainpath) throws IOException {
        if (iconPath == null) {
            return null;
        }
        File iconFile = new File(iconPath);
        if (iconFile.exists()) {
            return iconPath;
        }
        if (!(iconFile.getName().endsWith(".png") || iconFile.getName().endsWith(".jpg") || iconFile.getName().endsWith(".gif"))) {
            iconPath = String.valueOf(iconPath) + ".png";
        }
        if (iconFile.getParent() == null || iconFile.getParent().length() == 0) {
            int i = 0;
            while (i < PATHS.length) {
                File temp = new File(mainpath, "share/icons/crystalsvg/16x16/" + PATHS[i] + "/" + iconPath);
                if (temp.exists()) {
                    return temp.getCanonicalPath();
                }
                temp = new File(pathroot, "share/icons/crystalsvg/16x16/" + PATHS[i] + "/" + iconPath);
                if (temp.exists()) {
                    return temp.getCanonicalPath();
                }
                ++i;
            }
        }
        return null;
    }

    protected KDEMenu getMenu(KDEMenu menu, File pathroot, File mainpath, File file) throws IOException {
        if (!file.exists()) {
            return menu;
        }
        Properties p = new Properties();
        p.load(new FileInputStream(file));
        String name = p.getProperty("Name");
        if (name != null) {
            menu.setLabel(name);
        }
        menu.setNoDisplay(Boolean.valueOf(p.getProperty("NoDisplay")));
        String iconPath = p.getProperty("Icon");
        menu.setIconPath(this.getIconPath(iconPath, pathroot, mainpath));
        return menu;
    }

    protected void buildMenu(File pathroot, File mainpath, String ext, HashMap map, KDEMenu parent) throws IOException {
        File dir = new File(pathroot, ext);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            String localext = String.valueOf(ext) + "/" + files[i].getName();
            if (files[i].isDirectory()) {
                KDEMenu menu = (KDEMenu)map.get(localext);
                if (menu == null) {
                    menu = new KDEMenu(files[i].toString(), null, null, localext);
                    map.put(localext, menu);
                    parent.addMenuItem(menu);
                }
                this.getMenu(menu, pathroot, mainpath, new File(files[i], ".directory"));
                this.buildMenu(pathroot, mainpath, localext, map, menu);
            } else if (files[i].getName().endsWith(".desktop")) {
                KDEMenuItem item = (KDEMenuItem)map.get(localext);
                if (item == null) {
                    item = new KDEMenuItem(files[i].toString(), null, null, localext);
                    map.put(localext, item);
                    parent.addMenuItem(item);
                }
                this.getMenuItem(item, pathroot, mainpath, files[i]);
            }
            ++i;
        }
    }

    public AbstractMenuItem getSystemMenu() throws Exception {
        File kdepath = new File(KDEUtil.run("kde-config --prefix"));
        File kdepathlocal = new File(KDEUtil.run("kde-config --localprefix"));
        HashMap itemHash = new HashMap();
        boolean isroot = System.getProperty("user.name").equals("root");
        KDEMenu menu = new KDEMenu("KDE Main Menu", null, null, "");
        menu.setNoDisplay(false);
        this.buildMenu(kdepath, kdepath, "share/applnk", itemHash, menu);
        this.buildMenu(kdepathlocal, kdepath, "share/applnk", itemHash, menu);
        menu.cleanup();
        return menu;
    }

    protected void writeMenuItem(KDEMenuItem kdeitem, File kdeprefix) throws Exception {
        if (kdeitem instanceof AbstractMenu) {
            File dir = new File(kdeprefix, kdeitem.getFileLoc());
            dir.mkdir();
            File file = new File(dir, ".directory");
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            stream.println("[Desktop Entry]");
            stream.println("Icon=" + kdeitem.getIconPath());
            stream.println("Name=" + kdeitem.getLabel());
            stream.println("NoDisplay=" + kdeitem.noDisplay());
            stream.close();
        } else {
            File file = new File(kdeprefix, kdeitem.getFileLoc());
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            stream.println("[Desktop Entry]");
            stream.println("Comment=");
            stream.println("Path=");
            stream.println("Terminal=0");
            stream.println("TerminalOptions=");
            stream.println("Type=Application");
            stream.println("X-KDE-SubstituteUID=false");
            stream.println("X-KDE-Username=");
            if (kdeitem.getIconPath() != null) {
                stream.println("Icon=" + kdeitem.getIconPath());
            }
            stream.println("Name=" + kdeitem.getLabel());
            stream.println("Hidden=" + kdeitem.noDisplay());
            stream.println("Exec=" + kdeitem.getExecPath());
            stream.close();
        }
    }

    public void removeMenuItem(AbstractMenuItem item) throws Exception {
        if (!(item instanceof KDEMenuItem)) {
            throw new IllegalArgumentException("The menu item must be the result of a call to KDEUtil.getSystemMenu()");
        }
        File kdeprefix = KDEUtil.getKDEMenuPrefix();
        ((KDEMenuItem)item).setNoDisplay(false);
        this.writeMenuItem((KDEMenuItem)item, kdeprefix);
    }

    public static File getKDEMenuPrefix() throws Exception {
        if (System.getProperty("user.name").equals("root")) {
            return new File(String.valueOf(KDEUtil.run("kde-config --prefix")) + "/share/applnk");
        }
        return new File(String.valueOf(KDEUtil.run("kde-config --localprefix")) + "/share/applnk");
    }

    public AbstractMenuItem addMenuItem(AbstractMenu menu, String label, String path, String iconPath, boolean isSubMenu) throws Exception {
        if (!(menu instanceof KDEMenu)) {
            throw new IllegalArgumentException("The parent menu must be the result of a call to KDEUtil.getSystemMenu()");
        }
        File kdeprefix = KDEUtil.getKDEMenuPrefix();
        KDEMenuItem kdeitem = isSubMenu ? new KDEMenu(label, path, iconPath, label) : new KDEMenuItem(label, path, iconPath, String.valueOf(label) + ".desktop");
        kdeitem.setNoDisplay(false);
        ((KDEMenu)menu).addMenuItem(kdeitem);
        ((KDEMenu)menu).setNoDisplay(false);
        this.writeMenuItem((KDEMenu)menu, kdeprefix);
        this.writeMenuItem(kdeitem, kdeprefix);
        return kdeitem;
    }

    public void commitMenuChanges() throws Exception {
        KDEUtil.run("kbuildsycoca --checkstamps --incremental");
    }

    private class KDEMenu
    extends KDEMenuItem
    implements AbstractMenu {
        private static final long serialVersionUID = 6413209099505211363L;
        protected Vector items = new Vector();

        public KDEMenu(String label, String path, String icon, String fileloc) {
            super(label, path, icon, fileloc);
        }

        public boolean noDisplay() {
            if (this.nodisplay) {
                return true;
            }
            int i = 0;
            while (i < this.items.size()) {
                KDEMenuItem item = (KDEMenuItem)this.items.get(i);
                if (!item.noDisplay()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int getItemCount() {
            return this.items.size();
        }

        public AbstractMenuItem getItemAt(int index) {
            return (AbstractMenuItem)this.items.get(index);
        }

        public void addMenuItem(KDEMenuItem item) {
            File filename = new File(item.fileloc);
            File newpath = new File(this.fileloc, filename.getName());
            item.fileloc = newpath.toString();
            this.items.add(item);
        }

        protected void cleanup() {
            HashSet<KDEMenuItem> del = new HashSet<KDEMenuItem>();
            int i = 0;
            while (i < this.items.size()) {
                KDEMenuItem item = (KDEMenuItem)this.items.get(i);
                if (item.noDisplay()) {
                    del.add(item);
                } else if (item instanceof KDEMenu) {
                    ((KDEMenu)item).cleanup();
                }
                ++i;
            }
            this.items.removeAll(del);
            Collections.sort(this.items, new Comparator(this){
                final /* synthetic */ KDEMenu this$1;
                {
                    this.this$1 = kDEMenu;
                }

                public int compare(Object a, Object b) {
                    KDEMenuItem itema = (KDEMenuItem)a;
                    KDEMenuItem itemb = (KDEMenuItem)b;
                    if (itema instanceof KDEMenu && !(itemb instanceof KDEMenu)) {
                        return -1;
                    }
                    if (itemb instanceof KDEMenu && !(itema instanceof KDEMenu)) {
                        return 1;
                    }
                    int cval = itema.getLabel().compareTo(itemb.getLabel());
                    if (cval < 0) {
                        return -1;
                    }
                    if (cval > 0) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }

    private class KDEMenuItem
    implements AbstractMenuItem {
        private static final long serialVersionUID = -589420569929858898L;
        protected String label;
        protected String path;
        protected String icon;
        protected boolean nodisplay;
        protected String fileloc;

        public KDEMenuItem(String label, String path, String icon, String fileloc) {
            this.label = label;
            this.path = path;
            this.icon = icon;
            this.fileloc = fileloc;
            this.nodisplay = true;
        }

        public String getFileLoc() {
            return this.fileloc;
        }

        public String getIconPath() {
            return this.icon;
        }

        public String getLabel() {
            return String.valueOf(this.label) + (this.noDisplay() ? "(nodisplay)" : "");
        }

        public String getExecPath() {
            return this.path;
        }

        public boolean noDisplay() {
            return this.nodisplay;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setIconPath(String icon) {
            this.icon = icon;
        }

        public void setExecPath(String path) {
            this.path = path;
        }

        public void setNoDisplay(boolean nodisplay) {
            this.nodisplay = nodisplay;
        }

        public String toString() {
            return String.valueOf(this.getLabel()) + "\n" + "   fileloc = " + this.fileloc + "\n";
        }
    }
}

