/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.expression.parser;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.geneontology.expression.FunctionDef;
import org.geneontology.expression.JexlContext;
import org.geneontology.expression.parser.ASTIdentifier;
import org.geneontology.expression.parser.BindException;
import org.geneontology.expression.parser.Parser;
import org.geneontology.expression.parser.ParserVisitor;
import org.geneontology.expression.parser.ReturnValueException;
import org.geneontology.expression.parser.SimpleNode;
import org.geneontology.expression.util.Introspector;
import org.geneontology.expression.util.introspection.Info;
import org.geneontology.expression.util.introspection.VelMethod;

public class ASTMethod
extends SimpleNode {
    private static final Info DUMMY = new Info("", 1, 1);

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc) throws Exception {
        return this.execute(null, jc);
    }

    public Object execute(Object obj, JexlContext jc) throws Exception {
        String methodName = ((ASTIdentifier)this.jjtGetChild((int)0)).val;
        int paramCount = this.jjtGetNumChildren() - 1;
        Object[] params = new Object[paramCount];
        try {
            int i = 0;
            while (i < paramCount) {
                params[i] = ((SimpleNode)this.jjtGetChild(i + 1)).value(jc);
                ++i;
            }
            FunctionDef def = null;
            if (obj == null) {
                def = this.getEnclosingScript().getFunction(methodName, jc);
            }
            if (def != null) {
                try {
                    return def.execute(jc, params, this);
                }
                catch (ReturnValueException ex) {
                    return ex.getValue();
                }
            }
            VelMethod vm = Introspector.getUberspect().getMethod(obj, methodName, params, DUMMY);
            if (vm == null) {
                int i2 = 0;
                while (i2 < params.length) {
                    Object param = params[i2];
                    if (param instanceof Number) {
                        params[i2] = this.narrow((Number)param);
                    }
                    ++i2;
                }
                vm = Introspector.getUberspect().getMethod(obj, methodName, params, DUMMY);
                if (vm == null) {
                    throw new BindException("Called unknown method " + methodName, this.getLineNum(), this.getCharNum());
                }
            }
            return vm.invoke(obj, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    private Number narrow(Number original) {
        if (original == null || original instanceof BigDecimal || original instanceof BigInteger) {
            return original;
        }
        Number result = original;
        if (original instanceof Double || original instanceof Float) {
            double value = original.doubleValue();
            if (value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = new Float(result.floatValue());
            }
        } else {
            long value = original.longValue();
            if (value <= 127L && value >= -128L) {
                result = new Byte((byte)value);
            } else if (value <= 32767L && value >= -32768L) {
                result = new Short((short)value);
            } else if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                result = new Integer((int)value);
            }
        }
        return result;
    }
}

