/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.expression;

import java.io.StringReader;
import org.geneontology.expression.Expression;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.ExpressionImpl;
import org.geneontology.expression.parser.ASTExpressionExpression;
import org.geneontology.expression.parser.ASTForeachStatement;
import org.geneontology.expression.parser.ASTIfStatement;
import org.geneontology.expression.parser.ASTReferenceExpression;
import org.geneontology.expression.parser.ASTStatementExpression;
import org.geneontology.expression.parser.ASTWhileStatement;
import org.geneontology.expression.parser.ParseException;
import org.geneontology.expression.parser.Parser;
import org.geneontology.expression.parser.SimpleNode;
import org.geneontology.expression.parser.TokenMgrError;

public class ExpressionFactory {
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ExpressionFactory ef = new ExpressionFactory();

    private ExpressionFactory() {
    }

    protected static ExpressionFactory getInstance() {
        return ef;
    }

    public static Expression createExpression(String expression) throws Exception {
        return ExpressionFactory.getInstance().createNewExpression(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createNewExpression(String expression) throws ExpressionException {
        SimpleNode tree;
        String expr = this.cleanExpression(expression);
        Parser parser = ExpressionFactory.parser;
        synchronized (parser) {
            try {
                tree = ExpressionFactory.parser.parse(new StringReader(expr));
            }
            catch (TokenMgrError tme) {
                throw new ParseException(tme.getMessage());
            }
            catch (Exception e) {
                throw new ExpressionException(e);
            }
        }
        SimpleNode node = (SimpleNode)tree.jjtGetChild(0);
        if (node instanceof ASTReferenceExpression || node instanceof ASTExpressionExpression || node instanceof ASTStatementExpression || node instanceof ASTIfStatement || node instanceof ASTWhileStatement || node instanceof ASTForeachStatement) {
            return new ExpressionImpl(expression, node);
        }
        throw new ExpressionException("Invalid Expression: not a Reference, Expression, Statement or If");
    }

    private String cleanExpression(String expression) {
        String expr = expression.trim();
        if (!expr.endsWith(";")) {
            expr = String.valueOf(expr) + ";";
        }
        return expr;
    }
}

