/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.OntologyCheck;
import org.geneontology.util.ProgressEvent;

public class NameRedundancyCheck
extends AbstractCheck
implements OntologyCheck {
    protected void initConfiguration() {
        this.configuration.setCondition((byte)13);
    }

    public Collection check(OBOSession session, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        LinkedList<CheckWarning> out = new LinkedList<CheckWarning>();
        if (currentObject == null) {
            int percentage;
            HashMap nameMap = new HashMap();
            Iterator<Object> it = session.getObjects().iterator();
            int i = 0;
            while (it.hasNext()) {
                IdentifiedObject io = (IdentifiedObject)it.next();
                percentage = 50 * i / session.getObjects().size();
                this.fireProgressEvent(new ProgressEvent((Object)this, percentage, "checking object " + (i + 1) + " of " + session.getObjects().size()));
                if (checkObsoletes || !TermUtil.isObsolete(io)) {
                    this.createMapping(nameMap, io.getName(), io);
                    if (io instanceof SynonymedObject) {
                        SynonymedObject so = (SynonymedObject)io;
                        Iterator it2 = so.getSynonyms().iterator();
                        while (it2.hasNext()) {
                            Synonym s = (Synonym)it2.next();
                            if (s.getScope() != 1) continue;
                            this.createMapping(nameMap, s.getText(), io);
                        }
                    }
                }
                ++i;
            }
            it = nameMap.keySet().iterator();
            int j = 0;
            while (it.hasNext()) {
                String name = (String)it.next();
                percentage = 50 + 50 * j / nameMap.keySet().size();
                this.fireProgressEvent(new ProgressEvent((Object)this, percentage, "checking name " + (j + 1) + " of " + nameMap.keySet().size()));
                Collection c = (Collection)nameMap.get(name);
                if (c.size() > 1) {
                    StringBuffer termList = new StringBuffer();
                    Iterator it2 = c.iterator();
                    for (int i2 = 0; i2 < c.size(); ++i2) {
                        IdentifiedObject io = (IdentifiedObject)it2.next();
                        if (!checkObsoletes && TermUtil.isObsolete(io)) continue;
                        if (i2 > 0 && c.size() > 2) {
                            termList.append(", ");
                        }
                        if (i2 == c.size() - 1) {
                            termList.append("and ");
                        }
                        termList.append("<a href='file:" + io.getID() + "'>" + io.getName() + " (" + io.getID() + ")</a>");
                    }
                    it2 = c.iterator();
                    while (it2.hasNext()) {
                        IdentifiedObject io = (IdentifiedObject)it2.next();
                        if (!checkObsoletes && TermUtil.isObsolete(io)) continue;
                        CheckWarning warning = new CheckWarning("The terms " + termList.toString() + "share the name or synonym \"" + name + "\".", false, this, io);
                        out.add(warning);
                    }
                }
                ++j;
            }
        } else {
            Iterator it;
            if (!checkObsoletes && TermUtil.isObsolete(currentObject)) {
                return Collections.EMPTY_LIST;
            }
            HashSet<String> names = new HashSet<String>();
            if (currentObject instanceof SynonymedObject) {
                it = ((SynonymedObject)currentObject).getSynonyms().iterator();
                while (it.hasNext()) {
                    Synonym s = (Synonym)it.next();
                    if (s.getScope() != 1) continue;
                    names.add(s.getText());
                }
            }
            it = session.getObjects().iterator();
            while (it.hasNext()) {
                IdentifiedObject io = (IdentifiedObject)it.next();
                if (io.equals(currentObject) || !checkObsoletes && TermUtil.isObsolete(io)) continue;
                if (io.getName().equals(currentObject.getName())) {
                    CheckWarning warning = new CheckWarning("The current term has the same name as " + io.getID(), false, this, currentObject);
                    out.add(warning);
                }
                if (!(io instanceof SynonymedObject)) continue;
                Iterator it2 = ((SynonymedObject)io).getSynonyms().iterator();
                while (it2.hasNext()) {
                    Synonym s = (Synonym)it2.next();
                    if (s.getScope() != 1 || !s.getText().equals(currentObject.getName())) continue;
                    CheckWarning warning = new CheckWarning("The current term name is the same as a synonym of " + io.getName() + " (" + io.getID() + ")", false, this, currentObject);
                    out.add(warning);
                }
                if (!names.contains(io.getName())) continue;
                CheckWarning warning = new CheckWarning("The current term synonym \"" + io.getName() + "\" is " + "in use as the term name of " + io.getID(), false, this, currentObject);
                out.add(warning);
            }
        }
        return out;
    }

    protected void createMapping(Map nameMap, String name, IdentifiedObject io) {
        HashSet<IdentifiedObject> c = (HashSet<IdentifiedObject>)nameMap.get(name);
        if (c == null) {
            c = new HashSet<IdentifiedObject>();
            nameMap.put(name, c);
        }
        c.add(io);
    }

    public String getDescription() {
        return "Name Redundancy Check";
    }

    public String getID() {
        return "NAME_REDUNDANCY_CHECK";
    }
}

