/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.history.CommentChangeHistoryItem;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.oboedit.verify.impl.AbstractTextCheck;

public class CommentCheck
extends AbstractTextCheck {
    public CommentCheck() {
        this.setAllowNewlines(true);
        this.setAllowBlank(true);
        this.setSentenceStructureChecks(true);
        this.setAllowExtended(Controller.getController().getPreferences().getAllowExtendedCharacters());
    }

    public String getID() {
        return "COMMENT_CHECK";
    }

    public String getDescription() {
        return "Comment checks";
    }

    public String getWarningLabel(IdentifiedObject io, byte condition, int index) {
        if (VerificationEngine.isTextCommitCondition(condition)) {
            return "Comment";
        }
        return "Comment of <a href='file:" + io.getID() + "'>" + io.getID() + "</a>";
    }

    public HistoryItem getFieldChangeHistoryItem(IdentifiedObject currentObject, String newText) {
        return new CommentChangeHistoryItem((CommentedObject)currentObject, newText);
    }

    public Collection getStrings(IdentifiedObject io) {
        if (io instanceof CommentedObject) {
            LinkedList<String> out = new LinkedList<String>();
            out.add(((CommentedObject)io).getComment());
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

