/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.OBOSession;

public class SimpleOBORoundtripTest
extends TestCase {
    public String[] testFiles = new String[]{"lib/resources/testfile.1.0.obo"};

    public void testRoundtrip() throws DataAdapterException, IOException {
        for (int i = 0; i < this.testFiles.length; ++i) {
            OBOFileAdapter adapter = new OBOFileAdapter();
            OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
            config.getReadPaths().add(this.testFiles[i].toString());
            OBOSession session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
            config = new OBOFileAdapter.OBOAdapterConfiguration();
            File outFile = File.createTempFile("test", "obo");
            outFile.deleteOnExit();
            config.setWritePath(outFile.getAbsolutePath());
            adapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)config, session);
            config = new OBOFileAdapter.OBOAdapterConfiguration();
            config.getReadPaths().add(outFile.getAbsolutePath());
            OBOSession session2 = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
            HistoryList allChanges = HistoryGenerator.getHistory(session, session2);
            SimpleOBORoundtripTest.assertTrue((String)("The file should be exactly the same going in as going out; allChanges = " + allChanges.getHistoryList()), (allChanges.size() == 0 ? 1 : 0) != 0);
            outFile.delete();
        }
    }
}

