/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import org.bounce.text.xml.XMLEditorKit;
import org.geneontology.expression.ExpressionException;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DbxrefListEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.SwingUtil;
import org.geneontology.swing.XMLLayout;
import org.geneontology.util.XMLUtil;
import org.xml.sax.SAXParseException;

public class ConfigurationPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 683746976443349712L;
    ListEditor iconList;
    JTextField selectionBatchField;
    JTextField browserCommandField;
    JCheckBox useDefaultBrowserBox;
    JTextField userField;
    JTextField fullnameField;
    JTextField emailField;
    JTextField startField;
    JTextField endField;
    JTextField prefixField;
    JTextField idLengthField;
    JTextField defaultIDAdapterField;
    JCheckBox allowCyclesBox;
    JCheckBox warnBeforeDeleteBox;
    JCheckBox warnBeforeDefinitionLossBox;
    JCheckBox advancedRootDetectionBox;
    JCheckBox autoCommitCheckBox;
    JCheckBox warnBeforeDiscardingEditsBox;
    JTextField historyFilePath;
    JButton commitButton;
    JEditorPane xmlArea;
    JLabel xmlErrorLabel;
    JTabbedPane mainPanel;
    JTextField memoryField;
    JComboBox fontNameList;
    JComboBox fontSizeList;
    JComboBox fontTypeList;
    JTextArea fontPreviewArea;
    JCheckBox showUndefinedTermsBox;
    JCheckBox caseSensitiveSortBox;
    JCheckBox showToolTipsBox;
    JCheckBox confirmOnExitBox;
    JCheckBox autosaveEnabledCheckBox;
    JTextField autosavePathField;
    JTextField autosaveExpirationField;
    JTextField autosaveWaitField;
    JComboBox filterMethodBox;
    DbxrefListEditor dbxrefEditor;
    DbxrefListEditor defDbxrefListEditor;
    ListEditor defDbxrefList;
    JCheckBox allowExtendedCheckbox;
    JTextArea defTextArea = new JTextArea();
    JCheckBox personalDefCheckbox = new JCheckBox("Use personal definition");
    private Vector icons;

    public void setController(Controller controller) {
        super.setController(controller);
    }

    protected void selectListItem(JComboBox list, Object item) {
        list.removeItem(item);
        list.insertItemAt(item, 0);
        list.setSelectedIndex(0);
    }

    protected Font getChosenFont() {
        return Preferences.decodeFont((String)this.fontNameList.getSelectedItem(), (String)this.fontSizeList.getSelectedItem(), (String)this.fontTypeList.getSelectedItem());
    }

    public void buildFontPreview() {
        this.fontPreviewArea.setFont(this.getChosenFont());
        this.revalidate();
        this.repaint();
    }

    protected void indentXML() {
        this.xmlArea.setText(XMLUtil.indentXML((String)this.xmlArea.getText()));
    }

    protected void setLayoutXML(String xml) {
        String cleanedupXML = this.wrapLayoutXML(xml);
        if (cleanedupXML.equals(xml)) {
            this.xmlArea.setText(xml);
        } else {
            cleanedupXML = XMLUtil.indentXML((String)cleanedupXML);
            this.xmlArea.setText(cleanedupXML);
        }
        this.xmlArea.setCaretPosition(0);
    }

    protected String wrapLayoutXML(String xml) {
        if (!(xml = xml.trim()).startsWith("<xmllayout>") && !xml.endsWith("</xmllayout>")) {
            xml = "<xmllayout>\n" + xml + "\n</xmllayout>";
        }
        return xml;
    }

    protected String getLayoutXML() {
        String xml = this.xmlArea.getText();
        return this.wrapLayoutXML(xml);
    }

    protected void formatField(JLabel label, JTextField field) {
        field.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)field.getPreferredSize().getHeight()));
        label.setMaximumSize(label.getPreferredSize());
    }

    protected void updatePersonalDefFields(boolean enabled) {
        this.defTextArea.setEnabled(enabled);
        this.defDbxrefList.setEnabled(enabled);
    }

    public void init() {
        this.removeAll();
        this.mainPanel = new JTabbedPane();
        this.setFont(this.controller.getDefaultFont());
        this.setLayout(new BorderLayout());
        JLabel noIconLabel = new JLabel("Click an icon definition to edit");
        noIconLabel.setFont(this.controller.getDefaultFont());
        this.icons = this.getIcons();
        this.commitButton = new JButton("Save Configuration");
        this.commitButton.setAlignmentX(0.5f);
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.commitButton.setBackground(Preferences.defaultButtonColor());
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPlugin.this.save();
            }
        });
        this.iconList = new ListEditor((GenericEditorComponent)new IconEditor(), (Component)noIconLabel, this.icons, true, true, true, true, false);
        this.iconList.setBorder((Border)new TitledBorder("Relationship Type Icons"));
        this.iconList.setBackground(Preferences.defaultBackgroundColor());
        this.iconList.setButtonColor(Preferences.defaultButtonColor());
        this.iconList.setFont(this.controller.getDefaultFont());
        this.iconList.setMinimumSize(new Dimension(0, 0));
        Box allowBox = new Box(0);
        Box warnDeleteBox = new Box(0);
        Box warnDefinitionBox = new Box(0);
        Box advancedRootBox = new Box(0);
        Box autoCommitPanel = new Box(0);
        JLabel userLabel = new JLabel("User Name", 11);
        JLabel fullnameLabel = new JLabel("Full Name", 11);
        JLabel emailLabel = new JLabel("Email Address", 11);
        JLabel startLabel = new JLabel("Start of id range", 11);
        JLabel endLabel = new JLabel("End of id range", 11);
        JLabel prefixLabel = new JLabel("Default id prefix", 11);
        JLabel idLengthLabel = new JLabel("Default id length", 11);
        JLabel idAdapterLabel = new JLabel("Default id adapter name", 11);
        JLabel selectionBatchLabel = new JLabel("Selection batch size", 11);
        JTextArea noDbxLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noDbxLabel.setMinimumSize(new Dimension(0, 0));
        noDbxLabel.setOpaque(false);
        noDbxLabel.setFont(Controller.getController().getDefaultFont());
        noDbxLabel.setLineWrap(true);
        noDbxLabel.setWrapStyleWord(true);
        noDbxLabel.setEditable(false);
        noDbxLabel.setEnabled(false);
        final JLabel browserLabel = new JLabel("Browser command", 11);
        this.startField = new JTextField(20);
        this.userField = new JTextField(20);
        this.fullnameField = new JTextField(20);
        this.emailField = new JTextField(20);
        this.endField = new JTextField(20);
        this.prefixField = new JTextField(20);
        this.idLengthField = new JTextField(3);
        this.selectionBatchField = new JTextField(3);
        this.defaultIDAdapterField = new JTextField(20);
        this.browserCommandField = new JTextField(20);
        this.dbxrefEditor = new DbxrefListEditor(this.controller, -1);
        this.defDbxrefListEditor = new DbxrefListEditor(this.controller, 2);
        this.defDbxrefList = new ListEditor((GenericEditorComponent)this.defDbxrefListEditor, (Component)noDbxLabel, new Vector(0), true, true, true, true, true);
        this.allowExtendedCheckbox = new JCheckBox("Allow extended characters");
        this.allowExtendedCheckbox.setFont(Controller.getController().getPreferences().getFont());
        this.allowExtendedCheckbox.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.defDbxrefList.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.defDbxrefList.setFont(Controller.getController().getPreferences().getFont());
        this.defDbxrefList.setButtonColor(Controller.getController().getPreferences().getButtonColor());
        this.formatField(startLabel, this.startField);
        this.formatField(userLabel, this.userField);
        this.formatField(fullnameLabel, this.fullnameField);
        this.formatField(emailLabel, this.emailField);
        this.formatField(endLabel, this.endField);
        this.formatField(prefixLabel, this.prefixField);
        this.formatField(idLengthLabel, this.idLengthField);
        this.formatField(selectionBatchLabel, this.selectionBatchField);
        this.formatField(browserLabel, this.browserCommandField);
        this.useDefaultBrowserBox = new JCheckBox("Use default browser");
        this.useDefaultBrowserBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPlugin.this.browserCommandField.setEnabled(!ConfigurationPlugin.this.useDefaultBrowserBox.isSelected());
                browserLabel.setEnabled(!ConfigurationPlugin.this.useDefaultBrowserBox.isSelected());
            }
        });
        this.allowCyclesBox = new JCheckBox("Allow new cycles to be created");
        this.warnBeforeDeleteBox = new JCheckBox("Warn before final delete");
        this.warnBeforeDefinitionLossBox = new JCheckBox("Warn before discarding definitions on save");
        this.autoCommitCheckBox = new JCheckBox("Auto commit text edits");
        this.autoCommitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPlugin.this.warnBeforeDiscardingEditsBox.setEnabled(!ConfigurationPlugin.this.autoCommitCheckBox.isSelected());
            }
        });
        this.warnBeforeDiscardingEditsBox = new JCheckBox("Warn before discarding text edits.");
        this.advancedRootDetectionBox = new JCheckBox("Use advanced root detection");
        this.showUndefinedTermsBox = new JCheckBox("Gray out undefined terms");
        this.caseSensitiveSortBox = new JCheckBox("Case sensitive term sorting");
        this.showToolTipsBox = new JCheckBox("Show terms ids as tool tips in term panels");
        this.confirmOnExitBox = new JCheckBox("Confirm on exit");
        this.autosaveEnabledCheckBox = new JCheckBox("Enable Autosave");
        this.autosavePathField = new JTextField();
        this.autosaveExpirationField = new JTextField();
        this.autosaveWaitField = new JTextField();
        String[] filterMethods = new String[]{"LOOSE", "STRICT", "FEWEST_PATHS"};
        this.filterMethodBox = new JComboBox<String>(filterMethods);
        this.filterMethodBox.setFont(this.controller.getDefaultFont());
        this.filterMethodBox.setBackground(Preferences.defaultButtonColor());
        this.filterMethodBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.autosaveEnabledCheckBox.setOpaque(false);
        this.useDefaultBrowserBox.setOpaque(false);
        this.allowCyclesBox.setOpaque(false);
        this.warnBeforeDeleteBox.setOpaque(false);
        this.warnBeforeDefinitionLossBox.setOpaque(false);
        this.autoCommitCheckBox.setOpaque(false);
        this.warnBeforeDiscardingEditsBox.setOpaque(false);
        this.advancedRootDetectionBox.setOpaque(false);
        this.showUndefinedTermsBox.setOpaque(false);
        this.caseSensitiveSortBox.setOpaque(false);
        this.showToolTipsBox.setOpaque(false);
        this.confirmOnExitBox.setOpaque(false);
        this.useDefaultBrowserBox.setSelected(this.controller.getBrowserCommand().length() == 0);
        this.browserCommandField.setEnabled(!this.useDefaultBrowserBox.isSelected());
        browserLabel.setEnabled(!this.useDefaultBrowserBox.isSelected());
        this.autosaveEnabledCheckBox.setSelected(this.controller.getAutosaveEnabled());
        this.dbxrefEditor.load(this.controller.getPersonalDbxref());
        this.autosavePathField.setText(this.controller.getAutosavePath().toString());
        this.autosaveExpirationField.setText(this.controller.getAutosaveExpiration() + "");
        this.autosaveWaitField.setText(this.controller.getAutosaveWaitTime() + "");
        this.startField.setText(this.controller.getMinID() + "");
        this.userField.setText(this.controller.getUserName());
        this.fullnameField.setText(this.controller.getFullName());
        this.emailField.setText(this.controller.getEmailAddress());
        this.endField.setText(this.controller.getMaxID() + "");
        this.prefixField.setText(this.controller.getDefaultPrefix() + "");
        this.idLengthField.setText(this.controller.getIDLength() + "");
        this.selectionBatchField.setText(this.controller.getSelectionBatchSize() + "");
        this.browserCommandField.setText(this.controller.getBrowserCommand() + "");
        this.allowCyclesBox.setSelected(this.controller.allowCycles());
        this.filterMethodBox.setSelectedItem(this.controller.getFilterMethod());
        this.allowExtendedCheckbox.setSelected(this.controller.getPreferences().getAllowExtendedCharacters());
        this.personalDefCheckbox.setSelected(this.controller.getPreferences().getUsePersonalDefinition());
        if (this.controller.getPreferences().getUsePersonalDefinition()) {
            this.defTextArea.setText(this.controller.getPreferences().getPersonalDefinition());
            Vector v = new Vector();
            v.addAll(this.controller.getPreferences().getPersonalDbxrefs());
            this.defDbxrefList.setData(v);
        } else {
            this.defTextArea.setText("");
            this.defDbxrefList.setData(new Vector());
        }
        this.updatePersonalDefFields(this.controller.getPreferences().getUsePersonalDefinition());
        this.autoCommitCheckBox.setSelected(Controller.getController().getPreferences().getAutoCommitTextEdits());
        this.warnBeforeDiscardingEditsBox.setSelected(Controller.getController().getPreferences().getWarnBeforeDiscardingEdits());
        this.warnBeforeDiscardingEditsBox.setEnabled(!this.autoCommitCheckBox.isSelected());
        this.warnBeforeDeleteBox.setSelected(this.controller.warnBeforeDelete());
        this.warnBeforeDefinitionLossBox.setSelected(this.controller.warnBeforeDefinitionLoss());
        this.advancedRootDetectionBox.setSelected(!this.controller.useBasicRootDetection());
        this.caseSensitiveSortBox.setSelected(this.controller.caseSensitiveSort());
        this.showToolTipsBox.setSelected(this.controller.showToolTips());
        this.confirmOnExitBox.setSelected(this.controller.getPreferences().getConfirmOnExit());
        this.defaultIDAdapterField.setText(this.controller.getIDAdapter().getClass().getName());
        this.useDefaultBrowserBox.setFont(this.controller.getDefaultFont());
        this.allowCyclesBox.setFont(this.controller.getDefaultFont());
        this.warnBeforeDeleteBox.setFont(this.controller.getDefaultFont());
        this.warnBeforeDiscardingEditsBox.setFont(this.controller.getDefaultFont());
        this.autoCommitCheckBox.setFont(this.controller.getDefaultFont());
        this.warnBeforeDefinitionLossBox.setFont(this.controller.getDefaultFont());
        this.advancedRootDetectionBox.setFont(this.controller.getDefaultFont());
        this.showUndefinedTermsBox.setFont(this.controller.getDefaultFont());
        this.caseSensitiveSortBox.setFont(this.controller.getDefaultFont());
        this.showToolTipsBox.setFont(this.controller.getDefaultFont());
        this.confirmOnExitBox.setFont(this.controller.getDefaultFont());
        browserLabel.setFont(this.controller.getDefaultFont());
        userLabel.setFont(this.controller.getDefaultFont());
        fullnameLabel.setFont(this.controller.getDefaultFont());
        emailLabel.setFont(this.controller.getDefaultFont());
        startLabel.setFont(this.controller.getDefaultFont());
        endLabel.setFont(this.controller.getDefaultFont());
        prefixLabel.setFont(this.controller.getDefaultFont());
        idAdapterLabel.setFont(this.controller.getDefaultFont());
        idLengthLabel.setFont(this.controller.getDefaultFont());
        selectionBatchLabel.setFont(this.controller.getDefaultFont());
        this.startField.setFont(this.controller.getDefaultFont());
        this.userField.setFont(this.controller.getDefaultFont());
        this.fullnameField.setFont(this.controller.getDefaultFont());
        this.emailField.setFont(this.controller.getDefaultFont());
        this.idLengthField.setFont(this.controller.getDefaultFont());
        this.prefixField.setFont(this.controller.getDefaultFont());
        this.defaultIDAdapterField.setFont(this.controller.getDefaultFont());
        this.endField.setFont(this.controller.getDefaultFont());
        this.selectionBatchField.setFont(this.controller.getDefaultFont());
        this.browserCommandField.setFont(this.controller.getDefaultFont());
        allowBox.add(this.allowCyclesBox);
        allowBox.add(Box.createHorizontalGlue());
        warnDeleteBox.add(this.warnBeforeDeleteBox);
        warnDeleteBox.add(Box.createHorizontalGlue());
        warnDefinitionBox.add(this.warnBeforeDefinitionLossBox);
        warnDefinitionBox.add(Box.createHorizontalGlue());
        advancedRootBox.add(this.advancedRootDetectionBox);
        advancedRootBox.add(Box.createHorizontalGlue());
        autoCommitPanel.add(this.autoCommitCheckBox);
        autoCommitPanel.add(Box.createHorizontalStrut(10));
        autoCommitPanel.add(this.warnBeforeDiscardingEditsBox);
        autoCommitPanel.add(Box.createHorizontalStrut(10));
        autoCommitPanel.add(this.allowExtendedCheckbox);
        autoCommitPanel.add(Box.createHorizontalGlue());
        Box configFileLabelBox = new Box(0);
        JLabel configFileLabel = new JLabel("Config file");
        JLabel configFilePath = new JLabel(System.getProperty("user.home") + "/.oboedit");
        JLabel historyFileLabel = new JLabel("History file");
        this.historyFilePath = new JTextField(40);
        this.historyFilePath.setText(this.controller.getHistoryFilePath());
        configFileLabel.setFont(this.controller.getDefaultFont());
        configFilePath.setFont(this.controller.getDefaultFont());
        this.historyFilePath.setFont(this.controller.getDefaultFont());
        historyFileLabel.setFont(this.controller.getDefaultFont());
        configFileLabelBox.add(configFileLabel);
        configFileLabelBox.add(Box.createHorizontalStrut(20));
        configFileLabelBox.add(Box.createHorizontalGlue());
        configFileLabelBox.add(configFilePath);
        Box historyFileLabelBox = new Box(0);
        historyFileLabelBox.add(historyFileLabel);
        historyFileLabelBox.add(Box.createHorizontalStrut(20));
        historyFileLabelBox.add(Box.createHorizontalGlue());
        historyFileLabelBox.add(this.historyFilePath);
        Box autosaveEnabledBox = new Box(0);
        autosaveEnabledBox.add(this.autosaveEnabledCheckBox);
        autosaveEnabledBox.add(Box.createHorizontalGlue());
        JLabel autosavePathLabel = new JLabel("Autosave file path");
        Box autosavePathBox = new Box(0);
        autosavePathBox.add(Box.createHorizontalStrut(20));
        autosavePathBox.add(autosavePathLabel);
        autosavePathBox.add(Box.createHorizontalStrut(20));
        autosavePathBox.add(Box.createHorizontalGlue());
        autosavePathBox.add(this.autosavePathField);
        JLabel autosaveWaitLabel = new JLabel("Do autosave every");
        JLabel minutesLabel = new JLabel("minutes");
        Box autosaveWaitBox = new Box(0);
        autosaveWaitBox.add(Box.createHorizontalStrut(20));
        autosaveWaitBox.add(autosaveWaitLabel);
        autosaveWaitBox.add(Box.createHorizontalStrut(20));
        autosaveWaitBox.add(this.autosaveWaitField);
        autosaveWaitBox.add(Box.createHorizontalStrut(5));
        autosaveWaitBox.add(minutesLabel);
        JLabel autosaveExpirationLabel = new JLabel("Autosave files expire in");
        Box autosaveExpirationBox = new Box(0);
        JLabel daysLabel = new JLabel("days");
        autosaveExpirationBox.add(Box.createHorizontalStrut(20));
        autosaveExpirationBox.add(autosaveExpirationLabel);
        autosaveExpirationBox.add(Box.createHorizontalStrut(20));
        autosaveExpirationBox.add(this.autosaveExpirationField);
        autosaveExpirationBox.add(Box.createHorizontalStrut(5));
        autosaveExpirationBox.add(daysLabel);
        autosaveWaitLabel.setFont(this.controller.getDefaultFont());
        this.autosaveWaitField.setFont(this.controller.getDefaultFont());
        this.autosaveEnabledCheckBox.setFont(this.controller.getDefaultFont());
        autosavePathLabel.setFont(this.controller.getDefaultFont());
        this.autosavePathField.setFont(this.controller.getDefaultFont());
        minutesLabel.setFont(this.controller.getDefaultFont());
        daysLabel.setFont(this.controller.getDefaultFont());
        autosaveExpirationLabel.setFont(this.controller.getDefaultFont());
        this.autosaveExpirationField.setFont(this.controller.getDefaultFont());
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel, 1));
        this.dbxrefEditor.setBorder(new TitledBorder("Personal Dbxref"));
        JPanel fieldsPanel = new JPanel(new SpringLayout());
        fieldsPanel.setOpaque(false);
        fieldsPanel.add(userLabel);
        fieldsPanel.add(this.userField);
        fieldsPanel.add(fullnameLabel);
        fieldsPanel.add(this.fullnameField);
        fieldsPanel.add(emailLabel);
        fieldsPanel.add(this.emailField);
        userPanel.add(fieldsPanel);
        userPanel.add(Box.createVerticalGlue());
        SwingUtil.makeCompactGrid((Container)fieldsPanel, (int)3, (int)2, (int)5, (int)5, (int)5, (int)5);
        JPanel autosavePanel = new JPanel();
        autosavePanel.setOpaque(false);
        autosavePanel.setLayout(new BoxLayout(autosavePanel, 1));
        autosavePanel.setBorder(new TitledBorder("Autosave Options"));
        autosavePanel.add(autosaveEnabledBox);
        autosavePanel.add(autosavePathBox);
        autosavePanel.add(autosaveWaitBox);
        autosavePanel.add(autosaveExpirationBox);
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BorderLayout());
        Box pathBox = new Box(1);
        pathBox.add(configFileLabelBox);
        pathBox.add(historyFileLabelBox);
        pathBox.add(Box.createVerticalStrut(5));
        pathBox.add(autosavePanel);
        pathPanel.add((Component)pathBox, "North");
        pathPanel.add(Box.createVerticalGlue());
        pathPanel.setBorder(new TitledBorder("Config file paths"));
        this.xmlArea = new JEditorPane();
        this.xmlErrorLabel = new JLabel();
        XMLEditorKit kit = new XMLEditorKit(true);
        kit.setWrapStyleWord(true);
        this.xmlArea.setEditorKit((EditorKit)kit);
        this.xmlArea.setFont(Controller.getController().getPreferences().getFont());
        this.xmlErrorLabel.setFont(Controller.getController().getPreferences().getFont());
        this.xmlErrorLabel.setForeground(Color.red);
        this.xmlArea.getDocument().putProperty("tabSize", new Integer(4));
        this.xmlArea.getDocument().putProperty("autoIndentation", new Boolean(true));
        this.xmlArea.getDocument().putProperty("tagCompletion", new Boolean(true));
        this.setLayoutXML(this.controller.getXMLLayout());
        this.memoryField = new JTextField();
        this.memoryField.setFont(this.controller.getDefaultFont());
        this.memoryField.setText(this.controller.getAllocatedMemory());
        String[] sizes = new String[]{"6", "8", "10", "12", "14", "16", "18", "20"};
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String[] fontStyles = new String[]{"Normal", "Italic", "Bold", "Bold-Italic"};
        this.fontNameList = new JComboBox<String>(fonts);
        this.fontSizeList = new JComboBox<String>(sizes);
        this.fontTypeList = new JComboBox<String>(fontStyles);
        this.selectListItem(this.fontNameList, this.getDefaultFontName());
        this.fontNameList.setSelectedItem(this.getDefaultFontName());
        this.fontSizeList.setSelectedItem(this.getDefaultFontSize());
        this.fontTypeList.setSelectedItem(this.getDefaultFontStyle());
        this.fontNameList.setFont(this.controller.getDefaultFont());
        this.fontSizeList.setFont(this.controller.getDefaultFont());
        this.fontTypeList.setFont(this.controller.getDefaultFont());
        this.fontNameList.setBackground(Preferences.defaultButtonColor());
        this.fontSizeList.setBackground(Preferences.defaultButtonColor());
        this.fontTypeList.setBackground(Preferences.defaultButtonColor());
        this.fontPreviewArea = new JTextArea();
        this.fontPreviewArea.setText("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz");
        this.fontPreviewArea.setWrapStyleWord(true);
        this.fontPreviewArea.setLineWrap(true);
        this.fontPreviewArea.setEditable(false);
        this.fontPreviewArea.setOpaque(false);
        JButton importButton = new JButton("Import XML File...");
        importButton.setBackground(Preferences.defaultButtonColor());
        importButton.setFont(this.controller.getDefaultFont());
        importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog((Component)((Object)ConfigurationPlugin.this));
                    if (returnVal == 0) {
                        int readChar;
                        File file = chooser.getSelectedFile();
                        BufferedReader reader = new BufferedReader(new FileReader(file));
                        StringBuffer buffer = new StringBuffer();
                        while ((readChar = reader.read()) != -1) {
                            buffer.append((char)readChar);
                        }
                        ConfigurationPlugin.this.setLayoutXML(buffer.toString());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton exportButton = new JButton("Export XML File...");
        exportButton.setBackground(Preferences.defaultButtonColor());
        exportButton.setFont(this.controller.getDefaultFont());
        exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showSaveDialog((Component)((Object)ConfigurationPlugin.this));
                    if (returnVal == 0) {
                        File file = chooser.getSelectedFile();
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                        writer.write(ConfigurationPlugin.this.getLayoutXML());
                        writer.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton defaultLayoutButton = new JButton("Load default layout");
        defaultLayoutButton.setBackground(Preferences.defaultButtonColor());
        defaultLayoutButton.setFont(this.controller.getDefaultFont());
        defaultLayoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPlugin.this.setLayoutXML("<xmllayout>\n   <divider orientation=\"HORZ\">\n      <first>\n         <component id=\"DAG\" width=\"300\"/>\n      </first>\n      <second>\n         <divider orientation=\"VERT\">\n            <first>\n               <tabs>\n                  <tab name=\"Search &amp; Filter\">\n                     <panel>\n                        <center>\n                           <component id=\"FIND\"/>\n                        </center>\n                        <south>\n                           <box orientation=\"HORZ\">\n                              <component id=\"SEARCH_BUTTON\" label=\"Ignore obsoletes\" method=\"MODIFY\" filter=\"resource:noobsoletes.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search all\" method=\"MODIFY\" buttonGroup=\"SearchScope\" selected=\"true\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search children of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_children.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search ontology of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_root.filter.xml\"/>\n                           </box>\n                        </south>\n                     </panel>\n                  </tab>\n                  <tab name=\"Parent Plugin\">\n                     <component id=\"plugin:org.geneontology.oboedit.plugin.ParentPlugin\"/>\n                  </tab>\n               </tabs>\n            </first>\n            <second>\n               <component id=\"TEXTEDIT\" width=\"320\"/>\n            </second>\n         </divider>\n      </second>\n   </divider>\n</xmllayout>");
            }
        });
        JPanel guiPanel = new JPanel();
        guiPanel.setLayout(new SpringLayout());
        guiPanel.setBorder(new TitledBorder("GUI Options"));
        JScrollPane pane = new JScrollPane(this.xmlArea, 20, 30);
        final JLabel lineNumberLabel = new JLabel("Line: 1, Col: 1");
        lineNumberLabel.setFont(Controller.getController().getPreferences().getFont());
        JButton reformatButton = new JButton("Auto-Indent XML");
        reformatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPlugin.this.indentXML();
            }
        });
        reformatButton.setFont(Controller.getController().getPreferences().getFont());
        reformatButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.xmlArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int caretPosition = ConfigurationPlugin.this.xmlArea.getCaretPosition();
                Element root = ConfigurationPlugin.this.xmlArea.getDocument().getDefaultRootElement();
                int lineNum = root.getElementIndex(caretPosition) + 1;
                int colNum = 1 + caretPosition - root.getElement(lineNum - 1).getStartOffset();
                lineNumberLabel.setText("Line: " + lineNum + ", Col: " + colNum);
            }
        });
        Box xmlErrorBox = new Box(0);
        xmlErrorBox.add(this.xmlErrorLabel);
        xmlErrorBox.add(Box.createHorizontalGlue());
        Box lineNumberBox = new Box(0);
        lineNumberBox.add(lineNumberLabel);
        lineNumberBox.add(Box.createHorizontalGlue());
        lineNumberBox.add(reformatButton);
        Box importBox = new Box(0);
        importBox.add(importButton);
        importBox.add(Box.createHorizontalStrut(10));
        importBox.add(exportButton);
        importBox.add(Box.createHorizontalStrut(10));
        importBox.add(defaultLayoutButton);
        importBox.add(Box.createHorizontalGlue());
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        displayPanel.add(pane);
        displayPanel.add(xmlErrorBox);
        displayPanel.add(lineNumberBox);
        displayPanel.add(importBox);
        JLabel memoryLabel = new JLabel("OBO-Edit memory allocation");
        memoryLabel.setFont(this.controller.getDefaultFont());
        Box memoryBox = new Box(0);
        memoryBox.add(memoryLabel);
        memoryBox.add(Box.createHorizontalStrut(15));
        memoryBox.add(this.memoryField);
        memoryBox.add(this.fontPreviewArea);
        Box fontLine = new Box(0);
        fontLine.add(this.fontNameList);
        fontLine.add(this.fontSizeList);
        fontLine.add(this.fontTypeList);
        JLabel fontPreviewLabel = new JLabel("Font preview:");
        fontPreviewLabel.setFont(this.controller.getDefaultFont());
        Box fontPreviewLabelLine = new Box(0);
        fontPreviewLabelLine.add(fontPreviewLabel);
        fontPreviewLabelLine.add(Box.createHorizontalGlue());
        JLabel fontLabel = new JLabel("Default font");
        fontLabel.setFont(this.controller.getDefaultFont());
        Box fontAndPreviewBox = new Box(1);
        fontAndPreviewBox.add(fontLine);
        fontAndPreviewBox.add(Box.createVerticalStrut(5));
        fontAndPreviewBox.add(fontPreviewLabelLine);
        fontAndPreviewBox.add(this.fontPreviewArea);
        Box fontLabelBox = new Box(1);
        fontLabelBox.add(fontLabel);
        fontLabelBox.add(Box.createVerticalGlue());
        Box fontBox = new Box(0);
        fontBox.add(fontLabelBox);
        fontBox.add(Box.createHorizontalStrut(20));
        fontBox.add(fontAndPreviewBox);
        FontListener fontListener = new FontListener();
        this.fontNameList.addActionListener(fontListener);
        this.fontNameList.addItemListener(fontListener);
        this.fontSizeList.addActionListener(fontListener);
        this.fontSizeList.addItemListener(fontListener);
        this.fontTypeList.addActionListener(fontListener);
        this.fontTypeList.addItemListener(fontListener);
        JPanel moreOptionsPanel = new JPanel();
        moreOptionsPanel.setOpaque(false);
        moreOptionsPanel.setLayout(new BoxLayout(moreOptionsPanel, 1));
        moreOptionsPanel.setBorder(new TitledBorder("Startup Options (changes do not take effect until restart)"));
        moreOptionsPanel.add(Box.createVerticalStrut(10));
        moreOptionsPanel.add(memoryBox);
        moreOptionsPanel.add(Box.createVerticalStrut(10));
        moreOptionsPanel.add(fontBox);
        moreOptionsPanel.setMaximumSize(moreOptionsPanel.getPreferredSize());
        JPanel runtimeDisplayPanel = new JPanel();
        runtimeDisplayPanel.setBorder(new TitledBorder("Runtime display options"));
        runtimeDisplayPanel.setOpaque(false);
        runtimeDisplayPanel.setLayout(new BoxLayout(runtimeDisplayPanel, 1));
        JPanel caseSensitiveSortPanel = new JPanel();
        caseSensitiveSortPanel.setOpaque(false);
        caseSensitiveSortPanel.setLayout(new BoxLayout(caseSensitiveSortPanel, 0));
        caseSensitiveSortPanel.add(this.caseSensitiveSortBox);
        caseSensitiveSortPanel.add(Box.createHorizontalGlue());
        JPanel showToolTipsPanel = new JPanel();
        showToolTipsPanel.setOpaque(false);
        showToolTipsPanel.setLayout(new BoxLayout(showToolTipsPanel, 0));
        showToolTipsPanel.add(this.showToolTipsBox);
        showToolTipsPanel.add(Box.createHorizontalGlue());
        JPanel showConfirmOnExitPanel = new JPanel();
        showConfirmOnExitPanel.setOpaque(false);
        showConfirmOnExitPanel.setLayout(new BoxLayout(showConfirmOnExitPanel, 0));
        showConfirmOnExitPanel.add(this.confirmOnExitBox);
        showConfirmOnExitPanel.add(Box.createHorizontalGlue());
        runtimeDisplayPanel.add(caseSensitiveSortPanel);
        runtimeDisplayPanel.add(showToolTipsPanel);
        runtimeDisplayPanel.add(showConfirmOnExitPanel);
        runtimeDisplayPanel.setMaximumSize(runtimeDisplayPanel.getPreferredSize());
        JPanel iconPanel = new JPanel();
        iconPanel.setOpaque(false);
        iconPanel.setLayout(new GridLayout(1, 1));
        iconPanel.add((Component)this.iconList);
        iconPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        guiPanel.add(iconPanel);
        guiPanel.add(runtimeDisplayPanel);
        guiPanel.add(moreOptionsPanel);
        guiPanel.add(Box.createVerticalGlue());
        SwingUtil.makeCompactGrid((Container)guiPanel, (int)4, (int)1, (int)0, (int)0, (int)0, (int)5);
        JPanel behaviorPanel = new JPanel();
        behaviorPanel.setLayout(new BoxLayout(behaviorPanel, 1));
        behaviorPanel.add(allowBox);
        behaviorPanel.add(warnDeleteBox);
        behaviorPanel.add(warnDefinitionBox);
        behaviorPanel.add(advancedRootBox);
        behaviorPanel.add(Box.createVerticalGlue());
        JPanel valuesPanel = new JPanel(new SpringLayout());
        valuesPanel.setOpaque(false);
        valuesPanel.add(prefixLabel);
        valuesPanel.add(this.prefixField);
        valuesPanel.add(startLabel);
        valuesPanel.add(this.startField);
        valuesPanel.add(endLabel);
        valuesPanel.add(this.endField);
        valuesPanel.add(idLengthLabel);
        valuesPanel.add(this.idLengthField);
        valuesPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        valuesPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        valuesPanel.add(selectionBatchLabel);
        valuesPanel.add(this.selectionBatchField);
        valuesPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        valuesPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        valuesPanel.add(this.useDefaultBrowserBox);
        valuesPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        valuesPanel.add(browserLabel);
        valuesPanel.add(this.browserCommandField);
        valuesPanel.add(Box.createVerticalGlue());
        valuesPanel.add(Box.createVerticalGlue());
        SwingUtil.makeCompactGrid((Container)valuesPanel, (int)10, (int)2, (int)5, (int)5, (int)5, (int)5);
        JScrollPane scroller = new JScrollPane(this.defTextArea, 20, 31);
        this.defTextArea.setLineWrap(true);
        this.defTextArea.setWrapStyleWord(true);
        this.defTextArea.setFont(this.controller.getDefaultFont());
        this.personalDefCheckbox.setOpaque(false);
        this.personalDefCheckbox.setFont(this.controller.getDefaultFont());
        JPanel textEditTopPanel = new JPanel();
        textEditTopPanel.setLayout(new BoxLayout(textEditTopPanel, 1));
        textEditTopPanel.setOpaque(false);
        textEditTopPanel.add(autoCommitPanel);
        JPanel textEditPanel = new JPanel();
        textEditPanel.setLayout(new BorderLayout());
        textEditPanel.setOpaque(true);
        JPanel personalDefinitionSubPanel = new JPanel();
        personalDefinitionSubPanel.setLayout(new GridLayout(1, 2));
        personalDefinitionSubPanel.add(scroller);
        personalDefinitionSubPanel.add((Component)this.defDbxrefList);
        JPanel personalDefinitionPanel = new JPanel();
        personalDefinitionPanel.setLayout(new BorderLayout());
        personalDefinitionPanel.add((Component)personalDefinitionSubPanel, "Center");
        personalDefinitionPanel.add((Component)this.personalDefCheckbox, "North");
        this.personalDefCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPlugin.this.updatePersonalDefFields(ConfigurationPlugin.this.personalDefCheckbox.isSelected());
            }
        });
        personalDefinitionPanel.setOpaque(true);
        personalDefinitionSubPanel.setOpaque(true);
        textEditPanel.add((Component)personalDefinitionPanel, "Center");
        textEditPanel.add((Component)textEditTopPanel, "North");
        personalDefinitionPanel.setBackground(Preferences.defaultBackgroundColor());
        personalDefinitionSubPanel.setBackground(Preferences.defaultBackgroundColor());
        guiPanel.setBackground(Preferences.defaultBackgroundColor());
        pathPanel.setBackground(Preferences.defaultBackgroundColor());
        behaviorPanel.setBackground(Preferences.defaultBackgroundColor());
        displayPanel.setBackground(Preferences.defaultBackgroundColor());
        this.mainPanel.setBackground(Preferences.defaultBackgroundColor());
        userPanel.setBackground(Preferences.defaultBackgroundColor());
        textEditPanel.setBackground(Preferences.defaultBackgroundColor());
        this.mainPanel.addTab("General GUI", null, guiPanel, "General gui options");
        this.mainPanel.addTab("Paths & Autosave", null, pathPanel, "Set paths");
        this.mainPanel.addTab("Behavior", null, behaviorPanel, "Set ID options");
        this.mainPanel.addTab("User Settings", null, userPanel, "Set user options");
        this.mainPanel.addTab("Text Editing", null, textEditPanel, "Set text editing options");
        this.mainPanel.addTab("Display Layout", null, displayPanel, "Configure main display layout");
        this.mainPanel.setBackground(Preferences.defaultButtonColor());
        this.setBackground(Preferences.defaultBackgroundColor());
        this.add(this.mainPanel, "Center");
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(Box.createVerticalStrut(15));
        buttonBox.add(this.commitButton);
        buttonBox.add(Box.createVerticalStrut(15));
        this.add(buttonBox, "South");
        this.buildFontPreview();
    }

    private String getDefaultFontName() {
        return this.controller.getPreferences().getFont().getFamily();
    }

    private String getDefaultFontSize() {
        return this.controller.getPreferences().getFont().getSize() + "";
    }

    private String getDefaultFontStyle() {
        Font font = this.controller.getPreferences().getFont();
        String style = font.isItalic() && font.isBold() ? "Bold-Italic" : (font.isItalic() ? "Italic" : (font.isBold() ? "Bold" : "Normal"));
        return style;
    }

    private Vector getIcons() {
        Vector<IconWrapper> out = new Vector<IconWrapper>();
        Properties iconProps = this.controller.getPreferences().getIconProperties();
        int iconCount = 0;
        try {
            String countStr = iconProps.getProperty("iconCount");
            if (countStr != null) {
                iconCount = Integer.parseInt(countStr);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < iconCount; ++i) {
            try {
                URL url;
                String typeStr = iconProps.getProperty("iconType" + i);
                String urlStr = iconProps.getProperty("iconURL" + i);
                if (urlStr == null) {
                    String resourceStr = iconProps.getProperty("iconRes" + i);
                    url = this.controller.getExtensionLoader().getResource(resourceStr);
                } else {
                    url = new URL(urlStr);
                }
                if (typeStr == null || url == null) continue;
                IconWrapper iw = new IconWrapper(typeStr, url.toString());
                out.addElement(iw);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    protected boolean checkXML() {
        XMLLayout layout = Controller.getController().getConfiguredXMLLayout();
        layout.setLayout(this.getLayoutXML());
        int errorLine = -1;
        String errorMessage = null;
        boolean foundErrors = true;
        try {
            layout.validateLayout();
            foundErrors = false;
        }
        catch (SAXParseException ex) {
            errorLine = ex.getLineNumber();
            errorMessage = ex.getMessage();
        }
        catch (ExpressionException ex) {
            errorLine = ex.getLineNumber();
            errorMessage = ex.getMessage();
        }
        catch (Exception ex) {
            errorMessage = ex.getMessage();
        }
        if (foundErrors) {
            if (errorLine != -1) {
                errorMessage = "Error at line " + errorLine + ": " + errorMessage;
                Element root = this.xmlArea.getDocument().getDefaultRootElement();
                Element errorElement = root.getElement(errorLine - 1);
                this.xmlArea.setSelectionStart(errorElement.getStartOffset());
                this.xmlArea.setSelectionEnd(errorElement.getEndOffset());
            }
            this.xmlErrorLabel.setText(errorMessage);
        } else {
            this.xmlErrorLabel.setText("");
        }
        return !foundErrors;
    }

    protected boolean validateConfiguration() {
        boolean xmlOkay = this.checkXML();
        return xmlOkay;
    }

    public void save() {
        if (!this.validateConfiguration()) {
            return;
        }
        this.iconList.commit();
        this.defDbxrefList.commit();
        this.icons = this.iconList.getData();
        Preferences preferences = Controller.getController().getPreferences();
        try {
            int batchSize = Integer.parseInt(this.selectionBatchField.getText());
            preferences.setSelectionBatchSize(batchSize);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (this.useDefaultBrowserBox.isSelected()) {
            preferences.setBrowserCommand("");
        } else {
            preferences.setBrowserCommand(this.browserCommandField.getText());
        }
        preferences.setUserName(this.userField.getText());
        preferences.setFullName(this.fullnameField.getText());
        preferences.setEmail(this.emailField.getText());
        preferences.setAllowCycles(this.allowCyclesBox.isSelected());
        preferences.setAutoCommitTextEdits(this.autoCommitCheckBox.isSelected());
        preferences.setWarnBeforeDiscardingEdits(this.warnBeforeDiscardingEditsBox.isSelected());
        preferences.setWarnBeforeDelete(this.warnBeforeDeleteBox.isSelected());
        preferences.setWarnBeforeDefinitionLoss(this.warnBeforeDefinitionLossBox.isSelected());
        preferences.setUseBasicRootDetection(!this.advancedRootDetectionBox.isSelected());
        preferences.setFilterMethod((String)this.filterMethodBox.getSelectedItem());
        preferences.setAllowExtendedCharacters(this.allowExtendedCheckbox.isSelected());
        Dbxref ref = (Dbxref)this.dbxrefEditor.createNewValue();
        this.dbxrefEditor.store(ref);
        preferences.setPersonalDbxref(ref);
        preferences.setCaseSensitiveSort(this.caseSensitiveSortBox.isSelected());
        preferences.setShowToolTips(this.showToolTipsBox.isSelected());
        preferences.setConfirmOnExit(this.confirmOnExitBox.isSelected());
        preferences.setAutosaveEnabled(this.autosaveEnabledCheckBox.isSelected());
        try {
            int waitTime = Integer.parseInt(this.autosaveWaitField.getText());
            preferences.setAutosaveWaitTime(waitTime);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            int days = Integer.parseInt(this.autosaveExpirationField.getText());
            preferences.setAutosaveExpirationDays(days);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        preferences.setAutosavePath(new File(this.autosavePathField.getText()));
        preferences.setHistoryFilePath(this.historyFilePath.getText());
        preferences.setFont(Preferences.decodeFont((String)this.fontNameList.getSelectedItem(), (String)this.fontSizeList.getSelectedItem(), (String)this.fontTypeList.getSelectedItem()));
        preferences.setMemString(this.memoryField.getText());
        Properties iconProps = preferences.getIconProperties();
        iconProps.setProperty("iconCount", this.icons.size() + "");
        for (int i = 0; i < this.icons.size(); ++i) {
            IconWrapper iw = (IconWrapper)this.icons.elementAt(i);
            iconProps.setProperty("iconType" + i, iw.getType());
            iconProps.setProperty("iconURL" + i, iw.getURL());
        }
        preferences.setLayout(this.getLayoutXML());
        preferences.setUsePersonalDefinition(this.personalDefCheckbox.isSelected());
        if (this.personalDefCheckbox.isSelected()) {
            preferences.setPersonalDefinition(this.defTextArea.getText());
            if (preferences.getPersonalDbxrefs() == null) {
                preferences.setPersonalDbxrefs(new LinkedList());
            } else {
                preferences.getPersonalDbxrefs().clear();
            }
            preferences.getPersonalDbxrefs().addAll(this.defDbxrefList.getData());
        } else {
            preferences.setPersonalDefinition(null);
            preferences.setPersonalDbxrefs(null);
        }
        this.controller.flushConfig();
        this.controller.readConfig();
        this.controller.haltAutosaveThread();
        if (this.controller.getAutosaveEnabled()) {
            this.controller.startAutosaveThread();
        }
    }

    public String getName() {
        return "OBO-Edit Configuration Manager";
    }

    private class FontListener
    implements ActionListener,
    ItemListener {
        private FontListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ConfigurationPlugin.this.buildFontPreview();
        }

        public void itemStateChanged(ItemEvent e) {
            ConfigurationPlugin.this.buildFontPreview();
        }
    }

    private class IconEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 4386550408050571020L;
        JLabel typeLabel = new JLabel("Relationship type");
        JLabel urlLabel = new JLabel("Icon URL");
        JTextField typeField = new JTextField(10);
        JTextField urlField = new JTextField(50);
        JLabel previewLabel = new JLabel();
        JLabel previewTextLabel = new JLabel("Icon preview");
        JButton browseButton = new JButton("Browse files");
        JButton libraryButton = new JButton("Browse built-in icons");
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public IconEditor() {
            this.setMinimumSize(new Dimension(0, 0));
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(Preferences.getPreferences().getBackgroundColor());
            this.typeLabel.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.previewTextLabel.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.urlLabel.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.typeField.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.urlField.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.browseButton.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.libraryButton.setFont(ConfigurationPlugin.this.controller.getDefaultFont());
            this.urlField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.urlField.getPreferredSize().height));
            this.typeField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.typeField.getPreferredSize().height));
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    IconEditor.this.update();
                    ((IconEditor)IconEditor.this).ConfigurationPlugin.this.iconList.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this.urlField.addFocusListener(listener);
            this.typeField.addFocusListener(listener);
            this.libraryButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IconEditor.this.showIconLibrary();
                }
            });
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IconEditor.this.showFileChooser();
                }
            });
            Box typeBox = new Box(0);
            typeBox.add(this.typeLabel);
            typeBox.add(Box.createHorizontalStrut(10));
            typeBox.add(Box.createHorizontalGlue());
            typeBox.add(this.typeField);
            typeBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, typeBox.getPreferredSize().height));
            Box urlLabelBox = new Box(0);
            urlLabelBox.add(this.urlLabel);
            urlLabelBox.add(Box.createHorizontalGlue());
            Box buttonBox = new Box(0);
            buttonBox.add(this.browseButton);
            buttonBox.add(this.libraryButton);
            buttonBox.add(Box.createHorizontalGlue());
            Box previewBox = new Box(0);
            previewBox.add(this.previewTextLabel);
            previewBox.add(Box.createHorizontalGlue());
            previewBox.add(this.previewLabel);
            this.add(typeBox);
            this.add(Box.createVerticalStrut(10));
            this.add(urlLabelBox);
            this.add(this.urlField);
            this.add(Box.createVerticalStrut(5));
            this.add(buttonBox);
            this.add(Box.createVerticalStrut(10));
            this.add(previewBox);
            this.add(Box.createVerticalGlue());
        }

        private void update() {
            try {
                URL url = new URL(this.urlField.getText());
                this.previewLabel.setIcon(new ImageIcon(url));
                this.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void load(Object o) {
            IconWrapper iw = (IconWrapper)o;
            this.urlField.setText(iw.getURL());
            this.typeField.setText(iw.getType());
            this.urlField.setCaretPosition(0);
            this.typeField.setCaretPosition(0);
            this.update();
        }

        public void store(Object o) {
            IconWrapper iw = (IconWrapper)o;
            iw.setURL(this.urlField.getText());
            iw.setType(this.typeField.getText());
        }

        public Object createNewValue() {
            return new IconWrapper("UNKNOWN", "<new icon path>");
        }

        private void showIconLibrary() {
            JPanel panel = new JPanel();
            panel.setBackground(Color.white);
            Vector icons = ConfigurationPlugin.this.controller.getIconLibrary();
            final JDialog dialog = new JDialog();
            dialog.setTitle("Click an icon to select it");
            dialog.setModal(true);
            for (int i = 0; i < icons.size(); ++i) {
                final URL url = (URL)icons.elementAt(i);
                ActionListener listener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        IconEditor.this.urlField.setText(url.toString());
                        IconEditor.this.update();
                        dialog.dispose();
                    }
                };
                JButton button = new JButton(new ImageIcon(url));
                button.setOpaque(false);
                button.addActionListener(listener);
                panel.add(button);
            }
            dialog.setContentPane(panel);
            dialog.pack();
            dialog.show();
        }

        private void showFileChooser() {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            int returnVal = chooser.showOpenDialog(Controller.getController().getFrame());
            if (returnVal == 0) {
                File path = chooser.getSelectedFile();
                try {
                    this.urlField.setText(path.toURL().toString());
                    this.update();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
    }

    private class IconWrapper {
        private String type;
        private String url;

        public IconWrapper(String type, String url) {
            this.type = type;
            this.url = url;
        }

        public String getType() {
            return this.type;
        }

        public String getURL() {
            return this.url;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setURL(String url) {
            this.url = url;
        }

        public String toString() {
            return this.type;
        }
    }
}

