/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.ExpressionUtil;
import org.geneontology.expression.JexlContext;
import org.geneontology.io.IOUtil;
import org.geneontology.oboedit.controller.ExpressionManager;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.dataadapter.OBOSerializationEngine;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.filters.FilterPair;

public class OBO2OBO {
    protected static WordComparator wordComparator = new WordComparator();
    private static long extendCommentTime = 0L;
    private static long parseCommentTime = 0L;
    private static long groupTime = 0L;

    public static void convertFiles(OBOFileAdapter.OBOAdapterConfiguration readConfig, OBOFileAdapter.OBOAdapterConfiguration writeConfig, boolean parseObsoleteComments, boolean writeObsoleteComments, boolean fixDbxrefs, List scripts) throws Exception {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOSession session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)readConfig, null);
        if (parseObsoleteComments) {
            OBO2OBO.parseComments(session);
        }
        if (writeObsoleteComments) {
            OBO2OBO.writeComments(session);
        }
        if (fixDbxrefs) {
            OBO2OBO.fixDbxrefs(session);
        }
        Iterator it = scripts.iterator();
        while (it.hasNext()) {
            ScriptWrapper wrapper = (ScriptWrapper)it.next();
            OBO2OBO.runScript(session, wrapper.getScript(), wrapper.getArgs());
        }
        System.err.println("About to write files..., session object count = " + session.getObjects().size());
        System.err.println("writePath = " + writeConfig.getWritePath());
        System.err.println("savePath = " + writeConfig.getSaveRecords());
        adapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)writeConfig, session);
    }

    public static void runScript(OBOSession session, String script, List args) throws ExpressionException {
        JexlContext context = ExpressionManager.getManager().getContext();
        context.setGlobalVariable("session", (Object)session, false);
        context.setLocalVariable("args", (Object)args, true);
        ExpressionUtil.exec((String)script, (JexlContext)context);
    }

    protected static void fixDbxrefs(OBOSession session) {
        Iterator it = session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof DefinedObject)) continue;
            DefinedObject dfo = (DefinedObject)io;
            Iterator it2 = dfo.getDefDbxrefs().iterator();
            Dbxref metacycRef = null;
            Dbxref brokenRef = null;
            Dbxref otherRef = null;
            int metacycCount = 0;
            int brokenCount = 0;
            while (it2.hasNext()) {
                Dbxref ref = (Dbxref)it2.next();
                if (ref.getDatabase().equalsIgnoreCase("metacyc")) {
                    ++metacycCount;
                    metacycRef = ref;
                    continue;
                }
                if (ref.getDatabase().length() == 0) {
                    ++brokenCount;
                    brokenRef = ref;
                    continue;
                }
                otherRef = ref;
            }
            if (brokenRef != null && metacycRef != null) {
                if (brokenCount > 1 || metacycCount > 1) {
                    System.err.println("*!!!!! Probable broken ref at " + io.getID() + " cannot be automatically repaired. There are too many pieces.");
                    continue;
                }
                dfo.removeDefDbxref(metacycRef);
                dfo.removeDefDbxref(brokenRef);
                System.err.println("* Repairing broken dbxref at " + dfo.getID() + ", merging dbxrefs " + metacycRef + " and " + brokenRef);
                metacycRef.setID(metacycRef.getID() + "," + brokenRef.getID());
                dfo.addDefDbxref(metacycRef);
                continue;
            }
            if (dfo.getDefDbxrefs().size() == 2 && brokenRef != null && otherRef != null) {
                dfo.removeDefDbxref(otherRef);
                dfo.removeDefDbxref(brokenRef);
                System.err.println("* Repairing broken dbxref at " + dfo.getID() + ", merging dbxrefs " + otherRef + " and " + brokenRef);
                otherRef.setID(otherRef.getID() + "," + brokenRef.getID());
                dfo.addDefDbxref(otherRef);
                continue;
            }
            if (brokenRef == null) continue;
            System.err.println("*!! Possible broken ref at " + dfo.getID() + " could not be automatically repaired.");
        }
    }

    protected static void groupTerms(List terms, Map mappable, List external) {
        long time = System.currentTimeMillis();
        Iterator it = terms.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof DanglingWrapper) {
                external.add(o);
                continue;
            }
            if (!(o instanceof IdentifiedObject)) continue;
            LinkedObject root = TermUtil.getRoot((LinkedObject)o);
            ArrayList list = (ArrayList)mappable.get(root);
            if (list == null) {
                list = new ArrayList();
                mappable.put(root, list);
            }
            list.add(o);
        }
        groupTime += System.currentTimeMillis() - time;
    }

    protected static String buildPhrase(List list, String ontologyDescriptor, boolean considerChildren) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(ontologyDescriptor + " term");
        if (list.size() > 1) {
            out.append('s');
        }
        out.append(' ');
        Collections.sort(list, wordComparator);
        for (int i = 0; i < list.size(); ++i) {
            String id;
            String name;
            Object o = list.get(i);
            boolean addChildPhrase = false;
            if (o instanceof DanglingWrapper) {
                DanglingWrapper dw = (DanglingWrapper)o;
                name = dw.getName();
                id = dw.getID();
            } else {
                IdentifiedObject io = (IdentifiedObject)o;
                name = io.getName();
                id = io.getID();
                if (considerChildren && io instanceof LinkedObject) {
                    boolean bl = addChildPhrase = ((LinkedObject)io).getChildren().size() > 0;
                }
            }
            if (list.size() > 1 && i == list.size() - 1) {
                if (list.size() > 2) {
                    out.append(",");
                }
                out.append(" and ");
            } else if (i > 0 && list.size() > 2) {
                out.append(", ");
            }
            out.append("'" + name + " ; " + id + "'");
            if (!addChildPhrase) continue;
            out.append(" or its children");
        }
        return out.toString();
    }

    protected static String connectPhrases(List list) {
        if (list.size() == 0) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            String phrase = (String)it.next();
            if (list.size() > 1 && i == list.size() - 1) {
                if (list.size() > 2) {
                    out.append(",");
                }
                out.append(" and ");
            } else if (i > 0 && list.size() > 2) {
                out.append(", ");
            }
            out.append(phrase);
            ++i;
        }
        return out.toString();
    }

    protected static void extendComment(OBOSession session, CommentedObject commented, List replacedBy, List consider) {
        long atime = System.currentTimeMillis();
        if (replacedBy.size() == 0 && consider.size() == 0) {
            return;
        }
        LinkedList<String> replacementPhrases = new LinkedList<String>();
        LinkedList<String> considerPhrases = new LinkedList<String>();
        ArrayList list = new ArrayList();
        LinkedHashMap mappableTerms = new LinkedHashMap();
        LinkedList externalTerms = new LinkedList();
        mappableTerms.clear();
        OBO2OBO.groupTerms(replacedBy, mappableTerms, externalTerms);
        list.addAll(mappableTerms.keySet());
        Collections.sort(list, wordComparator);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            List phraseItems = (List)mappableTerms.get(io);
            String phrase = OBO2OBO.buildPhrase(phraseItems, io.getName(), false);
            if (phrase == null) continue;
            replacementPhrases.add(phrase);
        }
        String phrase = OBO2OBO.buildPhrase(externalTerms, "external ontology", false);
        if (phrase != null) {
            replacementPhrases.add(phrase);
        }
        externalTerms.clear();
        mappableTerms.clear();
        OBO2OBO.groupTerms(consider, mappableTerms, externalTerms);
        list.addAll(mappableTerms.keySet());
        Collections.sort(list, wordComparator);
        it = list.iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            phrase = OBO2OBO.buildPhrase((List)mappableTerms.get(io), io.getName(), true);
            if (phrase == null) continue;
            considerPhrases.add(phrase);
        }
        phrase = OBO2OBO.buildPhrase(externalTerms, "external ontology", true);
        if (phrase != null) {
            considerPhrases.add(phrase);
        }
        String replacedByStr = OBO2OBO.connectPhrases(replacementPhrases);
        String considerStr = OBO2OBO.connectPhrases(considerPhrases);
        StringBuffer out = new StringBuffer("To update annotations, ");
        if (replacedByStr != null) {
            out.append("use ");
            out.append(replacedByStr);
        }
        if (replacedByStr != null && considerStr != null) {
            out.append(" and ");
        }
        if (considerStr != null) {
            out.append("consider ");
            out.append(considerStr);
        }
        out.append(".");
        if (commented.getComment() == null && commented.getComment().length() == 0) {
            commented.setComment(out.toString());
        } else {
            commented.setComment(commented.getComment() + " " + out.toString());
        }
        extendCommentTime += System.currentTimeMillis() - atime;
    }

    protected static void writeComments(OBOSession session) {
        LinkedList replacedBy = new LinkedList();
        LinkedList consider = new LinkedList();
        Iterator it = session.getObsoleteTerms().iterator();
        while (it.hasNext()) {
            Object o;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof CommentedObject)) continue;
            OBO2OBO.parseComments(session, (CommentedObject)io, replacedBy, consider, false);
            Iterator it2 = ((ObsoletableObject)io).getReplacedBy().iterator();
            while (it2.hasNext()) {
                o = it2.next();
                if (replacedBy.contains(o)) continue;
                replacedBy.add(o);
            }
            it2 = ((ObsoletableObject)io).getConsiderReplacements().iterator();
            while (it2.hasNext()) {
                o = it2.next();
                if (consider.contains(o)) continue;
                consider.add(o);
            }
            OBO2OBO.extendComment(session, (CommentedObject)io, replacedBy, consider);
            replacedBy.clear();
            consider.clear();
        }
    }

    protected static void parseComments(OBOSession session) {
        LinkedList replacedBy = new LinkedList();
        LinkedList consider = new LinkedList();
        Iterator it = session.getObsoleteTerms().iterator();
        while (it.hasNext()) {
            Object o;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof CommentedObject)) continue;
            OBO2OBO.parseComments(session, (CommentedObject)io, replacedBy, consider, true);
            Iterator it2 = replacedBy.iterator();
            while (it2.hasNext()) {
                o = it2.next();
                if (!(o instanceof IdentifiedObject)) continue;
                ((ObsoletableObject)io).addReplacedBy((ObsoletableObject)o);
                it2.remove();
            }
            it2 = consider.iterator();
            while (it2.hasNext()) {
                o = it2.next();
                if (!(o instanceof IdentifiedObject)) continue;
                ((ObsoletableObject)io).addConsiderReplacement((ObsoletableObject)o);
                it2.remove();
            }
            OBO2OBO.extendComment(session, (CommentedObject)io, replacedBy, consider);
            replacedBy.clear();
            consider.clear();
        }
    }

    protected static void parseComments(OBOSession session, CommentedObject commented, List replacedBy, List consider, boolean showWarnings) {
        long time = System.currentTimeMillis();
        int index = commented.getComment().lastIndexOf("To update annotations,");
        if (index == -1) {
            if (showWarnings) {
                System.err.println("Warning (" + commented.getID() + "): Found comment without appropriate obsolete info.");
            }
            return;
        }
        String realComment = commented.getComment().substring(0, index).trim();
        String updateSection = commented.getComment().substring(index, commented.getComment().length());
        commented.setComment(realComment);
        boolean readConsider = false;
        boolean readReplaced = false;
        boolean inQuotes = false;
        LinkedList<String> quoteList = new LinkedList<String>();
        boolean magicWordComing = false;
        StringTokenizer tokenizer = new StringTokenizer(updateSection, " \t.;'\",!?", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() == 0) continue;
            if (token.equals("'") || token.equals("\"")) {
                if (inQuotes) {
                    inQuotes = false;
                    continue;
                }
                inQuotes = true;
                quoteList.clear();
                continue;
            }
            if (inQuotes) {
                if (magicWordComing) {
                    magicWordComing = false;
                    Object io = session.getObject(token);
                    if (io == null) {
                        StringBuffer text = new StringBuffer();
                        Iterator it = quoteList.iterator();
                        while (it.hasNext()) {
                            if (text.length() > 0) {
                                text.append(" ");
                            }
                            text.append(it.next().toString());
                        }
                        io = new DanglingWrapper(token, text.toString());
                    } else {
                        if (!(io instanceof ObsoletableObject)) {
                            System.err.println("Warning (" + commented.getID() + "): " + "Parsed comment identifier " + token + " refers to " + "a non-obsoletable object");
                            continue;
                        }
                        if (TermUtil.isObsolete((IdentifiedObject)io)) {
                            System.err.println("Warning (" + commented.getID() + "): " + "Parsed comment identifier " + token + " refers to " + "an obsolete object");
                            continue;
                        }
                    }
                    if (readConsider) {
                        consider.add(io);
                        continue;
                    }
                    if (readReplaced) {
                        replacedBy.add(io);
                        continue;
                    }
                    System.err.println("Warning (" + commented.getID() + "): " + "Found replacement identifier " + token + " not preceded by 'use' or " + "'consider'");
                    continue;
                }
                if (token.equals(";")) {
                    magicWordComing = true;
                    continue;
                }
                quoteList.add(token);
                continue;
            }
            if (token.equals("use")) {
                readReplaced = true;
                readConsider = false;
                continue;
            }
            if (!token.equals("consider")) continue;
            readConsider = true;
            readReplaced = false;
        }
        parseCommentTime += System.currentTimeMillis() - time;
    }

    public static void main(String[] args) throws Exception {
        int i;
        Controller.setSuppressInstallations(true);
        if (args.length == 0) {
            OBO2OBO.printUsage(1);
        }
        OBOFileAdapter.OBOAdapterConfiguration readConfig = new OBOFileAdapter.OBOAdapterConfiguration();
        OBOFileAdapter.OBOAdapterConfiguration writeConfig = new OBOFileAdapter.OBOAdapterConfiguration();
        writeConfig.setBasicSave(false);
        boolean parseObsoleteComments = false;
        boolean writeObsoleteComments = false;
        boolean fixDbxrefs = false;
        LinkedList<ScriptWrapper> scripts = new LinkedList<ScriptWrapper>();
        String formatVersion = "OBO_1_2";
        for (i = 0; i < args.length; ++i) {
            System.err.println("args[" + i + "] = |" + args[i] + "|");
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-formatversion")) {
                if (i >= args.length - 1) {
                    OBO2OBO.printUsage(1);
                }
                if ((formatVersion = args[++i]).equals("OBO_1_2") || formatVersion.equals("OBO_1_0")) continue;
                OBO2OBO.printUsage(1);
                continue;
            }
            if (args[i].equals("-parsecomments")) {
                parseObsoleteComments = true;
                continue;
            }
            if (args[i].equals("-fixdbxrefs")) {
                fixDbxrefs = true;
                continue;
            }
            if (args[i].equals("-writecomments")) {
                writeObsoleteComments = true;
                continue;
            }
            if (args[i].equals("-runscript")) {
                if (i >= args.length - 1) {
                    OBO2OBO.printUsage(1);
                }
                String scriptFile = args[++i];
                String script = IOUtil.readFile((String)scriptFile);
                ScriptWrapper wrapper = new ScriptWrapper();
                wrapper.setScript(script);
                ++i;
                while (i < args.length && !args[i].equals(";")) {
                    wrapper.getArgs().add(args[i]);
                    ++i;
                }
                scripts.add(wrapper);
                continue;
            }
            if (args[i].equals("-o")) {
                if (i >= args.length - 1) {
                    OBO2OBO.printUsage(1);
                }
                ++i;
                OBOSerializationEngine.FilteredPath path = new OBOSerializationEngine.FilteredPath();
                while (i < args.length) {
                    if (args[i].equals("-f")) {
                        String filterFile;
                        FilterPair filterPair;
                        if (i >= args.length - 1) {
                            OBO2OBO.printUsage(1);
                        }
                        path.setDoLinkFilter((filterPair = FilterPairEditor.loadFilterPair(filterFile = args[++i])).getLinkFilter() != null);
                        path.setDoFilter(filterPair.getObjectFilter() != null);
                        path.setFilterPair(filterPair);
                    } else if (args[i].equals("-allowdangling")) {
                        path.setAllowDangling(true);
                    } else if (args[i].equals("-strictrootdetection")) {
                        path.setRootAlgorithm("STRICT");
                    } else if (args[i].equals("-saveimpliedlinks")) {
                        path.setSaveImplied(true);
                        path.setImpliedType("Save for presentation");
                    } else if (args[i].equals("-saveallimpliedlinks")) {
                        path.setSaveImplied(true);
                        path.setImpliedType("Save all links");
                    } else if (args[i].equals("-realizeimpliedlinks")) {
                        path.setRealizeImpliedLinks(true);
                    } else if (args[i].equals("-p")) {
                        if (i >= args.length - 1) {
                            OBO2OBO.printUsage(1);
                        }
                        String prefilterProperty = args[++i];
                        path.setPrefilterProperty(prefilterProperty);
                    } else {
                        path.setPath(args[i]);
                        break;
                    }
                    ++i;
                }
                System.err.println("Allowdangling = " + path.getAllowDangling());
                if (path.getPath() == null) {
                    OBO2OBO.printUsage(1);
                    continue;
                }
                writeConfig.getSaveRecords().add(path);
                continue;
            }
            if (args[i].equals("-?")) {
                OBO2OBO.printUsage(0);
                continue;
            }
            readConfig.getReadPaths().add(args[i]);
        }
        if (readConfig.getReadPaths().size() < 1) {
            System.err.println("You must specify at least one file to load.");
            OBO2OBO.printUsage(1);
        }
        if (writeConfig.getSaveRecords().size() < 1 && scripts.size() == 0) {
            System.err.println("You must specify at least one file to save.");
            OBO2OBO.printUsage(1);
        }
        writeConfig.setSerializer(formatVersion);
        OBO2OBO.convertFiles(readConfig, writeConfig, parseObsoleteComments, writeObsoleteComments, fixDbxrefs, scripts);
    }

    protected static void printUsage(int exitCode) {
        System.err.println("obo2obo [-?] [-formatversion <versionid>] <filename 1> ... <filename N> \\\n    [-parsecomments] [-writecomments] \\\n     [-script <scriptname> [arg1 arg2 ... argN] \\;] \\\n   [-o [-f <filterfile1.xml>] <outputfile1>] ... \\\n   [-o [-f <filterfileN.xml>] <outputfileN>]");
        System.err.println("  -?                         - Writes this page to stderr and exits.");
        System.err.println("  -parsecomments             - Parses comments in obsolete terms looking for                                GO-style formatted comments containing parseable                                replacement and consider terms.");
        System.err.println("  -writecomments             - Writes replaced_by and consider tags into parseable                                GO-style formatted comments.");
        System.err.println("  -formatversion <versionid> - The version of OBO to write. Allowed values are\n                               OBO_1_0 and OBO_1_2. The default is OBO_1_2.\n                               Optional.");
        System.err.println("  -script <scriptname> <args> \\; - Runs an OSL script on the ontology. A script tag's                                              arguments MUST be followed by a \\; sequence.");
        System.err.println("  <filenameN>                - An obo file to load. Any number of OBO files may\n                               be loaded");
        System.err.println("  -o [-f <filterfile.xml>] [-allowdangling] [-p <prefilter property id>] [-strictrootdetection] [-saveimpliedlinks|-saveallimpliedlinks] [-realizeimpliedlinks] <outputfile.obo> - \n        An output file to write. The optional -f flag may be used to specify a\n        filter file to apply to the output file before writing. If the \n        -allowdangling flag is specified, dangling links will not be written.\n        The optional -p flag specifies the id of a property to use for \n        reasoner pre-filtering. The optional -strict-root-detection flag\n        applies filters using strict root detection.");
        System.exit(exitCode);
    }

    protected static class WordComparator
    implements Comparator {
        protected WordComparator() {
        }

        public int compare(Object a, Object b) {
            if (a instanceof DanglingWrapper && b instanceof DanglingWrapper) {
                DanglingWrapper dwa = (DanglingWrapper)a;
                DanglingWrapper dwb = (DanglingWrapper)b;
                return dwa.getName().compareToIgnoreCase(dwb.getName());
            }
            if (a instanceof IdentifiedObject && b instanceof IdentifiedObject) {
                IdentifiedObject ia = (IdentifiedObject)a;
                IdentifiedObject ib = (IdentifiedObject)b;
                return ia.getName().compareToIgnoreCase(ib.getName());
            }
            return 0;
        }
    }

    protected static class ScriptWrapper {
        protected String script;
        protected LinkedList args = new LinkedList();

        protected ScriptWrapper() {
        }

        public LinkedList getArgs() {
            return this.args;
        }

        public void setArgs(LinkedList args) {
            this.args = args;
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }
    }

    protected static class DanglingWrapper {
        protected String id;
        protected String text;

        public DanglingWrapper(String id, String text) {
            this.id = id;
            this.text = text;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.text;
        }
    }
}

