/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.LinkTypeHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class SpecificTypeChangeAction
implements ClickMenuAction {
    protected OBOProperty type;
    protected TreePath[] sources;
    protected boolean isLegal = false;
    protected Controller controller;

    public SpecificTypeChangeAction(OBOProperty type) {
        this.type = type;
    }

    public OBOProperty getType() {
        return this.type;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return this.type.toString();
    }

    public String getDesc() {
        return this.type.toString();
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
        if (paths != null) {
            this.isLegal = true;
            this.sources = paths;
            for (int i = 0; i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof Link)) {
                    this.isLegal = false;
                    return;
                }
                Link tr = (Link)paths[i].getLastPathComponent();
                if (tr.getType() != null && !tr.getType().equals(this.type)) continue;
                this.isLegal = false;
                return;
            }
        } else {
            this.isLegal = false;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        HistoryItem item;
        Vector<LinkTypeHistoryItem> historyList = new Vector<LinkTypeHistoryItem>();
        Vector<TreePath> pathouts = new Vector<TreePath>();
        for (int i = 0; i < this.sources.length; ++i) {
            Link tr = (Link)this.sources[i].getLastPathComponent();
            TreePath outpath = this.sources[i].getParentPath().pathByAddingChild(new OBORestrictionImpl(tr.getChild(), tr.getParent(), this.type));
            pathouts.add(TermUtil.convertPathToIDs(outpath));
            historyList.add(new LinkTypeHistoryItem(tr, this.type));
        }
        if (historyList.size() == 1) {
            item = (HistoryItem)historyList.get(0);
        } else {
            item = new TermMacroHistoryItem("Changed relationship types to " + this.type);
            for (int i = 0; i < historyList.size(); ++i) {
                ((TermMacroHistoryItem)item).addHistoryItem((HistoryItem)historyList.get(i));
            }
        }
        TreePath[] outpatharr = new TreePath[pathouts.size()];
        for (int i = 0; i < outpatharr.length; ++i) {
            outpatharr[i] = (TreePath)pathouts.get(i);
        }
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(outpatharr);
        return item;
    }
}

