/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddConsiderHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DropMenuAction;

public class AddConsiderAction
implements DropMenuAction {
    protected boolean isLegal = false;
    protected TreePath[] sources;
    protected TreePath dest;
    protected ObsoletableObject target;
    protected Collection considerTerms = new LinkedList();
    protected Controller controller;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public String getName() {
        return "Add consider term";
    }

    public String getDesc() {
        return "Add consider term";
    }

    public List getSubActions() {
        return null;
    }

    public void dropInit(TreePath[] paths, TreePath destItem) {
        this.considerTerms.clear();
        this.dest = destItem;
        this.sources = paths;
        if (paths == null) {
            this.isLegal = false;
            return;
        }
        if (destItem == null) {
            this.isLegal = false;
            return;
        }
        if (paths.length < 1) {
            this.isLegal = false;
            return;
        }
        if (!(destItem.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        Link destLink = (Link)destItem.getLastPathComponent();
        if (!TermUtil.isObsolete(destLink.getChild())) {
            this.isLegal = false;
            return;
        }
        this.target = (ObsoletableObject)((Object)destLink.getChild());
        for (int i = 0; i < this.sources.length; ++i) {
            Link sourceLink;
            if (!(this.sources[i].getLastPathComponent() instanceof Link) || !((sourceLink = (Link)this.sources[i].getLastPathComponent()).getChild() instanceof ObsoletableObject)) continue;
            ObsoletableObject consider = (ObsoletableObject)((Object)sourceLink.getChild());
            if (this.target.getConsiderReplacements().contains(consider)) continue;
            this.considerTerms.add(consider);
        }
        if (this.considerTerms.size() < 1) {
            this.isLegal = false;
            return;
        }
        this.isLegal = true;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        TermMacroHistoryItem item = new TermMacroHistoryItem("add obsolete consider term");
        Iterator it = this.considerTerms.iterator();
        while (it.hasNext()) {
            ObsoletableObject considerTerm = (ObsoletableObject)it.next();
            AddConsiderHistoryItem addItem = new AddConsiderHistoryItem(this.target, considerTerm);
            item.addHistoryItem(addItem);
        }
        TreePath[] preSelection = new TreePath[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            preSelection[i] = TermUtil.convertPathToIDs(this.sources[i]);
        }
        item.setPreSelection(preSelection);
        TreePath[] destPaths = new TreePath[]{TermUtil.convertPathToIDs(this.dest)};
        item.setPostSelection(destPaths);
        return item;
    }
}

