/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.TermModel;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.DefaultTermModel;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Filterable;
import org.geneontology.oboedit.gui.FilteredRenderable;
import org.geneontology.oboedit.gui.InputHandlerI;
import org.geneontology.oboedit.gui.LineRenderer;
import org.geneontology.oboedit.gui.OBOButtonPanel;
import org.geneontology.oboedit.gui.OBOCellRenderer;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.ObjectSelector;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.PrimarySelectorChangeEvent;
import org.geneontology.oboedit.gui.event.PrimarySelectorChangeListener;
import org.geneontology.oboedit.gui.event.ReconfigEvent;
import org.geneontology.oboedit.gui.event.ReconfigListener;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.oboedit.gui.event.ScrollSyncEvent;
import org.geneontology.oboedit.gui.event.ScrollSyncListener;
import org.geneontology.oboedit.gui.event.SubSelectEvent;
import org.geneontology.oboedit.gui.event.SubSelectListener;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.swing.DragSource;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.FreezableScrollPane;
import org.geneontology.swing.FreezableViewport;
import org.geneontology.swing.SwingUtil;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DragListener;
import org.geneontology.swing.event.DropListener;
import org.geneontology.swing.plaf.DragFriendlyTreeUI;

public class OBOTermPanel
extends JTree
implements ObjectSelector,
FilteredRenderable,
Filterable,
OBOEditComponent {
    private static final long serialVersionUID = 1L;
    public static Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    protected PrimarySelectorChangeListener selectorListener = new PrimarySelectorChangeListener(){

        public void primarySelectorChange(PrimarySelectorChangeEvent e) {
            OBOTermPanel.this.repaint();
        }
    };
    protected JButton cornerComponent = new JButton("");
    protected boolean ignoreSelection = false;
    protected boolean scrollOnSelection = true;
    protected int tabRow = -1;
    protected int highlightedRow = -1;
    protected int clickTarget = -1;
    protected int[] sortedSelectionRows = new int[0];
    protected TreePath lockedPath = null;
    protected DropTarget dropTarget;
    protected DragSource dragSource;
    protected InputListener inputListener;
    protected InputHandlerI currentDragHandler;
    protected DragEvent currentDragEvent;
    protected String dragTitle = "";
    protected List renderers = new ArrayList();
    protected FilterPair filter;
    protected boolean dragging = false;
    protected static final Color lockGray = new Color(200, 200, 200);
    protected static final Color secondaryGray = new Color(240, 240, 240);
    TreeSelectionListener selectionListener = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent e) {
            Controller controller = Controller.getController();
            if (controller.getPrimarySelector().equals(OBOTermPanel.this)) {
                controller.select(OBOTermPanel.this.getSelectionPaths(), false);
            }
            OBOTermPanel.this.sortedSelectionRows = OBOTermPanel.this.getSortedSelectionRows();
        }
    };
    RefreshListener reloadListener = new RefreshListener(){

        public void reload(RefreshEvent e) {
            OBOTermPanel.this.reload();
        }
    };
    SubSelectListener subSelectListener = new SubSelectListener(){

        public void selectObject(SubSelectEvent e) {
            Controller controller = Controller.getController();
            if (controller.getPrimarySelector().equals(OBOTermPanel.this) && e.getSelectedObject() != null) {
                TreePath[] paths = controller.getSelectedPaths();
                TreePath foundPath = null;
                boolean isVisible = false;
                boolean isShowing = false;
                for (int i = 0; i < paths.length; ++i) {
                    Link link = (Link)paths[i].getLastPathComponent();
                    if (!link.getChild().equals(e.getSelectedObject())) continue;
                    foundPath = paths[i];
                    if (OBOTermPanel.this.isVisible(paths[i])) {
                        isVisible = true;
                        if (OBOTermPanel.this.isShowing(paths[i])) {
                            isShowing = true;
                        }
                    }
                    if (isVisible && isShowing) break;
                }
                if (!isVisible) {
                    OBOTermPanel.this.makeVisible(foundPath);
                }
                if (!isShowing) {
                    OBOTermPanel.this.scrollPathToVisible(foundPath);
                }
            }
            OBOTermPanel.this.repaint();
        }
    };
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            this.doUpdate(true);
        }

        protected void doUpdate(boolean focused) {
            JScrollPane parentScroller = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = OBOTermPanel.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, OBOTermPanel.this);
            if (parentScroller != null) {
                if (focused) {
                    parentScroller.setViewportBorder(new LineBorder(Color.black, 1));
                } else {
                    parentScroller.setViewportBorder(EMPTY_BORDER);
                }
                parentScroller.repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            this.doUpdate(false);
        }
    };
    KeyListener focusKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 70 && e.isControlDown()) {
                OBOTermPanel.this.requestFocus();
            } else if (e.getKeyCode() == 91) {
                OBOTermPanel.this.tabBackward();
            } else if (e.getKeyCode() == 93) {
                OBOTermPanel.this.tabForward();
            }
        }
    };
    RootChangeListener rootChangeListener = new RootChangeListener(){

        public void changeRoot(RootChangeEvent e) {
            Controller controller = Controller.getController();
            Set roots = controller.getRoots();
            TreePath rootPath = new TreePath(OBOSession.ROOT);
            Iterator it = roots.iterator();
            while (it.hasNext()) {
                OBORestrictionImpl tr = new OBORestrictionImpl((LinkedObject)it.next());
                TreePath path = rootPath.pathByAddingChild(tr);
                OBOTermPanel.this.expandPath(path);
            }
        }
    };
    ScrollSyncListener syncListener = new ScrollSyncListener(){

        public void synchronizeScroll(ScrollSyncEvent e) {
            JScrollPane parentScroller;
            if (e.getSource() != OBOTermPanel.this && (parentScroller = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = OBOTermPanel.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, OBOTermPanel.this)) != null) {
                OBOTermPanel.this.makeVisible(e.getPath());
                Rectangle pathbounds = OBOTermPanel.this.getPathBounds(e.getPath());
                parentScroller.getViewport().setViewPosition(new Point(pathbounds.x - e.getWidthOffset(), pathbounds.y));
            }
        }
    };
    ReconfigListener reconfigListener = new ReconfigListener(){

        public void configReloaded(ReconfigEvent e) {
            OBOTermPanel.this.setToolTips();
        }
    };
    protected KeyListener draggingKeyListener = new KeyListener(){

        protected void processDraggingKey(KeyEvent e) {
            Point myPoint = SwingUtilities.convertPoint(OBOTermPanel.this.currentDragEvent.getDragSource(), OBOTermPanel.this.currentDragEvent.getX(), OBOTermPanel.this.currentDragEvent.getY(), OBOTermPanel.this);
            TreePath dest = OBOTermPanel.this.getPath(myPoint);
            OBOTermPanel dragComp = OBOTermPanel.this.currentDragEvent.getDragSource() instanceof OBOTermPanel ? (OBOTermPanel)OBOTermPanel.this.currentDragEvent.getDragSource() : null;
            Controller controller = Controller.getController();
            List l = controller.getInputHandlers();
            for (int i = 0; i < l.size(); ++i) {
                InputHandlerI handler = (InputHandlerI)l.get(i);
                int allowDropVal = handler.allowDrop(dragComp, OBOTermPanel.this, controller, OBOTermPanel.this.currentDragEvent.getData(), dest, (MouseEvent)OBOTermPanel.this.currentDragEvent, controller.getKeyRecorder().getKeyChecker());
                if (allowDropVal != 1 && allowDropVal != 2) continue;
                OBOTermPanel.this.currentDragHandler = handler;
                break;
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            this.processDraggingKey(e);
        }

        public void keyPressed(KeyEvent e) {
            this.processDraggingKey(e);
        }
    };
    protected SingletonEnumeration singletonEnumeration = new SingletonEnumeration();
    protected OBOButtonPanel buttonPanel;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    protected void ensureLockedPathIsShowing() {
        if (this.lockedPath != null && !this.isShowing(this.lockedPath)) {
            Rectangle bounds;
            FreezableViewport freezableViewport = (FreezableViewport)SwingUtilities.getAncestorOfClass(FreezableViewport.class, this);
            if (freezableViewport != null) {
                freezableViewport.setFrozen(false);
            }
            if ((bounds = this.getPathBounds(this.lockedPath)) != null) {
                this.scrollRectToVisible(bounds);
            }
            if (freezableViewport != null) {
                freezableViewport.setFrozen(true);
            }
        }
    }

    public void collapsePath(TreePath path) {
        if (this.lockedPath != null && SwingUtil.isChildPath((TreePath)path, (TreePath)this.lockedPath)) {
            return;
        }
        super.collapsePath(path);
    }

    public void expandPath(TreePath path) {
        super.expandPath(path);
        this.ensureLockedPathIsShowing();
    }

    public boolean isShowing(TreePath path) {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (viewport == null) {
            return true;
        }
        Rectangle visibleBounds = viewport.getViewRect();
        Rectangle pathBounds = this.getPathBounds(path);
        if (pathBounds == null || visibleBounds == null) {
            return false;
        }
        return visibleBounds.intersects(pathBounds);
    }

    protected boolean processPress(KeyEvent e) {
        Controller controller = Controller.getController();
        List l = controller.getInputHandlers();
        for (int i = 0; i < l.size(); ++i) {
            InputHandlerI handler = (InputHandlerI)l.get(i);
            if (!handler.press(this, controller, e, controller.getKeyRecorder().getKeyChecker())) continue;
            return true;
        }
        return false;
    }

    protected TreePath getPath(Point p) {
        TreePath path = this.getPathForLocation((int)p.getX(), (int)p.getY());
        return path;
    }

    public void setDragTitle(String title) {
        boolean updateImage = !this.dragTitle.equals(title);
        this.dragTitle = title;
        Controller controller = Controller.getController();
        if (updateImage) {
            ((OBODragListener)this.dragSource.getListener()).clearImageCache();
            controller.getDragController().updateDragImage(this.dragSource, false);
        }
    }

    public LinkDatabase getLinkDatabase() {
        return ((TermModel)this.getModel()).getLinkDatabase();
    }

    public RootAlgorithm getRootAlgorithm() {
        return ((TermModel)this.getModel()).getRootAlgorithm();
    }

    public int getHighlightRow() {
        return this.highlightedRow;
    }

    public void highlightDropTarget(int row) {
        int oldHighlightedRow = this.highlightedRow;
        this.highlightedRow = row;
        this.repaintRow(this.highlightedRow);
        this.repaintRow(oldHighlightedRow);
    }

    public void indicateClickTarget(int row) {
        int oldClickTarget = this.clickTarget;
        this.clickTarget = row;
        this.repaintRow(this.clickTarget);
        this.repaintRow(oldClickTarget);
    }

    public void cleanupDragController() {
        Controller controller = Controller.getController();
        controller.getDragController().unregisterDropTarget(this.dropTarget);
        controller.getDragController().unregisterDragSource(this.dragSource);
    }

    public void initDragController() {
        Controller controller = Controller.getController();
        if (this.dropTarget == null) {
            this.inputListener = new InputListener();
            this.dropTarget = new DropTarget((Component)this, (DropListener)this.inputListener);
        }
        if (this.dragSource == null) {
            this.dragSource = new DragSource((Component)this, (DragListener)new OBODragListener(this));
        }
        controller.getDragController().registerDropTarget(this.dropTarget);
        controller.getDragController().registerDragSource(this.dragSource);
    }

    public void setScrollOnSelection(boolean scrollOnSelection) {
        this.scrollOnSelection = scrollOnSelection;
    }

    public boolean getScrollOnSelection() {
        return this.scrollOnSelection;
    }

    public TreePath getLockedPath() {
        return this.lockedPath;
    }

    public void setLockedPath(TreePath lockedPath) {
        this.lockedPath = lockedPath;
        FreezableScrollPane scrollPane = (FreezableScrollPane)SwingUtilities.getAncestorOfClass(FreezableScrollPane.class, this);
        if (scrollPane != null) {
            scrollPane.setFrozen(lockedPath != null);
            if (lockedPath != null) {
                Rectangle r = this.getPathBounds(lockedPath);
                if (!scrollPane.getViewport().getViewRect().contains(r)) {
                    JOptionPane.showMessageDialog(this, "Warning: The view has been locked around a path that isn't currently visible. The view will be adjusted to make the path visible.");
                    this.ensureLockedPathIsShowing();
                }
            }
        }
        this.repaint();
    }

    public Color getBackground() {
        if (this.lockedPath != null) {
            return lockGray;
        }
        if (Controller.getController().getPrimarySelector() != this) {
            return secondaryGray;
        }
        return Color.white;
    }

    public void paint(Graphics g) {
        TreeModel model = this.getModel();
        if (model instanceof DefaultTermModel) {
            ((DefaultTermModel)model).setPainting(true);
        }
        super.paint(g);
        if (model instanceof DefaultTermModel) {
            ((DefaultTermModel)model).setPainting(false);
        }
    }

    public void repaintRow(int row) {
        Rectangle bounds;
        if (row != -1 && (bounds = this.getRowBounds(row)) != null) {
            this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public void setFilter(FilterPair filter) {
        if (this.getModel() instanceof TermModel) {
            this.filter = filter;
            if (filter != null) {
                ((TermModel)this.getModel()).setTermFilter(filter.getObjectFilter());
                ((TermModel)this.getModel()).setLinkFilter(filter.getLinkFilter());
            } else {
                ((TermModel)this.getModel()).setTermFilter(null);
                ((TermModel)this.getModel()).setLinkFilter(null);
            }
            this.formatCornerComponent();
            this.reload();
        }
    }

    public FilterPair getFilter() {
        if (this.getModel() instanceof TermModel) {
            return this.filter;
        }
        return null;
    }

    public void setPropertyFilter(OBOProperty type) {
        if (this.getModel() instanceof DefaultTermModel) {
            ((DefaultTermModel)this.getModel()).setPropertyFilter(type);
        }
    }

    public OBOProperty getPropertyFilter() {
        return ((DefaultTermModel)this.getModel()).getPropertyFilter();
    }

    public void addRenderer(FilterPair pair) {
        this.renderers.add(pair);
        this.formatCornerComponent();
        this.repaint();
    }

    public void removeRenderer(FilterPair pair) {
        this.renderers.remove(pair);
        this.formatCornerComponent();
        this.repaint();
    }

    public List getRenderers() {
        return this.renderers;
    }

    public void setIgnoreSelection(boolean ignoreSelection) {
        this.ignoreSelection = ignoreSelection;
    }

    public boolean ignoreSelection() {
        return this.ignoreSelection;
    }

    public int getClickTarget() {
        return this.clickTarget;
    }

    protected void scrollToTabLoc(int oldRow) {
        if (this.tabRow == -1 || this.lockedPath != null) {
            return;
        }
        if (this.tabRow >= this.getSelectionCount()) {
            this.tabRow = this.getSelectionCount() - 1;
        }
        this.scrollRowToVisible(this.getTabRow());
        if (oldRow != -1) {
            this.repaint(this.getRowBounds(oldRow));
        }
        if (this.tabRow != -1) {
            this.repaint(this.getRowBounds(this.tabRow));
        }
        this.repaint();
    }

    protected void tabForward() {
        this.tabRow = this.sortedSelectionRows.length == 0 ? -1 : (this.tabRow < this.sortedSelectionRows.length - 1 ? ++this.tabRow : 0);
        if (this.tabRow >= 0) {
            int row = this.sortedSelectionRows[this.tabRow];
            if (Controller.getController().getPrimarySelector().equals(this)) {
                LinkedObject term = null;
                TreePath path = this.getPathForRow(row);
                Object o = path.getLastPathComponent();
                if (o instanceof Link) {
                    term = ((Link)o).getChild();
                }
                if (term != null) {
                    Controller.getController().setSubSelection(term);
                }
            }
            this.scrollToTabLoc(this.tabRow);
        }
    }

    protected void tabBackward() {
        int oldRow = this.tabRow;
        this.tabRow = this.sortedSelectionRows.length == 0 ? -1 : (this.tabRow > 0 ? --this.tabRow : this.sortedSelectionRows.length - 1);
        if (this.tabRow >= 0) {
            int row = this.sortedSelectionRows[this.tabRow];
            if (Controller.getController().getPrimarySelector().equals(this)) {
                LinkedObject term = null;
                TreePath path = this.getPathForRow(row);
                Object o = path.getLastPathComponent();
                if (o instanceof Link) {
                    term = ((Link)o).getChild();
                }
                if (term != null) {
                    Controller.getController().setSubSelection(term);
                }
            }
            this.scrollToTabLoc(this.tabRow);
        }
    }

    public int getTabRow() {
        if (this.tabRow < 0 || this.tabRow >= this.sortedSelectionRows.length || this.sortedSelectionRows.length == 0) {
            return -1;
        }
        if (this.tabRow >= this.sortedSelectionRows.length) {
            this.tabRow = this.sortedSelectionRows.length - 1;
        }
        return this.sortedSelectionRows[this.tabRow];
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null || !(path.getLastPathComponent() instanceof Link)) {
            return null;
        }
        Link link = (Link)path.getLastPathComponent();
        String s = link.getChild().getID();
        StringBuffer buf = new StringBuffer("<html>");
        int linelength = 0;
        int MAXLENGTH = 40;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            ++linelength;
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\n' || linelength > MAXLENGTH && Character.isWhitespace(c)) {
                buf.append("<br>\n");
                linelength = 0;
                continue;
            }
            buf.append(c);
        }
        buf.append("</html>");
        return buf.toString();
    }

    public void attachListeners() {
        final Controller controller = Controller.getController();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                OBOTermPanel.this.ensureLockedPathIsShowing();
            }
        });
        this.addTreeSelectionListener(this.selectionListener);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                controller.getKeyRecorder().addKeyListener(OBOTermPanel.this.focusKeyListener);
            }

            public void mouseExited(MouseEvent e) {
                controller.getKeyRecorder().removeKeyListener(OBOTermPanel.this.focusKeyListener);
            }
        });
        this.addFocusListener(this.focusListener);
        controller.addListener(this.selectorListener);
        controller.addListener(this.subSelectListener);
        controller.addListener(this.rootChangeListener);
        controller.addListener(this.reconfigListener);
        controller.addListener(this.reloadListener);
        controller.addListener(this.syncListener);
        this.cornerComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOTermPanel.this.buttonPanel.setButtonPanelVisible(!OBOTermPanel.this.buttonPanel.getButtonPanelVisible());
            }
        });
    }

    public void cleanup() {
        Controller controller = Controller.getController();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        controller.removeListener(this.selectorListener);
        controller.getKeyRecorder().removeKeyListener(this.focusKeyListener);
        controller.removeListener(this.subSelectListener);
        controller.removeListener(this.rootChangeListener);
        controller.removeListener(this.reconfigListener);
        controller.removeListener(this.reloadListener);
        controller.removeListener(this.syncListener);
        this.buttonPanel.cleanup();
    }

    public void setController(Controller controller) {
    }

    public OBOTermPanel() {
        this.setDrawArrowhead(true);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.cornerComponent.setFont(new Font("Arial", 1, 10));
        this.cornerComponent.setBorder(null);
        this.cornerComponent.setBackground(Preferences.defaultBackgroundColor());
        this.buttonPanel = new OBOButtonPanel(this);
        DragFriendlyTreeUI ui = this.getDefaultUI();
        this.setUI((TreeUI)ui);
        ui.setRightChildIndent(20);
        this.formatCornerComponent();
    }

    public TreePath[] getSelectedPaths() {
        return this.getSelectionPaths();
    }

    public void select(TreePath[] paths) {
        Controller controller = Controller.getController();
        this.removeTreeSelectionListener(this.selectionListener);
        this.setSelectionPaths(paths);
        if (controller.getPrimarySelector().equals(this)) {
            controller.notifySelection(paths);
        }
        if (paths.length > 0) {
            this.makeVisible(paths[0]);
            this.scrollPathToVisible(paths[0]);
        }
        this.sortedSelectionRows = this.getSortedSelectionRows();
        this.addTreeSelectionListener(this.selectionListener);
    }

    public void fillInMenu(JPopupMenu menu) {
        final Controller controller = Controller.getController();
        final TreePath[] selectedPaths = controller.getSelectedPaths();
        JMenuItem collapseItem = new JMenuItem("Collapse all children of selection");
        final Vector<TreePath> collapsePaths = new Vector<TreePath>();
        for (int i = 0; i < selectedPaths.length; ++i) {
            if (!this.isExpanded(selectedPaths[i])) continue;
            collapsePaths.add(selectedPaths[i]);
        }
        collapseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < collapsePaths.size(); ++i) {
                    SwingUtil.collapseTree((JTree)OBOTermPanel.this, (TreePath)((TreePath)collapsePaths.get(i)));
                }
                TreePath rootPath = new TreePath(OBOTermPanel.this.getModel().getRoot());
                OBOTermPanel.this.expandPath(rootPath);
            }
        });
        collapseItem.setEnabled(collapsePaths.size() > 0);
        collapseItem.setFont(controller.getDefaultFont());
        menu.add(collapseItem);
        JMenuItem synchronizeItem = new JMenuItem("Synchronize views");
        synchronizeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OBOTermPanel.this.getSelectionPaths().length != 1) {
                    return;
                }
                JScrollPane parentScroller = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = OBOTermPanel.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, OBOTermPanel.this);
                TreePath path = OBOTermPanel.this.getSelectionPaths()[0];
                if (parentScroller != null) {
                    Rectangle pathbounds = OBOTermPanel.this.getPathBounds(path);
                    Rectangle viewerbounds = parentScroller.getViewport().getViewRect();
                    int heightOffset = 0;
                    int widthOffset = 0;
                    if (pathbounds == null || viewerbounds == null) {
                        heightOffset = 0;
                        widthOffset = 0;
                        return;
                    }
                    heightOffset = (int)(pathbounds.getY() - viewerbounds.getY());
                    widthOffset = (int)(pathbounds.getX() - viewerbounds.getX());
                    if (heightOffset < 0) {
                        heightOffset = 0;
                    }
                    if (widthOffset < 0) {
                        widthOffset = 0;
                    }
                    controller.fireScrollSync(new ScrollSyncEvent(OBOTermPanel.this, path, heightOffset, widthOffset));
                }
            }
        });
        synchronizeItem.setEnabled(controller.getDAGs().size() > 1);
        synchronizeItem.setFont(controller.getDefaultFont());
        menu.add(synchronizeItem);
        JMenuItem lockItem = new JMenuItem("Lock view");
        lockItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOTermPanel.this.setLockedPath(selectedPaths[0]);
            }
        });
        lockItem.setEnabled(selectedPaths.length == 1 && !selectedPaths[0].equals(this.lockedPath));
        lockItem.setFont(controller.getDefaultFont());
        menu.add(lockItem);
        JMenuItem unlockItem = new JMenuItem("Unlock view");
        unlockItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOTermPanel.this.setLockedPath(null);
            }
        });
        unlockItem.setEnabled(this.lockedPath != null);
        unlockItem.setFont(controller.getDefaultFont());
        menu.add(unlockItem);
        JMenuItem redrawScreenItem = new JMenuItem("Refresh view");
        redrawScreenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                controller.getSession().markRoots();
                controller.fireReload(new RefreshEvent(this));
            }
        });
        redrawScreenItem.setFont(controller.getDefaultFont());
        menu.add(redrawScreenItem);
        menu.addSeparator();
        Vector v = this.getFilterMenuItems();
        for (int i = 0; i < v.size(); ++i) {
            JMenuItem item = (JMenuItem)v.get(i);
            menu.add(item);
        }
    }

    public void setDrawArrowhead(boolean drawArrowhead) {
        if (this.getUI() instanceof DragFriendlyTreeUI) {
            DragFriendlyTreeUI ui = (DragFriendlyTreeUI)this.getUI();
            ui.setDrawArrowhead(drawArrowhead);
        }
    }

    protected DragFriendlyTreeUI getDefaultUI() {
        OBOTermPanelUI ui = new OBOTermPanelUI();
        return ui;
    }

    public Component getCornerComponent() {
        return this.cornerComponent;
    }

    protected void formatCornerComponent() {
    }

    public void setToolTips() {
        Controller controller = Controller.getController();
        if (controller.showToolTips()) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public TreePath[] getExpandedPaths() {
        TreePath[] out = new TreePath[this.getRowCount()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.getPathForRow(i);
        }
        return out;
    }

    public boolean pathIsValid(TreePath current) {
        return TermUtil.pathIsValid(current, this.getModel());
    }

    public void synchronize(OBOTermPanel panel) {
        TreePath rootPath = new TreePath(OBOSession.ROOT);
        Enumeration<TreePath> e = panel.getExpandedDescendants(rootPath);
        while (e.hasMoreElements()) {
            this.expandPath(e.nextElement());
        }
        this.setSelectionPaths(panel.getSelectionPaths());
    }

    public void reload() {
        this.reload(null);
    }

    public void reload(List graphOpList) {
        TreeModel model;
        TreeSelectionListener[] selectionListeners = this.getTreeSelectionListeners();
        for (int i = 0; i < selectionListeners.length; ++i) {
            this.removeTreeSelectionListener(selectionListeners[i]);
        }
        TreePath[] expanded = null;
        TreePath[] selected = this.getSelectionPaths();
        boolean cachePaths = false;
        if (graphOpList != null) {
            Iterator it = graphOpList.iterator();
            while (it.hasNext()) {
                HistoryItem.GraphOperation go = (HistoryItem.GraphOperation)it.next();
                if (!go.cachePathsNeeded()) continue;
                cachePaths = true;
                break;
            }
        } else {
            cachePaths = true;
        }
        if (cachePaths) {
            expanded = this.getExpandedPaths();
            if (this.lockedPath != null && !this.pathIsValid(this.lockedPath)) {
                this.setLockedPath(null);
            }
        }
        if ((model = this.getModel()) instanceof TermModel) {
            ((TermModel)model).reload(graphOpList);
        }
        if (cachePaths) {
            this.restorePaths(expanded);
            if (selected != null) {
                this.restoreSelectionPaths(selected);
            }
        }
        for (int i = 0; i < selectionListeners.length; ++i) {
            this.addTreeSelectionListener(selectionListeners[i]);
        }
    }

    public void restorePaths(TreePath[] expanded) {
        for (int i = 0; i < expanded.length; ++i) {
            TreePath current = expanded[i];
            if (!TermUtil.pathIsValid(current, this.getModel())) continue;
            this.makeVisible(current);
        }
    }

    public void restoreSelectionPaths(TreePath[] expanded) {
        for (int i = 0; i < expanded.length; ++i) {
            TreePath current = expanded[i];
            if (!TermUtil.pathIsValid(current, this.getModel())) continue;
            this.addSelectionPath(current);
        }
    }

    protected int[] getSortedSelectionRows() {
        int[] arr = this.getSelectionRows();
        if (arr == null) {
            return new int[0];
        }
        if (arr.length < 2) {
            return arr;
        }
        OBOTermPanel.sort(arr);
        return arr;
    }

    public void setModel(TreeModel model) {
        super.setModel(model);
        this.reload();
    }

    protected Vector getFilterMenuItems() {
        Controller controller = Controller.getController();
        Vector<JMenuItem> v = new Vector<JMenuItem>();
        JMenuItem removeAllDecorationAndFilters = new JMenuItem("Remove all renderers and filters");
        removeAllDecorationAndFilters.setFont(controller.getDefaultFont());
        removeAllDecorationAndFilters.setEnabled(this.renderers.size() > 0 || this.getFilter() != null);
        removeAllDecorationAndFilters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOTermPanel.this.renderers.clear();
                if (OBOTermPanel.this.getFilter() != null) {
                    OBOTermPanel.this.setFilter(null);
                    OBOTermPanel.this.reload();
                }
                OBOTermPanel.this.formatCornerComponent();
                OBOTermPanel.this.repaint();
            }
        });
        v.add(removeAllDecorationAndFilters);
        JMenuItem removeAllDecoration = new JMenuItem("Remove all renderers");
        removeAllDecoration.setFont(controller.getDefaultFont());
        removeAllDecoration.setEnabled(this.renderers.size() > 0);
        removeAllDecoration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOTermPanel.this.renderers.clear();
                OBOTermPanel.this.formatCornerComponent();
                OBOTermPanel.this.repaint();
            }
        });
        v.add(removeAllDecoration);
        JMenu renderMenu = new JMenu("Remove specific renderer");
        renderMenu.setFont(controller.getDefaultFont());
        renderMenu.setEnabled(this.renderers.size() > 0);
        Iterator it = this.renderers.iterator();
        while (it.hasNext()) {
            final FilterPair fr = (FilterPair)it.next();
            JMenuItem ritem = new JMenuItem("Remove " + fr.toString());
            ritem.setFont(controller.getDefaultFont());
            ritem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OBOTermPanel.this.removeRenderer(fr);
                }
            });
            renderMenu.add(ritem);
        }
        v.add(renderMenu);
        JMenuItem filterMenuItem = new JMenuItem("Remove filter");
        filterMenuItem.setFont(controller.getDefaultFont());
        filterMenuItem.setEnabled(this.getFilter() != null);
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOTermPanel.this.setFilter(null);
            }
        });
        v.add(filterMenuItem);
        return v;
    }

    protected static void sort(int[] arr) {
        OBOTermPanel.quicksort(arr, 0, arr.length - 1);
    }

    private static void quicksort(int[] a, int low, int high) {
        if (low < high) {
            int middle;
            int pivot = a[high];
            int smallSide = low;
            int largeSide = high - 1;
            while (smallSide < largeSide) {
                while (a[smallSide] < pivot) {
                    ++smallSide;
                }
                while (largeSide >= 0 && pivot <= a[largeSide]) {
                    --largeSide;
                }
                if (smallSide >= largeSide) continue;
                int temp = a[smallSide];
                a[smallSide] = a[largeSide];
                a[largeSide] = temp;
            }
            if (pivot < a[smallSide]) {
                int temp = a[smallSide];
                a[smallSide] = a[high];
                a[high] = temp;
                middle = smallSide;
            } else {
                middle = high;
            }
            OBOTermPanel.quicksort(a, low, middle - 1);
            OBOTermPanel.quicksort(a, middle + 1, high);
        }
    }

    public JComponent getComponent() {
        return this.buttonPanel;
    }

    public ComponentConfiguration getConfiguration() {
        OBOPanelConfiguration config = new OBOPanelConfiguration();
        if (Controller.getController().getPrimarySelector() == this) {
            config.setPrimarySelector(true);
        }
        config.setButtonsVisible(this.buttonPanel.getButtonPanelVisible());
        config.setFilter(this.getFilter());
        if (this.getModel() instanceof DefaultTermModel) {
            OBOProperty filterProperty = ((DefaultTermModel)this.getModel()).getPropertyFilter();
            if (filterProperty == null) {
                config.setFilterPropID(null);
            } else {
                config.setFilterPropID(filterProperty.getID());
            }
        }
        if (this.getRootAlgorithm() == RootAlgorithm.STRICT) {
            config.setRootAlgorithm("STRICT");
        } else if (this.getRootAlgorithm() == RootAlgorithm.GREEDY) {
            config.setRootAlgorithm("GREEDY");
        }
        return config;
    }

    public void setConfiguration(ComponentConfiguration c) {
        if (c instanceof OBOPanelConfiguration) {
            OBOPanelConfiguration config = (OBOPanelConfiguration)c;
            if (config.getPrimarySelector()) {
                Controller.getController().setPrimarySelector(this);
            }
            this.buttonPanel.setButtonPanelVisible(config.getButtonsVisible());
            if (config.getFilter() != null) {
                this.setFilter(config.getFilter());
            }
            if (config.getRootAlgorithm() != null) {
                if (config.getRootAlgorithm().equals("STRICT")) {
                    this.setRootAlgorithm(RootAlgorithm.STRICT);
                } else if (config.getRootAlgorithm().equals("GREEDY")) {
                    this.setRootAlgorithm(RootAlgorithm.GREEDY);
                }
            }
            if (config.getFilterPropID() == null) {
                this.setPropertyFilter(null);
            } else {
                IdentifiedObject obj = Controller.getController().getSession().getObject(config.getFilterPropID());
                OBOProperty type = (OBOProperty)obj;
                this.setPropertyFilter(type);
            }
        }
    }

    public void setRootAlgorithm(RootAlgorithm algorithm) {
        if (this.getModel() instanceof DefaultTermModel) {
            ((DefaultTermModel)this.getModel()).setRootAlgorithm(algorithm);
            this.reload();
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public void init() {
        this.initDragController();
        this.attachListeners();
        this.setToolTips();
        this.setCellRenderer(new OBOCellRenderer(Controller.getController()));
        this.buttonPanel.init();
    }

    public String getID() {
        return "DAG";
    }

    public void setXML(String xml) {
    }

    protected static class SingletonEnumeration
    implements Enumeration {
        protected Object object;

        public void setObject(Object object) {
            this.object = object;
        }

        public boolean hasMoreElements() {
            return this.object != null;
        }

        public Object nextElement() {
            Object out = this.object;
            this.object = null;
            return out;
        }
    }

    public class OBOTermPanelUI
    extends DragFriendlyTreeUI {
        protected int[] triangleXBuffer = new int[3];
        protected int[] triangleYBuffer = new int[3];

        protected MouseListener createMouseListener() {
            return new MouseUIAdapter();
        }

        protected KeyListener createKeyListener() {
            return new KeyUIAdapter();
        }

        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right, boolean isLeaf, TreePath path) {
            if (OBOTermPanel.this.getCellRenderer() instanceof LineRenderer) {
                LineRenderer lineRenderer = (LineRenderer)((Object)OBOTermPanel.this.getCellRenderer());
                lineRenderer.paintLine(g, c, y, left, right, isLeaf, path);
            }
        }

        public class KeyUIAdapter
        extends KeyAdapter {
            protected Action repeatKeyAction;
            protected boolean isKeyDown;

            public void keyTyped(KeyEvent e) {
                if (OBOTermPanel.this.processPress(e)) {
                    return;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (OBOTermPanel.this.processPress(e)) {
                    return;
                }
                if (OBOTermPanelUI.this.tree != null && OBOTermPanelUI.this.tree.hasFocus() && OBOTermPanelUI.this.tree.isEnabled()) {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                    if (OBOTermPanelUI.this.tree.getConditionForKeyStroke(keyStroke) == 0) {
                        ActionListener listener = OBOTermPanelUI.this.tree.getActionForKeyStroke(keyStroke);
                        if (listener instanceof Action) {
                            this.repeatKeyAction = (Action)listener;
                            if (!this.repeatKeyAction.isEnabled()) {
                                this.repeatKeyAction = null;
                            }
                        } else {
                            this.repeatKeyAction = null;
                        }
                    } else {
                        this.repeatKeyAction = null;
                    }
                    if (this.isKeyDown && this.repeatKeyAction != null) {
                        this.repeatKeyAction.actionPerformed(new ActionEvent(OBOTermPanelUI.this.tree, 1001, "", e.getWhen(), e.getModifiers()));
                        e.consume();
                    } else {
                        this.isKeyDown = true;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                if (OBOTermPanel.this.processPress(e)) {
                    return;
                }
                this.isKeyDown = false;
            }
        }

        protected class MouseUIAdapter
        extends MouseAdapter {
            protected MouseUIAdapter() {
            }

            public void mousePressed(MouseEvent e) {
                OBOTermPanel.this.indicateClickTarget(OBOTermPanel.this.getRowForLocation(e.getX(), e.getY()));
                if (((OBOTermPanelUI)OBOTermPanelUI.this).OBOTermPanel.this.dragging || e.isConsumed()) {
                    return;
                }
                this.processClick(e);
            }

            protected boolean processClick(MouseEvent e) {
                Controller controller = Controller.getController();
                List l = controller.getInputHandlers();
                TreePath path = OBOTermPanel.this.getPathForLocation(e.getX(), e.getY());
                for (int i = 0; i < l.size(); ++i) {
                    InputHandlerI handler = (InputHandlerI)l.get(i);
                    if (!handler.click(OBOTermPanel.this, controller, path, e, controller.getKeyRecorder().getKeyChecker())) continue;
                    return true;
                }
                return false;
            }

            public void mouseReleased(MouseEvent e) {
                OBOTermPanel.this.indicateClickTarget(-1);
                if (((OBOTermPanelUI)OBOTermPanelUI.this).OBOTermPanel.this.dragging || e.isConsumed()) {
                    return;
                }
                if (this.processClick(e)) {
                    return;
                }
                if (OBOTermPanelUI.this.tree != null && OBOTermPanelUI.this.tree.isEnabled()) {
                    OBOTermPanelUI.this.tree.requestFocus();
                    TreePath path = OBOTermPanelUI.this.getClosestPathForLocation(OBOTermPanelUI.this.tree, e.getX(), e.getY());
                    if (path != null) {
                        int x;
                        Rectangle bounds = OBOTermPanelUI.this.getPathBounds(OBOTermPanelUI.this.tree, path);
                        if (e.getY() > bounds.y + bounds.height) {
                            return;
                        }
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            OBOTermPanelUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                        }
                        if (!((x = e.getX()) <= bounds.x || x > bounds.x + bounds.width || OBOTermPanelUI.this.startEditing(path, e) || OBOTermPanel.this.equals(Controller.getController().getPrimarySelector()) && !Controller.getController().doPreSelectValidation(OBOTermPanel.this))) {
                            OBOTermPanelUI.this.selectPathForEvent(path, e);
                        }
                    }
                }
            }
        }
    }

    protected class InputListener
    implements DropListener {
        boolean dragging = false;

        protected InputListener() {
        }

        public void drop(DragEvent e) {
            OBOTermPanel.this.highlightDropTarget(-1);
            Point myPoint = SwingUtilities.convertPoint(e.getDragSource(), e.getX(), e.getY(), OBOTermPanel.this);
            TreePath dest = OBOTermPanel.this.getPath(myPoint);
            OBOTermPanel dragComp = e.getDragSource() instanceof OBOTermPanel ? (OBOTermPanel)e.getDragSource() : null;
            Controller controller = Controller.getController();
            OBOTermPanel.this.currentDragHandler.drop(dragComp, OBOTermPanel.this, controller, e.getData(), dest, (MouseEvent)e, controller.getKeyRecorder().getKeyChecker());
            this.dragging = false;
        }

        public void draggedOver(DragEvent e) {
            Point p = SwingUtilities.convertPoint(e.getDragSource(), e.getX(), e.getY(), OBOTermPanel.this);
            int row = OBOTermPanel.this.getRowForLocation((int)p.getX(), (int)p.getY());
            OBOTermPanel.this.highlightDropTarget(row);
        }

        public boolean allowDrop(DragEvent e) {
            OBOTermPanel.this.currentDragEvent = e;
            Object data = e.getData();
            if (data != null) {
                Point p = SwingUtilities.convertPoint(e.getDragSource(), e.getX(), e.getY(), OBOTermPanel.this);
                TreePath dest = OBOTermPanel.this.getPath(p);
                OBOTermPanel dragComp = e.getDragSource() instanceof OBOTermPanel ? (OBOTermPanel)e.getDragSource() : null;
                Controller controller = Controller.getController();
                List l = controller.getInputHandlers();
                for (int i = 0; i < l.size(); ++i) {
                    InputHandlerI handler = (InputHandlerI)l.get(i);
                    int allowDropVal = handler.allowDrop(dragComp, OBOTermPanel.this, controller, e.getData(), dest, (MouseEvent)e, controller.getKeyRecorder().getKeyChecker());
                    if (allowDropVal != 1 && allowDropVal != 2) continue;
                    OBOTermPanel.this.currentDragHandler = handler;
                    return allowDropVal == 2;
                }
                return false;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
        }

        public void dragExit(DragEvent e) {
            OBOTermPanel.this.highlightDropTarget(-1);
        }
    }

    protected class OBODragListener
    implements DragListener {
        protected JTree tree;
        protected Font font = new Font("Arial", 1, 16);
        protected Image dragEnabledImage;
        protected Image dragDisabledImage;
        protected CellRendererPane rendererPane = new CellRendererPane();
        static final int HEADER_HEIGHT = 20;
        static final int HEADER_MARGIN = 2;
        protected Point offset = new Point(5, 20);

        public OBODragListener(JTree tree) {
            this.tree = tree;
            tree.add(this.rendererPane);
        }

        public boolean allowDrag(MouseEvent e) {
            int[] rows = this.tree.getSelectionRows();
            return rows != null && rows.length > 0;
        }

        protected void buildImageCache() {
            this.dragEnabledImage = this.getDragImage(this.tree.getSelectionRows());
            this.dragDisabledImage = new BufferedImage(this.dragEnabledImage.getWidth(null), this.dragEnabledImage.getHeight(null), 2);
            Graphics imageGraphics = this.dragDisabledImage.getGraphics();
            imageGraphics.drawImage(this.dragEnabledImage, 0, 0, null);
            imageGraphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            imageGraphics.fillRect(0, 0, this.dragDisabledImage.getWidth(null), this.dragDisabledImage.getHeight(null));
        }

        protected void clearImageCache() {
            this.dragEnabledImage = null;
            this.dragDisabledImage = null;
        }

        protected void paintHeaderShape(Graphics2D graphics, int width, int height) {
            graphics.fill(new CubicCurve2D.Double(0.0, height, 0.0, 0.0, 0.0, 0.0, height, 0.0));
            graphics.fill(new CubicCurve2D.Double(width - height, 0.0, width, 0.0, width, 0.0, width, height));
            Polygon finalArea = new Polygon();
            finalArea.addPoint(0, height);
            finalArea.addPoint(height, 0);
            finalArea.addPoint(width - height, 0);
            finalArea.addPoint(width, height);
            graphics.fill(finalArea);
        }

        public Point getDragOffset(DragEvent e, boolean drawImage) {
            return this.offset;
        }

        protected BufferedImage getDragImage(int[] row) {
            FontMetrics fm = OBOTermPanel.this.getFontMetrics(this.font);
            TreeCellRenderer rend = this.tree.getCellRenderer();
            int width = (int)fm.getStringBounds(OBOTermPanel.this.dragTitle, OBOTermPanel.this.getGraphics()).getWidth() + 20;
            int height = 0;
            for (int i = 0; i < row.length; ++i) {
                Component rendComponent = rend.getTreeCellRendererComponent(this.tree, this.tree.getPathForRow(row[i]).getLastPathComponent(), false, false, false, row[i], false);
                this.rendererPane.add(rendComponent);
                rendComponent.validate();
                Dimension dim = rendComponent.getPreferredSize();
                rendComponent.setVisible(true);
                width = (int)Math.max((double)width, dim.getWidth());
                height = (int)((double)height + dim.getHeight());
            }
            BufferedImage out = new BufferedImage(width, height += 20, 2);
            Graphics2D graphics = out.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(new Color(0, 0, 255, 80));
            graphics.setClip(0, 0, width, height);
            this.paintHeaderShape(graphics, width, 20);
            graphics.fillRect(0, 20, width, height - 20);
            graphics.setColor(Color.white);
            graphics.setFont(this.font);
            graphics.drawString(OBOTermPanel.this.dragTitle, 10, 20 - fm.getDescent() - 2);
            graphics.drawLine(0, 20, width, 20);
            for (int i = 0; i < row.length; ++i) {
                Component rendComponent = rend.getTreeCellRendererComponent(this.tree, this.tree.getPathForRow(row[i]).getLastPathComponent(), false, false, false, row[i], false);
                Dimension dim = rendComponent.getPreferredSize();
                this.rendererPane.paintComponent(graphics, rendComponent, this.tree, 0, 20 + i * dim.height, width, dim.height, true);
                if (i == row.length - 1) continue;
                graphics.setColor(new Color(0, 0, 255, 180));
                graphics.drawLine(0, 20 + (int)(dim.getHeight() * (double)(i + 1)), width, 20 + (int)(dim.getHeight() * (double)(i + 1)));
            }
            this.rendererPane.removeAll();
            return out;
        }

        public Image getDragImage(DragEvent e, boolean dropAllowed) {
            if (this.dragEnabledImage == null || this.dragDisabledImage == null) {
                this.buildImageCache();
            }
            if (dropAllowed) {
                return this.dragEnabledImage;
            }
            return this.dragDisabledImage;
        }

        public Cursor getDragCursor(DragEvent e, boolean dropAllowed) {
            return null;
        }

        public Object getDragData(MouseEvent e) {
            Controller controller = Controller.getController();
            controller.getKeyRecorder().setSmoothOutAutorepeat(true);
            controller.getKeyRecorder().addKeyListener(OBOTermPanel.this.draggingKeyListener);
            return this.tree.getSelectionPaths();
        }

        public void dragging(DragEvent e) {
            OBOTermPanel.this.dragging = true;
        }

        public void dragEnd(DragEvent e) {
            Controller controller = Controller.getController();
            controller.getKeyRecorder().removeKeyListener(OBOTermPanel.this.draggingKeyListener);
            controller.getKeyRecorder().setSmoothOutAutorepeat(false);
            this.clearImageCache();
            OBOTermPanel.this.dragging = false;
        }

        public void dropped(DragEvent e) {
            Controller controller = Controller.getController();
            controller.getKeyRecorder().removeKeyListener(OBOTermPanel.this.draggingKeyListener);
            controller.getKeyRecorder().setSmoothOutAutorepeat(false);
            this.clearImageCache();
            OBOTermPanel.this.dragging = false;
            OBOTermPanel.this.indicateClickTarget(-1);
        }
    }

    public static class OBOPanelConfiguration
    implements ComponentConfiguration {
        protected boolean primarySelector;
        protected boolean buttonsVisible = false;
        protected String filterPropID;
        protected String rootAlgorithm;
        protected FilterPair filter;

        public void setFilterPropID(String filterPropID) {
            this.filterPropID = filterPropID;
        }

        public String getFilterPropID() {
            return this.filterPropID;
        }

        public void setPrimarySelector(boolean primarySelector) {
            this.primarySelector = primarySelector;
        }

        public boolean getPrimarySelector() {
            return this.primarySelector;
        }

        public boolean getButtonsVisible() {
            return this.buttonsVisible;
        }

        public void setRootAlgorithm(String rootAlgorithm) {
            this.rootAlgorithm = rootAlgorithm;
        }

        public String getRootAlgorithm() {
            return this.rootAlgorithm;
        }

        public void setButtonsVisible(boolean buttonsVisible) {
            this.buttonsVisible = buttonsVisible;
        }

        public void setFilter(FilterPair filter) {
            this.filter = filter;
        }

        public FilterPair getFilter() {
            return this.filter;
        }
    }
}

