/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class MiniBrowser
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected Vector history;
    protected JEditorPane htmlPane;
    protected int historyPos;
    protected JPopupMenu rightClickMenu;
    protected JMenuItem backItem;
    protected JMenuItem forwardItem;
    protected JMenuItem reloadItem;
    protected JProgressBar statusField = new JProgressBar();
    protected HyperlinkListener linkListener = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        if (e.getURL() != null) {
                            MiniBrowser.this.load(e.getURL().toString());
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    };

    protected void formatRightClickMenu() {
        this.forwardItem.setEnabled(this.canForward());
        this.backItem.setEnabled(this.canBack());
        this.reloadItem.setEnabled(false);
    }

    protected void setString(final String val) {
        Runnable r = new Runnable(){

            public void run() {
                MiniBrowser.this.statusField.setString(val);
            }
        };
        try {
            SwingUtilities.invokeLater(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MiniBrowser(JFrame frame) {
        super(frame);
        this.statusField.setStringPainted(true);
        this.statusField.setBorderPainted(true);
        this.history = new Vector();
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this.linkListener);
        this.htmlPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    MiniBrowser.this.formatRightClickMenu();
                    MiniBrowser.this.rightClickMenu.show(MiniBrowser.this.htmlPane, e.getX(), e.getY());
                }
            }
        });
        this.htmlPane.setContentType("text/html");
        this.rightClickMenu = new JPopupMenu("Nav Menu");
        this.backItem = new JMenuItem("Back");
        this.forwardItem = new JMenuItem("Forward");
        this.reloadItem = new JMenuItem("Reload");
        this.rightClickMenu.add(this.backItem);
        this.rightClickMenu.add(this.forwardItem);
        this.rightClickMenu.addSeparator();
        this.rightClickMenu.add(this.reloadItem);
        this.backItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiniBrowser.this.back();
            }
        });
        this.forwardItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiniBrowser.this.forward();
            }
        });
        this.reloadItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiniBrowser.this.reload();
            }
        });
        this.historyPos = 0;
        JScrollPane scrollPane = new JScrollPane(this.htmlPane, 20, 30);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        this.setContentPane(panel);
    }

    public void setMenuFont(Font font) {
        this.rightClickMenu.setFont(font);
        this.forwardItem.setFont(font);
        this.backItem.setFont(font);
        this.reloadItem.setFont(font);
    }

    public void load(String url) {
        this.historyPos = this.history.size();
        this.history.add(url);
        try {
            this.htmlPane.setPage(url);
        }
        catch (Exception e) {
            System.err.println("could not load " + url);
        }
    }

    protected void loadAtPos() {
        String url = (String)this.history.get(this.historyPos);
        try {
            this.htmlPane.setPage(url);
            String title = (String)this.htmlPane.getDocument().getProperty("title");
            this.setTitle(title);
            this.htmlPane.validate();
        }
        catch (Exception e) {
            System.err.println("could not load " + url);
        }
    }

    public void reload() {
        this.htmlPane.updateUI();
    }

    public void back() {
        --this.historyPos;
        this.loadAtPos();
    }

    public boolean canForward() {
        return this.historyPos < this.history.size() - 1;
    }

    public boolean canBack() {
        return this.historyPos > 0;
    }

    public void forward() {
        ++this.historyPos;
        this.loadAtPos();
    }
}

