/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;

public class IDEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected JTextField idLabel = new JTextField();
    protected JTextField secondaryIDLabel = new JTextField();
    protected Component secondaryIDComponent;
    protected Container parentContainer;
    protected int secondaryComponentIndex = -1;
    protected boolean secondariesVisible = true;

    public Component resolveName(String id, Properties props, String xml) {
        System.err.println("calling resolveName " + id);
        if (id.equals("id_label")) {
            return this.idLabel;
        }
        if (id.equals("secondary_id_label")) {
            return this.secondaryIDLabel;
        }
        return new JButton("id");
    }

    public IDEditorComponent() {
        this.idLabel.setEditable(false);
        this.idLabel.setBorder(null);
        this.idLabel.setOpaque(false);
        this.secondaryIDLabel.setEditable(false);
        this.secondaryIDLabel.setBorder(null);
        this.secondaryIDLabel.setOpaque(false);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<box orientation='vert'><box orientation='HORZ'><label text='PEID'/><spacer orientation='horz' size='10'/><component id='id_label'/></box><box orientation='HORZ' name='secondary_ids'><label text='Secondary IDs'/><spacer orientation='horz' size='10'/><component id='secondary_id_label'/></box></box>";
    }

    public boolean isSingleton() {
        return false;
    }

    protected void loadGUI() {
        if (this.currentObject != null) {
            this.idLabel.setEnabled(true);
            this.idLabel.setText(this.currentObject.getID());
            this.secondaryIDLabel.setEnabled(true);
            if (this.currentObject instanceof MultiIDObject) {
                ArrayList list = new ArrayList();
                list.addAll(((MultiIDObject)this.currentObject).getSecondaryIDs());
                this.setSecondariesVisible(list.size() > 0);
                Collections.sort(list);
                StringBuffer sb = new StringBuffer();
                Iterator it = list.iterator();
                int i = 0;
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(s);
                    ++i;
                }
                this.secondaryIDLabel.setText(sb.toString());
                this.secondaryIDLabel.repaint();
            }
        } else {
            this.idLabel.setEnabled(false);
            this.idLabel.setText("<no selection>");
            this.secondaryIDLabel.setEnabled(false);
            this.secondaryIDLabel.setText("<no selection>");
        }
    }

    protected void setSecondariesVisible(boolean visible) {
        if (this.secondariesVisible != visible && this.secondaryIDComponent != null && this.parentContainer != null && this.secondaryComponentIndex >= 0) {
            if (visible) {
                this.parentContainer.add(this.secondaryIDComponent, this.secondaryComponentIndex);
            } else {
                this.parentContainer.remove(this.secondaryIDComponent);
            }
            this.validateTree();
            this.repaint();
            this.secondariesVisible = visible;
        }
    }

    protected void initializeGUI() {
        Font font = Controller.getController().getDefaultFont();
        this.idLabel.setFont(font);
        this.secondaryIDLabel.setFont(font);
        this.idLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.idLabel.getPreferredSize().getHeight()));
        this.secondaryIDLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.secondaryIDLabel.getPreferredSize().getHeight()));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.getPreferredSize().getHeight()));
    }

    public String getID() {
        return "ID_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
    }

    public List getChanges() {
        return Collections.EMPTY_LIST;
    }
}

