/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geneontology.oboedit.datamodel.DatatypeValue;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.ValueLink;
import org.geneontology.util.ObjectUtil;

public class DeletePropertyValueHistoryItem
extends HistoryItem {
    private static final long serialVersionUID = 5400055973408890140L;
    protected String propertyID;
    protected String datatypeID;
    protected String value;

    public DeletePropertyValueHistoryItem(ValueLink ipv) {
        this.setTarget(ipv.getChild().getID());
        this.propertyID = ipv.getType().getID();
        if (ipv.getValue() instanceof DatatypeValue) {
            DatatypeValue dv = (DatatypeValue)ipv.getValue();
            this.value = dv.getValue();
            this.datatypeID = dv.getType().getID();
        } else {
            this.value = ((IdentifiedObject)ipv.getValue()).getID();
        }
    }

    public DeletePropertyValueHistoryItem(String targetID, String propertyID, String datatypeID, String value) {
        this.setTarget(targetID);
        this.propertyID = propertyID;
        this.datatypeID = datatypeID;
        this.value = value;
    }

    public String getPropertyID() {
        return this.propertyID;
    }

    public String getDatatypeID() {
        return this.datatypeID;
    }

    public String getValue() {
        return this.value;
    }

    public List getGraphEditList() {
        return Collections.singletonList(new HistoryItem.GraphOperation(0));
    }

    public String getShortName() {
        return "add property value";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletePropertyValueHistoryItem)) {
            return false;
        }
        DeletePropertyValueHistoryItem item = (DeletePropertyValueHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.propertyID, (Object)item.getPropertyID()) && ObjectUtil.equals((Object)this.datatypeID, (Object)item.getDatatypeID()) && ObjectUtil.equals((Object)this.value, (Object)item.getValue());
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

