/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.dataadapter.IDGenerator;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.DatatypeValue;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IDRule;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Impliable;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MutableLinkDatabase;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.PathCapable;
import org.geneontology.oboedit.datamodel.PathThread;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.Value;
import org.geneontology.oboedit.datamodel.history.DestroyObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.SecondaryIDHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.ObjectSelector;
import org.geneontology.util.ObjectUtil;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;
import org.geneontology.util.VectorFilter;

public class TermUtil {
    public static final String LOOSE = "LOOSE";
    public static final String STRICT = "STRICT";
    public static final String FEWEST_PATHS = "FEWEST_PATHS";
    public static final String[] FILTER_METHODS = new String[]{"LOOSE", "STRICT", "FEWEST_PATHS"};
    protected static int MAX_SETS = 5;
    protected static int MAX_MAPS = 5;
    protected static int MAX_LISTS = 5;
    protected static Set allocatedSets = new HashSet();
    protected static LinkedList freeSets = new LinkedList();
    protected static int highestSetUse = 0;
    protected static Set allocatedLists = new HashSet();
    protected static LinkedList freeLists = new LinkedList();
    protected static int highestListUse = 0;
    protected static int highestMapUse = 0;
    protected static Set freeMaps = new HashSet(MAX_MAPS);
    protected static Set allocatedMaps = new HashSet();
    protected static DescendantThread descendantThread = new DescendantThread();
    public static long clearTime = 0L;
    protected static final Comparator linkRatingComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Link l1 = (Link)o1;
            Link l2 = (Link)o2;
            return TermUtil.getLinkRating(l1) - TermUtil.getLinkRating(l2);
        }
    };
    public static long shouldBeTrimmedTime = 0L;
    protected static StringWriter writer = new StringWriter();
    protected static PrintWriter pw = new PrintWriter(writer);
    protected static Exception ex = new Exception();
    static int pass = 0;
    public static boolean ignoreChildren = false;

    public static String doReplacement(String template, JexlContext valueGenerator) {
        StringBuffer out = new StringBuffer();
        List list = TermUtil.parseVarString(template);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                out.append((String)o);
                continue;
            }
            if (!(o instanceof Variable)) continue;
            Variable v = (Variable)o;
            out.append(valueGenerator.getValue(v));
        }
        return out.toString();
    }

    public static List parseVarString(String s) {
        LinkedList<Object> out = new LinkedList<Object>();
        if (s == null) {
            return out;
        }
        StringBuffer buffer = new StringBuffer();
        boolean inVar = false;
        boolean inParens = false;
        boolean inQuotes = false;
        Variable currentVariable = null;
        for (int i = 0; i < s.length(); ++i) {
            if (!inParens && s.charAt(i) == '$') {
                if (inVar) {
                    if (currentVariable == null) {
                        currentVariable = new Variable(buffer.toString());
                    }
                    out.add(currentVariable);
                    inVar = false;
                    inParens = false;
                    currentVariable = null;
                } else {
                    out.add(buffer.toString());
                    inVar = true;
                    inParens = false;
                }
                buffer = new StringBuffer();
                continue;
            }
            if (inVar && !inParens && s.charAt(i) == '(') {
                currentVariable = new Variable(buffer.toString());
                buffer = new StringBuffer();
                inParens = true;
                continue;
            }
            if (inVar && inParens && s.charAt(i) == ')') {
                currentVariable.addParam(buffer.toString().trim());
                buffer = new StringBuffer();
                inParens = false;
                continue;
            }
            if (inVar && inParens && s.charAt(i) == ',') {
                currentVariable.addParam(buffer.toString().trim());
                buffer = new StringBuffer();
                continue;
            }
            if (s.charAt(i) == '\\') {
                if (i + 1 >= s.length() || s.charAt(i + 1) != '$' && s.charAt(i + 1) != ')' && s.charAt(i + 1) != '(' && s.charAt(i + 1) != ',') continue;
                ++i;
                buffer.append('$');
                continue;
            }
            buffer.append(s.charAt(i));
        }
        if (inVar || inParens || inQuotes || currentVariable != null) {
            return null;
        }
        if (buffer.length() > 0) {
            out.add(buffer.toString());
        }
        return out;
    }

    public static synchronized List mallocList() {
        List out;
        if (freeLists.size() > 0) {
            Iterator it = freeLists.iterator();
            out = (List)it.next();
            it.remove();
        } else {
            out = new TrackedList();
            allocatedLists.add(out);
            if (allocatedLists.size() > highestListUse) {
                highestListUse = allocatedLists.size();
            }
        }
        return out;
    }

    public static synchronized void freeList(List list) {
        if (!allocatedLists.contains(list)) {
            throw new IllegalArgumentException("Tried to free non-allocated list");
        }
        list.clear();
        if (freeLists.size() < MAX_LISTS) {
            freeLists.add(list);
        } else {
            allocatedLists.remove(list);
        }
    }

    public static synchronized Set mallocSet() {
        Set out;
        if (freeSets.size() > 0) {
            out = (Set)freeSets.removeFirst();
            long time = System.currentTimeMillis();
            out.clear();
            clearTime += System.currentTimeMillis() - time;
        } else {
            out = new TrackedSet();
            allocatedSets.add(out);
            if (allocatedSets.size() > highestSetUse) {
                highestSetUse = allocatedSets.size();
            }
        }
        return out;
    }

    public static synchronized void freeSet(Set s) {
        if (!allocatedSets.contains(s)) {
            throw new IllegalArgumentException("Tried to free non-allocated set");
        }
        s.clear();
        if (freeSets.size() < MAX_SETS) {
            freeSets.addLast(s);
        } else {
            allocatedSets.remove(s);
        }
    }

    public static synchronized Map mallocMap() {
        Map out;
        if (freeMaps.size() > 0) {
            Iterator it = freeMaps.iterator();
            out = (Map)it.next();
            it.remove();
        } else {
            out = new TrackedMap();
            allocatedMaps.add(out);
            if (allocatedMaps.size() > highestMapUse) {
                highestMapUse = allocatedMaps.size();
            }
        }
        return out;
    }

    public static synchronized void freeMap(Map m) {
        if (!allocatedMaps.contains(m)) {
            throw new IllegalArgumentException("Tried to free non-allocated map");
        }
        m.clear();
        if (freeMaps.size() < MAX_MAPS) {
            freeMaps.add(m);
        } else {
            allocatedMaps.remove(m);
        }
    }

    public static Collection getAllDbxrefs(IdentifiedObject io) {
        LinkedList out = new LinkedList();
        if (io instanceof DbxrefedObject) {
            out.addAll(((DbxrefedObject)io).getDbxrefs());
        }
        if (io instanceof DefinedObject) {
            out.addAll(((DefinedObject)io).getDefDbxrefs());
        }
        if (io instanceof SynonymedObject) {
            Iterator it = ((SynonymedObject)io).getSynonyms().iterator();
            while (it.hasNext()) {
                Synonym s = (Synonym)it.next();
                out.addAll(s.getDbxrefs());
            }
        }
        return out;
    }

    public static boolean containsLink(LinkDatabase linkDatabase, Link link) {
        Iterator it = linkDatabase.getParents(link.getChild()).iterator();
        while (it.hasNext()) {
            Link parentLink = (Link)it.next();
            if (!parentLink.getParent().equals(link.getParent()) || !parentLink.getType().equals(link.getType())) continue;
            return true;
        }
        return false;
    }

    public static TreePath[] getPaths(Collection items, ObjectSelector displayer, boolean shortestPathOnly) {
        if (displayer == null) {
            return TermUtil.getPaths(items, RootAlgorithm.GREEDY, DefaultLinkDatabase.getDefault(), shortestPathOnly);
        }
        return TermUtil.getPaths(items, displayer.getRootAlgorithm(), displayer.getLinkDatabase(), shortestPathOnly);
    }

    public static LinkedObject getRoot(LinkedObject obj) {
        return TermUtil.getRoot(obj, DefaultLinkDatabase.getDefault(), RootAlgorithm.GREEDY);
    }

    public static LinkedObject getRoot(LinkedObject obj, LinkDatabase linkDatabase, RootAlgorithm rootAlgorithm) {
        rootAlgorithm.setLinkDatabase(linkDatabase);
        if (rootAlgorithm.isRoot(obj)) {
            return obj;
        }
        Iterator it = linkDatabase.getParents(obj).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            Link parent = (Link)o;
            LinkedObject root = TermUtil.getRoot(parent.getParent(), linkDatabase, rootAlgorithm);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    public static TreePath[] getPaths(Collection items, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, boolean shortestPathOnly) {
        if (items == null) {
            return new TreePath[0];
        }
        HashSet<TreePath> pathVector = new HashSet<TreePath>();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            PathCapable lo = (PathCapable)it.next();
            if (shortestPathOnly) {
                TreePath path = TermUtil.getShortestPath(lo, rootAlgorithm, linkDatabase);
                pathVector.add(path);
                continue;
            }
            pathVector.addAll(TermUtil.getPathsAsVector(lo, rootAlgorithm, linkDatabase));
        }
        TreePath[] selectPaths = new TreePath[pathVector.size()];
        it = pathVector.iterator();
        int i = 0;
        while (it.hasNext()) {
            selectPaths[i] = (TreePath)it.next();
            ++i;
        }
        return selectPaths;
    }

    public static void finalMemoryReport() {
        Cloneable m;
        allocatedMaps.removeAll(freeMaps);
        allocatedSets.removeAll(freeSets);
        allocatedLists.removeAll(freeLists);
        Iterator it = allocatedMaps.iterator();
        System.err.println(allocatedMaps.size() + " maps still in use:");
        while (it.hasNext()) {
            m = (TrackedMap)it.next();
            System.err.println("map " + ((TrackedMap)m).id);
            ((TrackedMap)m).getInstantiationInfo().printStackTrace();
        }
        System.err.println("Peak map use: " + highestMapUse);
        it = allocatedSets.iterator();
        System.err.println(allocatedSets.size() + " sets still in use:");
        while (it.hasNext()) {
            m = (TrackedSet)it.next();
            System.err.println("set " + ((TrackedSet)m).id);
            ((TrackedSet)m).getInstantiationInfo().printStackTrace();
        }
        System.err.println("Peak set use: " + highestSetUse);
        it = allocatedLists.iterator();
        System.err.println(allocatedLists.size() + " lists still in use:");
        for (int i = 0; it.hasNext() && i < 5; ++i) {
            TrackedList m2 = (TrackedList)it.next();
            System.err.println("list " + m2.id);
            m2.getInstantiationInfo().printStackTrace();
            m2.getUseInfo().printStackTrace();
        }
        System.err.println("Peak list use: " + highestListUse);
    }

    public static boolean pathIsValid(TreePath current, TreeModel model) {
        Object[] objects = current.getPath();
        Object previous = objects[0];
        for (int j = 1; j < objects.length; ++j) {
            int count = model.getChildCount(previous);
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Object child = model.getChild(previous, i);
                if (!child.equals(objects[j])) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            previous = objects[j];
        }
        return true;
    }

    public static boolean linkExists(Link tr, TreeModel model) {
        OBORestrictionImpl dummy = new OBORestrictionImpl(tr.getParent());
        int c = model.getChildCount(dummy);
        for (int i = 0; i < c; ++i) {
            Link link = (Link)model.getChild(dummy, i);
            if (!link.equals(tr)) continue;
            return true;
        }
        return false;
    }

    public static TreePath[] getPaths(IdentifiedObject io) {
        return TermUtil.getPaths(io, RootAlgorithm.GREEDY, DefaultLinkDatabase.getDefault());
    }

    public static TreePath[] getPaths(LinkedObject term) {
        return TermUtil.getPaths(term, RootAlgorithm.GREEDY, DefaultLinkDatabase.getDefault());
    }

    public static TreePath[] getPaths(Link link) {
        return TermUtil.getPaths(link, RootAlgorithm.GREEDY, DefaultLinkDatabase.getDefault());
    }

    public static List getPathsAsVector(Link link) {
        return TermUtil.getPathsAsVector(link, RootAlgorithm.GREEDY, DefaultLinkDatabase.getDefault());
    }

    public static List getPathsAsVector(LinkedObject term) {
        return TermUtil.getPathsAsVector(term, RootAlgorithm.GREEDY, DefaultLinkDatabase.getDefault());
    }

    public static TreePath[] getPaths(IdentifiedObject io, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        if (io instanceof LinkedObject) {
            return TermUtil.getPaths((LinkedObject)io, rootAlgorithm, linkDatabase);
        }
        return new TreePath[0];
    }

    public static int getParentCount(LinkDatabase linkDatabase, LinkedObject lo) {
        return linkDatabase.getParents(lo).size();
    }

    public static int getChildCount(LinkDatabase linkDatabase, LinkedObject lo) {
        return linkDatabase.getChildren(lo).size();
    }

    public static int getObjectCount(LinkDatabase linkDatabase) {
        return linkDatabase.getObjects().size();
    }

    public static boolean usesType(LinkedObject lo, OBOProperty prop) {
        Iterator it = lo.getParents().iterator();
        while (it.hasNext()) {
            Link l = (Link)it.next();
            if (!l.getType().equals(prop)) continue;
            return true;
        }
        return false;
    }

    public static TreePath[] getPaths(LinkedObject term, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        List v = TermUtil.getPathsAsVector(term, rootAlgorithm, linkDatabase);
        Iterator it = v.iterator();
        TreePath[] out = new TreePath[v.size()];
        int i = 0;
        while (it.hasNext()) {
            out[i] = (TreePath)it.next();
            ++i;
        }
        return out;
    }

    public static TreePath[] getPaths(Link link, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        List paths = TermUtil.getPathsAsVector(link, rootAlgorithm, linkDatabase);
        TreePath[] out = new TreePath[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            out[i] = (TreePath)paths.get(i);
        }
        return out;
    }

    public static List getPathsAsVector(Link link, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, int nBest) {
        Map lookedAt = TermUtil.mallocMap();
        Vector out = TermUtil.getPathsAsVector(link, rootAlgorithm, linkDatabase, lookedAt, nBest);
        TermUtil.freeMap(lookedAt);
        return out;
    }

    protected static int getLinkRating(Link link) {
        if (link.getType() == null) {
            return 1;
        }
        if (link.getType().equals(OBOProperty.IS_A)) {
            if (TermUtil.isImplied(link)) {
                return 2;
            }
            return 1;
        }
        if (link.getType().isTransitive()) {
            if (TermUtil.isImplied(link)) {
                return 4;
            }
            return 3;
        }
        return 10;
    }

    protected static int getPathRating(TreePath path) {
        int rating = 0;
        Object[] objs = path.getPath();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof Link)) continue;
            Link link = (Link)objs[i];
            rating += TermUtil.getLinkRating(link);
        }
        return rating;
    }

    public static TreePath[] getBestPaths(Collection c, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        LinkedList<TreePath> out = new LinkedList<TreePath>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            PathCapable pc = (PathCapable)it.next();
            TreePath best = TermUtil.getBestPath(pc, rootAlgorithm, linkDatabase);
            if (best == null) continue;
            out.add(best);
        }
        TreePath[] paths = new TreePath[out.size()];
        it = out.iterator();
        int i = 0;
        while (it.hasNext()) {
            paths[i] = (TreePath)it.next();
            ++i;
        }
        return paths;
    }

    public static TreePath getBestPath(PathCapable lo, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        List v = TermUtil.getPathsAsVector(lo, rootAlgorithm, linkDatabase, 2);
        TreePath bestPath = null;
        int minRating = Integer.MAX_VALUE;
        Iterator it = v.iterator();
        while (it.hasNext()) {
            TreePath path = (TreePath)it.next();
            int rating = TermUtil.getPathRating(path);
            if (rating >= minRating) continue;
            bestPath = path;
            minRating = rating;
        }
        return bestPath;
    }

    public static TreePath getShortestPath(LinkedObject lo, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        if (TermUtil.isDangling(lo)) {
            return null;
        }
        rootAlgorithm.setLinkDatabase(linkDatabase);
        if (rootAlgorithm.isRoot(lo)) {
            Object[] os = new Object[3];
            os[0] = OBOSession.ROOT;
            if (TermUtil.isObsolete(lo)) {
                os[1] = OBOSession.OBSOLETE;
            } else if (TermUtil.isProperty(lo)) {
                os[1] = OBOSession.TYPES;
            } else if (TermUtil.isClass(lo)) {
                os[1] = OBOSession.CLASSES;
            } else if (TermUtil.isInstance(lo)) {
                os[1] = OBOSession.INSTANCES;
            } else {
                throw new RuntimeException("Could not determine type of object " + lo + ", class = " + lo.getClass());
            }
            os[2] = new OBORestrictionImpl(lo);
            TreePath path = new TreePath(os);
            return path;
        }
        if (lo.getParents().size() == 0 && !rootAlgorithm.isRoot(lo)) {
            return null;
        }
        Map lookedAt = TermUtil.mallocMap();
        Iterator it = linkDatabase.getParents(lo).iterator();
        TreePath shortest = null;
        while (it.hasNext()) {
            Link parent = (Link)it.next();
            TreePath path = TermUtil.getShortestPath(parent, rootAlgorithm, linkDatabase, lookedAt, null, 0);
            if (path == null) continue;
            if (shortest == null) {
                shortest = path;
                continue;
            }
            if (path.getPathCount() < shortest.getPathCount()) {
                shortest = path;
            }
            if (shortest.getPathCount() > 3) continue;
            break;
        }
        TermUtil.freeMap(lookedAt);
        return shortest;
    }

    public static List getPathsAsVector(PathCapable pc, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        return TermUtil.getPathsAsVector(pc, rootAlgorithm, linkDatabase, -1);
    }

    public static List getPathsAsVector(PathCapable pc, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, int nBest) {
        if (pc instanceof Link) {
            return TermUtil.getPathsAsVector((Link)pc, rootAlgorithm, linkDatabase, nBest);
        }
        if (pc instanceof LinkedObject) {
            return TermUtil.getPathsAsVector((LinkedObject)pc, rootAlgorithm, linkDatabase, nBest);
        }
        throw new IllegalArgumentException();
    }

    public static TreePath getShortestPath(PathCapable pc, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        if (pc instanceof Link) {
            return TermUtil.getShortestPath((Link)pc, rootAlgorithm, linkDatabase);
        }
        if (pc instanceof LinkedObject) {
            return TermUtil.getShortestPath((LinkedObject)pc, rootAlgorithm, linkDatabase);
        }
        throw new IllegalArgumentException();
    }

    public static TreePath getShortestPath(Link link, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        Map map = TermUtil.mallocMap();
        TreePath out = TermUtil.getShortestPath(link, rootAlgorithm, linkDatabase, map, null, 0);
        TermUtil.freeMap(map);
        return out;
    }

    public static TreePath getShortestPath(Link link, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, Map lookedAt, TreePath best, int currentDepth) {
        Link parentRel;
        TreePath parentPath;
        if (lookedAt.containsKey(link)) {
            return (TreePath)lookedAt.get(link);
        }
        rootAlgorithm.setLinkDatabase(linkDatabase);
        if (link.getParent() == null) {
            Object[] os = new Object[3];
            os[0] = OBOSession.ROOT;
            if (TermUtil.isObsolete(link.getChild())) {
                os[1] = OBOSession.OBSOLETE;
            } else if (TermUtil.isProperty(link.getChild())) {
                os[1] = OBOSession.TYPES;
            } else if (TermUtil.isClass(link.getChild())) {
                os[1] = OBOSession.CLASSES;
            } else if (TermUtil.isInstance(link.getChild())) {
                os[1] = OBOSession.INSTANCES;
            } else {
                throw new RuntimeException("Could not determine type of link child " + link.getChild() + ", class = " + link.getChild().getClass());
            }
            os[2] = link;
            TreePath out = new TreePath(os);
            lookedAt.put(link, out);
            return out;
        }
        if (rootAlgorithm.isRoot(link.getParent())) {
            TreePath shortest = TermUtil.getShortestPath(link.getParent(), rootAlgorithm, linkDatabase);
            if (shortest == null) {
                return null;
            }
            TreePath path = shortest.pathByAddingChild(link);
            lookedAt.put(link, path);
            return path;
        }
        if (best != null && currentDepth + 4 >= best.getPathCount()) {
            lookedAt.put(link, best);
            return best;
        }
        rootAlgorithm.setLinkDatabase(linkDatabase);
        TreePath shortestPath = null;
        Iterator it = linkDatabase.getParents(link.getParent()).iterator();
        while (it.hasNext() && ((parentPath = TermUtil.getShortestPath(parentRel = (Link)it.next(), rootAlgorithm, linkDatabase, lookedAt, shortestPath, currentDepth + 1)) == null || shortestPath != null && parentPath.getPathCount() + 1 >= shortestPath.getPathCount() || (shortestPath = parentPath.pathByAddingChild(link)).getPathCount() > 4)) {
        }
        lookedAt.put(link, shortestPath);
        return shortestPath;
    }

    protected static Vector getPathsAsVector(Link link, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, Map lookedAt, int nBest) {
        Collection parents;
        Vector out = new Vector();
        if (lookedAt.containsKey(link)) {
            out = (Vector)lookedAt.get(link);
            return (Vector)out.clone();
        }
        lookedAt.put(link, out);
        if (link.getParent() == null) {
            Object[] os = new Object[]{OBOSession.ROOT, TermUtil.isObsolete(link.getChild()) ? OBOSession.OBSOLETE : (TermUtil.isProperty(link.getChild()) ? OBOSession.TYPES : (TermUtil.isClass(link.getChild()) ? OBOSession.CLASSES : OBOSession.INSTANCES)), link};
            out.add(new TreePath(os));
            return out;
        }
        rootAlgorithm.setLinkDatabase(linkDatabase);
        if (rootAlgorithm.isRoot(link.getParent())) {
            List v = TermUtil.getPathsAsVector(link.getParent(), rootAlgorithm, linkDatabase);
            Iterator it = v.iterator();
            while (it.hasNext()) {
                TreePath path = ((TreePath)it.next()).pathByAddingChild(link);
                out.add(path);
            }
            return out;
        }
        if (nBest < 0) {
            parents = linkDatabase.getParents(link.getParent());
        } else {
            parents = new ArrayList();
            parents.addAll(linkDatabase.getParents(link.getParent()));
            Collections.sort((List)parents, linkRatingComparator);
            int count = parents.size() - nBest;
            for (int i = 0; i < count; ++i) {
                ((List)parents).remove(parents.size() - 1);
            }
            System.err.println("     trimmed parents of " + link + " = " + parents);
        }
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            Link parentRel = (Link)it.next();
            Vector parentVector = TermUtil.getPathsAsVector(parentRel, rootAlgorithm, linkDatabase, lookedAt, nBest);
            for (int j = 0; j < parentVector.size(); ++j) {
                TreePath path = (TreePath)parentVector.get(j);
                TreePath pathByAddingChild = path.pathByAddingChild(link);
                if (out.contains(pathByAddingChild)) continue;
                out.add(pathByAddingChild);
            }
        }
        return out;
    }

    public static Vector getPathsAsVector(LinkedObject term, RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, int nBest) {
        Vector<TreePath> out = new Vector<TreePath>();
        rootAlgorithm.setLinkDatabase(linkDatabase);
        if (rootAlgorithm.isRoot(term)) {
            Object[] os = new Object[]{OBOSession.ROOT, TermUtil.isObsolete(term) ? OBOSession.OBSOLETE : (TermUtil.isProperty(term) ? OBOSession.TYPES : (TermUtil.isClass(term) ? OBOSession.CLASSES : OBOSession.INSTANCES)), new OBORestrictionImpl(term)};
            out.add(new TreePath(os));
        } else {
            ArrayList parents;
            if (nBest < 0) {
                parents = linkDatabase.getParents(term);
            } else {
                parents = new ArrayList();
                parents.addAll(linkDatabase.getParents(term));
                Collections.sort(parents, linkRatingComparator);
                int count = parents.size() - nBest;
                for (int i = 0; i < count; ++i) {
                    ((List)parents).remove(parents.size() - 1);
                }
            }
            Iterator it = parents.iterator();
            while (it.hasNext()) {
                Link tr = (Link)it.next();
                List paths = TermUtil.getPathsAsVector(tr, rootAlgorithm, linkDatabase, nBest);
                for (int j = 0; j < paths.size(); ++j) {
                    TreePath path = (TreePath)paths.get(j);
                    if (out.contains(path)) continue;
                    out.add(path);
                }
            }
        }
        return out;
    }

    public static PathThread getPathThread(LinkedObject term, LinkDatabase linkDatabase) {
        PathThread thread = new PathThread();
        thread.setVector(new Vector());
        thread.setTerm(term);
        thread.setLinkDatabase(linkDatabase);
        return thread;
    }

    public static PathThread getPathThread(LinkedObject term) {
        PathThread thread = new PathThread();
        thread.setVector(new Vector());
        thread.setTerm(term);
        return thread;
    }

    public static Vector getDepthFirstDescendants(Vector roots, Comparator siblingComparator, boolean unique) {
        return TermUtil.getDepthFirstDescendants(new Vector(), roots, siblingComparator, unique);
    }

    public static Vector getDepthFirstDescendants(Vector out, Vector roots, Comparator siblingComparator, boolean unique) {
        TermUtil.fillDepthFirst(out, roots, siblingComparator, unique);
        return out;
    }

    protected static void fillDepthFirst(Vector out, Vector roots, Comparator siblingComparator, boolean unique) {
        Collections.sort(roots, siblingComparator);
        for (int i = 0; i < roots.size(); ++i) {
            LinkedObject t = null;
            t = roots.get(i) instanceof LinkedObject ? (LinkedObject)roots.get(i) : ((Link)roots.get(i)).getChild();
            if (!unique || !out.contains(t)) {
                out.add(t);
            }
            Vector children = new Vector();
            children.addAll(t.getChildren());
            TermUtil.fillDepthFirst(out, children, siblingComparator, unique);
        }
    }

    public static void detectRoots(Set outSet, LinkDatabase linkDatabase, RootAlgorithm rootAlgorithm) {
        TermUtil.detectRoots(outSet, linkDatabase, linkDatabase.getObjects(), rootAlgorithm);
    }

    public static void detectRoots(Set outSet, LinkDatabase linkDatabase, Collection objects, RootAlgorithm algorithm) {
        algorithm.setLinkDatabase(linkDatabase);
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            LinkedObject lo;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject) || !algorithm.isRoot(lo = (LinkedObject)io)) continue;
            outSet.add(io);
        }
    }

    public static boolean generateTransitiveImplication(ReasonedLinkDatabase reasoner, OBORestriction out, Link link, Link gpLink) {
        if (gpLink.getType().isNonInheritable() || link.getType().isNonInheritable()) {
            return false;
        }
        if (!link.getParent().equals(gpLink.getChild())) {
            throw new RuntimeException("link and gpLink don't fit!");
        }
        if (reasoner.isSubProperty(link.getType(), OBOProperty.IS_A)) {
            out.setChild(link.getChild());
            out.setType(gpLink.getType());
            out.setParent(gpLink.getParent());
            return true;
        }
        if (reasoner.isSubProperty(gpLink.getType(), OBOProperty.IS_A)) {
            out.setChild(link.getChild());
            out.setType(link.getType());
            out.setParent(gpLink.getParent());
            return true;
        }
        if (link.getType().isTransitive() && gpLink.getType().isTransitive()) {
            if (reasoner.isSubProperty(link.getType(), gpLink.getType())) {
                out.setChild(link.getChild());
                out.setType(gpLink.getType());
                out.setParent(gpLink.getParent());
                return true;
            }
            if (reasoner.isSubProperty(gpLink.getType(), link.getType())) {
                out.setChild(link.getChild());
                out.setType(link.getType());
                out.setParent(gpLink.getParent());
                return true;
            }
        }
        return false;
    }

    public static boolean shouldBeTrimmed(LinkDatabase linkDatabase, Link link) {
        long time = System.currentTimeMillis();
        Iterator it = linkDatabase.getParents(link.getChild()).iterator();
        while (it.hasNext()) {
            Link parentLink = (Link)it.next();
            if (parentLink.equals(link) || !parentLink.getType().equals(link.getType()) && !parentLink.getType().equals(OBOProperty.IS_A)) continue;
            boolean sawType = parentLink.getType().equals(link.getType());
            Iterator it2 = linkDatabase.getParents(parentLink.getParent()).iterator();
            while (it2.hasNext()) {
                Link gpLink = (Link)it2.next();
                if ((sawType && !link.getType().isTransitive() || !link.getType().equals(gpLink.getType())) && (!sawType || !gpLink.getType().equals(OBOProperty.IS_A)) || !link.getParent().equals(gpLink.getParent())) continue;
                shouldBeTrimmedTime += System.currentTimeMillis() - time;
                return true;
            }
        }
        shouldBeTrimmedTime += System.currentTimeMillis() - time;
        return false;
    }

    public static Set getAncestors(LinkedObject term) {
        return TermUtil.getAncestors(term, false);
    }

    public static Set getAncestors(LinkedObject term, boolean includeSelf) {
        return TermUtil.getAncestors(term, null, includeSelf);
    }

    public static Set getAncestors(LinkedObject term, LinkDatabase linkDatabase, boolean includeSelf) {
        HashSet<LinkedObject> out = new HashSet<LinkedObject>();
        Map scratchMap = TermUtil.mallocMap();
        AncestorThread thread = TermUtil.getAncestors(term, linkDatabase, out, scratchMap);
        thread.run();
        if (includeSelf) {
            out.add(term);
        }
        TermUtil.freeMap(scratchMap);
        return out;
    }

    public static AncestorThread getAncestors(LinkedObject term, Set out, Map memoizeTable) {
        return TermUtil.getAncestors(term, null, out, memoizeTable);
    }

    public static AncestorThread getAncestors(LinkedObject term, LinkDatabase linkDatabase, Set out, Map memoizeTable) {
        AncestorThread thread = new AncestorThread();
        thread.setTerm(term);
        thread.setMemoizeTable(memoizeTable);
        thread.setSet(out);
        thread.setLinkDatabase(linkDatabase);
        return thread;
    }

    public static boolean hasAncestor(LinkedObject child, LinkedObject ancestor) {
        Set scratchSet = TermUtil.mallocSet();
        boolean out = TermUtil.hasAncestor(child, ancestor, scratchSet);
        TermUtil.freeSet(scratchSet);
        return out;
    }

    protected static boolean hasAncestor(LinkedObject child, LinkedObject ancestor, Set lookedAt) {
        if (lookedAt.contains(child)) {
            return false;
        }
        lookedAt.add(child);
        Iterator it = child.getParents().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            if (tr.getParent().equals(ancestor)) {
                return true;
            }
            if (!TermUtil.hasAncestor(tr.getParent(), ancestor, lookedAt)) continue;
            return true;
        }
        return false;
    }

    public static Set getDescendants(LinkedObject term) {
        return TermUtil.getDescendants(term, false);
    }

    public static Set getDescendants(LinkedObject term, boolean includeSelf) {
        return TermUtil.getDescendants(term, null, includeSelf);
    }

    public static Set getDescendants(LinkedObject term, LinkDatabase linkDatabase, boolean includeSelf) {
        HashSet<LinkedObject> out = new HashSet<LinkedObject>();
        Map scratchMap = TermUtil.mallocMap();
        DescendantThread thread = TermUtil.getDescendants(term, out, scratchMap, linkDatabase, descendantThread);
        thread.run();
        if (includeSelf) {
            out.add(term);
        }
        TermUtil.freeMap(scratchMap);
        return out;
    }

    public static Map getMap(Set set) {
        HashMap out = new HashMap();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IdentifiedObject)) continue;
            out.put(((IdentifiedObject)o).getID(), o);
        }
        return out;
    }

    public static boolean isDescendant(LinkedObject parent, LinkedObject desc) {
        Map scratchMap = TermUtil.mallocMap();
        Set scratchSet = TermUtil.mallocSet();
        DescendantThread thread = TermUtil.getDescendants(parent, scratchSet, scratchMap, descendantThread);
        thread.run();
        boolean isDescendant = scratchSet.contains(desc);
        TermUtil.freeMap(scratchMap);
        TermUtil.freeSet(scratchSet);
        return isDescendant;
    }

    public static DescendantThread getDescendants(LinkedObject term, Set out, Map memoizeTable) {
        return TermUtil.getDescendants(term, out, memoizeTable, new DescendantThread());
    }

    public static DescendantThread getDescendants(LinkedObject term, Set out, Map memoizeTable, DescendantThread thread) {
        return TermUtil.getDescendants(term, out, memoizeTable, null, thread);
    }

    public static DescendantThread getDescendants(LinkedObject term, Set out, Map memoizeTable, LinkDatabase linkDatabase, DescendantThread thread) {
        thread.setTerm(term);
        thread.setMemoizeTable(memoizeTable);
        thread.setSet(out);
        thread.setLinkDatabase(linkDatabase);
        return thread;
    }

    public static boolean hasSubsumptionPath(LinkedObject term, Map memoizeTable) {
        Boolean result = (Boolean)memoizeTable.get(term);
        if (result != null) {
            return result;
        }
        if (term.isRoot()) {
            memoizeTable.put(term, Boolean.TRUE);
            return true;
        }
        Iterator it = term.getParents().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            if (!tr.getType().equals(OBOProperty.IS_A) || !TermUtil.hasSubsumptionPath(tr.getParent(), memoizeTable)) continue;
            memoizeTable.put(term, Boolean.TRUE);
            return true;
        }
        memoizeTable.put(term, Boolean.FALSE);
        return false;
    }

    public static boolean isSubclass(Datatype a, Datatype b) {
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return TermUtil.isSubclass(a.getSupertype(), b);
    }

    public static boolean isSubclass(IdentifiedObject a, IdentifiedObject b) {
        if (a instanceof LinkedObject && b instanceof LinkedObject) {
            return TermUtil.isSubclass((LinkedObject)a, (LinkedObject)b);
        }
        return false;
    }

    public static boolean isSubclass(LinkedObject a, LinkedObject b) {
        if (a.equals(b)) {
            return true;
        }
        Iterator it = a.getParents().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            if (!TermUtil.isSubclass(tr.getType(), OBOProperty.IS_A) || !TermUtil.isSubclass(tr.getParent(), b)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDirectInverse(OBOProperty a, OBOProperty b) {
        Link tr;
        Iterator it = a.getParents().iterator();
        while (it.hasNext()) {
            tr = (Link)it.next();
            if (!tr.getParent().equals(b) || !TermUtil.isSubclass(tr.getType(), OBOProperty.INVERSE_OF)) continue;
            return true;
        }
        it = b.getParents().iterator();
        while (it.hasNext()) {
            tr = (Link)it.next();
            if (!tr.getParent().equals(a) || !TermUtil.isSubclass(tr.getType(), OBOProperty.INVERSE_OF)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegalRelationship(LinkedObject child, OBOProperty type, LinkedObject parent) {
        if (type.getDomain() != null && !TermUtil.isSubclass((IdentifiedObject)child, type.getDomain())) {
            return false;
        }
        if (!(type.getRange() == null || type.getRange() instanceof LinkedObject && TermUtil.isSubclass(parent, (LinkedObject)((Object)type.getRange())))) {
            return false;
        }
        if (!(!TermUtil.isSubclass(type, OBOProperty.INVERSE_OF) || TermUtil.isProperty(child) && TermUtil.isProperty(parent))) {
            return false;
        }
        return !TermUtil.isSubclass(type, OBOProperty.DISJOINT_FROM) || !TermUtil.isProperty(child) && !TermUtil.isProperty(parent);
    }

    public static boolean isLegalRelationship(LinkDatabase linkDatabase, OBOClass child, OBOProperty type, OBOClass parent) {
        boolean rangeFailure;
        boolean domainFailure;
        boolean bl = domainFailure = type.getDomain() != null && !TermUtil.isSubclass(linkDatabase, (IdentifiedObject)child, type.getDomain());
        if (domainFailure) {
            return false;
        }
        boolean bl2 = rangeFailure = type.getRange() != null && (!(type.getRange() instanceof OBOClass) || !TermUtil.isSubclass(linkDatabase, parent, (OBOClass)type.getRange()));
        return !rangeFailure;
    }

    public static boolean isSubclass(LinkDatabase linkDatabase, IdentifiedObject a, IdentifiedObject b) {
        if (a instanceof OBOClass && b instanceof OBOClass) {
            return TermUtil.isSubclass(linkDatabase, (OBOClass)a, (OBOClass)b);
        }
        return false;
    }

    public static boolean isSubclass(LinkDatabase linkDatabase, OBOClass a, OBOClass b) {
        if (linkDatabase instanceof ReasonedLinkDatabase) {
            return ((ReasonedLinkDatabase)linkDatabase).isSubclass(a, b);
        }
        Iterator it = linkDatabase.getParents(a).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!link.getType().equals(OBOProperty.IS_A) || !link.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(LinkDatabase linkDatabase, OBOProperty a, OBOProperty b) {
        if (linkDatabase instanceof ReasonedLinkDatabase) {
            return ((ReasonedLinkDatabase)linkDatabase).isSubProperty(a, b);
        }
        Iterator it = linkDatabase.getParents(a).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!link.getType().equals(OBOProperty.IS_A) || !link.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    public static FilterSets getFilteredTermsAndRelationships(Collection terms, VectorFilter filter, String method) {
        return TermUtil.getFilteredTermsAndRelationships(terms.iterator(), filter, method);
    }

    public static FilterSets getFilteredTermsAndRelationships(Iterator it, VectorFilter filter, String method) {
        if (method.equals(LOOSE)) {
            return TermUtil.getLooseFilteredTermsAndRelationships(it, filter);
        }
        if (method.equals(STRICT)) {
            return TermUtil.getStrictFilteredTermsAndRelationships(it, filter);
        }
        if (method.equals(FEWEST_PATHS)) {
            return TermUtil.getFewestPathsFiltered(it, filter);
        }
        throw new IllegalArgumentException("The only allowable filtration methods are TermUtil.LOOSE, TermUtil.STRICT, and TermUtil.FEWEST_PATHS");
    }

    public static FilterSets getFewestPathsFiltered(Iterator it, VectorFilter filter) {
        Link tr;
        HashSet<PathCapable> keeperTerms = new HashSet<PathCapable>();
        HashSet<Link> keeperRels = new HashSet<Link>();
        while (it.hasNext()) {
            OBOClass t = (OBOClass)it.next();
            if (t.getParents().size() == 0) {
                OBORestrictionImpl tr2 = new OBORestrictionImpl(t);
                keeperTerms.add(tr2.getChild());
                keeperRels.add(tr2);
                continue;
            }
            if (t.isRoot()) {
                keeperTerms.add(t);
                keeperTerms.add(new OBORestrictionImpl(t));
                continue;
            }
            Iterator it2 = t.getParents().iterator();
            while (it2.hasNext()) {
                Link tr3 = (Link)it2.next();
                if (!filter.satisfies((Object)tr3)) continue;
                keeperTerms.add(tr3.getChild());
                keeperRels.add(tr3);
            }
        }
        FilterSets out = new FilterSets(keeperTerms, keeperRels);
        it = out.getTerms().iterator();
        Set orphans = TermUtil.mallocSet();
        while (it.hasNext()) {
            OBOClass t = (OBOClass)it.next();
            if (t.isRoot() || t.isObsolete() || t.getParents().size() == 0) continue;
            boolean foundSome = false;
            Iterator it2 = t.getParents().iterator();
            while (it2.hasNext()) {
                tr = (Link)it2.next();
                if (!out.getTerms().contains(tr.getParent())) continue;
                foundSome = true;
                break;
            }
            if (foundSome) continue;
            orphans.add(t);
        }
        it = orphans.iterator();
        Set scratchSet = TermUtil.mallocSet();
        Set newRels = TermUtil.mallocSet();
        while (it.hasNext()) {
            Link tr2;
            OBOClass t = (OBOClass)it.next();
            tr = null;
            Iterator it2 = t.getParents().iterator();
            while (it2.hasNext() && ((tr2 = (Link)it.next()).getParent() == null || (tr = TermUtil.findClosestMatchingAncestor(tr2.getParent().getParents(), out, scratchSet)) == null)) {
            }
            scratchSet.clear();
            Set paths = TermUtil.findPaths(tr.getChild(), t, scratchSet);
            Iterator it3 = paths.iterator();
            while (it3.hasNext()) {
                Vector path = (Vector)it3.next();
                newRels.addAll(path);
            }
        }
        TermUtil.freeSet(orphans);
        TermUtil.freeSet(scratchSet);
        it = newRels.iterator();
        while (it.hasNext()) {
            Link tr4 = (Link)it.next();
            out.getTerms().add(tr4.getChild());
            out.getRelationships().add(tr4);
        }
        TermUtil.freeSet(newRels);
        return out;
    }

    protected static Link findClosestMatchingAncestor(Collection parents, FilterSets sets, Set seenem) {
        if (parents.size() == 0) {
            return null;
        }
        Iterator it = parents.iterator();
        Vector<Link> newCollection = new Vector<Link>();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            seenem.add(tr);
            if (sets.getRelationships().contains(tr)) {
                return tr;
            }
            LinkedObject parent = tr.getParent();
            if (parent == null) continue;
            if (parent.getParents().size() == 0) {
                newCollection.add(new OBORestrictionImpl(parent));
                continue;
            }
            Iterator it2 = parent.getParents().iterator();
            while (it2.hasNext()) {
                Link ptr = (Link)it2.next();
                if (seenem.contains(ptr)) continue;
                newCollection.add(ptr);
            }
        }
        parents = null;
        return TermUtil.findClosestMatchingAncestor(newCollection, sets, seenem);
    }

    protected static Set findPaths(LinkedObject parent, LinkedObject child, Set seenem) {
        HashSet<Vector> out = new HashSet<Vector>();
        if (seenem.contains(child)) {
            return out;
        }
        seenem.add(child);
        Iterator it = child.getParents().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            if (tr.getParent() == null) continue;
            if (tr.getParent().equals(parent)) {
                Vector<Link> path = new Vector<Link>();
                path.add(tr);
                out.add(path);
                continue;
            }
            Set parentPaths = TermUtil.findPaths(parent, tr.getParent(), seenem);
            Iterator it2 = parentPaths.iterator();
            while (it2.hasNext()) {
                Vector path = (Vector)it2.next();
                path.add(0, tr);
                out.add(path);
            }
        }
        return out;
    }

    public static FilterSets getStrictFilteredTermsAndRelationships(Iterator it, VectorFilter filter) {
        HashSet<LinkedObject> keeperTerms = new HashSet<LinkedObject>();
        HashSet<Link> keeperRels = new HashSet<Link>();
        while (it.hasNext()) {
            OBOClass t = (OBOClass)it.next();
            if (t.getParents().size() == 0) {
                OBORestrictionImpl tr = new OBORestrictionImpl(t);
                if (!filter.satisfies((Object)tr)) continue;
                keeperTerms.add(tr.getChild());
                keeperRels.add(tr);
                continue;
            }
            Iterator it2 = t.getParents().iterator();
            while (it2.hasNext()) {
                Link tr = (Link)it2.next();
                if (!filter.satisfies((Object)tr)) continue;
                keeperTerms.add(tr.getChild());
                keeperRels.add(tr);
            }
        }
        return new FilterSets(keeperTerms, keeperRels);
    }

    public static FilterSets getLooseFilteredTermsAndRelationships(Iterator it, VectorFilter filter) {
        HashSet keeperTerms = new HashSet();
        HashSet keeperRels = new HashSet();
        while (it.hasNext()) {
            OBOClass t = (OBOClass)it.next();
            if (t.getParents().size() == 0) {
                OBORestrictionImpl tr = new OBORestrictionImpl(t);
                if (!filter.satisfies((Object)tr)) continue;
                TermUtil.markKeepers(tr, keeperTerms, keeperRels);
                continue;
            }
            Iterator it2 = t.getParents().iterator();
            while (it2.hasNext()) {
                Link tr = (Link)it2.next();
                if (!filter.satisfies((Object)tr)) continue;
                TermUtil.markKeepers(tr, keeperTerms, keeperRels);
            }
        }
        return new FilterSets(keeperTerms, keeperRels);
    }

    protected static void markKeepers(Link tr, Set keeperTerms, Set keeperRels) {
        if (keeperRels.contains(tr)) {
            return;
        }
        keeperTerms.add(tr.getChild());
        keeperRels.add(tr);
        if (tr.getParent() == null) {
            return;
        }
        if (tr.getParent().getParents().size() == 0) {
            TermUtil.markKeepers(new OBORestrictionImpl(tr.getParent()), keeperTerms, keeperRels);
        } else {
            Iterator it = tr.getParent().getParents().iterator();
            while (it.hasNext()) {
                Link trp = (Link)it.next();
                TermUtil.markKeepers(trp, keeperTerms, keeperRels);
            }
        }
    }

    public static String getLink(IdentifiedObject term) {
        return "<a href='file:" + term.getID() + "'>" + term.getName() + "</a>";
    }

    public static String getIDLink(IdentifiedObject term) {
        return "<a href='file:" + term.getID() + "'>" + term.getID() + "</a>";
    }

    public static String getLink(Link tr) {
        return TermUtil.getLink(tr.getChild()) + " -- " + TermUtil.getLink(tr.getType()) + " -&gt; " + TermUtil.getLink(tr.getParent());
    }

    public static Synonym findSynonym(SynonymedObject t, String stext) {
        Iterator it = t.getSynonyms().iterator();
        while (it.hasNext()) {
            Synonym s = (Synonym)it.next();
            if (!s.getText().equals(stext)) continue;
            return s;
        }
        return null;
    }

    public static Synonym findSynonym(SynonymedObject t, Synonym s) {
        return TermUtil.findSynonym(t, s.getText());
    }

    public static SynonymCategory findSynonymCategory(SynonymCategory cat, OBOSession session) {
        return TermUtil.findSynonymCategory(cat.getID(), session);
    }

    public static SynonymCategory findSynonymCategory(String cat_id, OBOSession session) {
        Iterator it = session.getSynonymCategories().iterator();
        while (it.hasNext()) {
            SynonymCategory cat = (SynonymCategory)it.next();
            if (!cat.getID().equals(cat_id)) continue;
            return cat;
        }
        return null;
    }

    public static TermCategory findCategory(TermCategory cat, OBOSession session) {
        return TermUtil.findCategory(cat.getName(), session);
    }

    public static TermCategory findCategory(String name, OBOSession session) {
        Iterator it = session.getCategories().iterator();
        while (it.hasNext()) {
            TermCategory cat = (TermCategory)it.next();
            if (!cat.getName().equals(name)) continue;
            return cat;
        }
        return null;
    }

    public static Namespace findNamespace(Namespace ns, OBOSession session) {
        return TermUtil.findNamespace(ns.getID(), session);
    }

    public static Namespace findNamespace(String nsid, OBOSession session) {
        Iterator it = session.getNamespaces().iterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            if (!ns.getID().equals(nsid)) continue;
            return ns;
        }
        return null;
    }

    public static boolean hasChild(LinkedObject t, Link tr) {
        if (tr.getType() == null) {
            return false;
        }
        Iterator it = t.getChildren().iterator();
        while (it.hasNext()) {
            Link tra = (Link)it.next();
            if (!tr.getChild().equals(tra.getChild()) || !tr.getType().equals(tra.getType())) continue;
            return true;
        }
        return false;
    }

    public static Link findChildRel(Link tr, LinkedObject t) {
        if (t == null) {
            if (tr.getParent() == null) {
                return tr;
            }
            return null;
        }
        Iterator it = t.getChildren().iterator();
        while (it.hasNext()) {
            Link ptr = (Link)it.next();
            if (!TermUtil.equals(ptr, tr)) continue;
            return ptr;
        }
        return null;
    }

    public static Link findChildRelNoIntersection(Link tr, LinkedObject t) {
        if (t == null) {
            if (tr.getParent() == null) {
                return tr;
            }
            return null;
        }
        Iterator it = t.getChildren().iterator();
        while (it.hasNext()) {
            Link ptr = (Link)it.next();
            if (!TermUtil.equalsWithoutIntersection(ptr, tr)) continue;
            return ptr;
        }
        return null;
    }

    public static Link findParentRelNoIntersection(Link tr, LinkedObject t) {
        Iterator it = t.getParents().iterator();
        while (it.hasNext()) {
            Link ctr = (Link)it.next();
            if (!TermUtil.equalsWithoutIntersection(ctr, tr)) continue;
            return ctr;
        }
        return null;
    }

    public static Link findParentRel(Link tr, LinkedObject t) {
        Iterator it = t.getParents().iterator();
        while (it.hasNext()) {
            Link ctr = (Link)it.next();
            if (!TermUtil.equals(ctr, tr)) continue;
            return ctr;
        }
        return null;
    }

    public static boolean isEquivalent(LinkDatabase linkDatabase, OBOClass findThis, OBOClass toMatch) {
        if (findThis.equals(toMatch)) {
            return true;
        }
        int completeLinks = 0;
        int completeMatches = 0;
        Iterator it2 = linkDatabase.getParents(toMatch).iterator();
        while (it2.hasNext()) {
            OBORestriction toMatchLink = (OBORestriction)it2.next();
            if (!toMatchLink.completes()) continue;
            ++completeLinks;
            boolean matched = false;
            Iterator it3 = linkDatabase.getParents(findThis).iterator();
            while (it3.hasNext()) {
                OBORestriction findLink = (OBORestriction)it3.next();
                if (!findLink.completes() || !findLink.getType().equals(toMatchLink.getType()) || !TermUtil.isEquivalent(linkDatabase, (OBOClass)findLink.getParent(), (OBOClass)toMatchLink.getParent())) continue;
                matched = true;
                break;
            }
            if (!matched) break;
            ++completeMatches;
        }
        if (completeLinks == 0) {
            return false;
        }
        return completeLinks == completeMatches;
    }

    public static OBOClass findEquivalentClass(LinkDatabase linkDatabase, OBOClass findThis) {
        Iterator it = linkDatabase.getObjects().iterator();
        while (it.hasNext()) {
            OBOClass toMatch;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof OBOClass) || !TermUtil.isEquivalent(linkDatabase, findThis, toMatch = (OBOClass)io)) continue;
            return toMatch;
        }
        return null;
    }

    public static OBORestriction createRestriction(Link link) {
        OBORestrictionImpl out = new OBORestrictionImpl(link.getChild(), link.getType(), link.getParent());
        if (link instanceof OBORestriction) {
            OBORestriction linkRes = (OBORestriction)link;
            out.setCardinality(linkRes.getCardinality());
            out.setMinCardinality(linkRes.getMinCardinality());
            out.setMaxCardinality(linkRes.getMaxCardinality());
            out.setCompletes(linkRes.completes());
            out.setInverseCompletes(linkRes.inverseCompletes());
            out.setNecessarilyTrue(linkRes.isNecessarilyTrue());
            out.setInverseNecessarilyTrue(linkRes.isInverseNecessarilyTrue());
            out.setNamespace(linkRes.getNamespace());
        }
        return out;
    }

    public static boolean isImplied(Link link) {
        if (link instanceof Impliable) {
            return ((Impliable)((Object)link)).isImplied();
        }
        return false;
    }

    public static boolean isInstance(IdentifiedObject io) {
        return io instanceof Instance;
    }

    public static boolean isNecessary(Link link) {
        if (link instanceof OBORestriction) {
            return ((OBORestriction)link).isNecessarilyTrue();
        }
        return false;
    }

    public static boolean isIntersection(LinkedObject lo) {
        Iterator it = lo.getParents().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!TermUtil.isIntersection(link)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntersection(Link link) {
        if (link instanceof OBORestriction) {
            return ((OBORestriction)link).completes();
        }
        return false;
    }

    public static boolean isImplied(IdentifiedObject io) {
        if (io instanceof Impliable) {
            return ((Impliable)((Object)io)).isImplied();
        }
        return false;
    }

    public static boolean isDangling(IdentifiedObject io) {
        return io instanceof DanglingObject;
    }

    public static Link findRel(Link tr) {
        return TermUtil.findParentRel(tr, tr.getChild());
    }

    public static Link findRel(Link tr, LinkedObject t) {
        Link tr_out = TermUtil.findChildRel(tr, t);
        if (tr_out != null) {
            return tr_out;
        }
        return TermUtil.findParentRel(tr, t);
    }

    public static boolean equalsWithoutIntersection(Link a, Link b) {
        return ObjectUtil.equals((Object)a.getChild(), (Object)b.getChild()) && ObjectUtil.equals((Object)a.getType(), (Object)b.getType()) && ObjectUtil.equals((Object)a.getParent(), (Object)b.getParent());
    }

    public static boolean equals(Link a, Link b) {
        return TermUtil.equalsWithoutIntersection(a, b) && TermUtil.isIntersection(a) == TermUtil.isIntersection(b);
    }

    public static Set getSiblings(LinkedObject t) {
        HashSet<LinkedObject> out = new HashSet<LinkedObject>();
        Iterator it = t.getParents().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            LinkedObject parent = tr.getParent();
            Iterator it2 = parent.getChildren().iterator();
            while (it2.hasNext()) {
                Link tr2 = (Link)it2.next();
                if (tr2.getChild().equals(t)) continue;
                out.add(tr2.getChild());
            }
        }
        return out;
    }

    public static boolean isRedundant(Link link) {
        if (Controller.getController().getUseReasoner()) {
            return Controller.getController().getReasonedLinkDatabase().isRedundant(link);
        }
        return false;
    }

    public static boolean isClass(IdentifiedObject io) {
        return io.getType().equals(OBOClass.OBO_CLASS) || io instanceof DanglingObject;
    }

    public static boolean isProperty(IdentifiedObject io) {
        return io.getType().equals(OBOClass.OBO_PROPERTY);
    }

    public static boolean isObsolete(IdentifiedObject o) {
        return o instanceof ObsoletableObject && ((ObsoletableObject)o).isObsolete();
    }

    protected static boolean checkRelatedMatch(LinkedObject checkme, OBOProperty checkProp, LinkedObject b, OBOProperty prop, LinkDatabase linkDatabase, boolean followTransitiveLinks, Map seenem, int depth, CheckTriple ct) {
        boolean matchingProperty;
        boolean bl = matchingProperty = checkProp.equals(prop) || TermUtil.isRelated(checkProp, prop, OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1);
        if (matchingProperty && (checkme.equals(b) || followTransitiveLinks && (checkProp.isTransitive() && TermUtil.isRelated(checkme, b, prop, linkDatabase, followTransitiveLinks, seenem, depth + 1) || TermUtil.isRelated(checkme, b, OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1)))) {
            return true;
        }
        return followTransitiveLinks && TermUtil.isRelated(checkProp, OBOProperty.IS_A, OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1) && TermUtil.isRelated(checkme, b, prop, linkDatabase, followTransitiveLinks, seenem, depth + 1);
    }

    public static boolean isInverse(OBOProperty a, OBOProperty b, LinkDatabase linkDatabase, boolean followTransitiveLinks, Map seenem, int depth) {
        boolean matchingProperty;
        Link link;
        if (a.isSymmetric() && b.equals(a)) {
            return true;
        }
        Iterator it = linkDatabase.getParents(a).iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            matchingProperty = link.getType().equals(OBOProperty.INVERSE_OF) || TermUtil.isRelated(link.getType(), OBOProperty.INVERSE_OF, OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1);
            if (!matchingProperty || !link.getParent().equals(b)) continue;
            return true;
        }
        it = linkDatabase.getChildren(a).iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            matchingProperty = link.getType().equals(OBOProperty.INVERSE_OF) || TermUtil.isRelated(link.getType(), OBOProperty.INVERSE_OF, OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1);
            if (!matchingProperty || !link.getChild().equals(b)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRelated(LinkedObject a, LinkedObject b, OBOProperty prop, LinkDatabase linkDatabase, boolean followTransitiveLinks, Map seenem, int depth) {
        Link link;
        CheckTriple ct = new CheckTriple(a, b, prop);
        if (a.equals(b) && prop.equals(OBOProperty.IS_A)) {
            seenem.put(ct, Boolean.TRUE);
            return true;
        }
        Boolean result = (Boolean)seenem.get(ct);
        if (result != null) {
            return result;
        }
        seenem.put(ct, Boolean.FALSE);
        Iterator it = linkDatabase.getParents(a).iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            if (!TermUtil.checkRelatedMatch(link.getParent(), link.getType(), b, prop, linkDatabase, followTransitiveLinks, seenem, depth, ct)) continue;
            seenem.put(ct, Boolean.TRUE);
            return true;
        }
        if (ignoreChildren) {
            return false;
        }
        it = linkDatabase.getChildren(a).iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            boolean matchingProperty = TermUtil.isInverse(link.getType(), prop, linkDatabase, followTransitiveLinks, seenem, depth + 1);
            if (matchingProperty && (link.getChild().equals(b) || followTransitiveLinks && (link.getType().isTransitive() && TermUtil.isRelated(link.getChild(), b, prop, linkDatabase, followTransitiveLinks, seenem, depth + 1) || TermUtil.isRelated(link.getChild(), b, OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1)))) {
                seenem.put(ct, Boolean.TRUE);
                return true;
            }
            if (!followTransitiveLinks || !TermUtil.isInverse(link.getType(), OBOProperty.IS_A, linkDatabase, followTransitiveLinks, seenem, depth + 1) || !TermUtil.isRelated(link.getChild(), b, prop, linkDatabase, followTransitiveLinks, seenem, depth + 1)) continue;
            seenem.put(ct, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static Collection findMatchingItems(TermMacroHistoryItem mitem, VectorFilter filter) {
        LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
        for (int i = 0; i < mitem.getHistoryItemCount(); ++i) {
            HistoryItem item = mitem.getHistoryItemAt(i);
            if (filter.satisfies((Object)item)) {
                out.add(item);
            }
            if (!(item instanceof TermMacroHistoryItem)) continue;
            out.addAll(TermUtil.findMatchingItems((TermMacroHistoryItem)item, filter));
        }
        return out;
    }

    public static Map createIDRemapping(HistoryList list) {
        HashMap<String, HashSet<String>> out = new HashMap<String, HashSet<String>>();
        VectorFilter destroyFilter = new VectorFilter(){

            public boolean satisfies(Object o) {
                return o instanceof DestroyObjectHistoryItem;
            }
        };
        final HashSet<String> destroyedIDs = new HashSet<String>();
        Collection matches = TermUtil.findMatchingItems(list, destroyFilter);
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            DestroyObjectHistoryItem item = (DestroyObjectHistoryItem)it.next();
            destroyedIDs.add(item.getTarget());
        }
        VectorFilter secondaryFilter = new VectorFilter(){

            public boolean satisfies(Object o) {
                return o instanceof SecondaryIDHistoryItem && destroyedIDs.contains(((SecondaryIDHistoryItem)o).getSecondaryID());
            }
        };
        matches = TermUtil.findMatchingItems(list, secondaryFilter);
        it = matches.iterator();
        while (it.hasNext()) {
            SecondaryIDHistoryItem item = (SecondaryIDHistoryItem)it.next();
            HashSet<String> c = (HashSet<String>)out.get(item.getSecondaryID());
            if (c == null) {
                c = new HashSet<String>();
                out.put(item.getSecondaryID(), c);
            }
            c.add(item.getTarget());
        }
        return out;
    }

    public static Collection findMatchingItems(HistoryList list, VectorFilter filter) {
        LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
        Iterator it = list.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            if (filter.satisfies((Object)item)) {
                out.add(item);
            }
            if (!(item instanceof TermMacroHistoryItem)) continue;
            out.addAll(TermUtil.findMatchingItems((TermMacroHistoryItem)item, filter));
        }
        return out;
    }

    public static void calculateTransitiveClosure(LinkDatabase linkDatabase, MutableLinkDatabase resultDatabase, LinkDatabase mergedDatabase, LinkedObject lo, Set seenem, Map inverseMap) {
        Iterator it2;
        Link link;
        Iterator it;
        if (seenem.contains(lo)) {
            return;
        }
        seenem.add(lo);
        HashSet<OBORestrictionImpl> parents = new HashSet<OBORestrictionImpl>();
        boolean doInverses = false;
        if (doInverses) {
            it = linkDatabase.getChildren(lo).iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                Set inverses = (Set)inverseMap.get(link.getType());
                if (inverses == null || inverses.size() < 1) continue;
                it2 = inverses.iterator();
                while (it2.hasNext()) {
                    OBOProperty inverseType = (OBOProperty)it2.next();
                    OBORestrictionImpl inverseLink = new OBORestrictionImpl(link.getParent(), inverseType, link.getChild());
                    resultDatabase.addParent(inverseLink);
                    parents.add(inverseLink);
                }
            }
        }
        parents.addAll(linkDatabase.getParents(lo));
        it = parents.iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            TermUtil.calculateTransitiveClosure(linkDatabase, resultDatabase, mergedDatabase, link.getParent(), seenem, inverseMap);
            boolean isaLink = TermUtil.isRelated(link.getType(), OBOProperty.IS_A, OBOProperty.IS_A, mergedDatabase, false, new HashMap(), 0);
            it2 = mergedDatabase.getParents(link.getParent()).iterator();
            while (it2.hasNext()) {
                Link parentLink = (Link)it2.next();
                if (isaLink) {
                    OBORestrictionImpl newRes = new OBORestrictionImpl(link.getChild(), parentLink.getType(), parentLink.getParent());
                    resultDatabase.addParent(newRes);
                    continue;
                }
                boolean linkMatch = link.getType().isTransitive() && TermUtil.isRelated(link.getType(), parentLink.getType(), OBOProperty.IS_A, mergedDatabase, false, new HashMap(), 0);
                if (!linkMatch) continue;
                OBORestrictionImpl newRes = new OBORestrictionImpl(link.getChild(), link.getType(), parentLink.getParent());
                resultDatabase.addParent(newRes);
            }
        }
    }

    public static LinkedObject cloneParentTree(LinkedObject term) {
        if (term.getParents().size() == 0) {
            return term;
        }
        OBOClass newRoot = null;
        Iterator<Object> it = TermUtil.getAncestors(term).iterator();
        Map newTermHash = TermUtil.mallocMap();
        Map oldTermHash = TermUtil.mallocMap();
        while (it.hasNext()) {
            OBOClass originalTerm = (OBOClass)it.next();
            OBOClass newTerm = (OBOClass)originalTerm.clone();
            if (originalTerm.getID().equals(term.getID())) continue;
            if (originalTerm.getParents().size() == 0) {
                newRoot = newTerm;
            }
            newTermHash.put(newTerm, originalTerm);
            oldTermHash.put(originalTerm, newTerm);
        }
        it = newTermHash.keySet().iterator();
        while (it.hasNext()) {
            OBORestrictionImpl trNew;
            Link tr;
            OBOClass newTerm = (OBOClass)it.next();
            OBOClass originalTerm = (OBOClass)newTermHash.get(newTerm);
            newTerm.getParents().clear();
            newTerm.getChildren().clear();
            Iterator it2 = originalTerm.getChildren().iterator();
            while (it2.hasNext()) {
                tr = (Link)it2.next();
                OBOClass newChild = (OBOClass)oldTermHash.get(tr.getChild());
                if (newChild != null) {
                    trNew = new OBORestrictionImpl((LinkedObject)newChild, newTerm, tr.getType());
                    newTerm.atomicAddChild(trNew);
                    continue;
                }
                if (tr.getChild() != term) continue;
                trNew = new OBORestrictionImpl(term, newTerm, tr.getType());
                newTerm.atomicAddChild(trNew);
            }
            it2 = originalTerm.getParents().iterator();
            while (it2.hasNext()) {
                tr = (Link)it2.next();
                OBOClass newParent = (OBOClass)oldTermHash.get(tr.getParent());
                trNew = new OBORestrictionImpl((LinkedObject)newTerm, newParent, tr.getType());
                newTerm.atomicAddParent(trNew);
            }
        }
        TermUtil.freeMap(newTermHash);
        TermUtil.freeMap(oldTermHash);
        return newRoot;
    }

    public static TreePath convertPathToIDs(TreePath path) {
        Object[] pathobs = path.getPath();
        if (pathobs.length == 0) {
            return path;
        }
        Object[] obj = new Object[pathobs.length - 1];
        for (int i = 1; i < pathobs.length; ++i) {
            if (pathobs[i] instanceof OBORestriction) {
                OBORestriction tr = (OBORestriction)pathobs[i];
                obj[i - 1] = new HistoryItem.StringRelationship(tr);
                continue;
            }
            if (pathobs[i] instanceof OBOClass) {
                OBOClass term = (OBOClass)pathobs[i];
                obj[i - 1] = term.getID();
                continue;
            }
            obj[i - 1] = pathobs[i];
        }
        TreePath out = new TreePath(obj);
        return out;
    }

    public static Collection getRoots(LinkDatabase linkDatabase) {
        return TermUtil.getRoots(RootAlgorithm.GREEDY, linkDatabase);
    }

    public static Collection getRoots(RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        rootAlgorithm.setLinkDatabase(linkDatabase);
        LinkedList<LinkedObject> out = new LinkedList<LinkedObject>();
        Iterator it = linkDatabase.getObjects().iterator();
        while (it.hasNext()) {
            LinkedObject lo;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject) || !rootAlgorithm.isRoot(lo = (LinkedObject)io)) continue;
            out.add(lo);
        }
        return out;
    }

    public static TreePath convertPathToObjects(TreePath path, OBOSession history) {
        Object[] pathobs = path.getPath();
        if (pathobs.length == 0) {
            return path;
        }
        Object[] obj = new Object[pathobs.length + 1];
        obj[0] = OBOSession.ROOT;
        for (int i = 0; i < pathobs.length; ++i) {
            if (pathobs[i] == null) {
                return null;
            }
            if (pathobs[i] instanceof HistoryItem.StringRelationship) {
                HistoryItem.StringRelationship sr = (HistoryItem.StringRelationship)pathobs[i];
                LinkedObject child = (LinkedObject)history.getObject(sr.getChild());
                LinkedObject parent = (LinkedObject)history.getObject(sr.getParent());
                OBOProperty type = (OBOProperty)history.getObject(sr.getType());
                if (child == null && sr.getChild() != null) {
                    return null;
                }
                if (parent == null && sr.getParent() != null) {
                    return null;
                }
                if (type == null && sr.getType() != null) {
                    return null;
                }
                Link tr = new OBORestrictionImpl(child, parent, type);
                if (tr.getParent() != null) {
                    tr = TermUtil.findChildRel(tr, tr.getParent());
                }
                if (tr == null) {
                    return null;
                }
                obj[i + 1] = tr;
                continue;
            }
            obj[i + 1] = pathobs[i];
        }
        TreePath out = new TreePath(obj);
        return out;
    }

    public static Link createRealRel(OBOSession session, HistoryItem.StringRelationship tr) {
        if (tr == null) {
            return null;
        }
        LinkedObject parent = (LinkedObject)session.getObject(tr.getParent());
        LinkedObject child = (LinkedObject)session.getObject(tr.getChild());
        OBOProperty type = (OBOProperty)session.getObject(tr.getType());
        Namespace ns = session.getNamespace(tr.getNamespace());
        OBORestrictionImpl realtr = new OBORestrictionImpl(child, parent, type);
        realtr.setNamespace(ns);
        realtr.setNecessarilyTrue(tr.isNecessary());
        realtr.setInverseNecessarilyTrue(tr.isInverseNecessary());
        realtr.setCompletes(tr.completes());
        realtr.setMinCardinality(tr.getMinCardinality());
        realtr.setMaxCardinality(tr.getMaxCardinality());
        realtr.setCardinality(tr.getCardinality());
        return realtr;
    }

    public static TreePath[] convertPathsToIDs(TreePath[] path) {
        if (path == null) {
            return null;
        }
        TreePath[] out = new TreePath[path.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = TermUtil.convertPathToIDs(path[i]);
        }
        return out;
    }

    public static TreePath[] convertPathsToObjects(TreePath[] paths, OBOSession history) {
        if (paths == null) {
            return null;
        }
        LinkedList<TreePath> temp = new LinkedList<TreePath>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = TermUtil.convertPathToObjects(paths[i], history);
            if (path == null) continue;
            temp.add(path);
        }
        TreePath[] out = new TreePath[temp.size()];
        temp.toArray(out);
        return out;
    }

    public static boolean pathContainsNonTransitive(TreePath path) {
        do {
            Link link;
            Object o = path.getLastPathComponent();
            path = path.getParentPath();
            if (!(o instanceof Link) || (link = (Link)o).getType() == null || link.getType().isTransitive()) continue;
            return true;
        } while (path != null && path.getPathCount() > 0);
        return false;
    }

    public static boolean pathIsCircular(TreePath path) {
        Set scratchSet = TermUtil.mallocSet();
        boolean out = TermUtil.pathIsCircular(path, scratchSet);
        TermUtil.freeSet(scratchSet);
        return out;
    }

    public static boolean pathIsCircular(TreePath path, Set scratchSet) {
        Object[] obs = path.getPath();
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] instanceof Link)) continue;
            Link tr = (Link)obs[i];
            if (scratchSet.contains(tr.getChild())) {
                return true;
            }
            scratchSet.add(tr.getChild());
        }
        return false;
    }

    public static Link getRealRel(OBOSession session, HistoryItem.StringRelationship tr) {
        if (tr == null) {
            return null;
        }
        LinkedObject child = (LinkedObject)session.getObject(tr.getChild());
        OBOProperty type = (OBOProperty)session.getObject(tr.getType());
        LinkedObject parent = (LinkedObject)session.getObject(tr.getParent());
        if (child == null) {
            return null;
        }
        Iterator it = child.getParents().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!link.getType().equals(type) || !link.getParent().equals(parent)) continue;
            return link;
        }
        return null;
    }

    public static boolean isUsed(OBOSession session, OBOProperty prop) {
        Iterator it = session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (io.isBuiltIn() || !(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            Iterator it2 = lo.getParents().iterator();
            while (it2.hasNext()) {
                Link link = (Link)it2.next();
                if (link.getParent().isBuiltIn() || !link.getType().equals(prop)) continue;
                return true;
            }
        }
        return false;
    }

    public static void markRoots(Set terms) {
        Set roots = TermUtil.mallocSet();
        Set attached = TermUtil.mallocSet();
        Set unattached = TermUtil.mallocSet();
        Map memoizeTable = TermUtil.mallocMap();
        Set scratchSet = TermUtil.mallocSet();
        descendantThread.setSet(scratchSet);
        descendantThread.setMemoizeTable(memoizeTable);
        Iterator it = terms.iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject term = (LinkedObject)io;
            unattached.add(term);
            if (TermUtil.checkRoot(term)) {
                term.setRoot(true);
                roots.add(term);
                scratchSet.clear();
                descendantThread.setTerm(term);
                descendantThread.run();
                attached.addAll(scratchSet);
                continue;
            }
            term.setRoot(false);
        }
        TermUtil.freeSet(scratchSet);
        unattached.removeAll(attached);
        it = unattached.iterator();
        while (it.hasNext()) {
            LinkedObject t = (LinkedObject)it.next();
            if (TermUtil.hasAncestor(t, t)) continue;
            it.remove();
        }
        boolean noHints = false;
        while (unattached.size() > 0) {
            LinkedObject root = null;
            if (noHints) {
                root = (LinkedObject)unattached.iterator().next();
            } else {
                it = unattached.iterator();
                while (it.hasNext()) {
                    noHints = true;
                    root = (LinkedObject)it.next();
                    if (!root.rootHint()) continue;
                    noHints = false;
                    break;
                }
            }
            roots.add(root);
            root.setRoot(true);
            unattached.remove(root);
            it = unattached.iterator();
            while (it.hasNext()) {
                LinkedObject t = (LinkedObject)it.next();
                if (!TermUtil.hasAncestor(t, root)) continue;
                it.remove();
            }
        }
        TermUtil.freeSet(roots);
        TermUtil.freeSet(attached);
        TermUtil.freeSet(unattached);
        TermUtil.freeMap(memoizeTable);
    }

    protected static boolean checkRoot(LinkedObject term) {
        if (Controller.getController() == null || Controller.getController().useBasicRootDetection()) {
            return term.getParents().size() == 0;
        }
        boolean showCompletes = Controller.getController() != null && Controller.getController().showCompleteRelationships();
        Iterator it = term.getParents().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            if (!tr.getType().isTransitive() || !showCompletes && TermUtil.isIntersection(tr)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalID(String id) {
        for (int i = 0; i < id.length(); ++i) {
            if (!Character.isWhitespace(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] fetchIDs(Controller controller, LinkedObject parent, int size) {
        String[] out = new String[size];
        Set reserved = TermUtil.mallocSet();
        for (int i = 0; i < size; ++i) {
            out[i] = TermUtil.fetchID(controller, parent, reserved, false);
            reserved.add(out[i]);
        }
        TermUtil.freeSet(reserved);
        return out;
    }

    public static String fetchID(Controller controller, LinkedObject parent) {
        return TermUtil.fetchID(controller, parent, null);
    }

    public static String fetchID(Controller controller, LinkedObject parent, Collection reservedIDs) {
        return TermUtil.fetchID(controller, parent, reservedIDs, false);
    }

    public static String fetchID(Controller controller, LinkedObject parent, Collection reservedIDs, boolean temporary) {
        IDGenerator idGen = Controller.getController().getIDAdapter();
        return idGen.generateID(controller.getSession(), parent, reservedIDs, temporary);
    }

    public static boolean containsExtended(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!TermUtil.isLegal(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegal(char c) {
        if (c == '\n' || c == '\t') {
            return true;
        }
        if (Character.isISOControl(c)) {
            return false;
        }
        return Character.UnicodeBlock.of(c).equals(Character.UnicodeBlock.BASIC_LATIN) || Character.UnicodeBlock.of(c).equals(Character.UnicodeBlock.LATIN_1_SUPPLEMENT);
    }

    public static Object getPropValue(String instance_id, String prop_id, OBOSession session) {
        Collection c = TermUtil.getPropValues(instance_id, prop_id, session);
        return TermUtil.getFirst(c);
    }

    public static Object getPropValue(Instance instance, OBOProperty property) {
        Collection c = TermUtil.getPropValues(instance, property);
        return TermUtil.getFirst(c);
    }

    public static Object getPropValue(Instance instance, String prop_id, OBOSession session) {
        OBOProperty property = (OBOProperty)session.getObject(prop_id);
        return TermUtil.getPropValue(instance, property);
    }

    protected static Object getFirst(Collection c) {
        Iterator it = c.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static Collection getPropValues(Instance instance, String prop_id, OBOSession session) {
        OBOProperty property = (OBOProperty)session.getObject(prop_id);
        return TermUtil.getPropValues(instance, property);
    }

    public static Collection getPropValues(String instance_id, String prop_id, OBOSession session) {
        Instance instance = (Instance)session.getObject(instance_id);
        OBOProperty property = (OBOProperty)session.getObject(prop_id);
        return TermUtil.getPropValues(instance, property);
    }

    public static Collection getPropValues(Instance instance, OBOProperty property) {
        Set values = instance.getValues(property);
        LinkedList<Object> list = new LinkedList<Object>();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Value v = (Value)it.next();
            if (v.getType() instanceof Datatype && v instanceof DatatypeValue) {
                Object o = ((Datatype)v.getType()).getValue(((DatatypeValue)v).getValue());
                list.add(o);
                continue;
            }
            list.add(v);
        }
        return list;
    }

    public static boolean isDisjoint(ReasonedLinkDatabase linkDatabase, OBOClass a, OBOClass b, boolean siblingsAreDisjoint) {
        if (a.equals(b)) {
            return false;
        }
        if (siblingsAreDisjoint) {
            if (linkDatabase.isSubclass(a, b) || linkDatabase.isSubclass(b, a)) {
                return false;
            }
            Set a_superClasses = linkDatabase.getParentsOfType(a, OBOProperty.IS_A);
            Set b_superClasses = linkDatabase.getParentsOfType(b, OBOProperty.IS_A);
            a_superClasses.retainAll(b_superClasses);
            return a_superClasses.size() > 0;
        }
        Set disjoints = linkDatabase.getParentsOfType(a, OBOProperty.DISJOINT_FROM);
        if (disjoints.contains(b)) {
            return true;
        }
        disjoints = linkDatabase.getParentsOfType(b, OBOProperty.DISJOINT_FROM);
        return disjoints.contains(a);
    }

    public static boolean isFake(Link link) {
        return link.getType() == null || link.getParent() == null || link.getType().equals(OBOProperty.REPLACES) || link.getType().equals(OBOProperty.CONSIDER) || TermUtil.isObsolete(link.getParent()) || TermUtil.isObsolete(link.getChild());
    }

    public static boolean equals(IDProfile a, IDProfile b) {
        boolean failed = false;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return true;
        }
        if (a.getRules().size() != b.getRules().size() && a.getRules().size() != 0) {
            failed = true;
        } else {
            Iterator it = a.getRules().iterator();
            while (it.hasNext()) {
                IDRule rule = (IDRule)it.next();
                boolean found = false;
                Iterator it2 = b.getRules().iterator();
                while (it2.hasNext()) {
                    IDRule rule2 = (IDRule)it2.next();
                    if (!rule.equals(rule2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                failed = true;
                break;
            }
        }
        if (!ObjectUtil.equals((Object)a.getDefaultRule(), (Object)b.getDefaultRule())) {
            failed = true;
        }
        return !failed;
    }

    public static boolean isCycle(LinkDatabase linkDatabase, OBOProperty property, LinkedObject lo) {
        if (linkDatabase instanceof ReasonedLinkDatabase) {
            Iterator it;
            LinkedList<OBOProperty> properties = new LinkedList<OBOProperty>();
            if (property != null) {
                properties.add(property);
            } else {
                it = linkDatabase.getObjects().iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof OBOProperty)) continue;
                    properties.add((OBOProperty)o);
                }
            }
            it = properties.iterator();
            while (it.hasNext()) {
                property = (OBOProperty)it.next();
                if (!((ReasonedLinkDatabase)linkDatabase).hasTransitiveRelationship(lo, property, lo)) continue;
                return true;
            }
            return false;
        }
        return TermUtil.isCycle(linkDatabase, property, lo, lo, true, new HashSet());
    }

    public static boolean isCycle(LinkDatabase linkDatabase, OBOProperty property, LinkedObject findme, LinkedObject current, boolean skipIt, Set seenem) {
        if (!skipIt && findme.equals(current)) {
            return true;
        }
        if (seenem.contains(current)) {
            return false;
        }
        seenem.add(current);
        Iterator it = linkDatabase.getParents(current).iterator();
        while (it.hasNext()) {
            boolean isCycle;
            Link link = (Link)it.next();
            if (property != null && !TermUtil.isSubclass(linkDatabase, link.getType(), property) || !(isCycle = TermUtil.isCycle(linkDatabase, property, findme, link.getParent(), false, seenem))) continue;
            return true;
        }
        return false;
    }

    public static String getHTMLLink(IdentifiedObject io, boolean hyperlink) {
        return TermUtil.getHTMLLink(null, null, io, hyperlink);
    }

    public static String getHTMLLink(Link link, boolean hyperlink) {
        return TermUtil.getHTMLLink(null, null, link, hyperlink);
    }

    public static String getHTMLLink(String param, String val, String desc, boolean hyperlink) {
        if (hyperlink) {
            return "<a href='file:action" + (param != null ? "(" + param + ")" : "") + "-" + val + "'>" + TermUtil.getHTMLLink(param, val, desc, false) + "</a>";
        }
        return desc;
    }

    public static String getHTMLLink(String param, String desc, IdentifiedObject io, boolean hyperlink) {
        if (hyperlink) {
            return "<a href='file:term" + (param != null ? "(" + param + ")" : "") + "-" + io.getID().replaceAll(":", "%3A") + "'>" + TermUtil.getHTMLLink(param, desc, io, false) + "</a>";
        }
        if (desc != null) {
            return desc;
        }
        return io.getName() + " <i>(" + io.getID() + ")</i>";
    }

    public static String getHTMLLink(String param, String desc, Link link, boolean hyperlink) {
        if (hyperlink) {
            return "<a href='file:link" + (param != null ? "(" + param + ")" : "") + "-" + link.getChild().getID().replaceAll(":", "%3A") + "-" + link.getType().getID().replaceAll(":", "%3A") + "-" + link.getParent().getID().replaceAll(":", "%3A") + "'>" + TermUtil.getHTMLLink(param, desc, link, false) + "</a>";
        }
        if (desc != null) {
            return desc;
        }
        return link.getChild() + " -<b>" + link.getType().getID() + "</b>->" + link.getParent();
    }

    protected static class CheckTriple {
        LinkedObject a;
        LinkedObject b;
        OBOProperty prop;

        public CheckTriple(LinkedObject a, LinkedObject b, OBOProperty prop) {
            this.a = a;
            this.b = b;
            this.prop = prop;
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode() + this.prop.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CheckTriple) {
                CheckTriple ct = (CheckTriple)o;
                return ct.a.equals(this.a) && ct.b.equals(this.b) && ct.prop.equals(this.prop);
            }
            return false;
        }
    }

    public static class FilterSets {
        protected Set terms;
        protected Set relationships;

        public FilterSets(Set terms, Set relationships) {
            this.terms = terms;
            this.relationships = relationships;
        }

        public Set getTerms() {
            return this.terms;
        }

        public Set getRelationships() {
            return this.relationships;
        }
    }

    public static class DescendantThread
    extends Thread {
        protected LinkedObject term;
        protected LinkDatabase linkDatabase;
        protected Set set;
        protected boolean halt = false;
        protected double progress;
        protected Map memoizeTable;
        protected ReusableProgressEvent pe = new ReusableProgressEvent((Object)this);
        protected Vector listeners = new Vector();

        public void start() {
            this.halt = false;
            this.progress = 0.0;
            this.pe.setDescription("Finding descendants...");
            super.start();
        }

        public void addProgressListener(ProgressListener pl) {
            this.listeners.add(pl);
        }

        public void removeProgressListener(ProgressListener pl) {
            this.listeners.remove(pl);
        }

        public void fireProgressEvent(ProgressEvent pe) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ProgressListener pl = (ProgressListener)this.listeners.get(i);
                pl.progressMade(pe);
            }
        }

        public void setLinkDatabase(LinkDatabase linkDatabase) {
            this.linkDatabase = linkDatabase;
        }

        public void setMemoizeTable(Map memoizeTable) {
            this.memoizeTable = memoizeTable;
        }

        public void halt() {
            this.halt = true;
        }

        public boolean halted() {
            return this.halt;
        }

        public void setTerm(LinkedObject term) {
            this.term = term;
        }

        public Set getSet() {
            return this.set;
        }

        public void setSet(Set set) {
            this.set = set;
        }

        public void run() {
            this.set.clear();
            this.set.addAll(this.getDescendants(100.0, this.linkDatabase, this.term, this.memoizeTable));
        }

        protected Set getDescendants(double incSize, LinkDatabase linkDatabase, LinkedObject term, Map memoizeTable) {
            Link tr;
            HashSet<LinkedObject> out;
            if (linkDatabase == null) {
                linkDatabase = DefaultLinkDatabase.getDefault();
            }
            if ((out = (HashSet<LinkedObject>)memoizeTable.get(term)) != null) {
                this.progress += incSize;
                return out;
            }
            out = new HashSet<LinkedObject>();
            memoizeTable.put(term, out);
            Iterator it = linkDatabase.getChildren(term).iterator();
            while (it.hasNext()) {
                tr = (Link)it.next();
                out.add(tr.getChild());
            }
            it = linkDatabase.getChildren(term).iterator();
            while (it.hasNext()) {
                tr = (Link)it.next();
                out.addAll(this.getDescendants(incSize / (double)term.getChildren().size(), linkDatabase, tr.getChild(), memoizeTable));
            }
            if (term.getChildren().size() == 0) {
                this.progress += incSize;
            }
            return out;
        }
    }

    public static class AncestorThread
    extends Thread {
        protected LinkedObject term;
        protected LinkDatabase linkDatabase;
        protected Set set;
        protected boolean halt = false;
        protected double progress;
        protected Map memoizeTable;
        protected ReusableProgressEvent pe = new ReusableProgressEvent((Object)this);
        protected Vector listeners = new Vector();

        public void start() {
            this.halt = false;
            this.progress = 0.0;
            this.pe.setDescription("Finding ancestors...");
            super.start();
        }

        public void addProgressListener(ProgressListener pl) {
            this.listeners.add(pl);
        }

        public void removeProgressListener(ProgressListener pl) {
            this.listeners.remove(pl);
        }

        public void fireProgressEvent(ProgressEvent pe) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ProgressListener pl = (ProgressListener)this.listeners.get(i);
                pl.progressMade(pe);
            }
        }

        public void setMemoizeTable(Map memoizeTable) {
            if (memoizeTable == null) {
                memoizeTable = new HashMap();
            }
            this.memoizeTable = memoizeTable;
        }

        public void halt() {
            this.halt = true;
        }

        public boolean halted() {
            return this.halt;
        }

        public void setTerm(LinkedObject term) {
            this.term = term;
        }

        public Set getSet() {
            return this.set;
        }

        public void setSet(Set set) {
            this.set = set;
        }

        public void setLinkDatabase(LinkDatabase linkDatabase) {
            this.linkDatabase = linkDatabase;
        }

        public void run() {
            this.set.clear();
            this.set.addAll(this.getAncestors(100.0, this.linkDatabase, this.term, this.memoizeTable));
        }

        protected Set getAncestors(double incSize, LinkDatabase linkDatabase, LinkedObject term, Map memoizeTable) {
            HashSet<LinkedObject> out;
            if (linkDatabase == null) {
                linkDatabase = DefaultLinkDatabase.getDefault();
            }
            if ((out = (HashSet<LinkedObject>)memoizeTable.get(term)) != null) {
                this.progress += incSize;
                return out;
            }
            out = new HashSet<LinkedObject>();
            memoizeTable.put(term, out);
            Iterator it = linkDatabase.getParents(term).iterator();
            while (it.hasNext()) {
                Link tr = (Link)it.next();
                out.add(tr.getParent());
                out.addAll(this.getAncestors(incSize / (double)term.getParents().size(), linkDatabase, tr.getParent(), memoizeTable));
            }
            if (term.getParents().size() == 0) {
                this.progress += incSize;
            }
            return out;
        }
    }

    public static interface JexlContext {
        public String getValue(Variable var1);
    }

    public static class VariableValue {
        protected Variable v;
        protected String value;

        public VariableValue(Variable v, String value) {
            this.v = v;
            this.value = value;
        }

        public Variable getVariable() {
            return this.v;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Variable {
        protected String s;
        protected List params = new ArrayList();

        public Variable(String s) {
            this.s = s;
        }

        public String getName() {
            return this.s;
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        public List getParams() {
            return this.params;
        }

        public String toString() {
            return "[variable: " + this.s + ", params: " + this.params + "]";
        }
    }

    protected static class TrackedMap
    extends HashMap {
        private static final long serialVersionUID = 1L;
        protected static int id_gen = 0;
        protected int id = id_gen++;
        protected int hashcode = new Integer(this.id).hashCode();
        protected Exception instantiationInfo = new Exception("Created set " + this.id);

        protected TrackedMap() {
        }

        public Exception getInstantiationInfo() {
            return this.instantiationInfo;
        }

        public boolean equals(Object o) {
            return o instanceof TrackedMap && ((TrackedMap)o).id == this.id;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    protected static class TrackedSet
    extends LinkedHashSet {
        private static final long serialVersionUID = 1L;
        protected static int id_gen = 0;
        protected int id = id_gen++;
        protected int hashcode = new Integer(this.id).hashCode();
        protected Exception instantiationInfo = new Exception("Created set " + this.id);

        protected TrackedSet() {
        }

        public Exception getInstantiationInfo() {
            return this.instantiationInfo;
        }

        public boolean equals(Object o) {
            return o instanceof TrackedSet && ((TrackedSet)o).id == this.id;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    protected static class TrackedList
    extends LinkedList {
        private static final long serialVersionUID = 1L;
        protected static int id_gen = 0;
        protected int id = id_gen++;
        protected int hashcode = new Integer(this.id).hashCode();
        protected Exception instantiationInfo = new Exception("Created list " + this.id);
        protected Exception useInfo;

        protected TrackedList() {
        }

        public Exception getInstantiationInfo() {
            return this.instantiationInfo;
        }

        public Exception getUseInfo() {
            return this.useInfo;
        }

        public void setUseInfo(Exception useInfo) {
            this.useInfo = useInfo;
        }

        public boolean equals(Object o) {
            return o instanceof TrackedList && ((TrackedList)o).id == this.id;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            return this.id + ":" + super.toString();
        }
    }
}

