/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class PathThread
extends Thread {
    protected Collection out;
    protected LinkedObject term;
    protected LinkDatabase linkDatabase = DefaultLinkDatabase.getDefault();
    protected RootAlgorithm rootAlgorithm = RootAlgorithm.GREEDY;
    protected boolean halt = false;
    protected double progress;
    protected ReusableProgressEvent pe = new ReusableProgressEvent((Object)this);
    protected Collection listeners = new LinkedList();

    public void start() {
        this.halt = false;
        this.progress = 0.0;
        this.pe.setDescription("Calculating paths...");
        super.start();
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void fireProgressEvent(ProgressEvent pe) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ProgressListener pl = (ProgressListener)it.next();
            pl.progressMade(pe);
        }
    }

    public void halt() {
        this.halt = true;
    }

    public boolean halted() {
        return this.halt;
    }

    public void setTerm(LinkedObject term) {
        this.term = term;
    }

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public void setRootAlgorithm(RootAlgorithm rootAlgorithm) {
        this.rootAlgorithm = rootAlgorithm;
    }

    public void setVector(Collection out) {
        this.out = out;
    }

    public Collection getPaths() {
        return this.out;
    }

    public void run() {
        this.rootAlgorithm.setLinkDatabase(this.linkDatabase);
        if (this.rootAlgorithm.isRoot(this.term)) {
            Object[] os = new Object[]{OBOSession.ROOT, TermUtil.isObsolete(this.term) ? OBOSession.OBSOLETE : (TermUtil.isProperty(this.term) ? OBOSession.TYPES : (TermUtil.isClass(this.term) ? OBOSession.CLASSES : OBOSession.INSTANCES)), new OBORestrictionImpl(this.term)};
            TreePath path = new TreePath(os);
            this.out.add(path);
        } else {
            double incSize = 100 / TermUtil.getParentCount(this.linkDatabase, this.term);
            Iterator it = this.linkDatabase.getParents(this.term).iterator();
            while (it.hasNext()) {
                Link tr = (Link)it.next();
                Map lookedAt = TermUtil.mallocMap();
                Map lookedAtCount = TermUtil.mallocMap();
                this.out.addAll(this.getPathsAsVector(incSize, tr, lookedAt, lookedAtCount));
                TermUtil.freeMap(lookedAtCount);
                TermUtil.freeMap(lookedAt);
                if (!this.halt) continue;
                return;
            }
        }
    }

    protected Collection getPathsAsVector(double incSize, Link link, Map lookedAt, Map lookedAtCount) {
        Collection<TreePath> out = new LinkedList();
        if (this.halt) {
            return out;
        }
        Integer lookedAtNum = (Integer)lookedAtCount.get(link);
        if (lookedAtNum == null) {
            lookedAtNum = new Integer(0);
        }
        lookedAtNum = new Integer(lookedAtNum + 1);
        lookedAtCount.put(link, lookedAtNum);
        if (link.getParent() == null) {
            Object[] os = new Object[]{OBOSession.ROOT, TermUtil.isObsolete(link.getChild()) ? OBOSession.OBSOLETE : (TermUtil.isProperty(link.getChild()) ? OBOSession.TYPES : (TermUtil.isClass(link.getChild()) ? OBOSession.CLASSES : OBOSession.INSTANCES)), link};
            out.add(new TreePath(os));
            this.progress += incSize;
            this.pe.setFastVal((int)this.progress);
            this.fireProgressEvent((ProgressEvent)this.pe);
            lookedAt.put(link, out);
            return out;
        }
        if (this.rootAlgorithm.isRoot(link.getParent())) {
            Object[] os = new Object[]{OBOSession.ROOT, OBOSession.CLASSES, new OBORestrictionImpl(link.getParent())};
            TreePath path = new TreePath(os);
            TreePath pathByAddingChild = path.pathByAddingChild(link);
            out.add(pathByAddingChild);
            this.progress += incSize;
            this.pe.setFastVal((int)this.progress);
            this.fireProgressEvent((ProgressEvent)this.pe);
            lookedAt.put(link, out);
            return out;
        }
        if (lookedAt.containsKey(link)) {
            out = (Collection)lookedAt.get(link);
            this.progress += incSize;
            this.pe.setFastVal((int)this.progress);
            this.fireProgressEvent((ProgressEvent)this.pe);
            if (lookedAtNum > 2) {
                return Collections.EMPTY_SET;
            }
            return out;
        }
        lookedAt.put(link, out);
        Iterator it = this.linkDatabase.getParents(link.getParent()).iterator();
        while (it.hasNext()) {
            Link parentRel = (Link)it.next();
            Collection parentVector = this.getPathsAsVector(incSize / (double)TermUtil.getParentCount(this.linkDatabase, link.getParent()), parentRel, lookedAt, lookedAtCount);
            Iterator it2 = parentVector.iterator();
            while (it2.hasNext()) {
                TreePath path = (TreePath)it2.next();
                TreePath pathByAddingChild = path.pathByAddingChild(link);
                if (out.contains(pathByAddingChild)) continue;
                out.add(pathByAddingChild);
            }
        }
        return out;
    }
}

