/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.AdapterWidgetI;
import org.geneontology.dataadapter.DataAdapter;
import org.geneontology.dataadapter.DataAdapterUIException;
import org.geneontology.dataadapter.GraphicalUI;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.dataadapter.UIConfiguration;
import org.geneontology.oboedit.dataadapter.GOFlatFileAdapter;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.impl.DefaultTermModel;
import org.geneontology.oboedit.datamodel.impl.OBOPropertyImpl;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OBOCellRenderer;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.SwingUtil;
import org.geneontology.util.EditableString;

public class GOFlatFileGUI
extends JPanel
implements GraphicalUI {
    private static final long serialVersionUID = 1L;
    DataAdapter driver;
    IOOperation op;
    JButton commitButton;
    JButton cancelButton;
    JButton browseDefButton;
    JLabel definitionLabel;
    JButton advancedButton;
    JScrollPane commentPane;
    ListEditor fileList;
    JTextField filenameField;
    JTextField definitionField;
    JTextArea commentField;
    ListEditor saveList;
    JCheckBox hideDownstreamBox;
    JCheckBox allowCyclesBox;
    JCheckBox allowDanglingBox;
    JCheckBox reduceSizeBox;
    JCheckBox useLegacyTypesBox;
    JCheckBox translateTypesBox;
    Vector fileNames;
    ListEditor symbolList;
    Properties props;
    JDialog optionDialog;
    Controller controller = Controller.getController();
    boolean notListPick = false;
    int currentSelectedIndex = -1;
    JPanel commitBox;
    protected GOFlatFileAdapter.GOFlatFileConfiguration config;
    protected UIConfiguration uiconfig;
    protected GraphicalUI simpleUI;
    protected boolean embed = false;

    public void init(AdapterWidgetI widget, IOOperation op, DataAdapter adapter, Object input) {
        this.driver = adapter;
        this.op = op;
        this.removeAll();
        this.setBackground(Preferences.defaultBackgroundColor());
        JPanel advancedButtonPanel = new JPanel();
        advancedButtonPanel.setOpaque(false);
        advancedButtonPanel.setLayout(new BoxLayout(advancedButtonPanel, 0));
        advancedButtonPanel.setAlignmentX(0.0f);
        advancedButtonPanel.add(Box.createHorizontalGlue());
        advancedButtonPanel.add(this.advancedButton);
        advancedButtonPanel.add(Box.createHorizontalGlue());
        JPanel advancedBox = new JPanel();
        advancedBox.setOpaque(false);
        advancedBox.setLayout(new BoxLayout(advancedBox, 0));
        advancedBox.setAlignmentX(0.0f);
        advancedBox.add(advancedButtonPanel);
        advancedBox.add(Box.createVerticalGlue());
        JPanel definitionLabelBox = new JPanel();
        definitionLabelBox.setOpaque(false);
        definitionLabelBox.setLayout(new BoxLayout(definitionLabelBox, 0));
        definitionLabelBox.setAlignmentX(0.0f);
        definitionLabelBox.add(this.definitionLabel);
        definitionLabelBox.add(Box.createHorizontalGlue());
        JPanel definitionNameBox = new JPanel();
        definitionNameBox.setOpaque(false);
        definitionNameBox.setLayout(new BoxLayout(definitionNameBox, 0));
        definitionNameBox.setAlignmentX(0.0f);
        definitionNameBox.add(this.definitionField);
        definitionNameBox.add(Box.createHorizontalStrut(10));
        definitionNameBox.add(this.browseDefButton);
        definitionNameBox.add(Box.createHorizontalGlue());
        this.advancedButton.setAlignmentX(0.5f);
        if (op.equals(IOOperation.READ)) {
            this.add((Component)this.fileList);
        }
        JPanel filenamePanel = new JPanel();
        filenamePanel.setOpaque(false);
        filenamePanel.setLayout(new BoxLayout(filenamePanel, 1));
        JButton filenameBrowseButton = new JButton("Browse...");
        filenameBrowseButton.setBackground(Preferences.defaultButtonColor());
        filenameBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(GOFlatFileGUI.this) == 0) {
                    File file = chooser.getSelectedFile();
                    GOFlatFileGUI.this.filenameField.setText(file.toString());
                }
            }
        });
        JLabel filenameLabel = new JLabel("File name");
        filenameLabel.setFont(this.controller.getDefaultFont());
        filenameBrowseButton.setFont(this.controller.getDefaultFont());
        JPanel filenameButtonPanel = new JPanel();
        filenameButtonPanel.setOpaque(false);
        filenameButtonPanel.setLayout(new BoxLayout(filenameButtonPanel, 0));
        filenameButtonPanel.add(this.filenameField);
        filenameButtonPanel.add(Box.createHorizontalStrut(10));
        filenameButtonPanel.add(filenameBrowseButton);
        filenamePanel.add(filenameLabel);
        filenamePanel.add(filenameButtonPanel);
        this.fileList.setAlignmentX(0.0f);
        this.fileList.setButtonColor(Preferences.defaultButtonColor());
        filenamePanel.setAlignmentX(0.0f);
        filenameLabel.setAlignmentX(0.0f);
        filenameButtonPanel.setAlignmentX(0.0f);
        if (op.equals(IOOperation.WRITE)) {
            this.add((Component)this.saveList);
        }
        this.add(Box.createVerticalStrut(20));
        this.add(definitionLabelBox);
        this.add(definitionNameBox);
        this.add(Box.createVerticalStrut(10));
        this.add(advancedBox);
        JPanel optionBox = new JPanel();
        optionBox.setOpaque(false);
        optionBox.setLayout(new BoxLayout(optionBox, 0));
        optionBox.setAlignmentX(0.0f);
        optionBox.add(Box.createHorizontalGlue());
        boolean showingOptions = false;
        if (op.equals(IOOperation.READ)) {
            showingOptions = true;
            optionBox.add(this.hideDownstreamBox);
            optionBox.add(Box.createHorizontalGlue());
        }
        showingOptions = true;
        optionBox.add(this.allowCyclesBox);
        optionBox.add(Box.createHorizontalGlue());
        optionBox.add(this.allowDanglingBox);
        optionBox.add(Box.createHorizontalGlue());
        optionBox.add(this.translateTypesBox);
        optionBox.add(Box.createHorizontalGlue());
        if (op.equals(IOOperation.WRITE)) {
            showingOptions = true;
            optionBox.add(this.reduceSizeBox);
            optionBox.add(Box.createHorizontalGlue());
            optionBox.add(this.useLegacyTypesBox);
            optionBox.add(Box.createHorizontalGlue());
        }
        if (showingOptions) {
            this.add(Box.createVerticalStrut(20));
            this.add(optionBox);
        }
        if (op.equals(IOOperation.WRITE)) {
            this.commentField.setText(this.controller.getSession().getCurrentHistory().getComment());
            JLabel commentLabel = new JLabel("Comment");
            commentLabel.setFont(this.controller.getDefaultFont());
            commentLabel.setAlignmentX(0.0f);
            JPanel commentBox = new JPanel();
            commentBox.setOpaque(false);
            commentBox.setLayout(new BoxLayout(commentBox, 0));
            commentBox.setAlignmentX(0.0f);
            commentBox.add(commentLabel);
            commentBox.add(Box.createHorizontalGlue());
            this.add(Box.createVerticalStrut(20));
            this.add(commentBox);
            this.add(this.commentPane);
        }
        this.add(Box.createVerticalStrut(20));
    }

    public void setConfiguration(AdapterConfiguration c) {
        if (c instanceof GOFlatFileAdapter.GOFlatFileConfiguration) {
            this.config = (GOFlatFileAdapter.GOFlatFileConfiguration)c;
            Vector<EditableString> v = new Vector<EditableString>();
            Iterator it = this.config.getReadPaths().iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                v.add(new EditableString(s));
            }
            this.fileList.setData(v);
            v = new Vector();
            v.addAll(this.config.getSaveRecords());
            this.saveList.setData(v);
            if (this.op.equals(IOOperation.READ)) {
                if (this.config.getDefFilename() != null) {
                    this.definitionField.setText(this.config.getDefFilename());
                }
            } else if (this.op.equals(IOOperation.WRITE) && this.config.getSaveDefFilename() != null) {
                this.definitionField.setText(this.config.getSaveDefFilename());
            }
            this.hideDownstreamBox.setSelected(this.config.getHideDownstream());
            this.allowCyclesBox.setSelected(this.config.getAllowCycles());
            this.allowDanglingBox.setSelected(this.config.getAllowDangling());
            this.reduceSizeBox.setSelected(this.config.getReduceSize());
            this.useLegacyTypesBox.setSelected(this.config.getUseLegacyTypes());
            this.translateTypesBox.setSelected(this.config.getTranslateTypes());
            v = new Vector();
            v.addAll(this.config.getTypeMappings());
            this.symbolList.setData(v);
        }
    }

    public AdapterConfiguration getConfig(IOOperation op, DataAdapter adapter, Object input) throws DataAdapterUIException {
        return this.config;
    }

    public AdapterConfiguration createEmptyConfig() {
        return new GOFlatFileAdapter.GOFlatFileConfiguration();
    }

    public void cleanup() {
    }

    public UIConfiguration getUIConfiguration() {
        return this.uiconfig;
    }

    public void setUIConfiguration(UIConfiguration uiconfig) {
        this.uiconfig = uiconfig;
    }

    public void setEmbed(boolean embed) {
        this.embed = embed;
        if (embed) {
            this.remove(this.commitBox);
            this.validate();
        }
    }

    protected void showAdvancedOptions() {
        JPanel advancedPanel = this.getAdvancedPanel(new JPanel());
        this.optionDialog = new JDialog();
        this.optionDialog.setModal(true);
        this.optionDialog.setContentPane(advancedPanel);
        this.optionDialog.setTitle("Advanced flat file options");
        this.optionDialog.pack();
        this.optionDialog.show();
        SwingUtil.center((Window)this.optionDialog);
    }

    public GOFlatFileGUI() {
        JLabel noRelationshipLabel = new JLabel("Click a symbol to edit it.");
        noRelationshipLabel.setFont(this.controller.getDefaultFont());
        this.symbolList = new ListEditor((GenericEditorComponent)new RelationshipTypeEditor(), (Component)noRelationshipLabel, new Vector(), true, true, true, true, false);
        this.symbolList.setBackground(Preferences.defaultBackgroundColor());
        this.symbolList.setButtonColor(Preferences.defaultButtonColor());
        this.symbolList.setFont(this.controller.getDefaultFont());
        JLabel noFileLabel = new JLabel("Click a filename to edit it.");
        noFileLabel.setFont(this.controller.getDefaultFont());
        this.fileList = new ListEditor((GenericEditorComponent)new FilenameEditor(), (Component)noFileLabel, new Vector(), true, true, true, true, false);
        this.fileList.setBackground(Preferences.defaultBackgroundColor());
        this.fileList.setDefaultDividerLoc(70);
        this.fileList.setFont(this.controller.getDefaultFont());
        this.fileList.setListSize(100);
        Vector<GOFlatFileAdapter.SaveRecord> firstvector = new Vector<GOFlatFileAdapter.SaveRecord>();
        firstvector.add(new GOFlatFileAdapter.SaveRecord(null, ""));
        this.saveList = new ListEditor((GenericEditorComponent)new SaveItemEditor(), (Component)noFileLabel, new Vector(), true, true, true, true, false);
        this.saveList.getList().setCellRenderer(new SaveRenderer());
        this.saveList.setAlignmentX(0.0f);
        this.saveList.setFont(this.controller.getDefaultFont());
        this.saveList.setListSize(140);
        this.saveList.setBackground(Preferences.defaultBackgroundColor());
        this.saveList.setButtonColor(Preferences.defaultButtonColor());
        TitledBorder fileListBorder = new TitledBorder("File paths");
        fileListBorder.setTitleFont(this.controller.getDefaultFont());
        this.fileList.setBorder((Border)fileListBorder);
        this.fileList.setOrientation(0);
        this.definitionField = new JTextField();
        this.filenameField = new JTextField();
        this.commentField = new JTextArea(4, 30);
        this.commentField.setWrapStyleWord(true);
        this.commentField.setLineWrap(true);
        this.commentField.setFont(this.controller.getDefaultFont());
        this.commentField.setAlignmentX(0.0f);
        this.commentPane = new JScrollPane(this.commentField, 20, 31);
        this.commentPane.setAlignmentX(0.0f);
        this.filenameField.setPreferredSize(new Dimension(300, 20));
        this.definitionField.setPreferredSize(new Dimension(300, 20));
        this.hideDownstreamBox = new JCheckBox("Hide downstream errors", true);
        this.allowCyclesBox = new JCheckBox("Allow cycles", false);
        this.allowDanglingBox = new JCheckBox("Allow dangling parent references", false);
        this.reduceSizeBox = new JCheckBox("Reduce file size", false);
        this.useLegacyTypesBox = new JCheckBox("Use legacy compatible types", false);
        this.translateTypesBox = new JCheckBox("Translate type ids", true);
        this.hideDownstreamBox.setOpaque(false);
        this.allowCyclesBox.setOpaque(false);
        this.allowDanglingBox.setOpaque(false);
        this.reduceSizeBox.setOpaque(false);
        this.useLegacyTypesBox.setOpaque(false);
        this.translateTypesBox.setOpaque(false);
        this.browseDefButton = new JButton("Browse...");
        this.browseDefButton.setBackground(Preferences.defaultButtonColor());
        this.browseDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                File startFile = new File(System.getProperty("user.home"));
                if (GOFlatFileGUI.this.definitionField.getText().length() > 0) {
                    File temp = new File(GOFlatFileGUI.this.definitionField.getText());
                    if (temp.exists()) {
                        startFile = temp.isDirectory() ? temp : temp.getParentFile();
                    } else if ((temp = temp.getParentFile()) != null && temp.isDirectory()) {
                        startFile = temp;
                    }
                }
                if ((chooser = new JFileChooser(startFile)).showOpenDialog(GOFlatFileGUI.this) == 0) {
                    File file = chooser.getSelectedFile();
                    GOFlatFileGUI.this.definitionField.setText(file.toString());
                }
            }
        });
        this.commitButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        this.advancedButton = new JButton("Advanced Options...");
        this.advancedButton.setFont(this.controller.getDefaultFont());
        this.advancedButton.setBackground(Preferences.defaultButtonColor());
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GOFlatFileGUI.this.showAdvancedOptions();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.definitionLabel = new JLabel("Definition file name:");
        this.setOpaque(false);
    }

    protected void commitAdvancedChanges() {
        Vector symbols = this.symbolList.getData();
        Hashtable<String, OBOPropertyImpl> newBindings = new Hashtable<String, OBOPropertyImpl>();
        if (symbols.size() < 1) {
            JOptionPane.showMessageDialog(null, "You must specify at least one term relationship type.");
            return;
        }
        HashMap<String, String> nameList = new HashMap<String, String>();
        for (int i = 0; i < symbols.size(); ++i) {
            GOFlatFileAdapter.CharTypeMapping rtw = (GOFlatFileAdapter.CharTypeMapping)symbols.elementAt(i);
            if (newBindings.get(rtw.getTypeChar()) != null) {
                JOptionPane.showMessageDialog(null, "Each relationship must have a unique symbol. You may not reuse the character '" + rtw.getTypeChar() + "'.");
                return;
            }
            if (rtw.getTypeChar().length() == 1 && GOFlatFileAdapter.isReservedCharacter(rtw.getTypeChar().charAt(0)) || rtw.getTypeChar().length() != 1 && (rtw.getTypeChar().charAt(0) != '@' || rtw.getTypeChar().charAt(rtw.getTypeChar().length() - 1) != '@')) {
                JOptionPane.showMessageDialog(null, rtw.getTypeChar() + " is a " + "reserved character, and " + "cannot be used as a " + "relationship type " + "identifier.");
                return;
            }
            if (rtw.getPropertyID().length() < 1) {
                JOptionPane.showMessageDialog(null, "Each relationship must have a name!");
                return;
            }
            if (rtw.getPropertyName().length() < 1) {
                JOptionPane.showMessageDialog(null, "Each relationship must have a description!");
                return;
            }
            if (nameList.get(rtw.getPropertyID()) != null) {
                JOptionPane.showMessageDialog(null, "Each relationship must have a unique name. You may not reuse the name '" + rtw.getPropertyID() + "'.");
                return;
            }
            OBOPropertyImpl trt = new OBOPropertyImpl(rtw.getPropertyID(), rtw.getPropertyName());
            newBindings.put(rtw.getTypeChar(), trt);
            nameList.put(rtw.getPropertyID(), rtw.getPropertyID());
        }
        this.config.setTypeMappings(symbols);
        if (this.optionDialog != null) {
            this.optionDialog.dispose();
        }
    }

    public JPanel getAdvancedPanel(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(Preferences.defaultBackgroundColor());
        JButton okButton = new JButton("Ok");
        JButton cancelButton = new JButton("Cancel");
        okButton.setFont(this.controller.getDefaultFont());
        cancelButton.setFont(this.controller.getDefaultFont());
        okButton.setBackground(Preferences.defaultButtonColor());
        cancelButton.setBackground(Preferences.defaultButtonColor());
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GOFlatFileGUI.this.commitAdvancedChanges();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GOFlatFileGUI.this.optionDialog != null) {
                    GOFlatFileGUI.this.optionDialog.dispose();
                }
            }
        });
        Box buttonBox = new Box(0);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(okButton);
        buttonBox.add(Box.createHorizontalStrut(20));
        buttonBox.add(cancelButton);
        buttonBox.add(Box.createHorizontalGlue());
        panel.add((Component)this.symbolList);
        panel.add(Box.createVerticalStrut(10));
        panel.add(buttonBox);
        panel.add(Box.createVerticalStrut(10));
        panel.setPreferredSize(new Dimension(450, 250));
        panel.setMinimumSize(new Dimension(450, 250));
        panel.setBorder(new TitledBorder("Define term relationship symbols"));
        return panel;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.browseDefButton != null) {
            this.filenameField.setFont(font);
            this.browseDefButton.setFont(font);
            this.definitionField.setFont(font);
            this.definitionLabel.setFont(font);
            this.hideDownstreamBox.setFont(font);
            this.allowCyclesBox.setFont(font);
            this.allowDanglingBox.setFont(font);
            this.reduceSizeBox.setFont(font);
            this.useLegacyTypesBox.setFont(font);
            this.translateTypesBox.setFont(font);
            this.commitButton.setFont(font);
            this.cancelButton.setFont(font);
        }
    }

    public void setSimpleUI(GraphicalUI simpleUI) {
        this.simpleUI = simpleUI;
    }

    public GraphicalUI getSimpleUI() {
        return this.simpleUI;
    }

    public GraphicalUI getAdvancedUI() {
        return null;
    }

    public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
        this.config.setComment(this.commentField.getText());
        this.config.setHideDownstream(this.hideDownstreamBox.isSelected());
        this.config.setAllowCycles(this.allowCyclesBox.isSelected());
        this.config.setAllowDangling(this.allowDanglingBox.isSelected());
        this.config.setReduceSize(this.reduceSizeBox.isSelected());
        this.config.setUseLegacyTypes(this.useLegacyTypesBox.isSelected());
        this.config.setTranslateTypes(this.translateTypesBox.isSelected());
        ArrayList saveRecords = new ArrayList();
        saveRecords.addAll(this.saveList.getData());
        this.config.setSaveRecords(saveRecords);
        ArrayList<String> loadFiles = new ArrayList<String>();
        Vector v = this.fileList.getData();
        Iterator it = v.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            loadFiles.add(o.toString());
        }
        this.config.setReadPaths(loadFiles);
        if (this.op.equals(IOOperation.WRITE)) {
            this.config.setSaveDefFilename(this.definitionField.getText());
        } else if (this.definitionField.getText().length() > 0) {
            this.config.setDefFilename(this.definitionField.getText());
        } else {
            this.config.setDefFilename(null);
        }
        if (!storeonly && this.op.equals(IOOperation.WRITE)) {
            int val;
            LinkedList<String> overwriteFiles = new LinkedList<String>();
            if (Controller.getController().warnBeforeDefinitionLoss() && (this.config.getSaveDefFilename() == null || this.config.getSaveDefFilename().trim().length() == 0) && (val = JOptionPane.showConfirmDialog(this, "No definition file was specified. Definitions will be\nlost if you save without a definitions file. Continue?", "Discard definitions?", 0)) != 0) {
                throw new DataAdapterUIException();
            }
            it = saveRecords.iterator();
            while (it.hasNext()) {
                GOFlatFileAdapter.SaveRecord sr = (GOFlatFileAdapter.SaveRecord)it.next();
                if (!new File(sr.getFilename()).exists()) continue;
                overwriteFiles.add(sr.getFilename());
            }
            if (this.config.getSaveDefFilename() != null && new File(this.config.getSaveDefFilename()).exists()) {
                overwriteFiles.add(this.config.getSaveDefFilename());
            }
            if (overwriteFiles.size() > 0) {
                StringBuffer out = new StringBuffer();
                out.append("The following files exist:\n");
                it = overwriteFiles.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    out.append("   * " + s + "\n");
                }
                out.append("Overwrite these files?");
                int val2 = JOptionPane.showConfirmDialog(this, out.toString(), "Overwrite files?", 0);
                if (val2 != 0) {
                    throw new DataAdapterUIException();
                }
            }
            this.config.setBasicSave(false);
        }
    }

    private class BrowseListener
    implements ActionListener {
        protected JTextField field;

        public BrowseListener(JTextField field) {
            this.field = field;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showOpenDialog(GOFlatFileGUI.this) == 0) {
                File file = chooser.getSelectedFile();
                this.field.setText(file.toString());
            }
        }
    }

    private class FilenameEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        private JTextField filenameField;
        private JButton browseButton;
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public FilenameEditor() {
            this.setBackground(Preferences.defaultBackgroundColor());
            JLabel filenameLabel = new JLabel("File Name or URL");
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FilenameEditor.this.editor.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this.filenameField = new JTextField();
            this.browseButton = new JButton("Browse...");
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser;
                    File startFile = new File(System.getProperty("user.home"));
                    if (FilenameEditor.this.filenameField.getText().length() > 0) {
                        File temp = new File(FilenameEditor.this.filenameField.getText());
                        if (temp.exists()) {
                            startFile = temp.isDirectory() ? temp : temp.getParentFile();
                        } else if ((temp = temp.getParentFile()) != null && temp.isDirectory()) {
                            startFile = temp;
                        }
                    }
                    if ((chooser = new JFileChooser(startFile)).showOpenDialog(GOFlatFileGUI.this) == 0) {
                        File file = chooser.getSelectedFile();
                        FilenameEditor.this.filenameField.setText(file.toString());
                        FilenameEditor.this.editor.commit();
                    }
                }
            });
            this.filenameField.addFocusListener(listener);
            this.filenameField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilenameEditor.this.editor.commit();
                }
            });
            this.browseButton.setBackground(Preferences.defaultButtonColor());
            filenameLabel.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.filenameField.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.browseButton.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.browseButton.setBackground(Preferences.defaultButtonColor());
            JPanel fieldBox = new JPanel();
            fieldBox.setLayout(new BoxLayout(fieldBox, 0));
            fieldBox.setOpaque(false);
            fieldBox.add(this.filenameField);
            fieldBox.add(Box.createHorizontalStrut(20));
            fieldBox.add(this.browseButton);
            fieldBox.setAlignmentX(0.0f);
            filenameLabel.setAlignmentX(0.0f);
            this.filenameField.setAlignmentX(0.0f);
            this.browseButton.setAlignmentX(0.0f);
            filenameLabel.setAlignmentY(0.0f);
            fieldBox.setAlignmentY(0.0f);
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(filenameLabel);
            panel.add(fieldBox);
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "North");
        }

        public void load(Object o) {
            this.filenameField.setText(o.toString());
        }

        public void store(Object o) {
            ((EditableString)o).setValue(this.filenameField.getText());
        }

        public Object createNewValue() {
            return new EditableString("<new file>");
        }
    }

    private class SaveItemEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        protected JRadioButton rootSave = new JRadioButton("Save at ROOT");
        protected JRadioButton nodeSave = new JRadioButton("Save at");
        protected JTextField idField = new JTextField(15);
        protected JButton nodeBrowseButton = new JButton("Browse...");
        protected JButton fileBrowseButton = new JButton("Browse...");
        protected JTextField filenameField = new JTextField();
        protected JLabel filenameLabel = new JLabel("Filename");
        protected ListEditor editor;
        protected JPanel idPanel;
        protected JPanel filenamePanel;

        protected void formatField(JTextField field) {
            field.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        }

        public SaveItemEditor() {
            this.setBackground(Preferences.defaultBackgroundColor());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rootSave);
            bg.add(this.nodeSave);
            this.setLayout(new BoxLayout(this, 1));
            this.rootSave.addActionListener(new RadioListener(true));
            this.nodeSave.addActionListener(new RadioListener(false));
            this.rootSave.setOpaque(false);
            this.nodeSave.setOpaque(false);
            CommitListener cl = new CommitListener();
            this.idField.addFocusListener(cl);
            this.idField.addActionListener(cl);
            this.filenameField.addFocusListener(cl);
            this.filenameField.addActionListener(cl);
            this.fileBrowseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser;
                    File startFile = new File(System.getProperty("user.home"));
                    if (SaveItemEditor.this.filenameField.getText().length() > 0) {
                        File temp = new File(SaveItemEditor.this.filenameField.getText());
                        if (temp.exists()) {
                            startFile = temp.isDirectory() ? temp : temp.getParentFile();
                        } else if ((temp = temp.getParentFile()) != null && temp.isDirectory()) {
                            startFile = temp;
                        }
                    }
                    if ((chooser = new JFileChooser(startFile)).showSaveDialog(GOFlatFileGUI.this) == 0) {
                        File file = chooser.getSelectedFile();
                        SaveItemEditor.this.filenameField.setText(file.toString());
                        SaveItemEditor.this.editor.commit();
                    }
                }
            });
            this.nodeBrowseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TermBrowser tb = new TermBrowser(((SaveItemEditor)SaveItemEditor.this).GOFlatFileGUI.this.controller);
                    tb.setSize(300, 300);
                    tb.show();
                    OBOClass t = tb.getSelectedTerm();
                    if (t == null) {
                        SaveItemEditor.this.idField.setText("");
                    } else {
                        SaveItemEditor.this.idField.setText(t.getID());
                    }
                }
            });
            this.nodeBrowseButton.setBackground(Preferences.defaultButtonColor());
            this.fileBrowseButton.setBackground(Preferences.defaultButtonColor());
            this.filenameLabel.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.idField.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.nodeBrowseButton.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.fileBrowseButton.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.filenameField.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.rootSave.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.nodeSave.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.formatField(this.filenameField);
            this.formatField(this.idField);
            this.idPanel = new JPanel();
            this.idPanel.setOpaque(false);
            this.idPanel.setLayout(new BoxLayout(this.idPanel, 0));
            this.idPanel.add(this.nodeSave);
            this.idPanel.add(Box.createHorizontalStrut(20));
            this.idPanel.add(this.idField);
            this.idPanel.add(Box.createHorizontalStrut(10));
            this.idPanel.add(this.nodeBrowseButton);
            this.filenamePanel = new JPanel();
            this.filenamePanel.setOpaque(false);
            this.filenamePanel.setLayout(new BoxLayout(this.filenamePanel, 0));
            this.filenamePanel.add(this.filenameField);
            this.filenamePanel.add(Box.createHorizontalStrut(20));
            this.filenamePanel.add(this.fileBrowseButton);
            this.idPanel.setAlignmentX(0.0f);
            this.filenameLabel.setAlignmentX(0.0f);
            this.idField.setAlignmentX(0.0f);
            this.nodeBrowseButton.setAlignmentX(0.0f);
            this.fileBrowseButton.setAlignmentX(0.0f);
            this.filenameField.setAlignmentX(0.0f);
            this.rootSave.setAlignmentX(0.0f);
            this.nodeSave.setAlignmentX(0.0f);
            this.filenamePanel.setAlignmentX(0.0f);
            this.add(this.rootSave);
            this.add(this.idPanel);
            this.add(this.filenameLabel);
            this.add(this.filenamePanel);
            this.add(Box.createVerticalGlue());
        }

        public Object createNewValue() {
            return new GOFlatFileAdapter.SaveRecord(null, "");
        }

        public void load(Object o) {
            GOFlatFileAdapter.SaveRecord sr = (GOFlatFileAdapter.SaveRecord)o;
            if (sr.getID() == null) {
                this.rootSave.setSelected(true);
                this.idField.setText("");
            } else {
                this.nodeSave.setSelected(true);
                this.idField.setText(sr.getID());
            }
            this.filenameField.setText(sr.getFilename());
        }

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public void store(Object o) {
            GOFlatFileAdapter.SaveRecord sr = (GOFlatFileAdapter.SaveRecord)o;
            if (this.rootSave.isSelected()) {
                sr.setID(null);
            } else {
                sr.setID(this.idField.getText());
            }
            sr.setFilename(this.filenameField.getText());
        }

        protected class RadioListener
        implements ActionListener {
            protected boolean root = false;

            public RadioListener(boolean root) {
                this.root = root;
            }

            public void actionPerformed(ActionEvent e) {
                SaveItemEditor.this.idPanel.setEnabled(!this.root);
                SaveItemEditor.this.idField.setEnabled(!this.root);
                SaveItemEditor.this.nodeBrowseButton.setEnabled(!this.root);
                if (this.root) {
                    SaveItemEditor.this.editor.commit();
                }
            }
        }

        private class CommitListener
        implements ActionListener,
        FocusListener {
            private CommitListener() {
            }

            public void actionPerformed(ActionEvent e) {
                SaveItemEditor.this.editor.commit();
            }

            public void focusLost(FocusEvent e) {
                SaveItemEditor.this.editor.commit();
            }

            public void focusGained(FocusEvent e) {
            }
        }
    }

    public class TermBrowser
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected JTree tree;
        protected JButton okButton;

        public TermBrowser(Controller controller) {
            super((Frame)null, "Select a term", true);
            this.okButton = new JButton("Ok");
            this.tree = new JTree();
            DefaultTermModel model = new DefaultTermModel(controller);
            model.setShowTerms(true);
            model.setShowTypes(false);
            model.setShowObsoletes(false);
            model.reload(null);
            this.tree.setModel(model);
            this.tree.setCellRenderer(new OBOCellRenderer(controller));
            this.tree.setRootVisible(false);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TermBrowser.this.dispose();
                }
            });
            this.tree.getSelectionModel().setSelectionMode(1);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JScrollPane pane = new JScrollPane(this.tree);
            panel.add((Component)pane, "Center");
            this.okButton.setFont(controller.getDefaultFont());
            this.okButton.setBackground(Preferences.defaultButtonColor());
            panel.add((Component)this.okButton, "South");
            panel.setBackground(Color.white);
            this.setContentPane(panel);
            this.tree.expandRow(0);
        }

        public OBOClass getSelectedTerm() {
            TreePath selected = this.tree.getSelectionPath();
            if (selected == null) {
                return null;
            }
            return (OBOClass)((Link)selected.getLastPathComponent()).getChild();
        }
    }

    public class SaveRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GOFlatFileAdapter.SaveRecord sr = (GOFlatFileAdapter.SaveRecord)value;
            String id = sr.getID();
            if (id == null) {
                id = "ROOT";
            }
            return super.getListCellRendererComponent((JList<?>)list, id, index, isSelected, cellHasFocus);
        }
    }

    private class RelationshipTypeEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        private JTextField charField;
        private JTextField nameField;
        private JTextField descField;
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public RelationshipTypeEditor() {
            this.setOpaque(false);
            JLabel charLabel = new JLabel("Relationship type symbol");
            JLabel nameLabel = new JLabel("Relationship type name");
            JLabel descLabel = new JLabel("Relationship type description");
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ((RelationshipTypeEditor)RelationshipTypeEditor.this).GOFlatFileGUI.this.symbolList.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this.charField = new JTextField(1);
            this.nameField = new JTextField(10);
            this.descField = new JTextField();
            this.charField.addFocusListener(listener);
            this.nameField.addFocusListener(listener);
            this.descField.addFocusListener(listener);
            charLabel.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.charField.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.nameField.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            nameLabel.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            descLabel.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.descField.setFont(GOFlatFileGUI.this.controller.getDefaultFont());
            this.setLayout(new BoxLayout(this, 1));
            this.add(charLabel);
            this.add(this.charField);
            this.add(Box.createVerticalStrut(10));
            this.add(nameLabel);
            this.add(this.nameField);
            this.add(Box.createVerticalStrut(10));
            this.add(descLabel);
            this.add(this.descField);
            this.add(Box.createVerticalGlue());
        }

        public void load(Object o) {
            GOFlatFileAdapter.CharTypeMapping rtw = (GOFlatFileAdapter.CharTypeMapping)o;
            this.charField.setText(rtw.getTypeChar() + "");
            this.nameField.setText(rtw.getPropertyID());
            this.descField.setText(rtw.getPropertyName());
        }

        public void store(Object o) {
            GOFlatFileAdapter.CharTypeMapping rtw = (GOFlatFileAdapter.CharTypeMapping)o;
            String charStr = this.charField.getText();
            if (charStr.length() < 1) {
                rtw.setTypeChar("?");
            } else {
                rtw.setTypeChar(charStr);
            }
            rtw.setPropertyID(this.nameField.getText());
            rtw.setPropertyName(this.descField.getText());
        }

        public Object createNewValue() {
            GOFlatFileAdapter.CharTypeMapping ctw = new GOFlatFileAdapter.CharTypeMapping("?", "NEWTYPE", "<new relationship type>");
            return ctw;
        }
    }
}

